/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.StrictMode;
import android.support.v4.app.Fragment;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.LifecycleDelegate;
import com.google.android.gms.dynamic.zzn;
import com.google.android.gms.dynamic.zzo;
import com.google.android.gms.maps.GoogleMapOptions;
import com.google.android.gms.maps.MapsInitializer;
import com.google.android.gms.maps.OnMapReadyCallback;
import com.google.android.gms.maps.internal.IMapFragmentDelegate;
import com.google.android.gms.maps.internal.MapLifecycleDelegate;
import com.google.android.gms.maps.internal.zzby;
import com.google.android.gms.maps.internal.zzbz;
import com.google.android.gms.maps.model.RuntimeRemoteException;
import com.google.android.gms.maps.zzak;
import java.util.ArrayList;
import java.util.List;

public class SupportMapFragment
extends Fragment {
    @Hide
    private final zzb zza = new zzb(this);

    public static SupportMapFragment newInstance() {
        return new SupportMapFragment();
    }

    public static SupportMapFragment newInstance(GoogleMapOptions googleMapOptions) {
        SupportMapFragment supportMapFragment = new SupportMapFragment();
        Bundle bundle = new Bundle();
        bundle.putParcelable("MapOptions", (Parcelable)googleMapOptions);
        supportMapFragment.setArguments(bundle);
        return supportMapFragment;
    }

    public SupportMapFragment() {
    }

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        this.zza.zza(activity);
    }

    public void onInflate(Activity activity, AttributeSet attributeSet, Bundle bundle) {
        StrictMode.ThreadPolicy threadPolicy = StrictMode.getThreadPolicy();
        StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)new StrictMode.ThreadPolicy.Builder(threadPolicy).permitAll().build());
        try {
            super.onInflate(activity, attributeSet, bundle);
            this.zza.zza(activity);
            GoogleMapOptions googleMapOptions = GoogleMapOptions.createFromAttributes((Context)activity, attributeSet);
            Bundle bundle2 = new Bundle();
            bundle2.putParcelable("MapOptions", (Parcelable)googleMapOptions);
            this.zza.zza(activity, bundle2, bundle);
            return;
        }
        finally {
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)threadPolicy);
        }
    }

    public void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.zza.zza(bundle);
    }

    public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        View view = this.zza.zza(layoutInflater, viewGroup, bundle);
        view.setClickable(true);
        return view;
    }

    public void onResume() {
        super.onResume();
        this.zza.zzc();
    }

    public void onPause() {
        this.zza.zzd();
        super.onPause();
    }

    public void onStart() {
        super.onStart();
        this.zza.zzb();
    }

    public void onStop() {
        this.zza.zze();
        super.onStop();
    }

    public void onDestroyView() {
        this.zza.zzf();
        super.onDestroyView();
    }

    public void onDestroy() {
        this.zza.zzg();
        super.onDestroy();
    }

    public void onLowMemory() {
        this.zza.zzh();
        super.onLowMemory();
    }

    public void onActivityCreated(Bundle bundle) {
        if (bundle != null) {
            bundle.setClassLoader(SupportMapFragment.class.getClassLoader());
        }
        super.onActivityCreated(bundle);
    }

    public void onSaveInstanceState(Bundle bundle) {
        if (bundle != null) {
            bundle.setClassLoader(SupportMapFragment.class.getClassLoader());
        }
        super.onSaveInstanceState(bundle);
        this.zza.zzb(bundle);
    }

    public final void onEnterAmbient(Bundle bundle) {
        zzbq.zzb((String)"onEnterAmbient must be called on the main thread.");
        Bundle bundle2 = bundle;
        zzb zzb2 = this.zza;
        if (zzb2.zza() != null) {
            ((zza)zzb2.zza()).zza(bundle2);
        }
    }

    public final void onExitAmbient() {
        zzbq.zzb((String)"onExitAmbient must be called on the main thread.");
        zzb zzb2 = this.zza;
        if (zzb2.zza() != null) {
            ((zza)zzb2.zza()).zza();
        }
    }

    public void getMapAsync(OnMapReadyCallback onMapReadyCallback) {
        zzbq.zzb((String)"getMapAsync must be called on the main thread.");
        this.zza.zza(onMapReadyCallback);
    }

    public void setArguments(Bundle bundle) {
        super.setArguments(bundle);
    }

    static final class zzb
    extends com.google.android.gms.dynamic.zza<zza> {
        private final Fragment zza;
        private zzo<zza> zzb;
        private Activity zzc;
        private final List<OnMapReadyCallback> zzd = new ArrayList<OnMapReadyCallback>();

        zzb(Fragment fragment) {
            this.zza = fragment;
        }

        protected final void zza(zzo<zza> zzo2) {
            this.zzb = zzo2;
            this.zzi();
        }

        private final void zzi() {
            if (this.zzc != null && this.zzb != null && this.zza() == null) {
                try {
                    MapsInitializer.initialize((Context)this.zzc);
                    IMapFragmentDelegate iMapFragmentDelegate = zzbz.zza((Context)this.zzc).zza(zzn.zza((Object)this.zzc));
                    if (iMapFragmentDelegate == null) {
                        return;
                    }
                    this.zzb.zza((LifecycleDelegate)new zza(this.zza, iMapFragmentDelegate));
                    for (OnMapReadyCallback onMapReadyCallback : this.zzd) {
                        ((zza)this.zza()).getMapAsync(onMapReadyCallback);
                    }
                    this.zzd.clear();
                    return;
                }
                catch (RemoteException remoteException) {
                    throw new RuntimeRemoteException(remoteException);
                }
                catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {}
            }
        }

        private final void zza(Activity activity) {
            this.zzc = activity;
            this.zzi();
        }

        public final void zza(OnMapReadyCallback onMapReadyCallback) {
            if (this.zza() != null) {
                ((zza)this.zza()).getMapAsync(onMapReadyCallback);
                return;
            }
            this.zzd.add(onMapReadyCallback);
        }
    }

    @Hide
    static final class zza
    implements MapLifecycleDelegate {
        private final Fragment zza;
        private final IMapFragmentDelegate zzb;

        public zza(Fragment fragment, IMapFragmentDelegate iMapFragmentDelegate) {
            this.zzb = (IMapFragmentDelegate)zzbq.zza((Object)iMapFragmentDelegate);
            this.zza = (Fragment)zzbq.zza((Object)fragment);
        }

        public final void onInflate(Activity activity, Bundle bundle, Bundle bundle2) {
            GoogleMapOptions googleMapOptions = (GoogleMapOptions)bundle.getParcelable("MapOptions");
            try {
                Bundle bundle3 = new Bundle();
                zzby.zza(bundle2, bundle3);
                this.zzb.onInflate(zzn.zza((Object)activity), googleMapOptions, bundle3);
                zzby.zza(bundle3, bundle2);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onCreate(Bundle bundle) {
            try {
                Bundle bundle2 = new Bundle();
                zzby.zza(bundle, bundle2);
                Bundle bundle3 = this.zza.getArguments();
                if (bundle3 != null && bundle3.containsKey("MapOptions")) {
                    zzby.zza(bundle2, "MapOptions", bundle3.getParcelable("MapOptions"));
                }
                this.zzb.onCreate(bundle2);
                zzby.zza(bundle2, bundle);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
            IObjectWrapper iObjectWrapper;
            try {
                Bundle bundle2 = new Bundle();
                zzby.zza(bundle, bundle2);
                iObjectWrapper = this.zzb.onCreateView(zzn.zza((Object)layoutInflater), zzn.zza((Object)viewGroup), bundle2);
                zzby.zza(bundle2, bundle);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
            return (View)zzn.zza((IObjectWrapper)iObjectWrapper);
        }

        public final void onStart() {
            try {
                this.zzb.onStart();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onResume() {
            try {
                this.zzb.onResume();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onPause() {
            try {
                this.zzb.onPause();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onStop() {
            try {
                this.zzb.onStop();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onDestroyView() {
            try {
                this.zzb.onDestroyView();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onDestroy() {
            try {
                this.zzb.onDestroy();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onLowMemory() {
            try {
                this.zzb.onLowMemory();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void onSaveInstanceState(Bundle bundle) {
            try {
                Bundle bundle2 = new Bundle();
                zzby.zza(bundle, bundle2);
                this.zzb.onSaveInstanceState(bundle2);
                zzby.zza(bundle2, bundle);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        @Override
        public final void getMapAsync(OnMapReadyCallback onMapReadyCallback) {
            try {
                this.zzb.getMapAsync(new zzak(this, onMapReadyCallback));
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void zza(Bundle bundle) {
            try {
                Bundle bundle2 = new Bundle();
                zzby.zza(bundle, bundle2);
                this.zzb.onEnterAmbient(bundle2);
                zzby.zza(bundle2, bundle);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public final void zza() {
            try {
                this.zzb.onExitAmbient();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }
    }
}

