/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.cast;

import android.content.SharedPreferences;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import androidx.annotation.MainThread;
import androidx.annotation.Nullable;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.framework.CastContext;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.internal.Logger;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.cast.zzdy;
import com.google.android.gms.internal.cast.zzf;
import com.google.android.gms.internal.cast.zzg;
import com.google.android.gms.internal.cast.zzh;
import com.google.android.gms.internal.cast.zzl;
import com.google.android.gms.internal.cast.zzm;
import com.google.android.gms.internal.cast.zzmq;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.dataflow.qual.Pure;

@MainThread
public final class zzk {
    private static final Logger zza = new Logger("ApplicationAnalytics");
    private final zzf zzb;
    private final zzm zzc;
    private final zzh zzd;
    private final Runnable zze;
    private final Handler zzf;
    private final SharedPreferences zzg;
    @Nullable
    private zzl zzh;
    @Nullable
    private CastSession zzi;
    private boolean zzj;
    private boolean zzk;

    static /* bridge */ /* synthetic */ SharedPreferences zza(zzk zzk2) {
        return zzk2.zzg;
    }

    static /* bridge */ /* synthetic */ zzf zzb(zzk zzk2) {
        return zzk2.zzb;
    }

    public final zzh zzc() {
        return this.zzd;
    }

    static /* bridge */ /* synthetic */ zzl zzd(zzk zzk2) {
        return zzk2.zzh;
    }

    static /* bridge */ /* synthetic */ zzm zze(zzk zzk2) {
        return zzk2.zzc;
    }

    static /* bridge */ /* synthetic */ Logger zzf() {
        return zza;
    }

    @Pure
    private static String zzs() {
        return ((CastContext)Preconditions.checkNotNull((Object)CastContext.getSharedInstance())).getCastOptions().getReceiverApplicationId();
    }

    public static /* synthetic */ void zzg(zzk zzk2) {
        zzl zzl2 = zzk2.zzh;
        if (zzl2 != null) {
            zzl2 = zzk2.zzc.zza(zzl2);
            zzk2.zzb.zzd((zzmq)zzl2, 223);
        }
        zzk2.zzw();
    }

    static /* bridge */ /* synthetic */ void zzh(zzk zzk2, zzl zzl2) {
        zzk2.zzh = null;
    }

    static /* bridge */ /* synthetic */ void zzi(zzk zzk2, CastSession castSession) {
        zzk2.zzi = castSession;
    }

    static /* bridge */ /* synthetic */ void zzj(zzk zzk2, boolean bl) {
        zzk2.zzk = bl;
    }

    static /* bridge */ /* synthetic */ void zzk(zzk zzk2) {
        zzk2.zzt();
    }

    static /* bridge */ /* synthetic */ void zzl(zzk zzk2) {
        zzk2.zzu();
    }

    static /* bridge */ /* synthetic */ void zzm(zzk zzk2) {
        zzk2.zzv();
    }

    static /* bridge */ /* synthetic */ void zzn(zzk zzk2, int n) {
        Object[] objectArray = new Object[]{n};
        zza.d("log session ended with error = %d", objectArray);
        zzk2.zzu();
        zzmq zzmq2 = zzk2.zzc.zze(zzk2.zzh, n);
        zzk2.zzb.zzd(zzmq2, 228);
        zzk2.zzt();
        if (!zzk2.zzk) {
            zzk2.zzh = null;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    static /* bridge */ /* synthetic */ void zzo(zzk zzk2, SharedPreferences object, String string2) {
        if (zzk2.zzz(string2)) {
            object = new Object[]{};
            zza.d("Use the existing ApplicationAnalyticsSession if it is available and valid.", (Object[])object);
            Preconditions.checkNotNull((Object)zzk2.zzh);
            return;
        }
        zzk2.zzh = zzl.zzb((SharedPreferences)object);
        if (zzk2.zzz(string2)) {
            object = new Object[]{};
            zza.d("Use the restored ApplicationAnalyticsSession if it is valid.", (Object[])object);
            Preconditions.checkNotNull((Object)zzk2.zzh);
            zzl.zza = zzk2.zzh.zzd + 1L;
            return;
        }
        object = new Object[]{};
        zza.d("The restored ApplicationAnalyticsSession is not valid, create a new one.", (Object[])object);
        zzk2.zzh = zzl.zza(zzk2.zzj);
        zzl zzl2 = (zzl)Preconditions.checkNotNull((Object)zzk2.zzh);
        object = zzk2.zzi;
        boolean bl = object != null ? ((CastSession)object).zzj() : false;
        zzl2.zzj = bl;
        ((zzl)Preconditions.checkNotNull((Object)zzk2.zzh)).zzb = com.google.android.gms.internal.cast.zzk.zzs();
        ((zzl)Preconditions.checkNotNull((Object)zzk2.zzh)).zzf = string2;
    }

    static /* bridge */ /* synthetic */ void zzp(zzk zzk2) {
        zzk2.zzh.zzc(zzk2.zzg);
    }

    static /* bridge */ /* synthetic */ void zzq(zzk zzk2) {
        zzk2.zzw();
    }

    /*
     * Enabled aggressive block sorting
     */
    static /* bridge */ /* synthetic */ void zzr(zzk object, boolean bl) {
        Logger logger = zza;
        Object[] objectArray = new Object[1];
        String string2 = true != bl ? "foreground" : "background";
        objectArray[0] = string2;
        logger.d("update app visibility to %s", objectArray);
        ((zzk)object).zzj = bl;
        object = ((zzk)object).zzh;
        if (object != null) {
            ((zzl)object).zzi = bl;
            return;
        }
    }

    public zzk(SharedPreferences sharedPreferences, zzf zzf2, Bundle bundle, String string2) {
        this.zzg = sharedPreferences;
        this.zzb = zzf2;
        this.zzc = new zzm(bundle, string2);
        this.zzd = new zzh(this);
        this.zzf = new zzdy(Looper.getMainLooper());
        this.zze = new zzg(this);
    }

    private final void zzt() {
        this.zzf.removeCallbacks(this.zze);
    }

    /*
     * Enabled aggressive block sorting
     */
    @EnsuresNonNull(value={"analyticsSession"})
    private final void zzu() {
        if (!this.zzy()) {
            zza.w("The analyticsSession should not be null for logging. Create a dummy one.", new Object[0]);
            this.zzv();
            return;
        }
        CastSession castSession = this.zzi;
        castSession = castSession != null ? castSession.getCastDevice() : null;
        if (castSession != null && !TextUtils.equals((CharSequence)this.zzh.zzc, (CharSequence)castSession.zzc())) {
            this.zzx((CastDevice)castSession);
        }
        Preconditions.checkNotNull((Object)this.zzh);
    }

    /*
     * Enabled aggressive block sorting
     */
    @EnsuresNonNull(value={"analyticsSession"})
    private final void zzv() {
        zza.d("Create a new ApplicationAnalyticsSession based on CastSession", new Object[0]);
        this.zzh = zzl.zza(this.zzj);
        zzl zzl2 = (zzl)Preconditions.checkNotNull((Object)this.zzh);
        CastSession castSession = this.zzi;
        boolean bl = castSession != null ? castSession.zzj() : false;
        zzl2.zzj = bl;
        ((zzl)Preconditions.checkNotNull((Object)this.zzh)).zzb = com.google.android.gms.internal.cast.zzk.zzs();
        CastSession castSession2 = this.zzi;
        castSession2 = castSession2 == null ? null : castSession2.getCastDevice();
        if (castSession2 != null) {
            this.zzx((CastDevice)castSession2);
        }
        zzl2 = (zzl)Preconditions.checkNotNull((Object)this.zzh);
        castSession2 = this.zzi;
        int n = castSession2 == null ? 0 : castSession2.zzk();
        zzl2.zzk = n;
        Preconditions.checkNotNull((Object)this.zzh);
    }

    private final void zzw() {
        ((Handler)Preconditions.checkNotNull((Object)this.zzf)).postDelayed((Runnable)Preconditions.checkNotNull((Object)this.zze), 300000L);
    }

    private final void zzx(CastDevice castDevice) {
        zzl zzl2 = ((zzk)((Object)zzl2)).zzh;
        if (zzl2 == null) {
            return;
        }
        zzl2.zzc = castDevice.zzc();
        zzl2.zzg = castDevice.zza();
        zzl2.zzh = castDevice.getModelName();
    }

    @EnsuresNonNullIf(expression={"analyticsSession"}, result=true)
    private final boolean zzy() {
        String string2;
        Object[] objectArray;
        if (objectArray.zzh == null) {
            objectArray = new Object[]{};
            zza.d("The analytics session is null when matching with application ID.", objectArray);
            return false;
        }
        String string3 = com.google.android.gms.internal.cast.zzk.zzs();
        if (string3 == null || (string2 = objectArray.zzh.zzb) == null || !TextUtils.equals((CharSequence)string2, (CharSequence)string3)) {
            objectArray = new Object[]{string3};
            zza.d("The analytics session doesn't match the application ID %s", objectArray);
            return false;
        }
        Preconditions.checkNotNull((Object)objectArray.zzh);
        return true;
    }

    private final boolean zzz(String string2) {
        if (!objectArray.zzy()) {
            return false;
        }
        Preconditions.checkNotNull((Object)objectArray.zzh);
        if (string2 == null || (objectArray = objectArray.zzh.zzf) == null || !TextUtils.equals((CharSequence)objectArray, (CharSequence)string2)) {
            Object[] objectArray = new Object[]{string2};
            zza.d("The analytics session doesn't match the receiver session ID %s.", objectArray);
            return false;
        }
        return true;
    }
}

