/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.cast;

import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.os.Looper;
import android.support.v4.media.session.MediaSessionCompat;
import androidx.annotation.Nullable;
import androidx.mediarouter.media.MediaRouteSelector;
import androidx.mediarouter.media.MediaRouter;
import androidx.mediarouter.media.MediaRouterParams;
import androidx.mediarouter.media.MediaTransferReceiver;
import com.google.android.gms.cast.framework.CastOptions;
import com.google.android.gms.cast.internal.Logger;
import com.google.android.gms.cast.internal.zzn;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.cast.zzak;
import com.google.android.gms.internal.cast.zzan;
import com.google.android.gms.internal.cast.zzas;
import com.google.android.gms.internal.cast.zzbb;
import com.google.android.gms.internal.cast.zzbc;
import com.google.android.gms.internal.cast.zzbd;
import com.google.android.gms.internal.cast.zzbe;
import com.google.android.gms.internal.cast.zzbm;
import com.google.android.gms.internal.cast.zzdy;
import com.google.android.gms.internal.cast.zzln;
import com.google.android.gms.internal.cast.zzr;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public final class zzbf
extends zzak {
    private static final Logger zza = new Logger("MediaRouterProxy");
    private final MediaRouter zzb;
    private final CastOptions zzc;
    private final Map zzd = new HashMap();
    @Nullable
    private zzbm zze;
    private boolean zzf;

    @Override
    @Nullable
    public final Bundle zzb(String string2) {
        for (MediaRouter.RouteInfo routeInfo : ((zzbf)this).zzb.getRoutes()) {
            if (!routeInfo.getId().equals(string2)) continue;
            return routeInfo.getExtras();
        }
        return null;
    }

    @Nullable
    public final zzbm zzn() {
        return this.zze;
    }

    @Override
    public final String zzc() {
        return this.zzb.getSelectedRoute().getId();
    }

    public zzbf(Context context, MediaRouter object, CastOptions castOptions, zzn zzn2) {
        objectArray.zzb = object;
        objectArray.zzc = castOptions;
        if (Build.VERSION.SDK_INT <= 32) {
            Object[] objectArray = new Object[]{};
            zza.i("Don't need to set MediaRouterParams for Android S v2 or below", objectArray);
            return;
        }
        object = new Object[]{};
        zza.d("Set up MediaRouterParams based on module flag and CastOptions for Android T or above", object);
        objectArray.zze = new zzbm(castOptions);
        object = MediaTransferReceiver.class;
        Intent intent = new Intent(context, (Class)object);
        intent.setPackage(context.getPackageName());
        objectArray.zzf = context.getPackageManager().queryBroadcastReceivers(intent, 0).isEmpty() ^ true;
        if (objectArray.zzf) {
            zzr.zzd(zzln.zzJ);
        }
        zzn2.zza(new String[]{"com.google.android.gms.cast.FLAG_OUTPUT_SWITCHER_ENABLED"}).addOnCompleteListener((OnCompleteListener)new zzbd((zzbf)objectArray, castOptions));
    }

    @Override
    public final void zzd(@Nullable Bundle bundle, int n) {
        if ((bundle = MediaRouteSelector.fromBundle((Bundle)bundle)) == null) {
            return;
        }
        if (Looper.myLooper() == Looper.getMainLooper()) {
            this.zzt((MediaRouteSelector)bundle, n);
            return;
        }
        new zzdy(Looper.getMainLooper()).post((Runnable)new zzbc(this, (MediaRouteSelector)bundle, n));
    }

    private final void zzt(@Nullable MediaRouteSelector mediaRouteSelector, int n) {
        Object object = (Set)this.zzd.get(mediaRouteSelector);
        if (object == null) {
            return;
        }
        object = object.iterator();
        while (object.hasNext()) {
            MediaRouter.Callback callback = (MediaRouter.Callback)object.next();
            this.zzb.addCallback(mediaRouteSelector, callback, n);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final /* synthetic */ void zzo(MediaRouteSelector mediaRouteSelector, int n) {
        Map map = this.zzd;
        synchronized (map) {
            this.zzt(mediaRouteSelector, n);
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    final /* synthetic */ void zzp(CastOptions castOptions, Task task) {
        block6: {
            block5: {
                Object object;
                boolean bl;
                if (task.isSuccessful()) {
                    Bundle bundle = (Bundle)task.getResult();
                    bl = bundle != null ? bundle.containsKey("com.google.android.gms.cast.FLAG_OUTPUT_SWITCHER_ENABLED") : false;
                    Logger logger = zza;
                    Object[] objectArray = new Object[1];
                    object = true != bl ? "not existed" : "existed";
                    objectArray[0] = object;
                    logger.d("The module-to-client output switcher flag %s", objectArray);
                    bl = bl ? bundle.getBoolean("com.google.android.gms.cast.FLAG_OUTPUT_SWITCHER_ENABLED") : true;
                } else {
                    bl = true;
                }
                object = new Object[]{bl, castOptions.zzh()};
                zza.i("Set up output switcher flags: %b (from module), %b (from CastOptions)", (Object[])object);
                boolean bl2 = bl ? castOptions.zzh() : false;
                Object[] objectArray = this.zzb;
                if (objectArray == null || (object = this.zzc) == null) break block5;
                boolean bl3 = ((CastOptions)((Object)object)).zzf();
                boolean bl4 = ((CastOptions)((Object)object)).zzd();
                objectArray.setRouterParams(new MediaRouterParams.Builder().setMediaTransferReceiverEnabled(bl2).setTransferToLocalEnabled(bl3).setOutputSwitcherEnabled(bl4).build());
                objectArray = new Object[]{this.zzf, bl2, bl3, bl4};
                zza.i("media transfer = %b, session transfer = %b, transfer to local = %b, in-app output switcher = %b", objectArray);
                if (bl3) break block6;
            }
            return;
        }
        this.zzb.setOnPrepareTransferListener((MediaRouter.OnPrepareTransferListener)new zzbb((zzbm)Preconditions.checkNotNull((Object)this.zze)));
        zzr.zzd(zzln.zzK);
    }

    final /* synthetic */ void zzq(MediaRouteSelector mediaRouteSelector) {
        this.zzu(mediaRouteSelector);
    }

    @Override
    public final void zze(@Nullable Bundle bundle, zzan zzan2) {
        if ((bundle = MediaRouteSelector.fromBundle((Bundle)bundle)) == null) {
            return;
        }
        if (!this.zzd.containsKey(bundle)) {
            this.zzd.put(bundle, new HashSet());
        }
        ((Set)this.zzd.get(bundle)).add(new zzas(zzan2));
    }

    @Override
    public final void zzf() {
        Iterator iterator = this.zzd.values().iterator();
        while (iterator.hasNext()) {
            for (MediaRouter.Callback callback : (Set)iterator.next()) {
                this.zzb.removeCallback(callback);
            }
        }
        this.zzd.clear();
    }

    @Override
    public final void zzg(@Nullable Bundle bundle) {
        if ((bundle = MediaRouteSelector.fromBundle((Bundle)bundle)) == null) {
            return;
        }
        if (Looper.myLooper() == Looper.getMainLooper()) {
            this.zzu((MediaRouteSelector)bundle);
            return;
        }
        new zzdy(Looper.getMainLooper()).post((Runnable)new zzbe(this, (MediaRouteSelector)bundle));
    }

    private final void zzu(@Nullable MediaRouteSelector object) {
        if ((object = (Set)this.zzd.get(object)) == null) {
            return;
        }
        object = object.iterator();
        while (object.hasNext()) {
            MediaRouter.Callback callback = (MediaRouter.Callback)object.next();
            this.zzb.removeCallback(callback);
        }
    }

    @Override
    public final void zzh() {
        MediaRouter mediaRouter = this.zzb;
        mediaRouter.selectRoute(mediaRouter.getDefaultRoute());
    }

    @Override
    public final void zzi(String objectArray) {
        Object[] objectArray2 = new Object[]{objectArray};
        zza.d("select route with routeId = %s", objectArray2);
        for (MediaRouter.RouteInfo routeInfo : this.zzb.getRoutes()) {
            if (!routeInfo.getId().equals(objectArray)) continue;
            objectArray = new Object[]{};
            zza.d("media route is found and selected", objectArray);
            this.zzb.selectRoute(routeInfo);
            return;
        }
    }

    public final void zzr(@Nullable MediaSessionCompat mediaSessionCompat) {
        this.zzb.setMediaSessionCompat(mediaSessionCompat);
    }

    @Override
    public final void zzj(int n) {
        this.zzb.unselect(n);
    }

    @Override
    public final boolean zzk() {
        MediaRouter.RouteInfo routeInfo = this.zzb.getBluetoothRoute();
        return routeInfo != null && this.zzb.getSelectedRoute().getId().equals(routeInfo.getId());
    }

    @Override
    public final boolean zzl() {
        MediaRouter.RouteInfo routeInfo = this.zzb.getDefaultRoute();
        return routeInfo != null && this.zzb.getSelectedRoute().getId().equals(routeInfo.getId());
    }

    public final boolean zzs() {
        return this.zzf;
    }

    @Override
    public final boolean zzm(@Nullable Bundle bundle, int n) {
        if ((bundle = MediaRouteSelector.fromBundle((Bundle)bundle)) == null) {
            return false;
        }
        return this.zzb.isRouteAvailable((MediaRouteSelector)bundle, n);
    }
}

