/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework.media.widget;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.PorterDuff;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.MenuItem;
import android.view.View;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.SeekBar;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.R;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import com.google.android.gms.cast.AdBreakClipInfo;
import com.google.android.gms.cast.Cast;
import com.google.android.gms.cast.MediaMetadata;
import com.google.android.gms.cast.MediaStatus;
import com.google.android.gms.cast.framework.CastContext;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.framework.R;
import com.google.android.gms.cast.framework.Session;
import com.google.android.gms.cast.framework.SessionManager;
import com.google.android.gms.cast.framework.SessionManagerListener;
import com.google.android.gms.cast.framework.media.ImageHints;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.cast.framework.media.internal.zzb;
import com.google.android.gms.cast.framework.media.internal.zzw;
import com.google.android.gms.cast.framework.media.uicontroller.UIMediaController;
import com.google.android.gms.cast.framework.media.widget.CastSeekBar;
import com.google.android.gms.cast.framework.media.widget.ControlButtonsContainer;
import com.google.android.gms.cast.framework.media.widget.zzh;
import com.google.android.gms.cast.framework.media.widget.zzi;
import com.google.android.gms.cast.framework.media.widget.zzk;
import com.google.android.gms.cast.framework.media.widget.zzl;
import com.google.android.gms.cast.framework.media.widget.zzn;
import com.google.android.gms.cast.framework.media.widget.zzp;
import com.google.android.gms.cast.framework.media.widget.zzr;
import com.google.android.gms.cast.framework.media.widget.zzs;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.cast.zzct;
import com.google.android.gms.internal.cast.zzcu;
import com.google.android.gms.internal.cast.zzcv;
import com.google.android.gms.internal.cast.zzcw;
import com.google.android.gms.internal.cast.zzln;
import java.util.Timer;
import java.util.TimerTask;

public abstract class ExpandedControllerActivity
extends AppCompatActivity
implements ControlButtonsContainer {
    @VisibleForTesting
    final SessionManagerListener zza = new zzr(this, null);
    @VisibleForTesting
    final RemoteMediaClient.Listener zzb = new zzp(this, null);
    @DrawableRes
    private int zze;
    @DrawableRes
    private int zzf;
    @DrawableRes
    private int zzg;
    @DrawableRes
    private int zzh;
    @DrawableRes
    private int zzi;
    @DrawableRes
    private int zzj;
    @DrawableRes
    private int zzk;
    @DrawableRes
    private int zzl;
    @DrawableRes
    private int zzm;
    @DrawableRes
    private int zzn;
    @ColorInt
    private int zzo;
    @ColorInt
    private int zzp;
    @ColorInt
    private int zzq;
    @ColorInt
    private int zzr;
    private int zzs;
    private int zzt;
    private int zzu;
    private int zzv;
    private TextView zzw;
    private SeekBar zzx;
    private CastSeekBar zzy;
    private ImageView zzz;
    private ImageView zzA;
    private int[] zzB;
    private final ImageView[] zzC = new ImageView[4];
    private View zzD;
    private View zzE;
    private ImageView zzF;
    private TextView zzG;
    private TextView zzH;
    private TextView zzI;
    private TextView zzJ;
    @VisibleForTesting
    zzb zzc;
    private UIMediaController zzK;
    private SessionManager zzL;
    @Nullable
    private Cast.Listener zzM;
    @VisibleForTesting
    boolean zzd;
    private boolean zzN;
    private Timer zzO;
    @Nullable
    private String zzP;

    @Override
    public final int getButtonSlotCount() {
        return 4;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int getButtonTypeAt(int slotIndex) throws IndexOutOfBoundsException {
        void var1_1;
        return this.zzB[var1_1];
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NonNull
    public final ImageView getButtonImageViewAt(int slotIndex) throws IndexOutOfBoundsException {
        void var1_1;
        return this.zzC[var1_1];
    }

    @Deprecated
    @NonNull
    public SeekBar getSeekBar() {
        return this.zzx;
    }

    @NonNull
    public TextView getStatusTextView() {
        return this.zzw;
    }

    @Override
    @NonNull
    public UIMediaController getUIMediaController() {
        return this.zzK;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        TypedArray typedArray;
        void var1_1;
        super.onCreate((Bundle)var1_1);
        this.zzL = CastContext.getSharedInstance((Context)this).getSessionManager();
        if (this.zzL.getCurrentCastSession() == null) {
            this.finish();
        }
        this.zzK = new UIMediaController((Activity)this);
        this.zzK.setPostRemoteMediaClientListener(this.zzb);
        this.setContentView(R.layout.cast_expanded_controller_activity);
        TypedArray typedArray2 = this.obtainStyledAttributes(new int[]{R.attr.selectableItemBackgroundBorderless});
        this.zze = typedArray2.getResourceId(0, 0);
        typedArray2.recycle();
        Object object = this.obtainStyledAttributes(null, R.styleable.CastExpandedController, R.attr.castExpandedControllerStyle, R.style.CastExpandedController);
        this.zzs = object.getResourceId(R.styleable.CastExpandedController_castButtonColor, 0);
        this.zzf = object.getResourceId(R.styleable.CastExpandedController_castPlayButtonDrawable, 0);
        this.zzg = object.getResourceId(R.styleable.CastExpandedController_castPauseButtonDrawable, 0);
        this.zzh = object.getResourceId(R.styleable.CastExpandedController_castStopButtonDrawable, 0);
        this.zzi = object.getResourceId(R.styleable.CastExpandedController_castSkipPreviousButtonDrawable, 0);
        this.zzj = object.getResourceId(R.styleable.CastExpandedController_castSkipNextButtonDrawable, 0);
        this.zzk = object.getResourceId(R.styleable.CastExpandedController_castRewind30ButtonDrawable, 0);
        this.zzl = object.getResourceId(R.styleable.CastExpandedController_castForward30ButtonDrawable, 0);
        this.zzm = object.getResourceId(R.styleable.CastExpandedController_castMuteToggleButtonDrawable, 0);
        this.zzn = object.getResourceId(R.styleable.CastExpandedController_castClosedCaptionsButtonDrawable, 0);
        int n = object.getResourceId(R.styleable.CastExpandedController_castControlButtons, 0);
        if (n != 0) {
            typedArray = this.getResources().obtainTypedArray(n);
            n = typedArray.length() == 4 ? 1 : 0;
            Preconditions.checkArgument(n != 0);
            this.zzB = new int[typedArray.length()];
            n = 0;
            while (n < typedArray.length()) {
                int n2 = n++;
                this.zzB[n2] = typedArray.getResourceId(n2, 0);
            }
            typedArray.recycle();
        } else {
            this.zzB = new int[]{R.id.cast_button_type_empty, R.id.cast_button_type_empty, R.id.cast_button_type_empty, R.id.cast_button_type_empty};
        }
        this.zzr = object.getColor(R.styleable.CastExpandedController_castExpandedControllerLoadingIndicatorColor, 0);
        n = object.getResourceId(R.styleable.CastExpandedController_castAdLabelColor, 0);
        this.zzo = this.getResources().getColor(n);
        n = object.getResourceId(R.styleable.CastExpandedController_castAdInProgressTextColor, 0);
        this.zzp = this.getResources().getColor(n);
        n = object.getResourceId(R.styleable.CastExpandedController_castAdLabelTextColor, 0);
        this.zzq = this.getResources().getColor(n);
        this.zzt = object.getResourceId(R.styleable.CastExpandedController_castAdLabelTextAppearance, 0);
        this.zzu = object.getResourceId(R.styleable.CastExpandedController_castAdInProgressLabelTextAppearance, 0);
        this.zzv = object.getResourceId(R.styleable.CastExpandedController_castAdInProgressText, 0);
        n = object.getResourceId(R.styleable.CastExpandedController_castDefaultAdPosterUrl, 0);
        if (n != 0) {
            this.zzP = this.getApplicationContext().getResources().getString(n);
        }
        object.recycle();
        View view = this.findViewById(R.id.expanded_controller_layout);
        object = this.zzK;
        this.zzz = (ImageView)view.findViewById(R.id.background_image_view);
        this.zzA = (ImageView)view.findViewById(R.id.blurred_background_image_view);
        typedArray = view.findViewById(R.id.background_place_holder_image_view);
        DisplayMetrics displayMetrics = new DisplayMetrics();
        this.getWindowManager().getDefaultDisplay().getMetrics(displayMetrics);
        ((UIMediaController)object).zzb(this.zzz, new ImageHints(4, displayMetrics.widthPixels, displayMetrics.heightPixels), (View)typedArray, new zzn(this, null));
        this.zzw = (TextView)view.findViewById(R.id.status_text);
        typedArray = (ProgressBar)view.findViewById(R.id.loading_indicator);
        displayMetrics = typedArray.getIndeterminateDrawable();
        int n3 = this.zzr;
        if (n3 != 0) {
            displayMetrics.setColorFilter(n3, PorterDuff.Mode.SRC_IN);
        }
        ((UIMediaController)object).bindViewToLoadingIndicator((View)typedArray);
        typedArray = (TextView)view.findViewById(R.id.start_text);
        displayMetrics = (TextView)view.findViewById(R.id.end_text);
        this.zzx = (SeekBar)view.findViewById(R.id.seek_bar);
        this.zzy = (CastSeekBar)view.findViewById(R.id.cast_seek_bar);
        ((UIMediaController)object).bindSeekBar(this.zzy, 1000L);
        TypedArray typedArray3 = typedArray;
        ((UIMediaController)object).bindViewToUIController((View)typedArray3, new zzcv((TextView)typedArray3, ((UIMediaController)object).zza()));
        DisplayMetrics displayMetrics2 = displayMetrics;
        ((UIMediaController)object).bindViewToUIController((View)displayMetrics2, new zzct((TextView)displayMetrics2, ((UIMediaController)object).zza()));
        TypedArray typedArray4 = typedArray = view.findViewById(R.id.live_indicators);
        ((UIMediaController)object).bindViewToUIController((View)typedArray4, new zzcu((View)typedArray4, ((UIMediaController)object).zza()));
        typedArray = (RelativeLayout)view.findViewById(R.id.tooltip_container);
        Object object2 = object;
        TypedArray typedArray5 = typedArray;
        zzcw zzcw2 = new zzcw((RelativeLayout)typedArray5, this.zzy, ((UIMediaController)object).zza());
        ((UIMediaController)object2).bindViewToUIController((View)typedArray5, zzcw2);
        ((UIMediaController)object2).zzf(zzcw2);
        this.zzC[0] = (ImageView)view.findViewById(R.id.button_0);
        this.zzC[1] = (ImageView)view.findViewById(R.id.button_1);
        this.zzC[2] = (ImageView)view.findViewById(R.id.button_2);
        this.zzC[3] = (ImageView)view.findViewById(R.id.button_3);
        ExpandedControllerActivity expandedControllerActivity = this;
        expandedControllerActivity.zzl(view, R.id.button_0, expandedControllerActivity.zzB[0], (UIMediaController)object);
        ExpandedControllerActivity expandedControllerActivity2 = this;
        expandedControllerActivity2.zzl(view, R.id.button_1, expandedControllerActivity2.zzB[1], (UIMediaController)object);
        this.zzl(view, R.id.button_play_pause_toggle, R.id.cast_button_type_play_pause_toggle, (UIMediaController)object);
        ExpandedControllerActivity expandedControllerActivity3 = this;
        expandedControllerActivity3.zzl(view, R.id.button_2, expandedControllerActivity3.zzB[2], (UIMediaController)object);
        ExpandedControllerActivity expandedControllerActivity4 = this;
        expandedControllerActivity4.zzl(view, R.id.button_3, expandedControllerActivity4.zzB[3], (UIMediaController)object);
        this.zzD = this.findViewById(R.id.ad_container);
        this.zzF = (ImageView)this.zzD.findViewById(R.id.ad_image_view);
        this.zzE = this.zzD.findViewById(R.id.ad_background_image_view);
        this.zzH = (TextView)this.zzD.findViewById(R.id.ad_label);
        this.zzH.setTextColor(this.zzq);
        this.zzH.setBackgroundColor(this.zzo);
        this.zzG = (TextView)this.zzD.findViewById(R.id.ad_in_progress_label);
        this.zzJ = (TextView)this.findViewById(R.id.ad_skip_text);
        this.zzI = (TextView)this.findViewById(R.id.ad_skip_button);
        this.zzI.setOnClickListener((View.OnClickListener)new zzi(this));
        ExpandedControllerActivity expandedControllerActivity5 = this;
        expandedControllerActivity5.setSupportActionBar((Toolbar)expandedControllerActivity5.findViewById(R.id.toolbar));
        view = this.getSupportActionBar();
        if (view != null) {
            view.setDisplayHomeAsUpEnabled(true);
            view.setHomeAsUpIndicator(R.drawable.quantum_ic_keyboard_arrow_down_white_36);
        }
        this.zzn();
        this.zzo();
        if (this.zzG != null && this.zzv != 0) {
            if (PlatformVersion.isAtLeastM()) {
                this.zzG.setTextAppearance(this.zzu);
            } else {
                this.zzG.setTextAppearance(this.getApplicationContext(), this.zzu);
            }
            this.zzG.setTextColor(this.zzp);
            this.zzG.setText(this.zzv);
        }
        this.zzc = new zzb(this.getApplicationContext(), new ImageHints(-1, this.zzF.getWidth(), this.zzF.getHeight()));
        this.zzc.zzc(new zzh(this));
        com.google.android.gms.internal.cast.zzr.zzd(zzln.zzc);
    }

    protected void onDestroy() {
        this.zzc.zza();
        UIMediaController uIMediaController = this.zzK;
        if (uIMediaController != null) {
            uIMediaController.setPostRemoteMediaClientListener(null);
            this.zzK.dispose();
        }
        super.onDestroy();
    }

    protected void onPause() {
        Object object = this.zzL;
        if (object == null) {
            return;
        }
        object = ((SessionManager)object).getCurrentCastSession();
        Cast.Listener listener = this.zzM;
        if (listener != null && object != null) {
            ((CastSession)object).removeCastListener(listener);
            this.zzM = null;
        }
        this.zzL.removeSessionManagerListener(this.zza, CastSession.class);
        super.onPause();
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void onResume() {
        Object object = this.zzL;
        if (object == null) {
            return;
        }
        ((SessionManager)object).addSessionManagerListener(this.zza, CastSession.class);
        object = this.zzL.getCurrentCastSession();
        if (object == null || !((Session)object).isConnected() && !((Session)object).isConnecting()) {
            this.finish();
        } else {
            this.zzM = new zzl(this);
            ((CastSession)object).addCastListener(this.zzM);
        }
        boolean bl = (object = this.zzj()) != null ? !((RemoteMediaClient)object).hasMediaSession() : true;
        this.zzd = bl;
        this.zzn();
        this.zzp();
        super.onResume();
    }

    public void onWindowFocusChanged(boolean hasFocus) {
        int n;
        super.onWindowFocusChanged(n != 0);
        if (n != 0) {
            n = this.getWindow().getDecorView().getSystemUiVisibility() ^ 2;
            if (PlatformVersion.isAtLeastJellyBean()) {
                n ^= 4;
            }
            if (PlatformVersion.isAtLeastKitKat()) {
                n ^= 0x1000;
            }
            this.getWindow().getDecorView().setSystemUiVisibility(n);
            this.setImmersive(true);
            return;
        }
    }

    public boolean onOptionsItemSelected(@NonNull MenuItem item) {
        if (item.getItemId() == 16908332) {
            this.finish();
        }
        return true;
    }

    static /* bridge */ /* synthetic */ ImageView zza(ExpandedControllerActivity expandedControllerActivity) {
        return expandedControllerActivity.zzF;
    }

    static /* bridge */ /* synthetic */ TextView zzb(ExpandedControllerActivity expandedControllerActivity) {
        return expandedControllerActivity.zzG;
    }

    static /* bridge */ /* synthetic */ TextView zzc(ExpandedControllerActivity expandedControllerActivity) {
        return expandedControllerActivity.zzI;
    }

    static /* bridge */ /* synthetic */ TextView zzd(ExpandedControllerActivity expandedControllerActivity) {
        return expandedControllerActivity.zzw;
    }

    static /* bridge */ /* synthetic */ RemoteMediaClient zze(ExpandedControllerActivity expandedControllerActivity) {
        return expandedControllerActivity.zzj();
    }

    @Nullable
    private final RemoteMediaClient zzj() {
        CastSession castSession = ((ExpandedControllerActivity)((Object)castSession)).zzL.getCurrentCastSession();
        if (castSession != null && castSession.isConnected()) {
            return castSession.getRemoteMediaClient();
        }
        return null;
    }

    static /* bridge */ /* synthetic */ void zzf(ExpandedControllerActivity expandedControllerActivity, RemoteMediaClient remoteMediaClient) {
        expandedControllerActivity.zzm(remoteMediaClient);
    }

    static /* bridge */ /* synthetic */ void zzg(ExpandedControllerActivity expandedControllerActivity) {
        expandedControllerActivity.zzn();
    }

    static /* bridge */ /* synthetic */ void zzh(ExpandedControllerActivity expandedControllerActivity) {
        expandedControllerActivity.zzo();
    }

    static /* bridge */ /* synthetic */ void zzi(ExpandedControllerActivity expandedControllerActivity) {
        expandedControllerActivity.zzp();
    }

    private final void zzk(String string2) {
        string2 = Uri.parse((String)string2);
        this.zzc.zzd((Uri)string2);
        this.zzE.setVisibility(8);
    }

    private final void zzl(View view, int n, int n2, UIMediaController uIMediaController) {
        view = (ImageView)view.findViewById(n);
        if (n2 == R.id.cast_button_type_empty) {
            view.setVisibility(4);
            return;
        }
        if (n2 == R.id.cast_button_type_play_pause_toggle) {
            view.setBackgroundResource(this.zze);
            ExpandedControllerActivity expandedControllerActivity = this;
            Drawable drawable2 = com.google.android.gms.cast.framework.media.widget.zzs.zzb((Context)expandedControllerActivity, this.zzs, expandedControllerActivity.zzg);
            ExpandedControllerActivity expandedControllerActivity2 = this;
            Drawable drawable3 = com.google.android.gms.cast.framework.media.widget.zzs.zzb((Context)expandedControllerActivity2, this.zzs, expandedControllerActivity2.zzf);
            ExpandedControllerActivity expandedControllerActivity3 = this;
            Drawable drawable4 = com.google.android.gms.cast.framework.media.widget.zzs.zzb((Context)expandedControllerActivity3, this.zzs, expandedControllerActivity3.zzh);
            view.setImageDrawable(drawable3);
            uIMediaController.bindImageViewToPlayPauseToggle((ImageView)view, drawable3, drawable2, drawable4, null, false);
            return;
        }
        if (n2 == R.id.cast_button_type_skip_previous) {
            view.setBackgroundResource(this.zze);
            ExpandedControllerActivity expandedControllerActivity = this;
            view.setImageDrawable(com.google.android.gms.cast.framework.media.widget.zzs.zzb((Context)expandedControllerActivity, this.zzs, expandedControllerActivity.zzi));
            view.setContentDescription((CharSequence)this.getResources().getString(R.string.cast_skip_prev));
            uIMediaController.bindViewToSkipPrev(view, 0);
            return;
        }
        if (n2 == R.id.cast_button_type_skip_next) {
            view.setBackgroundResource(this.zze);
            ExpandedControllerActivity expandedControllerActivity = this;
            view.setImageDrawable(com.google.android.gms.cast.framework.media.widget.zzs.zzb((Context)expandedControllerActivity, this.zzs, expandedControllerActivity.zzj));
            view.setContentDescription((CharSequence)this.getResources().getString(R.string.cast_skip_next));
            uIMediaController.bindViewToSkipNext(view, 0);
            return;
        }
        if (n2 == R.id.cast_button_type_rewind_30_seconds) {
            view.setBackgroundResource(this.zze);
            ExpandedControllerActivity expandedControllerActivity = this;
            view.setImageDrawable(com.google.android.gms.cast.framework.media.widget.zzs.zzb((Context)expandedControllerActivity, this.zzs, expandedControllerActivity.zzk));
            view.setContentDescription((CharSequence)this.getResources().getString(R.string.cast_rewind_30));
            uIMediaController.bindViewToRewind(view, 30000L);
            return;
        }
        if (n2 == R.id.cast_button_type_forward_30_seconds) {
            view.setBackgroundResource(this.zze);
            ExpandedControllerActivity expandedControllerActivity = this;
            view.setImageDrawable(com.google.android.gms.cast.framework.media.widget.zzs.zzb((Context)expandedControllerActivity, this.zzs, expandedControllerActivity.zzl));
            view.setContentDescription((CharSequence)this.getResources().getString(R.string.cast_forward_30));
            uIMediaController.bindViewToForward(view, 30000L);
            return;
        }
        if (n2 == R.id.cast_button_type_mute_toggle) {
            view.setBackgroundResource(this.zze);
            ExpandedControllerActivity expandedControllerActivity = this;
            view.setImageDrawable(com.google.android.gms.cast.framework.media.widget.zzs.zzb((Context)expandedControllerActivity, this.zzs, expandedControllerActivity.zzm));
            uIMediaController.bindImageViewToMuteToggle((ImageView)view);
            return;
        }
        if (n2 == R.id.cast_button_type_closed_caption) {
            view.setBackgroundResource(this.zze);
            ExpandedControllerActivity expandedControllerActivity = this;
            view.setImageDrawable(com.google.android.gms.cast.framework.media.widget.zzs.zzb((Context)expandedControllerActivity, this.zzs, expandedControllerActivity.zzn));
            uIMediaController.bindViewToClosedCaption(view);
            return;
        }
    }

    private final void zzm(RemoteMediaClient remoteMediaClient) {
        if (!this.zzd) {
            MediaStatus mediaStatus = remoteMediaClient.getMediaStatus();
            if (mediaStatus == null || remoteMediaClient.isBuffering()) {
                return;
            }
            this.zzI.setVisibility(8);
            this.zzJ.setVisibility(8);
            mediaStatus = mediaStatus.getCurrentAdBreakClip();
            if (mediaStatus != null && mediaStatus.getWhenSkippableInMs() != -1L) {
                float f;
                if (!this.zzN) {
                    zzk zzk2 = new zzk(this, remoteMediaClient);
                    this.zzO = new Timer();
                    this.zzO.scheduleAtFixedRate((TimerTask)zzk2, 0L, 500L);
                    this.zzN = true;
                }
                if ((f = (float)(mediaStatus.getWhenSkippableInMs() - remoteMediaClient.getApproximateAdBreakClipPositionMs())) <= 0.0f) {
                    if (this.zzN) {
                        this.zzO.cancel();
                        this.zzN = false;
                    }
                    this.zzI.setVisibility(0);
                    this.zzI.setClickable(true);
                    return;
                }
                this.zzJ.setVisibility(0);
                this.zzJ.setText((CharSequence)this.getResources().getString(R.string.cast_expanded_controller_skip_ad_text, new Object[]{(int)Math.ceil(f / 1000.0f)}));
                this.zzI.setClickable(false);
                return;
            }
            return;
        }
    }

    private final void zzn() {
        Object object = this.zzL.getCurrentCastSession();
        if (object != null && (object = ((CastSession)object).getCastDevice()) != null && !TextUtils.isEmpty((CharSequence)(object = object.getFriendlyName()))) {
            this.zzw.setText((CharSequence)this.getResources().getString(R.string.cast_casting_to_device, new Object[]{object}));
            return;
        }
        this.zzw.setText((CharSequence)"");
    }

    private final void zzo() {
        Object object = this.zzj();
        if (object != null && ((RemoteMediaClient)object).hasMediaSession() && (object = ((RemoteMediaClient)object).getMediaInfo()) != null && (object = object.getMetadata()) != null && (this = this.getSupportActionBar()) != null) {
            this.setTitle(object.getString("com.google.android.gms.cast.metadata.TITLE"));
            object = com.google.android.gms.cast.framework.media.internal.zzw.zze((MediaMetadata)object);
            if (object != null) {
                this.setSubtitle((CharSequence)object);
                return;
            }
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @TargetApi(value=23)
    private final void zzp() {
        void var1_6;
        void var1_4;
        void var2_14;
        AdBreakClipInfo adBreakClipInfo;
        Bitmap bitmap;
        Bitmap bitmap2;
        Drawable drawable2;
        RemoteMediaClient remoteMediaClient = this.zzj();
        if (remoteMediaClient == null) {
            return;
        }
        MediaStatus mediaStatus = remoteMediaClient.getMediaStatus();
        if (mediaStatus == null) {
            return;
        }
        if (!mediaStatus.isPlayingAd()) {
            this.zzJ.setVisibility(8);
            this.zzI.setVisibility(8);
            this.zzD.setVisibility(8);
            this.zzA.setVisibility(8);
            this.zzA.setImageBitmap(null);
            return;
        }
        if (this.zzA.getVisibility() == 8 && (drawable2 = this.zzz.getDrawable()) != null && drawable2 instanceof BitmapDrawable && (bitmap2 = ((BitmapDrawable)drawable2).getBitmap()) != null && (bitmap = com.google.android.gms.cast.framework.media.widget.zzs.zza((Context)this, bitmap2, 0.25f, 7.5f)) != null) {
            this.zzA.setImageBitmap(bitmap);
            this.zzA.setVisibility(0);
        }
        if ((adBreakClipInfo = mediaStatus.getCurrentAdBreakClip()) != null) {
            String string2 = adBreakClipInfo.getTitle();
            String string3 = adBreakClipInfo.getImageUrl();
        } else {
            Object var1_7 = null;
            Object var2_16 = null;
        }
        if (!TextUtils.isEmpty((CharSequence)var2_14)) {
            this.zzk((String)var2_14);
        } else if (!TextUtils.isEmpty((CharSequence)this.zzP)) {
            ExpandedControllerActivity expandedControllerActivity = this;
            expandedControllerActivity.zzk(expandedControllerActivity.zzP);
        } else {
            this.zzG.setVisibility(0);
            this.zzE.setVisibility(0);
            this.zzF.setVisibility(8);
        }
        TextView textView = this.zzH;
        if (TextUtils.isEmpty((CharSequence)var1_4)) {
            String string4 = this.getResources().getString(R.string.cast_ad_label);
        }
        textView.setText((CharSequence)var1_6);
        if (PlatformVersion.isAtLeastM()) {
            this.zzH.setTextAppearance(this.zzt);
        } else {
            ExpandedControllerActivity expandedControllerActivity = this;
            this.zzH.setTextAppearance((Context)expandedControllerActivity, expandedControllerActivity.zzt);
        }
        this.zzD.setVisibility(0);
        this.zzm(remoteMediaClient);
    }
}

