/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework.media;

import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.view.View;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TabHost;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.fragment.app.DialogFragment;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaStatus;
import com.google.android.gms.cast.MediaTrack;
import com.google.android.gms.cast.framework.CastContext;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.framework.R;
import com.google.android.gms.cast.framework.Session;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.cast.framework.media.zzbq;
import com.google.android.gms.cast.framework.media.zzbr;
import com.google.android.gms.cast.framework.media.zzbu;
import com.google.android.gms.common.internal.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public class TracksChooserDialogFragment
extends DialogFragment {
    @VisibleForTesting
    boolean zza;
    @VisibleForTesting
    List zzb;
    @VisibleForTesting
    List zzc;
    @Nullable
    private long[] zzd;
    @Nullable
    private Dialog zze;
    @Nullable
    private RemoteMediaClient zzf;
    @Nullable
    private MediaInfo zzg;
    private long[] zzh;

    /*
     * Enabled aggressive block sorting
     */
    @NonNull
    public Dialog onCreateDialog(@Nullable Bundle bundle) {
        int n = TracksChooserDialogFragment.zzd(this.zzb, this.zzd, 0);
        int n2 = TracksChooserDialogFragment.zzd(this.zzc, this.zzd, -1);
        zzbu zzbu2 = new zzbu((Context)this.getActivity(), this.zzb, n);
        zzbu zzbu3 = new zzbu((Context)this.getActivity(), this.zzc, n2);
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this.getActivity());
        View view = this.getActivity().getLayoutInflater().inflate(R.layout.cast_tracks_chooser_dialog_layout, null);
        ListView listView = (ListView)view.findViewById(R.id.text_list_view);
        ListView listView2 = (ListView)view.findViewById(R.id.audio_list_view);
        TabHost tabHost = (TabHost)view.findViewById(R.id.tab_host);
        tabHost.setup();
        if (zzbu2.getCount() == 0) {
            listView.setVisibility(4);
        } else {
            listView.setAdapter((ListAdapter)zzbu2);
            TabHost tabHost2 = tabHost;
            TabHost.TabSpec tabSpec = tabHost2.newTabSpec("textTab");
            tabSpec.setContent(R.id.text_list_view);
            tabSpec.setIndicator((CharSequence)this.getActivity().getString(R.string.cast_tracks_chooser_dialog_subtitles));
            tabHost2.addTab(tabSpec);
        }
        if (zzbu3.getCount() <= 1) {
            listView2.setVisibility(4);
        } else {
            listView2.setAdapter((ListAdapter)zzbu3);
            TabHost tabHost3 = tabHost;
            TabHost.TabSpec tabSpec = tabHost3.newTabSpec("audioTab");
            tabSpec.setContent(R.id.audio_list_view);
            tabSpec.setIndicator((CharSequence)this.getActivity().getString(R.string.cast_tracks_chooser_dialog_audio));
            tabHost3.addTab(tabSpec);
        }
        builder.setView(view).setPositiveButton((CharSequence)this.getActivity().getString(R.string.cast_tracks_chooser_dialog_ok), (DialogInterface.OnClickListener)new zzbr(this, zzbu2, zzbu3)).setNegativeButton(R.string.cast_tracks_chooser_dialog_cancel, (DialogInterface.OnClickListener)new zzbq(this));
        zzbu3 = this.zze;
        if (zzbu3 != null) {
            zzbu3.cancel();
            this.zze = null;
        }
        this.zze = builder.create();
        return this.zze;
    }

    @NonNull
    public static TracksChooserDialogFragment newInstance() {
        return new TracksChooserDialogFragment();
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @NonNull
    public static TracksChooserDialogFragment newInstance(@NonNull MediaInfo mediaInfo, @NonNull long[] activeTrackIds) {
        void var1_1;
        MediaInfo mediaInfo2;
        return new TracksChooserDialogFragment(mediaInfo2, (long[])var1_1);
    }

    @Deprecated
    public TracksChooserDialogFragment() {
    }

    private TracksChooserDialogFragment(MediaInfo mediaInfo, long[] lArray) {
        this.zzg = mediaInfo;
        this.zzh = lArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void onCreate(@Nullable Bundle savedInstanceState) {
        MediaInfo mediaInfo;
        Object object;
        super.onCreate((Bundle)object);
        this.zza = true;
        this.zzc = new ArrayList();
        this.zzb = new ArrayList();
        this.zzd = new long[0];
        object = CastContext.getSharedInstance(this.getContext()).getSessionManager().getCurrentCastSession();
        if (object == null || !((Session)object).isConnected()) {
            this.zza = false;
            return;
        }
        this.zzf = ((CastSession)object).getRemoteMediaClient();
        object = this.zzf;
        if (object == null || !((RemoteMediaClient)object).hasMediaSession() || this.zzf.getMediaInfo() == null) {
            this.zza = false;
            return;
        }
        object = this.zzf;
        long[] lArray = this.zzh;
        if (lArray != null) {
            this.zzd = lArray;
        } else {
            MediaStatus mediaStatus = ((RemoteMediaClient)object).getMediaStatus();
            if (mediaStatus != null) {
                this.zzd = mediaStatus.getActiveTrackIds();
            }
        }
        object = (mediaInfo = this.zzg) != null ? mediaInfo : ((RemoteMediaClient)object).getMediaInfo();
        if (object == null) {
            this.zza = false;
            return;
        }
        if ((object = object.getMediaTracks()) == null) {
            this.zza = false;
            return;
        }
        this.zzc = TracksChooserDialogFragment.zze((List)object, 2);
        this.zzb = TracksChooserDialogFragment.zze((List)object, 1);
        if (!this.zzb.isEmpty()) {
            MediaTrack.Builder builder = new MediaTrack.Builder(-1L, 1);
            builder.setName(this.getActivity().getString(R.string.cast_tracks_chooser_dialog_none));
            builder.setSubtype(2);
            builder.setContentId("");
            this.zzb.add(0, builder.build());
            return;
        }
    }

    public void onDestroyView() {
        Dialog dialog = this.getDialog();
        if (dialog != null && this.getRetainInstance()) {
            dialog.setDismissMessage(null);
        }
        super.onDestroyView();
    }

    private static int zzd(List list, @Nullable long[] lArray, int n) {
        if (lArray != null && list != null) {
            for (int i = 0; i < list.size(); ++i) {
                for (int j = 0; j < lArray.length; ++j) {
                    if (lArray[j] != ((MediaTrack)list.get(i)).getId()) continue;
                    return i;
                }
            }
            return n;
        }
        return n;
    }

    static /* bridge */ /* synthetic */ Dialog zza(TracksChooserDialogFragment tracksChooserDialogFragment) {
        return tracksChooserDialogFragment.zze;
    }

    private static ArrayList zze(List object, int n) {
        ArrayList<MediaTrack> arrayList = new ArrayList<MediaTrack>();
        object = object.iterator();
        while (object.hasNext()) {
            MediaTrack mediaTrack = (MediaTrack)object.next();
            if (mediaTrack.getType() != n) continue;
            arrayList.add(mediaTrack);
        }
        return arrayList;
    }

    static /* bridge */ /* synthetic */ void zzb(TracksChooserDialogFragment tracksChooserDialogFragment, Dialog dialog) {
        tracksChooserDialogFragment.zze = null;
    }

    static /* bridge */ /* synthetic */ void zzc(TracksChooserDialogFragment tracksChooserDialogFragment, zzbu object, zzbu object2) {
        if (!tracksChooserDialogFragment.zza) {
            tracksChooserDialogFragment.zzf();
            return;
        }
        RemoteMediaClient remoteMediaClient = (RemoteMediaClient)Preconditions.checkNotNull((Object)tracksChooserDialogFragment.zzf);
        if (!remoteMediaClient.hasMediaSession()) {
            tracksChooserDialogFragment.zzf();
            return;
        }
        ArrayList<Long> arrayList = new ArrayList<Long>();
        if ((object = ((zzbu)((Object)object)).zza()) != null && object.getId() != -1L) {
            arrayList.add(object.getId());
        }
        if ((object = object2.zza()) != null) {
            arrayList.add(object.getId());
        }
        if ((object2 = (Object)tracksChooserDialogFragment.zzd) != null && ((zzbu)object2).length > 0) {
            HashSet<Long> hashSet = new HashSet<Long>();
            object = tracksChooserDialogFragment.zzc.iterator();
            while (object.hasNext()) {
                hashSet.add(((MediaTrack)object.next()).getId());
            }
            object = tracksChooserDialogFragment.zzb.iterator();
            while (object.hasNext()) {
                hashSet.add(((MediaTrack)object.next()).getId());
            }
            int n = ((zzbu)object2).length;
            for (int i = 0; i < n; ++i) {
                Long l = (long)object2[i];
                if (hashSet.contains(l)) continue;
                arrayList.add(l);
            }
        }
        object2 = new long[arrayList.size()];
        int n = 0;
        while (n < arrayList.size()) {
            int n2 = n++;
            object2[n2] = (zzbu)((Object)((Long)arrayList.get(n2)));
        }
        Arrays.sort((long[])object2);
        remoteMediaClient.setActiveMediaTracks((long[])object2);
        tracksChooserDialogFragment.zzf();
    }

    private final void zzf() {
        Dialog dialog = this.zze;
        if (dialog != null) {
            dialog.cancel();
            this.zze = null;
            return;
        }
    }
}

