/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework.media;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.google.android.gms.cast.framework.media.zzx;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="NotificationActionCreator")
public class NotificationAction
extends AbstractSafeParcelable {
    @NonNull
    public static final Parcelable.Creator<NotificationAction> CREATOR = new zzx();
    @SafeParcelable.Field(id=2, getter="getAction")
    private final String zza;
    @SafeParcelable.Field(id=3, getter="getIconResId")
    private final int zzb;
    @SafeParcelable.Field(id=4, getter="getContentDescription")
    private final String zzc;

    public int getIconResId() {
        return this.zzb;
    }

    @NonNull
    public String getAction() {
        return this.zza;
    }

    @NonNull
    public String getContentDescription() {
        return this.zzc;
    }

    @SafeParcelable.Constructor
    NotificationAction(@SafeParcelable.Param(id=2) String string2, @SafeParcelable.Param(id=3) int n, @SafeParcelable.Param(id=4) String string3) {
        this.zza = string2;
        this.zzb = n;
        this.zzc = string3;
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@NonNull Parcel dest, int n) {
        void var1_1;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)dest);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)2, (String)this.getAction(), (boolean)false);
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)3, (int)this.getIconResId());
        void v1 = var1_1;
        SafeParcelWriter.writeString((Parcel)v1, (int)4, (String)this.getContentDescription(), (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)v1, (int)n2);
    }

    public static final class Builder {
        String zza;
        int zzb;
        String zzc;

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setAction(@NonNull String action) {
            void var1_1;
            if (TextUtils.isEmpty((CharSequence)action)) {
                throw new IllegalArgumentException("action cannot be null or an empty string.");
            }
            this.zza = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setContentDescription(@NonNull String contentDescription) {
            void var1_1;
            if (TextUtils.isEmpty((CharSequence)contentDescription)) {
                throw new IllegalArgumentException("contentDescription cannot be null  or an empty string.");
            }
            this.zzc = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setIconResId(int iconResId) {
            void var1_1;
            this.zzb = var1_1;
            return this;
        }

        @NonNull
        public NotificationAction build() {
            return new NotificationAction(this.zza, this.zzb, this.zzc);
        }
    }
}

