/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.RemoteException;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.framework.CastStateListener;
import com.google.android.gms.cast.framework.R;
import com.google.android.gms.cast.framework.Session;
import com.google.android.gms.cast.framework.SessionManagerListener;
import com.google.android.gms.cast.framework.zzao;
import com.google.android.gms.cast.framework.zzaz;
import com.google.android.gms.cast.framework.zzr;
import com.google.android.gms.cast.internal.Logger;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;

public class SessionManager {
    private static final Logger zza = new Logger("SessionManager");
    private final zzao zzb;
    private final Context zzc;

    @Nullable
    public CastSession getCurrentCastSession() {
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        Session session = ((SessionManager)((Object)session)).getCurrentSession();
        if (session != null && session instanceof CastSession) {
            return (CastSession)session;
        }
        return null;
    }

    @Nullable
    public Session getCurrentSession() {
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        try {
            Session session = (Session)ObjectWrapper.unwrap((IObjectWrapper)((SessionManager)((Object)session)).zzb.zzf());
            return session;
        }
        catch (RemoteException remoteException) {
            String string2 = "getWrappedCurrentSession";
            Object[] objectArray = new Object[]{string2, zzao.class.getSimpleName()};
            zza.d((Throwable)remoteException, "Unable to call %s on %s.", objectArray);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void addSessionManagerListener(@NonNull SessionManagerListener<Session> listener) throws NullPointerException {
        void var1_1;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        this.addSessionManagerListener((SessionManagerListener)var1_1, (Class)Session.class);
    }

    public <T extends Session> void addSessionManagerListener(@NonNull SessionManagerListener<T> listener, @NonNull Class<T> sessionClass) throws NullPointerException {
        String string2;
        Object[] objectArray;
        if (listener == null) {
            throw new NullPointerException("SessionManagerListener can't be null");
        }
        Preconditions.checkNotNull((Object)objectArray);
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        try {
            zzao zzao2 = ((SessionManager)((Object)zzao2)).zzb;
            zzao2.zzi(new zzaz((SessionManagerListener)((Object)string2), (Class)objectArray));
            return;
        }
        catch (RemoteException remoteException) {
            string2 = "addSessionManagerListener";
            objectArray = new Object[]{string2, zzao.class.getSimpleName()};
            zza.d((Throwable)remoteException, "Unable to call %s on %s.", objectArray);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void endCurrentSession(boolean stopCasting) {
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        try {
            void var1_2;
            zza.i("End session for %s", new Object[]{this.zzc.getPackageName()});
            this.zzb.zzj(true, (boolean)var1_2);
            return;
        }
        catch (RemoteException remoteException) {
            String string2 = "endCurrentSession";
            Object[] objectArray = new Object[]{string2, zzao.class.getSimpleName()};
            zza.d((Throwable)remoteException, "Unable to call %s on %s.", objectArray);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void removeSessionManagerListener(@NonNull SessionManagerListener<Session> listener) {
        void var1_1;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        this.removeSessionManagerListener((SessionManagerListener)var1_1, (Class)Session.class);
    }

    public <T extends Session> void removeSessionManagerListener(@NonNull SessionManagerListener<T> listener, @NonNull Class<T> sessionClass) {
        Object[] objectArray;
        String string2;
        Preconditions.checkNotNull(sessionClass);
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        if (string2 == null) {
            return;
        }
        try {
            zzao zzao2 = ((SessionManager)((Object)zzao2)).zzb;
            zzao2.zzl(new zzaz((SessionManagerListener)((Object)string2), (Class)objectArray));
            return;
        }
        catch (RemoteException remoteException) {
            string2 = "removeSessionManagerListener";
            objectArray = new Object[]{string2, zzao.class.getSimpleName()};
            zza.d((Throwable)remoteException, "Unable to call %s on %s.", objectArray);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void startSession(@NonNull Intent startSessionIntent) {
        String string2;
        try {
            String string3;
            zza.i("Start session for %s", new Object[]{this.zzc.getPackageName()});
            Bundle bundle = string2.getExtras();
            if (bundle == null || (string3 = bundle.getString("CAST_INTENT_TO_CAST_ROUTE_ID_KEY")) == null) {
                return;
            }
            string3 = bundle.getString("CAST_INTENT_TO_CAST_DEVICE_NAME_KEY");
            boolean bl = bundle.getBoolean("CAST_INTENT_TO_CAST_NO_TOAST_KEY");
            if (!bl) {
                string3 = this.zzc.getString(R.string.cast_connecting_to_device, new Object[]{string3});
                Toast.makeText((Context)this.zzc, (CharSequence)string3, (int)0).show();
            }
            string3 = "CAST_CUSTOM_MEDIA_ROUTE_DIALOG_FACTORY_SET_UP_KEY";
            bundle.putBoolean(string3, false);
            this.zzb.zzm(new Bundle(bundle));
            string2.removeExtra("CAST_INTENT_TO_CAST_ROUTE_ID_KEY");
            return;
        }
        catch (RemoteException remoteException) {
            string2 = "startSession";
            Object[] objectArray = new Object[]{string2, zzao.class.getSimpleName()};
            zza.d((Throwable)remoteException, "Unable to call %s on %s.", objectArray);
            return;
        }
    }

    final int zza() {
        try {
            int n = this.zzb.zze();
            return n;
        }
        catch (RemoteException remoteException) {
            String string2 = "addCastStateListener";
            Object[] objectArray = new Object[]{string2, zzao.class.getSimpleName()};
            zza.d((Throwable)remoteException, "Unable to call %s on %s.", objectArray);
            return 1;
        }
    }

    @Nullable
    public final IObjectWrapper zzb() {
        try {
            SessionManager sessionManager = sessionManager.zzb.zzg();
            return sessionManager;
        }
        catch (RemoteException remoteException) {
            String string2 = "getWrappedThis";
            Object[] objectArray = new Object[]{string2, zzao.class.getSimpleName()};
            zza.d((Throwable)remoteException, "Unable to call %s on %s.", objectArray);
            return null;
        }
    }

    public SessionManager(zzao zzao2, Context context) {
        this.zzb = zzao2;
        this.zzc = context;
    }

    final void zzc(CastStateListener object) throws NullPointerException {
        Preconditions.checkNotNull((Object)object);
        try {
            zzao zzao2 = ((SessionManager)((Object)zzao2)).zzb;
            zzao2.zzh(new zzr((CastStateListener)object));
            return;
        }
        catch (RemoteException remoteException) {
            object = "addCastStateListener";
            Object[] objectArray = new Object[]{object, zzao.class.getSimpleName()};
            zza.d((Throwable)remoteException, "Unable to call %s on %s.", objectArray);
            return;
        }
    }

    final void zzd(CastStateListener object) {
        try {
            zzao zzao2 = ((SessionManager)((Object)zzao2)).zzb;
            zzao2.zzk(new zzr((CastStateListener)object));
            return;
        }
        catch (RemoteException remoteException) {
            object = "removeCastStateListener";
            Object[] objectArray = new Object[]{object, zzao.class.getSimpleName()};
            zza.d((Throwable)remoteException, "Unable to call %s on %s.", objectArray);
            return;
        }
    }
}

