/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework;

import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.cast.ApplicationMetadata;
import com.google.android.gms.cast.Cast;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.framework.CastOptions;
import com.google.android.gms.cast.framework.Session;
import com.google.android.gms.cast.framework.media.CastMediaOptions;
import com.google.android.gms.cast.framework.media.NotificationOptions;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.cast.framework.media.internal.zzv;
import com.google.android.gms.cast.framework.zzac;
import com.google.android.gms.cast.framework.zzg;
import com.google.android.gms.cast.framework.zzh;
import com.google.android.gms.cast.framework.zzi;
import com.google.android.gms.cast.framework.zzm;
import com.google.android.gms.cast.framework.zzo;
import com.google.android.gms.cast.internal.Logger;
import com.google.android.gms.cast.internal.zzaq;
import com.google.android.gms.cast.zzbb;
import com.google.android.gms.cast.zzbc;
import com.google.android.gms.cast.zzbh;
import com.google.android.gms.cast.zzbt;
import com.google.android.gms.cast.zzq;
import com.google.android.gms.cast.zzr;
import com.google.android.gms.common.api.ApiException;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.PendingResults;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.RemoteCall;
import com.google.android.gms.common.api.internal.TaskApiCall;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.cast.zzaf;
import com.google.android.gms.internal.cast.zzbf;
import com.google.android.gms.internal.cast.zzbr;
import com.google.android.gms.tasks.Task;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.checkerframework.dataflow.qual.Pure;

public class CastSession
extends Session {
    private static final Logger zzb = new Logger("CastSession");
    private final Context zzc;
    private final Set zzd = new HashSet();
    @Nullable
    private final zzac zze;
    private final CastOptions zzf;
    private final zzbf zzg;
    private final zzv zzh;
    @Nullable
    private zzr zzi;
    @Nullable
    private RemoteMediaClient zzj;
    @Nullable
    private CastDevice zzk;
    @Nullable
    private Cast.ApplicationConnectionResult zzl;
    private final zzi zzm;
    public static final /* synthetic */ int zza;

    public double getVolume() throws IllegalStateException {
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        CastSession castSession = castSession.zzi;
        if (castSession != null && castSession.zzl()) {
            return castSession.zza();
        }
        return 0.0;
    }

    public int getActiveInputState() throws IllegalStateException {
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        CastSession castSession = castSession.zzi;
        if (castSession != null && castSession.zzl()) {
            return castSession.zzb();
        }
        return -1;
    }

    public int getStandbyState() throws IllegalStateException {
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        CastSession castSession = castSession.zzi;
        if (castSession != null && castSession.zzl()) {
            return castSession.zzc();
        }
        return -1;
    }

    @Override
    public long getSessionRemainingTimeMs() {
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        RemoteMediaClient remoteMediaClient = this.zzj;
        if (remoteMediaClient == null) {
            return 0L;
        }
        return remoteMediaClient.getStreamDuration() - this.zzj.getApproximateStreamPosition();
    }

    @Nullable
    public ApplicationMetadata getApplicationMetadata() throws IllegalStateException {
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        CastSession castSession = castSession.zzi;
        if (castSession != null && castSession.zzl()) {
            return castSession.zzd();
        }
        return null;
    }

    @Nullable
    public Cast.ApplicationConnectionResult getApplicationConnectionResult() {
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        return this.zzl;
    }

    @Pure
    @Nullable
    public CastDevice getCastDevice() {
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        return this.zzk;
    }

    @Nullable
    public RemoteMediaClient getRemoteMediaClient() {
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        return this.zzj;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public PendingResult<Status> sendMessage(@NonNull String namespace, @NonNull String message) {
        void var2_2;
        void var1_1;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        CastSession castSession = castSession.zzi;
        if (castSession == null) {
            return PendingResults.immediatePendingResult((Status)new Status(17));
        }
        return zzbr.zza(castSession.zzh((String)var1_1, (String)var2_2), com.google.android.gms.cast.framework.zzg.zza, com.google.android.gms.cast.framework.zzh.zza);
    }

    @Nullable
    public String getApplicationStatus() throws IllegalStateException {
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        CastSession castSession = castSession.zzi;
        if (castSession != null && castSession.zzl()) {
            return castSession.zzj();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public void addCastListener(@NonNull Cast.Listener listener) {
        void var1_1;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        if (var1_1 != null) {
            this.zzd.add(var1_1);
            return;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void end(boolean stopCasting) {
        Object object = this.zze;
        if (object == null) {
            return;
        }
        try {
            void var1_1;
            object.zze((boolean)var1_1, 0);
        }
        catch (RemoteException remoteException) {
            object = "disconnectFromDevice";
            Object[] objectArray = new Object[]{object, zzac.class.getSimpleName()};
            zzb.d((Throwable)remoteException, "Unable to call %s on %s.", objectArray);
        }
        this.notifySessionEnded(0);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void onResuming(@Nullable Bundle routeInfoExtra) {
        void var1_1;
        this.zzk = CastDevice.getFromBundle((Bundle)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void onStarting(@Nullable Bundle routeInfoExtra) {
        void var1_1;
        this.zzk = CastDevice.getFromBundle((Bundle)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void removeCastListener(@NonNull Cast.Listener listener) {
        void var1_1;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        if (var1_1 != null) {
            this.zzd.remove(var1_1);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void removeMessageReceivedCallbacks(@NonNull String namespace) throws IOException, IllegalArgumentException {
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        CastSession castSession = castSession.zzi;
        if (castSession != null) {
            void var1_1;
            castSession.zzg((String)var1_1);
            return;
        }
    }

    public void requestStatus() throws IOException, IllegalStateException {
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        CastSession castSession = castSession.zzi;
        if (castSession != null) {
            TaskApiCall taskApiCall = TaskApiCall.builder().run((RemoteCall)zzbb.zza).setMethodKey(8404).build();
            ((zzbt)castSession).doWrite(taskApiCall);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void resume(@Nullable Bundle routeInfoExtra) {
        void var1_1;
        this.zzm((Bundle)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setMessageReceivedCallbacks(@NonNull String namespace, @NonNull Cast.MessageReceivedCallback callbacks) throws IOException, IllegalStateException {
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        CastSession castSession = castSession.zzi;
        if (castSession != null && castSession.zzl()) {
            void var2_2;
            void var1_1;
            castSession.zzi((String)var1_1, (Cast.MessageReceivedCallback)var2_2);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setMute(boolean mute) throws IOException, IllegalStateException {
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        CastSession castSession = castSession.zzi;
        if (castSession != null && castSession.zzl()) {
            void var1_1;
            TaskApiCall taskApiCall = TaskApiCall.builder().run((RemoteCall)new zzbc((zzbt)castSession, (boolean)var1_1)).setMethodKey(8412).build();
            ((zzbt)castSession).doWrite(taskApiCall);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setVolume(double volume) throws IOException {
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        CastSession castSession = castSession.zzi;
        if (castSession != null && castSession.zzl()) {
            void var1_1;
            if (Double.isInfinite((double)var1_1) || Double.isNaN((double)var1_1)) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Volume cannot be ");
                stringBuilder.append((double)var1_1);
                throw new IllegalArgumentException(stringBuilder.toString());
            }
            TaskApiCall taskApiCall = TaskApiCall.builder().run((RemoteCall)new zzbh((zzbt)castSession, (double)var1_1)).setMethodKey(8411).build();
            ((zzbt)castSession).doWrite(taskApiCall);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void start(@Nullable Bundle routeInfoExtra) {
        void var1_1;
        this.zzm((Bundle)var1_1);
    }

    public boolean isMute() throws IllegalStateException {
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        CastSession castSession = castSession.zzi;
        return castSession != null && castSession.zzl() && castSession.zzm();
    }

    static /* bridge */ /* synthetic */ zzr zza(CastSession castSession) {
        return castSession.zzi;
    }

    static /* bridge */ /* synthetic */ zzac zzb(CastSession castSession) {
        return castSession.zze;
    }

    static /* bridge */ /* synthetic */ RemoteMediaClient zzc(CastSession castSession) {
        return castSession.zzj;
    }

    public final zzv zzd() {
        return this.zzh;
    }

    static /* bridge */ /* synthetic */ Logger zze() {
        return zzb;
    }

    static /* bridge */ /* synthetic */ Set zzf(CastSession castSession) {
        return castSession.zzd;
    }

    static /* bridge */ /* synthetic */ void zzg(CastSession castSession, int n) {
        castSession.zzh.zzi(n);
        Object object = castSession.zzi;
        if (object != null) {
            object.zzf();
            castSession.zzi = null;
        }
        castSession.zzk = null;
        object = castSession.zzj;
        if (object != null) {
            ((RemoteMediaClient)object).zzr(null);
            castSession.zzj = null;
        }
        castSession.zzl = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static /* bridge */ /* synthetic */ void zzh(CastSession castSession, String object, Task applicationConnectionResult) {
        if (castSession.zze == null) {
            return;
        }
        try {
            block11: {
                block10: {
                    block9: {
                        boolean bl;
                        boolean bl2 = applicationConnectionResult.isSuccessful();
                        if (!bl2) break block9;
                        castSession.zzl = applicationConnectionResult = (Cast.ApplicationConnectionResult)applicationConnectionResult.getResult();
                        Status status = applicationConnectionResult.getStatus();
                        if (status != null && (bl = applicationConnectionResult.getStatus().isSuccess())) {
                            zzb.d("%s() -> success result", new Object[]{object});
                            castSession.zzj = new RemoteMediaClient(new zzaq(null));
                            castSession.zzj.zzr(castSession.zzi);
                            castSession.zzj.zzp();
                            castSession.zzh.zzh(castSession.zzj, castSession.getCastDevice());
                            castSession.zze.zzf((ApplicationMetadata)Preconditions.checkNotNull((Object)applicationConnectionResult.getApplicationMetadata()), applicationConnectionResult.getApplicationStatus(), (String)Preconditions.checkNotNull((Object)applicationConnectionResult.getSessionId()), applicationConnectionResult.getWasLaunched());
                            return;
                        }
                        Status status2 = applicationConnectionResult.getStatus();
                        if (status2 != null) {
                            zzb.d("%s() -> failure result", new Object[]{object});
                            castSession.zze.zzg(applicationConnectionResult.getStatus().getStatusCode());
                            return;
                        }
                        break block10;
                    }
                    object = applicationConnectionResult.getException();
                    boolean bl = object instanceof ApiException;
                    if (bl) break block11;
                }
                castSession.zze.zzg(2476);
                return;
            }
            castSession.zze.zzg(((ApiException)object).getStatusCode());
            return;
        }
        catch (RemoteException remoteException) {
            object = "methods";
            applicationConnectionResult = new Cast.ApplicationConnectionResult[]{object, zzac.class.getSimpleName()};
            zzb.d((Throwable)remoteException, "Unable to call %s on %s.", (Object[])applicationConnectionResult);
            return;
        }
    }

    public CastSession(Context context, String string2, @Nullable String string3, CastOptions castOptions, zzbf zzbf2, zzv zzv2) {
        super(context, string2, string3);
        this.zzc = context.getApplicationContext();
        this.zzf = castOptions;
        this.zzg = zzbf2;
        CastSession castSession = this;
        castSession.zzh = zzv2;
        castSession.zzm = com.google.android.gms.cast.framework.zzi.zza;
        this.zze = zzaf.zzb(context, castOptions, this.zzl(), new zzm(this, null));
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void zzm(@Nullable Bundle object) {
        this.zzk = CastDevice.getFromBundle((Bundle)object);
        if (this.zzk == null) {
            if (this.isResuming()) {
                this.notifyFailedToResumeSession(2153);
                return;
            }
            this.notifyFailedToStartSession(2151);
            return;
        }
        object = this.zzi;
        if (object != null) {
            object.zzf();
            this.zzi = null;
        }
        object = new Object[]{this.zzk};
        zzb.d("Acquiring a connection to Google Play Services for %s", (Object[])object);
        CastDevice castDevice = (CastDevice)Preconditions.checkNotNull((Object)this.zzk);
        Bundle bundle = new Bundle();
        object = this.zzf;
        object = object == null ? null : ((CastOptions)((Object)object)).getCastMediaOptions();
        NotificationOptions notificationOptions = object == null ? null : ((CastMediaOptions)((Object)object)).getNotificationOptions();
        boolean bl = object != null ? ((CastMediaOptions)((Object)object)).zza() : false;
        boolean bl2 = notificationOptions != null;
        bundle.putBoolean("com.google.android.gms.cast.EXTRA_CAST_FRAMEWORK_NOTIFICATION_ENABLED", bl2);
        bundle.putBoolean("com.google.android.gms.cast.EXTRA_CAST_REMOTE_CONTROL_NOTIFICATION_ENABLED", bl);
        bl = this.zzg.zzs();
        bundle.putBoolean("com.google.android.gms.cast.EXTRA_CAST_ALWAYS_FOLLOW_SESSION_ENABLED", bl);
        Cast.CastOptions.Builder builder = new Cast.CastOptions.Builder(castDevice, (Cast.Listener)new zzo(this, null));
        builder.zzc(bundle);
        Cast.CastOptions castOptions = builder.build();
        zzr zzr2 = Cast.zza((Context)this.zzc, (Cast.CastOptions)castOptions);
        zzr2.zzk((zzq)new com.google.android.gms.cast.framework.zzq(this, null));
        this.zzi = zzr2;
        this.zzi.zze();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected final void zzi(@Nullable Bundle bundle) {
        Object object = CastDevice.getFromBundle((Bundle)bundle);
        if (object != null && !object.equals((Object)((CastSession)((Object)iterator)).zzk)) {
            CastDevice castDevice;
            boolean bl = !TextUtils.isEmpty((CharSequence)object.getFriendlyName()) ? ((bundle = ((CastSession)((Object)iterator)).zzk) != null ? !TextUtils.equals((CharSequence)bundle.getFriendlyName(), (CharSequence)object.getFriendlyName()) : true) : false;
            ((CastSession)((Object)iterator)).zzk = object;
            Logger logger = zzb;
            Object[] objectArray = new Object[2];
            objectArray[0] = ((CastSession)((Object)iterator)).zzk;
            object = true != bl ? "unchanged" : "changed";
            objectArray[1] = object;
            logger.d("update to device (%s) with name %s", objectArray);
            if (bl && (castDevice = ((CastSession)((Object)iterator)).zzk) != null) {
                object = ((CastSession)((Object)iterator)).zzh;
                if (object != null) {
                    ((zzv)object).zzk(castDevice);
                }
                Iterator iterator = new HashSet(((CastSession)((Object)iterator)).zzd).iterator();
                while (iterator.hasNext()) {
                    ((Cast.Listener)iterator.next()).onDeviceNameChanged();
                }
            }
        }
    }

    public final boolean zzj() {
        return this.zzg.zzs();
    }
}

