/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.cast.LaunchOptions;
import com.google.android.gms.cast.framework.media.CastMediaOptions;
import com.google.android.gms.cast.framework.zzf;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.cast.zzeq;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="CastOptionsCreator")
public class CastOptions
extends AbstractSafeParcelable {
    @NonNull
    public static final Parcelable.Creator<CastOptions> CREATOR = new zzf();
    @SafeParcelable.Field(id=2, getter="getReceiverApplicationId")
    private String zza;
    @SafeParcelable.Field(id=3, getter="getSupportedNamespaces")
    private final List zzb;
    @SafeParcelable.Field(id=4, getter="getStopReceiverApplicationWhenEndingSession")
    private final boolean zzc;
    @SafeParcelable.Field(id=5, getter="getLaunchOptions")
    private LaunchOptions zzd;
    @SafeParcelable.Field(id=6, getter="getResumeSavedSession")
    private final boolean zze;
    @SafeParcelable.Field(id=7, getter="getCastMediaOptions")
    @Nullable
    private final CastMediaOptions zzf;
    @SafeParcelable.Field(id=8, getter="getEnableReconnectionService")
    private final boolean zzg;
    @SafeParcelable.Field(id=9, getter="getVolumeDeltaBeforeIceCreamSandwich")
    private final double zzh;
    @SafeParcelable.Field(id=10, getter="getEnableIpv6Support")
    private final boolean zzi;
    @SafeParcelable.Field(id=11, getter="getOutputSwitcherEnabled")
    private final boolean zzj;
    @SafeParcelable.Field(id=12, getter="isRemoteToLocalEnabled")
    private final boolean zzk;
    @SafeParcelable.Field(id=13, getter="getRouteDiscoveryReceiverApplicationIds")
    private final List zzl;
    @SafeParcelable.Field(id=14, getter="isSessionTransferEnabled")
    private final boolean zzm;
    @SafeParcelable.Field(id=15, getter="getPersistCastButtonEnabled")
    private final int zzn;
    @SafeParcelable.Field(id=16, getter="isResumeSessionAfterTransferEnabled")
    private final boolean zzo;

    @Deprecated
    public double getVolumeDeltaBeforeIceCreamSandwich() {
        return this.zzh;
    }

    @NonNull
    public LaunchOptions getLaunchOptions() {
        return this.zzd;
    }

    @Nullable
    public CastMediaOptions getCastMediaOptions() {
        return this.zzf;
    }

    @NonNull
    public String getReceiverApplicationId() {
        return this.zza;
    }

    @NonNull
    public List<String> getSupportedNamespaces() {
        return Collections.unmodifiableList(this.zzb);
    }

    /*
     * Enabled aggressive block sorting
     */
    @SafeParcelable.Constructor
    CastOptions(@SafeParcelable.Param(id=2) String string2, @SafeParcelable.Param(id=3) List list, @SafeParcelable.Param(id=4) boolean bl, @SafeParcelable.Param(id=5) LaunchOptions launchOptions, @SafeParcelable.Param(id=6) boolean bl2, @SafeParcelable.Param(id=7) @Nullable CastMediaOptions castMediaOptions, @SafeParcelable.Param(id=8) boolean bl3, @SafeParcelable.Param(id=9) double d, @SafeParcelable.Param(id=10) boolean bl4, @SafeParcelable.Param(id=11) boolean bl5, @SafeParcelable.Param(id=12) boolean bl6, @SafeParcelable.Param(id=13) List list2, @SafeParcelable.Param(id=14) boolean bl7, @SafeParcelable.Param(id=15) int n, @SafeParcelable.Param(id=16) boolean bl8) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            string2 = "";
        }
        this.zza = string2;
        int n2 = list == null ? 0 : list.size();
        this.zzb = new ArrayList(n2);
        if (n2 > 0) {
            this.zzb.addAll(list);
        }
        this.zzc = bl;
        if (launchOptions == null) {
            launchOptions = new LaunchOptions();
        }
        this.zzd = launchOptions;
        this.zze = bl2;
        this.zzf = castMediaOptions;
        this.zzg = bl3;
        this.zzh = d;
        this.zzi = bl4;
        this.zzj = bl5;
        this.zzk = bl6;
        this.zzl = list2;
        this.zzm = bl7;
        this.zzn = n;
        this.zzo = bl8;
    }

    public final void writeToParcel(@NonNull Parcel parcel, int n) {
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel);
        SafeParcelWriter.writeString((Parcel)parcel, (int)2, (String)this.getReceiverApplicationId(), (boolean)false);
        SafeParcelWriter.writeStringList((Parcel)parcel, (int)3, this.getSupportedNamespaces(), (boolean)false);
        SafeParcelWriter.writeBoolean((Parcel)parcel, (int)4, (boolean)this.getStopReceiverApplicationWhenEndingSession());
        SafeParcelWriter.writeParcelable((Parcel)parcel, (int)5, (Parcelable)this.getLaunchOptions(), (int)n, (boolean)false);
        SafeParcelWriter.writeBoolean((Parcel)parcel, (int)6, (boolean)this.getResumeSavedSession());
        SafeParcelWriter.writeParcelable((Parcel)parcel, (int)7, (Parcelable)this.getCastMediaOptions(), (int)n, (boolean)false);
        SafeParcelWriter.writeBoolean((Parcel)parcel, (int)8, (boolean)this.getEnableReconnectionService());
        SafeParcelWriter.writeDouble((Parcel)parcel, (int)9, (double)this.getVolumeDeltaBeforeIceCreamSandwich());
        SafeParcelWriter.writeBoolean((Parcel)parcel, (int)10, (boolean)this.zzi);
        SafeParcelWriter.writeBoolean((Parcel)parcel, (int)11, (boolean)this.zzj);
        SafeParcelWriter.writeBoolean((Parcel)parcel, (int)12, (boolean)this.zzk);
        SafeParcelWriter.writeStringList((Parcel)parcel, (int)13, Collections.unmodifiableList(this.zzl), (boolean)false);
        SafeParcelWriter.writeBoolean((Parcel)parcel, (int)14, (boolean)this.zzm);
        SafeParcelWriter.writeInt((Parcel)parcel, (int)15, (int)this.zzn);
        Parcel parcel2 = parcel;
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)16, (boolean)this.zzo);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    public boolean getEnableReconnectionService() {
        return this.zzg;
    }

    public boolean getResumeSavedSession() {
        return this.zze;
    }

    public boolean getStopReceiverApplicationWhenEndingSession() {
        return this.zzc;
    }

    @ShowFirstParty
    @NonNull
    public final List zza() {
        return Collections.unmodifiableList(this.zzl);
    }

    public final void zzb(@NonNull LaunchOptions launchOptions) {
        this.zzd = launchOptions;
    }

    public final void zzc(@NonNull String string2) {
        this.zza = string2;
    }

    public final boolean zzd() {
        return this.zzj;
    }

    @ShowFirstParty
    public final boolean zze() {
        int n = this.zzn;
        if (n == 1) {
            return true;
        }
        if (n != 2) {
            if (this.zzj) {
                return false;
            }
            return false;
        }
        return false;
    }

    public final boolean zzf() {
        return this.zzk;
    }

    public final boolean zzg() {
        return this.zzo;
    }

    public final boolean zzh() {
        return this.zzm;
    }

    public static final class Builder {
        private String zza;
        private List zzb = new ArrayList();
        private boolean zzc;
        private LaunchOptions zzd = new LaunchOptions();
        private boolean zze = true;
        @Nullable
        private zzeq zzf = null;
        private boolean zzg = true;
        private double zzh = 0.05f;
        private boolean zzi = false;
        private final List zzj = new ArrayList();

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setCastMediaOptions(@NonNull CastMediaOptions castMediaOptions) {
            void var1_1;
            this.zzf = zzeq.zzb((Object)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setEnableReconnectionService(boolean enableReconnectionService) {
            void var1_1;
            this.zzg = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setLaunchOptions(@NonNull LaunchOptions launchOptions) {
            void var1_1;
            this.zzd = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setReceiverApplicationId(@NonNull String applicationId) {
            void var1_1;
            this.zza = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setRemoteToLocalEnabled(boolean remoteToLocalEnabled) {
            void var1_1;
            this.zzi = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setResumeSavedSession(boolean resumeSavedSession) {
            void var1_1;
            this.zze = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setStopReceiverApplicationWhenEndingSession(boolean stopApp) {
            void var1_1;
            this.zzc = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setSupportedNamespaces(@NonNull List<String> supportedNamespaces) {
            void var1_1;
            this.zzb = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Deprecated
        @NonNull
        public Builder setVolumeDeltaBeforeIceCreamSandwich(double volumeDelta) throws IllegalArgumentException {
            void var1_1;
            if (volumeDelta <= 0.0 || var1_1 > 0.5) {
                throw new IllegalArgumentException("volumeDelta must be greater than 0 and less or equal to 0.5");
            }
            this.zzh = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        @NonNull
        public CastOptions build() {
            void var1_3;
            zzeq zzeq2 = ((Builder)((Object)this_)).zzf;
            if (zzeq2 != null) {
                Object object = zzeq2.zza();
            } else {
                CastMediaOptions castMediaOptions = new CastMediaOptions.Builder().build();
            }
            boolean bl = ((Builder)((Object)this_)).zzg;
            double d = ((Builder)((Object)this_)).zzh;
            boolean bl2 = ((Builder)((Object)this_)).zzi;
            List this_ = ((Builder)((Object)this_)).zzj;
            return new CastOptions(((Builder)((Object)this_)).zza, ((Builder)((Object)this_)).zzb, ((Builder)((Object)this_)).zzc, ((Builder)((Object)this_)).zzd, ((Builder)((Object)this_)).zze, (CastMediaOptions)var1_3, bl, d, false, false, bl2, this_, true, 0, false);
        }
    }
}

