/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.cast;

import android.content.SharedPreferences;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import androidx.annotation.MainThread;
import androidx.annotation.Nullable;
import com.google.android.gms.cast.internal.Logger;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.common.util.DefaultClock;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.cast.zzf;
import com.google.android.gms.internal.cast.zzkx;
import com.google.android.gms.internal.cast.zzlj;
import com.google.android.gms.internal.cast.zzlk;
import com.google.android.gms.internal.cast.zzlp;
import com.google.android.gms.internal.cast.zzlq;
import com.google.android.gms.internal.cast.zzma;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;

@MainThread
public final class zzr {
    private static final Logger zza;
    private static final String zzb;
    @Nullable
    private static zzr zzc;
    private final zzf zzd;
    private final SharedPreferences zze;
    private final String zzf;
    private final Runnable zzg;
    private final Handler zzh;
    private final Set zzi;
    private final Set zzj;
    private final Clock zzk;
    private long zzl;

    private final long zzf() {
        return ((Clock)Preconditions.checkNotNull((Object)this.zzk)).currentTimeMillis();
    }

    public static synchronized zzr zza(SharedPreferences sharedPreferences, zzf zzf2, String string2) {
        if (zzc == null) {
            zzr zzr2;
            zzc = zzr2 = new zzr(sharedPreferences, zzf2, string2);
        }
        return zzc;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static zzkx zzg(String string2) {
        try {
            return zzkx.zzb((int)Integer.parseInt(string2));
        }
        catch (NumberFormatException numberFormatException) {
            return zzkx.zza;
        }
    }

    @VisibleForTesting
    static String zzb(String string2, String string3) {
        Object[] objectArray = new Object[]{string2, string3};
        return String.format("%s%s", objectArray);
    }

    @RequiresNonNull(value={"sharedPreferences"})
    private final String zzh(String string2) {
        String string3 = zzr.zzb("feature_usage_timestamp_reported_feature_", string2);
        if (this.zze.contains(string3)) {
            return string3;
        }
        return zzr.zzb("feature_usage_timestamp_detected_feature_", string2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static /* synthetic */ void zzc(zzr zzr2) {
        long l;
        block6: {
            block5: {
                if (zzr2.zzi.isEmpty()) break block5;
                long l2 = true != ((Object)zzr2.zzj).equals(zzr2.zzi) ? 86400000L : 172800000L;
                l = zzr2.zzf();
                long l3 = zzr2.zzl;
                if (l3 == 0L || l - l3 >= l2) break block6;
            }
            return;
        }
        zza.d("Upload the feature usage report.", new Object[0]);
        zzlp zzlp2 = zzlq.zza();
        zzlp2.zzb(zzb);
        zzlp2.zza(zzr2.zzf);
        zzlp2 = zzlp2.zzp();
        zzlp2 = (zzlq)zzlp2;
        Object object = new ArrayList();
        object.addAll(zzr2.zzi);
        zzlj zzlj2 = zzlk.zza();
        zzlj2.zza(object);
        zzlj2.zzb((zzlq)zzlp2);
        zzlp2 = zzlj2.zzp();
        zzlp2 = (zzlk)zzlp2;
        object = zzma.zzc();
        object.zzc((zzlk)zzlp2);
        zzlp2 = object.zzp();
        zzlp2 = (zzma)zzlp2;
        zzr2.zzd.zzd((zzma)zzlp2, 243);
        zzlp2 = zzr2.zze.edit();
        if (!((Object)zzr2.zzj).equals(zzr2.zzi)) {
            zzr2.zzj.clear();
            zzr2.zzj.addAll(zzr2.zzi);
            object = zzr2.zzj.iterator();
            while (object.hasNext()) {
                String string2;
                String string3 = Integer.toString(((zzkx)object.next()).zza());
                String string4 = zzr2.zzh(string3);
                if (TextUtils.equals((CharSequence)string4, (CharSequence)(string2 = zzr.zzb("feature_usage_timestamp_reported_feature_", string3)))) continue;
                long l4 = zzr2.zze.getLong(string4, 0L);
                zzlp2.remove(string4);
                if (l4 == 0L) continue;
                zzlp2.putLong(string2, l4);
            }
        }
        zzr2.zzl = l;
        zzlp2.putLong("feature_usage_last_report_time", l).apply();
    }

    static {
        Logger logger;
        zza = logger = new Logger("FeatureUsageAnalytics");
        zzb = "21.2.0";
    }

    private zzr(SharedPreferences object, zzf zzf2, String string2) {
        this.zze = object;
        this.zzd = zzf2;
        this.zzf = string2;
        this.zzk = DefaultClock.getInstance();
        this.zzi = object;
        super();
        this.zzj = object;
        super(Looper.getMainLooper());
        this.zzh = object;
        super(this);
        this.zzg = object;
    }

    public static void zzd(zzkx zzkx2) {
        zzr zzr2 = zzc;
        if (zzr2 == null) {
            return;
        }
        int n = zzkx2.zza();
        String string2 = Integer.toString(n);
        zzr2.zze.edit().putLong(zzr2.zzh(string2), zzr2.zzf()).apply();
        zzr2.zzi.add(zzkx2);
        zzr2.zzj();
    }

    private final void zzi(Set object) {
        if (object.isEmpty()) {
            return;
        }
        zzr zzr2 = zzr2.zze.edit();
        object = object.iterator();
        while (object.hasNext()) {
            zzr2.remove((String)object.next());
        }
        zzr2.apply();
    }

    public final void zze() {
        Object object = this.zze;
        object = object.getString("feature_usage_sdk_version", null);
        Iterator iterator = this.zze.getString("feature_usage_package_name", null);
        this.zzi.clear();
        this.zzj.clear();
        this.zzl = 0L;
        if (!zzb.equals(object) || !this.zzf.equals(iterator)) {
            object = new HashSet();
            for (String string2 : this.zze.getAll().keySet()) {
                if (!string2.startsWith("feature_usage_timestamp_")) continue;
                object.add(string2);
            }
            object.add("feature_usage_last_report_time");
            this.zzi((Set)object);
            this.zze.edit().putString("feature_usage_sdk_version", zzb).putString("feature_usage_package_name", this.zzf).apply();
            return;
        }
        this.zzl = this.zze.getLong("feature_usage_last_report_time", 0L);
        long l = this.zzf();
        object = new HashSet();
        for (String string3 : this.zze.getAll().keySet()) {
            if (!string3.startsWith("feature_usage_timestamp_")) continue;
            long l2 = this.zze.getLong(string3, 0L);
            if (l2 != 0L && l - l2 > 1209600000L) {
                object.add(string3);
                continue;
            }
            if (string3.startsWith("feature_usage_timestamp_reported_feature_")) {
                string3 = zzr.zzg(string3.substring(41));
                this.zzj.add(string3);
                this.zzi.add(string3);
                continue;
            }
            if (!string3.startsWith("feature_usage_timestamp_detected_feature_")) continue;
            string3 = string3.substring(41);
            string3 = zzr.zzg(string3);
            this.zzi.add(string3);
        }
        this.zzi((Set)object);
        Preconditions.checkNotNull((Object)this.zzh);
        Preconditions.checkNotNull((Object)this.zzg);
        this.zzj();
    }

    @RequiresNonNull(value={"handler", "reportFeatureUsageRunnable"})
    private final void zzj() {
        this.zzh.post(this.zzg);
    }
}

