/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.cast;

import android.graphics.PorterDuff;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.framework.R;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.cast.framework.media.uicontroller.zza;
import com.google.android.gms.cast.framework.media.widget.CastSeekBar;
import com.google.android.gms.internal.cast.zzcl;

public final class zzcr
extends zzcl {
    private final RelativeLayout zza;
    private final TextView zzb;
    private final CastSeekBar zzc;
    private final zza zzd;

    public zzcr(RelativeLayout relativeLayout, CastSeekBar castSeekBar, zza zza2) {
        this.zza = relativeLayout;
        this.zzb = (TextView)relativeLayout.findViewById(R.id.tooltip);
        this.zzc = castSeekBar;
        this.zzd = zza2;
        relativeLayout = this.zzb.getContext().obtainStyledAttributes(null, R.styleable.CastExpandedController, R.attr.castExpandedControllerStyle, R.style.CastExpandedController);
        int n = R.styleable.CastExpandedController_castSeekBarTooltipBackgroundColor;
        n = relativeLayout.getResourceId(n, 0);
        relativeLayout.recycle();
        relativeLayout = this.zzb;
        relativeLayout = relativeLayout.getContext();
        relativeLayout = relativeLayout.getResources();
        int n2 = relativeLayout.getColor(n);
        this.zzb.getBackground().setColorFilter(n2, PorterDuff.Mode.SRC_IN);
    }

    @Override
    public final void onMediaStatusUpdated() {
        this.zzd();
    }

    @Override
    public final void onSessionConnected(CastSession castSession) {
        super.onSessionConnected(castSession);
        this.zzd();
    }

    @Override
    public final void onSessionEnded() {
        super.onSessionEnded();
        this.zzd();
    }

    @Override
    public final void zza(boolean bl) {
        super.zza(bl);
        this.zzd();
    }

    @Override
    public final void zzb(long l) {
        this.zzd();
    }

    @VisibleForTesting
    final void zzd() {
        RemoteMediaClient remoteMediaClient = this.getRemoteMediaClient();
        if (remoteMediaClient == null || !remoteMediaClient.hasMediaSession() || this.zzc()) {
            this.zza.setVisibility(8);
            return;
        }
        this.zza.setVisibility(0);
        remoteMediaClient = this.zzb;
        zza zza2 = this.zzd;
        remoteMediaClient.setText(zza2.zzl((long)this.zzc.getProgress() + zza2.zze()));
        int n = this.zzc.getMeasuredWidth() - this.zzc.getPaddingLeft() - this.zzc.getPaddingRight();
        int n2 = View.MeasureSpec.makeMeasureSpec((int)n, (int)Integer.MIN_VALUE);
        int n3 = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        this.zzb.measure(n2, n3);
        n2 = this.zzb.getMeasuredWidth();
        CastSeekBar castSeekBar = this.zzc;
        int n4 = castSeekBar.getProgress();
        CastSeekBar castSeekBar2 = this.zzc;
        int n5 = castSeekBar2.getMaxProgress();
        n4 = Math.max(0, (int)((double)n4 / (double)n5 * (double)n) - n2 / 2);
        n = Math.min(n4, n - n2);
        RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)this.zzb.getLayoutParams();
        layoutParams.leftMargin = n;
        this.zzb.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }
}

