/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.cast;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.view.View;
import android.widget.ImageView;
import androidx.annotation.Nullable;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaMetadata;
import com.google.android.gms.cast.framework.CastContext;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.framework.media.CastMediaOptions;
import com.google.android.gms.cast.framework.media.ImageHints;
import com.google.android.gms.cast.framework.media.ImagePicker;
import com.google.android.gms.cast.framework.media.MediaUtils;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.cast.framework.media.internal.zzb;
import com.google.android.gms.cast.framework.media.uicontroller.UIController;
import com.google.android.gms.internal.cast.zzbs;
import com.google.android.gms.internal.cast.zzbt;

public final class zzbu
extends UIController {
    private final ImageView zza;
    private final ImageHints zzb;
    @Nullable
    private final Bitmap zzc;
    @Nullable
    private final View zzd;
    @Nullable
    private final ImagePicker zze;
    @Nullable
    private final zzbt zzf;
    private final zzb zzg;

    static /* bridge */ /* synthetic */ View zza(zzbu zzbu2) {
        return zzbu2.zzd;
    }

    static /* bridge */ /* synthetic */ ImageView zzb(zzbu zzbu2) {
        return zzbu2.zza;
    }

    static /* bridge */ /* synthetic */ zzbt zzc(zzbu zzbu2) {
        return zzbu2.zzf;
    }

    /*
     * Enabled aggressive block sorting
     */
    public zzbu(ImageView object, Context context, ImageHints imageHints, int n, @Nullable View view, @Nullable zzbt zzbt2) {
        this.zza = object;
        this.zzb = imageHints;
        this.zzf = zzbt2;
        object = n != 0 ? BitmapFactory.decodeResource((Resources)context.getResources(), (int)n) : null;
        this.zzc = object;
        this.zzd = view;
        object = CastContext.zza(context);
        if (object != null) {
            object = (object = ((CastContext)object).getCastOptions().getCastMediaOptions()) != null ? ((CastMediaOptions)((Object)object)).getImagePicker() : null;
            this.zze = object;
        } else {
            this.zze = null;
        }
        this.zzg = object = new zzb(context.getApplicationContext());
    }

    @Override
    public final void onMediaStatusUpdated() {
        this.zze();
    }

    @Override
    public final void onSessionConnected(CastSession object) {
        super.onSessionConnected((CastSession)object);
        object = this.zzg;
        zzbs zzbs2 = new zzbs(this);
        ((zzb)object).zzc(zzbs2);
        this.zzd();
        this.zze();
    }

    @Override
    public final void onSessionEnded() {
        this.zzg.zza();
        this.zzd();
        super.onSessionEnded();
    }

    private final void zzd() {
        View view = this.zzd;
        if (view != null) {
            view.setVisibility(0);
            this.zza.setVisibility(4);
        }
        if ((view = this.zzc) != null) {
            this.zza.setImageBitmap((Bitmap)view);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void zze() {
        RemoteMediaClient remoteMediaClient = this.getRemoteMediaClient();
        if (remoteMediaClient == null || !remoteMediaClient.hasMediaSession()) {
            this.zzd();
            return;
        }
        if ((remoteMediaClient = remoteMediaClient.getMediaInfo()) == null) {
            remoteMediaClient = null;
        } else {
            MediaMetadata mediaMetadata = remoteMediaClient.getMetadata();
            ImagePicker imagePicker = this.zze;
            remoteMediaClient = imagePicker != null && mediaMetadata != null && (mediaMetadata = imagePicker.onPickImage(mediaMetadata, this.zzb)) != null && mediaMetadata.getUrl() != null ? mediaMetadata.getUrl() : MediaUtils.getImageUri((MediaInfo)remoteMediaClient, 0);
        }
        if (remoteMediaClient == null) {
            this.zzd();
            return;
        }
        this.zzg.zzd((Uri)remoteMediaClient);
    }
}

