/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.cast;

import android.os.Bundle;
import android.os.RemoteException;
import android.text.TextUtils;
import androidx.mediarouter.media.MediaRouter;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.internal.Logger;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.cast.zzal;

public final class zzaq
extends MediaRouter.Callback {
    private static final Logger zza;
    private final zzal zzb;

    static {
        Logger logger;
        zza = logger = new Logger("MediaRouterCallback");
    }

    public zzaq(zzal zzal2) {
        this.zzb = (zzal)Preconditions.checkNotNull((Object)zzal2);
    }

    public final void onRouteAdded(MediaRouter mediaRouter, MediaRouter.RouteInfo objectArray) {
        try {
            this.zzb.zzf(objectArray.getId(), objectArray.getExtras());
            return;
        }
        catch (RemoteException remoteException) {
            mediaRouter = zza;
            objectArray = new Object[]{"onRouteAdded", zzal.class.getSimpleName()};
            mediaRouter.d((Throwable)remoteException, "Unable to call %s on %s.", objectArray);
            return;
        }
    }

    public final void onRouteChanged(MediaRouter mediaRouter, MediaRouter.RouteInfo objectArray) {
        try {
            this.zzb.zzg(objectArray.getId(), objectArray.getExtras());
            return;
        }
        catch (RemoteException remoteException) {
            mediaRouter = zza;
            objectArray = new Object[]{"onRouteChanged", zzal.class.getSimpleName()};
            mediaRouter.d((Throwable)remoteException, "Unable to call %s on %s.", objectArray);
            return;
        }
    }

    public final void onRouteRemoved(MediaRouter mediaRouter, MediaRouter.RouteInfo objectArray) {
        try {
            this.zzb.zzh(objectArray.getId(), objectArray.getExtras());
            return;
        }
        catch (RemoteException remoteException) {
            mediaRouter = zza;
            objectArray = new Object[]{"onRouteRemoved", zzal.class.getSimpleName()};
            mediaRouter.d((Throwable)remoteException, "Unable to call %s on %s.", objectArray);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void onRouteSelected(MediaRouter object, MediaRouter.RouteInfo objectArray, int n) {
        Object object2 = zza;
        Object[] objectArray2 = new Object[]{n, objectArray.getId()};
        object2.i("onRouteSelected with reason = %d, routeId = %s", objectArray2);
        if (objectArray.getPlaybackType() != 1) {
            return;
        }
        try {
            int n2;
            String string2;
            block7: {
                block8: {
                    block9: {
                        string2 = objectArray.getId();
                        object2 = objectArray.getId();
                        if (object2 == null) break block8;
                        boolean bl = ((String)object2).endsWith("-groupRoute");
                        if (bl) break block9;
                        object = object2;
                        break block7;
                    }
                    CastDevice castDevice = CastDevice.getFromBundle((Bundle)objectArray.getExtras());
                    if (castDevice == null) {
                        object = object2;
                        break block7;
                    } else {
                        boolean bl;
                        castDevice = castDevice.getDeviceId();
                        object = object.getRoutes().iterator();
                        while (bl = object.hasNext()) {
                            boolean bl2;
                            CastDevice castDevice2;
                            boolean bl3;
                            MediaRouter.RouteInfo routeInfo = (MediaRouter.RouteInfo)object.next();
                            String string3 = routeInfo.getId();
                            if (string3 == null || (bl3 = string3.endsWith("-groupRoute")) || (castDevice2 = CastDevice.getFromBundle((Bundle)routeInfo.getExtras())) == null || !(bl2 = TextUtils.equals((CharSequence)castDevice2.getDeviceId(), (CharSequence)castDevice))) continue;
                            object = zza;
                            castDevice = new Object[]{object2, routeInfo.getId()};
                            object.d("routeId is changed from %s to %s", (Object[])castDevice);
                            object = routeInfo.getId();
                            break block7;
                        }
                        object = object2;
                    }
                    break block7;
                }
                object = object2;
            }
            if ((n2 = this.zzb.zze()) >= 220400000) {
                this.zzb.zzj((String)object, string2, objectArray.getExtras());
                return;
            }
            this.zzb.zzi((String)object, objectArray.getExtras());
            return;
        }
        catch (RemoteException remoteException) {
            object = zza;
            objectArray = new Object[]{"onRouteSelected", zzal.class.getSimpleName()};
            object.d((Throwable)remoteException, "Unable to call %s on %s.", objectArray);
            return;
        }
    }

    public final void onRouteUnselected(MediaRouter mediaRouter, MediaRouter.RouteInfo objectArray, int n) {
        mediaRouter = zza;
        Object[] objectArray2 = new Object[]{n, objectArray.getId()};
        mediaRouter.i("onRouteUnselected with reason = %d, routeId = %s", objectArray2);
        if (objectArray.getPlaybackType() != 1) {
            zza.d("skip route unselection for non-cast route", new Object[0]);
            return;
        }
        try {
            this.zzb.zzk(objectArray.getId(), objectArray.getExtras(), n);
            return;
        }
        catch (RemoteException remoteException) {
            mediaRouter = zza;
            objectArray = new Object[]{"onRouteUnselected", zzal.class.getSimpleName()};
            mediaRouter.d((Throwable)remoteException, "Unable to call %s on %s.", objectArray);
            return;
        }
    }
}

