/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework.media.uicontroller;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.SeekBar;
import android.widget.TextView;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentTransaction;
import com.google.android.gms.cast.MediaSeekOptions;
import com.google.android.gms.cast.framework.CastContext;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.framework.R;
import com.google.android.gms.cast.framework.Session;
import com.google.android.gms.cast.framework.SessionManager;
import com.google.android.gms.cast.framework.SessionManagerListener;
import com.google.android.gms.cast.framework.media.ImageHints;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.cast.framework.media.TracksChooserDialogFragment;
import com.google.android.gms.cast.framework.media.uicontroller.UIController;
import com.google.android.gms.cast.framework.media.uicontroller.zza;
import com.google.android.gms.cast.framework.media.uicontroller.zzb;
import com.google.android.gms.cast.framework.media.uicontroller.zzc;
import com.google.android.gms.cast.framework.media.uicontroller.zzd;
import com.google.android.gms.cast.framework.media.uicontroller.zze;
import com.google.android.gms.cast.framework.media.uicontroller.zzf;
import com.google.android.gms.cast.framework.media.uicontroller.zzg;
import com.google.android.gms.cast.framework.media.uicontroller.zzh;
import com.google.android.gms.cast.framework.media.uicontroller.zzi;
import com.google.android.gms.cast.framework.media.uicontroller.zzj;
import com.google.android.gms.cast.framework.media.uicontroller.zzk;
import com.google.android.gms.cast.framework.media.widget.CastSeekBar;
import com.google.android.gms.cast.internal.Logger;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.cast.zzbn;
import com.google.android.gms.internal.cast.zzbo;
import com.google.android.gms.internal.cast.zzbp;
import com.google.android.gms.internal.cast.zzbr;
import com.google.android.gms.internal.cast.zzbt;
import com.google.android.gms.internal.cast.zzbu;
import com.google.android.gms.internal.cast.zzbv;
import com.google.android.gms.internal.cast.zzbw;
import com.google.android.gms.internal.cast.zzbx;
import com.google.android.gms.internal.cast.zzby;
import com.google.android.gms.internal.cast.zzca;
import com.google.android.gms.internal.cast.zzcb;
import com.google.android.gms.internal.cast.zzcc;
import com.google.android.gms.internal.cast.zzcd;
import com.google.android.gms.internal.cast.zzcf;
import com.google.android.gms.internal.cast.zzcg;
import com.google.android.gms.internal.cast.zzch;
import com.google.android.gms.internal.cast.zzci;
import com.google.android.gms.internal.cast.zzcj;
import com.google.android.gms.internal.cast.zzck;
import com.google.android.gms.internal.cast.zzcl;
import com.google.android.gms.internal.cast.zzcm;
import com.google.android.gms.internal.cast.zzcn;
import com.google.android.gms.internal.cast.zzkx;
import com.google.android.gms.internal.cast.zzr;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;

public class UIMediaController
implements RemoteMediaClient.Listener,
SessionManagerListener<CastSession> {
    private static final Logger zzb;
    private final Activity zzc;
    @Nullable
    private final SessionManager zzd;
    private final Map zze;
    private final Set zzf;
    @VisibleForTesting
    zza zza;
    @Nullable
    private RemoteMediaClient.Listener zzg;
    @Nullable
    private RemoteMediaClient zzh;

    @Nullable
    public RemoteMediaClient getRemoteMediaClient() {
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        return this.zzh;
    }

    static {
        Logger logger;
        zzb = logger = new Logger("UIMediaController");
    }

    /*
     * Enabled aggressive block sorting
     */
    public UIMediaController(@NonNull Activity activity) {
        Object object;
        HashSet hashSet;
        HashMap hashMap;
        this.zze = hashMap = new HashMap();
        this.zzf = hashSet = new HashSet();
        this.zza = com.google.android.gms.cast.framework.media.uicontroller.zza.zzf();
        this.zzc = object;
        object = CastContext.zza((Context)object);
        zzr.zzd(zzkx.zzp);
        object = object != null ? ((CastContext)object).getSessionManager() : null;
        this.zzd = object;
        if ((object = this.zzd) != null) {
            ((SessionManager)object).addSessionManagerListener(this, CastSession.class);
            this.zzh(this.zzd.getCurrentCastSession());
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public void bindImageViewToImageOfCurrentItem(@NonNull ImageView view, int imageType, @DrawableRes int placeHolderDrawableResId) {
        void var3_3;
        void var1_1;
        void var2_2;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        Activity activity = this.zzc;
        ImageHints imageHints = new ImageHints((int)var2_2, 0, 0);
        zzbu zzbu2 = new zzbu((ImageView)var1_1, (Context)activity, imageHints, (int)var3_3, null, null);
        this.zzl((View)var1_1, zzbu2);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public void bindImageViewToImageOfCurrentItem(@NonNull ImageView view, int imageType, @NonNull View placeHolderView) {
        void var3_3;
        void var1_1;
        void var2_2;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        Activity activity = this.zzc;
        ImageHints imageHints = new ImageHints((int)var2_2, 0, 0);
        zzbu zzbu2 = new zzbu((ImageView)var1_1, (Context)activity, imageHints, 0, (View)var3_3, null);
        this.zzl((View)var1_1, zzbu2);
    }

    /*
     * WARNING - void declaration
     */
    public void bindImageViewToImageOfCurrentItem(@NonNull ImageView view, @NonNull ImageHints imageHints, @DrawableRes int placeHolderDrawableResId) {
        void var3_3;
        void var2_2;
        void var1_1;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        zzbu zzbu2 = new zzbu((ImageView)var1_1, (Context)this.zzc, (ImageHints)var2_2, (int)var3_3, null, null);
        this.zzl((View)var1_1, zzbu2);
    }

    /*
     * WARNING - void declaration
     */
    public void bindImageViewToImageOfCurrentItem(@NonNull ImageView view, @NonNull ImageHints imageHints, @NonNull View placeHolderView) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.zzb((ImageView)var1_1, (ImageHints)var2_2, (View)var3_3, null);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public void bindImageViewToImageOfPreloadedItem(@NonNull ImageView view, int imageType, @DrawableRes int placeHolderDrawableResId) {
        void var3_3;
        void var1_1;
        void var2_2;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        Activity activity = this.zzc;
        ImageHints imageHints = new ImageHints((int)var2_2, 0, 0);
        zzbr zzbr2 = new zzbr((ImageView)var1_1, (Context)activity, imageHints, (int)var3_3);
        this.zzl((View)var1_1, zzbr2);
    }

    /*
     * WARNING - void declaration
     */
    public void bindImageViewToImageOfPreloadedItem(@NonNull ImageView view, @NonNull ImageHints imageHints, @DrawableRes int placeHolderDrawableResId) {
        void var3_3;
        void var2_2;
        void var1_1;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        zzbr zzbr2 = new zzbr((ImageView)var1_1, (Context)this.zzc, (ImageHints)var2_2, (int)var3_3);
        this.zzl((View)var1_1, zzbr2);
    }

    /*
     * WARNING - void declaration
     */
    public void bindImageViewToMuteToggle(@NonNull ImageView view) {
        void var1_1;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        Object object = new zzb(this);
        var1_1.setOnClickListener((View.OnClickListener)object);
        object = new zzca((ImageView)var1_1, (Context)this.zzc);
        this.zzl((View)var1_1, (UIController)object);
    }

    /*
     * WARNING - void declaration
     */
    public void bindImageViewToPlayPauseToggle(@NonNull ImageView view, @NonNull Drawable playDrawable, @NonNull Drawable pauseDrawable, @NonNull Drawable stopDrawable, @Nullable View loadingIndicator, boolean hideViewWhenLoading) {
        void var6_6;
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        zzr.zzd(zzkx.zzm);
        Object object = new zzc(this);
        var1_1.setOnClickListener((View.OnClickListener)object);
        object = new zzcb((ImageView)var1_1, (Context)this.zzc, (Drawable)var2_2, (Drawable)var3_3, (Drawable)var4_4, (View)var5_5, (boolean)var6_6);
        this.zzl((View)var1_1, (UIController)object);
    }

    /*
     * WARNING - void declaration
     */
    public void bindProgressBar(@NonNull ProgressBar view) {
        void var1_1;
        this.bindProgressBar((ProgressBar)var1_1, 1000L);
    }

    /*
     * WARNING - void declaration
     */
    public void bindProgressBar(@NonNull ProgressBar view, long progressUpdateStepMs) {
        void var2_2;
        void var1_1;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        zzcc zzcc2 = new zzcc((ProgressBar)var1_1, (long)var2_2);
        this.zzl((View)var1_1, zzcc2);
    }

    /*
     * WARNING - void declaration
     */
    public void bindSeekBar(@NonNull SeekBar view) {
        void var1_1;
        this.bindSeekBar((SeekBar)var1_1, 1000L);
    }

    /*
     * WARNING - void declaration
     */
    public void bindSeekBar(@NonNull CastSeekBar view) {
        void var1_1;
        this.bindSeekBar((CastSeekBar)var1_1, 1000L);
    }

    /*
     * WARNING - void declaration
     */
    public void bindSeekBar(@NonNull SeekBar view, long progressUpdateStepMs) {
        void var2_2;
        void var1_1;
        zzr.zzd(zzkx.zzn);
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        Object object = new zzi(this, (SeekBar)var1_1);
        var1_1.setOnSeekBarChangeListener((SeekBar.OnSeekBarChangeListener)object);
        object = new zzcf((SeekBar)var1_1, (long)var2_2, this.zza);
        this.zzl((View)var1_1, (UIController)object);
    }

    /*
     * WARNING - void declaration
     */
    public void bindSeekBar(@NonNull CastSeekBar view, long progressUpdateStepMs) {
        void var2_2;
        void var1_1;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        zzr.zzd(zzkx.zzn);
        Object object = new zzh(this);
        var1_1.zzd = object;
        object = new zzbn((CastSeekBar)var1_1, (long)var2_2, this.zza);
        this.zzl((View)var1_1, (UIController)object);
    }

    /*
     * WARNING - void declaration
     */
    public void bindTextViewToMetadataOfCurrentItem(@NonNull TextView view, @NonNull String key) {
        void var2_2;
        void var1_1;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        this.bindTextViewToMetadataOfCurrentItem((TextView)var1_1, Collections.singletonList(var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public void bindTextViewToMetadataOfCurrentItem(@NonNull TextView view, @NonNull List<String> keysInPreference) {
        void var2_2;
        void var1_1;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        zzby zzby2 = new zzby((TextView)var1_1, (List)var2_2);
        this.zzl((View)var1_1, zzby2);
    }

    /*
     * WARNING - void declaration
     */
    public void bindTextViewToMetadataOfPreloadedItem(@NonNull TextView view, @NonNull String key) {
        void var2_2;
        void var1_1;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        this.bindTextViewToMetadataOfPreloadedItem((TextView)var1_1, Collections.singletonList(var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public void bindTextViewToMetadataOfPreloadedItem(@NonNull TextView view, @NonNull List<String> keysInPreference) {
        void var2_2;
        void var1_1;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        zzbx zzbx2 = new zzbx((TextView)var1_1, (List)var2_2);
        this.zzl((View)var1_1, zzbx2);
    }

    /*
     * WARNING - void declaration
     */
    public void bindTextViewToSmartSubtitle(@NonNull TextView textView) {
        void var1_1;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        zzci zzci2 = new zzci((TextView)var1_1);
        this.zzl((View)var1_1, zzci2);
    }

    /*
     * WARNING - void declaration
     */
    public void bindTextViewToStreamDuration(@NonNull TextView view) {
        void var1_1;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        zzcj zzcj2 = new zzcj((TextView)var1_1, this.zzc.getString(R.string.cast_invalid_stream_duration_text), null);
        this.zzl((View)var1_1, zzcj2);
    }

    /*
     * WARNING - void declaration
     */
    public void bindTextViewToStreamDuration(@NonNull TextView view, @NonNull View liveStreamIndicator) {
        void var2_2;
        void var1_1;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        zzcj zzcj2 = new zzcj((TextView)var1_1, this.zzc.getString(R.string.cast_invalid_stream_duration_text), (View)var2_2);
        this.zzl((View)var1_1, zzcj2);
    }

    /*
     * WARNING - void declaration
     */
    public void bindTextViewToStreamPosition(@NonNull TextView view, boolean updateWhileScrubbing) {
        void var2_2;
        void var1_1;
        this.bindTextViewToStreamPosition((TextView)var1_1, (boolean)var2_2, 1000L);
    }

    /*
     * WARNING - void declaration
     */
    public void bindTextViewToStreamPosition(@NonNull TextView view, boolean updateWhileScrubbing, long progressUpdateStepMs) {
        void var2_2;
        void var3_3;
        void var1_1;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        zzck zzck2 = new zzck((TextView)var1_1, (long)var3_3, this.zzc.getString(R.string.cast_invalid_stream_position_text));
        if (var2_2 != false) {
            this.zzf.add(zzck2);
        }
        this.zzl((View)var1_1, zzck2);
    }

    /*
     * WARNING - void declaration
     */
    public void bindViewToClosedCaption(@NonNull View view) {
        void var1_1;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        Object object = new zzk(this);
        var1_1.setOnClickListener((View.OnClickListener)object);
        object = new zzbo((View)var1_1, (Context)this.zzc);
        this.zzl((View)var1_1, (UIController)object);
    }

    /*
     * WARNING - void declaration
     */
    public void bindViewToForward(@NonNull View view, long skipStepMs) {
        void var1_1;
        void var2_2;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        Object object = new zzf(this, (long)var2_2);
        var1_1.setOnClickListener((View.OnClickListener)object);
        object = new zzbp((View)var1_1, this.zza);
        this.zzl((View)var1_1, (UIController)object);
    }

    /*
     * WARNING - void declaration
     */
    public void bindViewToLaunchExpandedController(@NonNull View view) {
        void var1_1;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        Object object = new zzj(this);
        var1_1.setOnClickListener((View.OnClickListener)object);
        object = new zzbv((View)var1_1);
        this.zzl((View)var1_1, (UIController)object);
    }

    /*
     * WARNING - void declaration
     */
    public void bindViewToLoadingIndicator(@NonNull View view) {
        void var1_1;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        zzbw zzbw2 = new zzbw((View)var1_1);
        this.zzl((View)var1_1, zzbw2);
    }

    /*
     * WARNING - void declaration
     */
    public void bindViewToRewind(@NonNull View view, long skipStepMs) {
        void var1_1;
        void var2_2;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        Object object = new zzg(this, (long)var2_2);
        var1_1.setOnClickListener((View.OnClickListener)object);
        object = new zzcd((View)var1_1, this.zza);
        this.zzl((View)var1_1, (UIController)object);
    }

    /*
     * WARNING - void declaration
     */
    public void bindViewToSkipNext(@NonNull View view, int invisibleState) {
        void var2_2;
        void var1_1;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        Object object = new zzd(this);
        var1_1.setOnClickListener((View.OnClickListener)object);
        object = new zzcg((View)var1_1, (int)var2_2);
        this.zzl((View)var1_1, (UIController)object);
    }

    /*
     * WARNING - void declaration
     */
    public void bindViewToSkipPrev(@NonNull View view, int invisibleState) {
        void var2_2;
        void var1_1;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        Object object = new zze(this);
        var1_1.setOnClickListener((View.OnClickListener)object);
        object = new zzch((View)var1_1, (int)var2_2);
        this.zzl((View)var1_1, (UIController)object);
    }

    /*
     * WARNING - void declaration
     */
    public void bindViewToUIController(@NonNull View view, @NonNull UIController uiController) {
        void var2_2;
        void var1_1;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        this.zzl((View)var1_1, (UIController)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void bindViewVisibilityToMediaSession(@NonNull View view, int invisibleState) {
        void var2_2;
        void var1_1;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        zzcn zzcn2 = new zzcn((View)var1_1, (int)var2_2);
        this.zzl((View)var1_1, zzcn2);
    }

    /*
     * WARNING - void declaration
     */
    public void bindViewVisibilityToPreloadingEvent(@NonNull View view, int invisibleState) {
        void var2_2;
        void var1_1;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        zzcm zzcm2 = new zzcm((View)var1_1, (int)var2_2);
        this.zzl((View)var1_1, zzcm2);
    }

    public void dispose() {
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        this.zzg();
        this.zze.clear();
        SessionManager sessionManager = this.zzd;
        if (sessionManager != null) {
            sessionManager.removeSessionManagerListener(this, CastSession.class);
        }
        this.zzg = null;
    }

    @Override
    public void onAdBreakStatusUpdated() {
        ((UIMediaController)this_).zzm();
        RemoteMediaClient.Listener this_ = ((UIMediaController)this_).zzg;
        if (this_ != null) {
            this_.onAdBreakStatusUpdated();
            return;
        }
    }

    protected void onClosedCaptionClicked(@NonNull View object) {
        object = this_.getRemoteMediaClient();
        if (object == null || !object.hasMediaSession()) {
            return;
        }
        if (!(this_.zzc instanceof FragmentActivity)) {
            return;
        }
        object = TracksChooserDialogFragment.newInstance();
        UIMediaController this_ = (FragmentActivity)this_.zzc;
        FragmentTransaction fragmentTransaction = this_.getSupportFragmentManager().beginTransaction();
        if ((this_ = this_.getSupportFragmentManager().findFragmentByTag("TRACKS_CHOOSER_DIALOG_TAG")) != null) {
            fragmentTransaction.remove((Fragment)this_);
        }
        object.show(fragmentTransaction, "TRACKS_CHOOSER_DIALOG_TAG");
    }

    /*
     * WARNING - void declaration
     */
    protected void onForwardClicked(@NonNull View object, long skipStepMs) {
        object = ((UIMediaController)((Object)this_)).getRemoteMediaClient();
        if (object != null && ((RemoteMediaClient)object).hasMediaSession()) {
            void var2_2;
            if (((RemoteMediaClient)object).zzv()) {
                long l = ((RemoteMediaClient)object).getApproximateStreamPosition();
                zza this_ = ((UIMediaController)((Object)this_)).zza;
                ((RemoteMediaClient)object).seek(Math.min(l + var2_2, (long)this_.zzc() + this_.zze()));
                return;
            }
            ((RemoteMediaClient)object).seek(((RemoteMediaClient)object).getApproximateStreamPosition() + var2_2);
            return;
        }
    }

    protected void onLaunchExpandedControllerClicked(@NonNull View object) {
        object = CastContext.getSharedInstance((Context)this.zzc).getCastOptions().getCastMediaOptions();
        if (object == null || TextUtils.isEmpty((CharSequence)object.getExpandedControllerActivityClassName())) {
            return;
        }
        ComponentName componentName = new ComponentName(this.zzc.getApplicationContext(), object.getExpandedControllerActivityClassName());
        object = new Intent();
        object.setComponent(componentName);
        this.zzc.startActivity((Intent)object);
    }

    @Override
    public void onMetadataUpdated() {
        ((UIMediaController)this_).zzm();
        RemoteMediaClient.Listener this_ = ((UIMediaController)this_).zzg;
        if (this_ != null) {
            this_.onMetadataUpdated();
            return;
        }
    }

    protected void onMuteToggleClicked(@NonNull ImageView imageView) {
        CastSession this_ = CastContext.getSharedInstance(((UIMediaController)((Object)this_)).zzc.getApplicationContext()).getSessionManager().getCurrentCastSession();
        if (this_ == null || !this_.isConnected()) {
            return;
        }
        boolean bl = this_.isMute();
        bl ^= true;
        try {
            this_.setMute(bl);
            return;
        }
        catch (IOException | IllegalArgumentException exception) {
            imageView = zzb;
            Object[] objectArray = new Object[]{exception};
            imageView.e("Unable to call CastSession.setMute(boolean).", objectArray);
            return;
        }
    }

    protected void onPlayPauseToggleClicked(@NonNull ImageView imageView) {
        if ((this = ((UIMediaController)this).getRemoteMediaClient()) != null && ((RemoteMediaClient)this).hasMediaSession()) {
            ((RemoteMediaClient)this).togglePlayback();
            return;
        }
    }

    @Override
    public void onPreloadStatusUpdated() {
        ((UIMediaController)this_).zzm();
        RemoteMediaClient.Listener this_ = ((UIMediaController)this_).zzg;
        if (this_ != null) {
            this_.onPreloadStatusUpdated();
            return;
        }
    }

    @Override
    public void onQueueStatusUpdated() {
        ((UIMediaController)this_).zzm();
        RemoteMediaClient.Listener this_ = ((UIMediaController)this_).zzg;
        if (this_ != null) {
            this_.onQueueStatusUpdated();
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void onRewindClicked(@NonNull View object, long skipStepMs) {
        object = ((UIMediaController)((Object)this_)).getRemoteMediaClient();
        if (object != null && ((RemoteMediaClient)object).hasMediaSession()) {
            void var2_2;
            if (((RemoteMediaClient)object).zzv()) {
                long l = ((RemoteMediaClient)object).getApproximateStreamPosition();
                zza this_ = ((UIMediaController)((Object)this_)).zza;
                ((RemoteMediaClient)object).seek(Math.max(l - var2_2, (long)this_.zzd() + this_.zze()));
                return;
            }
            ((RemoteMediaClient)object).seek(((RemoteMediaClient)object).getApproximateStreamPosition() - var2_2);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void onSeekBarProgressChanged(@NonNull SeekBar seekBar, int progress, boolean fromUser) {
        void var3_3;
        void var2_2;
        this.zzi((int)var2_2, (boolean)var3_3);
    }

    protected void onSeekBarStartTrackingTouch(@NonNull SeekBar seekBar) {
        Iterator iterator;
        if (this.zze.containsKey(iterator)) {
            for (UIController uIController : (List)this.zze.get(iterator)) {
                if (!(uIController instanceof zzcf)) continue;
                ((zzcf)uIController).zza(false);
            }
        }
        this.zzj();
    }

    /*
     * WARNING - void declaration
     */
    protected void onSeekBarStopTrackingTouch(@NonNull SeekBar seekBar) {
        void var1_1;
        if (this.zze.containsKey(var1_1)) {
            for (UIController uIController : (List)this.zze.get(var1_1)) {
                if (!(uIController instanceof zzcf)) continue;
                ((zzcf)uIController).zza(true);
            }
        }
        this.zzk(var1_1.getProgress());
    }

    @Override
    public void onSendingRemoteMediaRequest() {
        Iterator iterator = ((UIMediaController)this_).zze.values().iterator();
        while (iterator.hasNext()) {
            Iterator iterator2 = ((List)iterator.next()).iterator();
            while (iterator2.hasNext()) {
                ((UIController)iterator2.next()).onSendingRemoteMediaRequest();
            }
        }
        RemoteMediaClient.Listener this_ = ((UIMediaController)this_).zzg;
        if (this_ != null) {
            this_.onSendingRemoteMediaRequest();
            return;
        }
    }

    @Override
    public void onSessionEnded(@NonNull CastSession castSession, int n) {
        this.zzg();
    }

    @Override
    public void onSessionEnding(@NonNull CastSession castSession) {
    }

    @Override
    public void onSessionResumeFailed(@NonNull CastSession castSession, int n) {
        this.zzg();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onSessionResumed(@NonNull CastSession session, boolean bl) {
        void var1_1;
        this.zzh((Session)var1_1);
    }

    @Override
    public void onSessionResuming(@NonNull CastSession castSession, @NonNull String string2) {
    }

    @Override
    public void onSessionStartFailed(@NonNull CastSession castSession, int n) {
        this.zzg();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onSessionStarted(@NonNull CastSession session, @NonNull String string2) {
        void var1_1;
        this.zzh((Session)var1_1);
    }

    @Override
    public void onSessionStarting(@NonNull CastSession castSession) {
    }

    @Override
    public void onSessionSuspended(@NonNull CastSession castSession, int n) {
    }

    protected void onSkipNextClicked(@NonNull View view) {
        if ((this = ((UIMediaController)this).getRemoteMediaClient()) != null && ((RemoteMediaClient)this).hasMediaSession()) {
            ((RemoteMediaClient)this).queueNext(null);
            return;
        }
    }

    protected void onSkipPrevClicked(@NonNull View view) {
        if ((this = ((UIMediaController)this).getRemoteMediaClient()) != null && ((RemoteMediaClient)this).hasMediaSession()) {
            ((RemoteMediaClient)this).queuePrev(null);
            return;
        }
    }

    @Override
    public void onStatusUpdated() {
        ((UIMediaController)this_).zzm();
        RemoteMediaClient.Listener this_ = ((UIMediaController)this_).zzg;
        if (this_ != null) {
            this_.onStatusUpdated();
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setPostRemoteMediaClientListener(@Nullable RemoteMediaClient.Listener listener) {
        void var1_1;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        this.zzg = var1_1;
    }

    @EnsuresNonNullIf(expression={"remoteMediaClient"}, result=true)
    public boolean isActive() {
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        return this.zzh != null;
    }

    public final zza zza() {
        return this.zza;
    }

    public final void zzb(ImageView imageView, ImageHints imageHints, View view, @Nullable zzbt zzbt2) {
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        zzbu zzbu2 = new zzbu(imageView, (Context)this.zzc, imageHints, 0, view, zzbt2);
        this.zzl((View)imageView, zzbu2);
    }

    private final void zzg() {
        if (!this.isActive()) {
            return;
        }
        this.zza.zza = null;
        Iterator iterator = this.zze.values().iterator();
        while (iterator.hasNext()) {
            Iterator iterator2 = ((List)iterator.next()).iterator();
            while (iterator2.hasNext()) {
                ((UIController)iterator2.next()).onSessionEnded();
            }
        }
        Preconditions.checkNotNull((Object)this.zzh);
        this.zzh.removeListener(this);
        this.zzh = null;
    }

    private final void zzh(@Nullable Session session) {
        if (this.isActive() || session == null || !session.isConnected()) {
            return;
        }
        this.zzh = ((CastSession)session).getRemoteMediaClient();
        Object object = this.zzh;
        if (object != null) {
            ((RemoteMediaClient)object).addListener(this);
            Preconditions.checkNotNull((Object)this.zza);
            this.zza.zza = ((CastSession)session).getRemoteMediaClient();
            object = this.zze.values().iterator();
            while (object.hasNext()) {
                Iterator iterator = ((List)object.next()).iterator();
                while (iterator.hasNext()) {
                    ((UIController)iterator.next()).onSessionConnected((CastSession)session);
                }
            }
            this.zzm();
            return;
        }
    }

    protected final void zzc(@NonNull CastSeekBar castSeekBar, int n, boolean bl) {
        this.zzi(n, bl);
    }

    private final void zzi(int n, boolean bl) {
        if (bl) {
            Iterator iterator = this.zzf.iterator();
            while (iterator.hasNext()) {
                ((zzcl)iterator.next()).zzb((long)n + this.zza.zze());
            }
        }
    }

    protected final void zzd(@NonNull CastSeekBar castSeekBar) {
        this.zzj();
    }

    private final void zzj() {
        Iterator iterator = ((UIMediaController)((Object)iterator)).zzf.iterator();
        while (iterator.hasNext()) {
            ((zzcl)iterator.next()).zza(false);
        }
    }

    protected final void zze(@NonNull CastSeekBar castSeekBar) {
        this.zzk(castSeekBar.getProgress());
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void zzk(int n) {
        Object object = this.zzf.iterator();
        while (object.hasNext()) {
            ((zzcl)object.next()).zza(true);
        }
        object = this.getRemoteMediaClient();
        if (object != null && ((RemoteMediaClient)object).hasMediaSession()) {
            long l = (long)n + this.zza.zze();
            MediaSeekOptions.Builder builder = new MediaSeekOptions.Builder();
            builder.setPosition(l);
            boolean bl = ((RemoteMediaClient)object).isLiveStream() ? this.zza.zzn(l) : false;
            builder.setIsSeekToInfinite(bl);
            ((RemoteMediaClient)object).seek(builder.build());
            return;
        }
    }

    public final void zzf(zzcl zzcl2) {
        this.zzf.add(zzcl2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void zzl(View object, UIController uIController) {
        if (this.zzd == null) {
            return;
        }
        ArrayList arrayList = (ArrayList)this.zze.get(object);
        if (arrayList == null) {
            arrayList = new ArrayList();
            this.zze.put(object, arrayList);
            object = arrayList;
        } else {
            object = arrayList;
        }
        object.add(uIController);
        if (this.isActive()) {
            uIController.onSessionConnected((CastSession)Preconditions.checkNotNull((Object)this.zzd.getCurrentCastSession()));
            this.zzm();
            return;
        }
    }

    private final void zzm() {
        Iterator iterator = ((UIMediaController)((Object)iterator)).zze.values().iterator();
        while (iterator.hasNext()) {
            Iterator iterator2 = ((List)iterator.next()).iterator();
            while (iterator2.hasNext()) {
                ((UIController)iterator2.next()).onMediaStatusUpdated();
            }
        }
    }
}

