/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework.media;

import android.os.Handler;
import android.os.Looper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.cast.AdBreakInfo;
import com.google.android.gms.cast.Cast;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.MediaError;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaLoadOptions;
import com.google.android.gms.cast.MediaLoadRequestData;
import com.google.android.gms.cast.MediaQueueItem;
import com.google.android.gms.cast.MediaSeekOptions;
import com.google.android.gms.cast.MediaStatus;
import com.google.android.gms.cast.SessionState;
import com.google.android.gms.cast.TextTrackStyle;
import com.google.android.gms.cast.framework.media.MediaQueue;
import com.google.android.gms.cast.framework.media.zzab;
import com.google.android.gms.cast.framework.media.zzac;
import com.google.android.gms.cast.framework.media.zzad;
import com.google.android.gms.cast.framework.media.zzae;
import com.google.android.gms.cast.framework.media.zzaf;
import com.google.android.gms.cast.framework.media.zzag;
import com.google.android.gms.cast.framework.media.zzah;
import com.google.android.gms.cast.framework.media.zzai;
import com.google.android.gms.cast.framework.media.zzaj;
import com.google.android.gms.cast.framework.media.zzak;
import com.google.android.gms.cast.framework.media.zzal;
import com.google.android.gms.cast.framework.media.zzam;
import com.google.android.gms.cast.framework.media.zzan;
import com.google.android.gms.cast.framework.media.zzao;
import com.google.android.gms.cast.framework.media.zzap;
import com.google.android.gms.cast.framework.media.zzaq;
import com.google.android.gms.cast.framework.media.zzar;
import com.google.android.gms.cast.framework.media.zzas;
import com.google.android.gms.cast.framework.media.zzat;
import com.google.android.gms.cast.framework.media.zzau;
import com.google.android.gms.cast.framework.media.zzav;
import com.google.android.gms.cast.framework.media.zzaw;
import com.google.android.gms.cast.framework.media.zzax;
import com.google.android.gms.cast.framework.media.zzay;
import com.google.android.gms.cast.framework.media.zzaz;
import com.google.android.gms.cast.framework.media.zzba;
import com.google.android.gms.cast.framework.media.zzbb;
import com.google.android.gms.cast.framework.media.zzbc;
import com.google.android.gms.cast.framework.media.zzbd;
import com.google.android.gms.cast.framework.media.zzbe;
import com.google.android.gms.cast.framework.media.zzbf;
import com.google.android.gms.cast.framework.media.zzbh;
import com.google.android.gms.cast.framework.media.zzbi;
import com.google.android.gms.cast.framework.media.zzbj;
import com.google.android.gms.cast.framework.media.zzbl;
import com.google.android.gms.cast.framework.media.zzbm;
import com.google.android.gms.cast.framework.media.zzbp;
import com.google.android.gms.cast.framework.media.zzbr;
import com.google.android.gms.cast.internal.Logger;
import com.google.android.gms.cast.zzr;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.cast.zzdm;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.tasks.Tasks;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.checkerframework.checker.initialization.qual.NotOnlyInitialized;
import org.json.JSONObject;

public class RemoteMediaClient
implements Cast.MessageReceivedCallback {
    @NonNull
    public static final String NAMESPACE;
    public static final int RESUME_STATE_UNCHANGED = 0;
    public static final int RESUME_STATE_PLAY = 1;
    public static final int RESUME_STATE_PAUSE = 2;
    public static final int STATUS_SUCCEEDED = 0;
    public static final int STATUS_FAILED = 2100;
    public static final int STATUS_REPLACED = 2103;
    private static final Logger zzb;
    private final Object zzc;
    private final Handler zzd;
    private final com.google.android.gms.cast.internal.zzas zze;
    private final zzbh zzf;
    @NotOnlyInitialized
    private final MediaQueue zzg;
    @Nullable
    private zzr zzh;
    private TaskCompletionSource zzi;
    private final List zzj;
    @VisibleForTesting
    final List zza;
    private final Map zzk;
    private final Map zzl;
    private ParseAdsInfoCallback zzm;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getIdleReason() {
        Object object = this_.zzc;
        synchronized (object) {
            Preconditions.checkMainThread((String)"Must be called from the main thread.");
            RemoteMediaClient this_ = this_.getMediaStatus();
            if (this_ == null) return 0;
            return this_.getIdleReason();
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getPlayerState() {
        Object object = this_.zzc;
        synchronized (object) {
            Preconditions.checkMainThread((String)"Must be called from the main thread.");
            RemoteMediaClient this_ = this_.getMediaStatus();
            if (this_ == null) return 1;
            return this_.getPlayerState();
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getApproximateAdBreakClipPositionMs() {
        Object object = this.zzc;
        synchronized (object) {
            Preconditions.checkMainThread((String)"Must be called from the main thread.");
            return this.zze.zzj();
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getApproximateLiveSeekableRangeEnd() {
        Object object = this.zzc;
        synchronized (object) {
            Preconditions.checkMainThread((String)"Must be called from the main thread.");
            return this.zze.zzk();
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getApproximateLiveSeekableRangeStart() {
        Object object = this.zzc;
        synchronized (object) {
            Preconditions.checkMainThread((String)"Must be called from the main thread.");
            return this.zze.zzl();
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getApproximateStreamPosition() {
        Object object = this.zzc;
        synchronized (object) {
            Preconditions.checkMainThread((String)"Must be called from the main thread.");
            return this.zze.zzm();
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getStreamDuration() {
        Object object = this.zzc;
        synchronized (object) {
            Preconditions.checkMainThread((String)"Must be called from the main thread.");
            return this.zze.zzo();
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public MediaInfo getMediaInfo() {
        Object object = this_.zzc;
        synchronized (object) {
            Preconditions.checkMainThread((String)"Must be called from the main thread.");
            return this_.zze.zzK();
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    @Nullable
    public MediaQueueItem getCurrentItem() {
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        RemoteMediaClient remoteMediaClient = remoteMediaClient.getMediaStatus();
        if (remoteMediaClient == null) {
            return null;
        }
        return remoteMediaClient.getQueueItemById(remoteMediaClient.getCurrentItemId());
    }

    @Nullable
    public MediaQueueItem getLoadingItem() {
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        RemoteMediaClient remoteMediaClient = remoteMediaClient.getMediaStatus();
        if (remoteMediaClient == null) {
            return null;
        }
        return remoteMediaClient.getQueueItemById(remoteMediaClient.getLoadingItemId());
    }

    @Nullable
    public MediaQueueItem getPreloadedItem() {
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        RemoteMediaClient remoteMediaClient = remoteMediaClient.getMediaStatus();
        if (remoteMediaClient == null) {
            return null;
        }
        return remoteMediaClient.getQueueItemById(remoteMediaClient.getPreloadedItemId());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public MediaStatus getMediaStatus() {
        Object object = this_.zzc;
        synchronized (object) {
            Preconditions.checkMainThread((String)"Must be called from the main thread.");
            return this_.zze.zzL();
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    public MediaQueue getMediaQueue() {
        Object object = ((RemoteMediaClient)this_).zzc;
        synchronized (object) {
            Preconditions.checkMainThread((String)"Must be called from the main thread.");
            return ((RemoteMediaClient)this_).zzg;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @NonNull
    public PendingResult<MediaChannelResult> load(@NonNull MediaInfo mediaInfo) {
        void var1_1;
        MediaLoadOptions.Builder builder = new MediaLoadOptions.Builder();
        return this.load((MediaInfo)var1_1, builder.build());
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public PendingResult<MediaChannelResult> load(@NonNull MediaLoadRequestData loadRequestData) {
        void var1_1;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        if (!this.zzy()) {
            return RemoteMediaClient.zze(17, null);
        }
        zzax zzax2 = new zzax(this, (MediaLoadRequestData)var1_1);
        RemoteMediaClient.zzz(zzax2);
        return zzax2;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public PendingResult<MediaChannelResult> load(@NonNull MediaInfo mediaInfo, @NonNull MediaLoadOptions mediaLoadOptions) {
        void var2_2;
        void var1_1;
        MediaLoadRequestData.Builder builder = new MediaLoadRequestData.Builder();
        builder.setMediaInfo((MediaInfo)var1_1);
        builder.setAutoplay(Boolean.valueOf(var2_2.getAutoplay()));
        builder.setCurrentTime(var2_2.getPlayPosition());
        builder.setPlaybackRate(var2_2.getPlaybackRate());
        builder.setActiveTrackIds(var2_2.getActiveTrackIds());
        builder.setCustomData(var2_2.getCustomData());
        builder.setCredentials(var2_2.getCredentials());
        builder.setCredentialsType(var2_2.getCredentialsType());
        return this.load(builder.build());
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @NonNull
    public PendingResult<MediaChannelResult> load(@NonNull MediaInfo mediaInfo, boolean autoplay) {
        void var1_1;
        void var2_2;
        MediaLoadOptions.Builder builder = new MediaLoadOptions.Builder();
        builder.setAutoplay((boolean)var2_2);
        return this.load((MediaInfo)var1_1, builder.build());
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @NonNull
    public PendingResult<MediaChannelResult> load(@NonNull MediaInfo mediaInfo, boolean autoplay, long playPosition) {
        void var1_1;
        void var3_3;
        void var2_2;
        MediaLoadOptions.Builder builder = new MediaLoadOptions.Builder();
        builder.setAutoplay((boolean)var2_2);
        builder.setPlayPosition((long)var3_3);
        return this.load((MediaInfo)var1_1, builder.build());
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @NonNull
    public PendingResult<MediaChannelResult> load(@NonNull MediaInfo mediaInfo, boolean autoplay, long playPosition, @Nullable JSONObject customData) {
        void var1_1;
        void var5_4;
        void var3_3;
        void var2_2;
        MediaLoadOptions.Builder builder = new MediaLoadOptions.Builder();
        builder.setAutoplay((boolean)var2_2);
        builder.setPlayPosition((long)var3_3);
        builder.setCustomData((JSONObject)var5_4);
        return this.load((MediaInfo)var1_1, builder.build());
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @NonNull
    public PendingResult<MediaChannelResult> load(@NonNull MediaInfo mediaInfo, boolean autoplay, long playPosition, @NonNull long[] activeTrackIds, @Nullable JSONObject customData) {
        void var1_1;
        void var6_5;
        void var5_4;
        void var3_3;
        void var2_2;
        MediaLoadOptions.Builder builder = new MediaLoadOptions.Builder();
        builder.setAutoplay((boolean)var2_2);
        builder.setPlayPosition((long)var3_3);
        builder.setActiveTrackIds((long[])var5_4);
        builder.setCustomData((JSONObject)var6_5);
        return this.load((MediaInfo)var1_1, builder.build());
    }

    @NonNull
    public PendingResult<MediaChannelResult> pause() {
        return this.pause(null);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public PendingResult<MediaChannelResult> pause(@Nullable JSONObject customData) {
        void var1_1;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        if (!this.zzy()) {
            return RemoteMediaClient.zze(17, null);
        }
        zzaz zzaz2 = new zzaz(this, (JSONObject)var1_1);
        RemoteMediaClient.zzz(zzaz2);
        return zzaz2;
    }

    @NonNull
    public PendingResult<MediaChannelResult> play() {
        return this.play(null);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public PendingResult<MediaChannelResult> play(@Nullable JSONObject customData) {
        void var1_1;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        if (!this.zzy()) {
            return RemoteMediaClient.zze(17, null);
        }
        zzbb zzbb2 = new zzbb(this, (JSONObject)var1_1);
        RemoteMediaClient.zzz(zzbb2);
        return zzbb2;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public PendingResult<MediaChannelResult> queueAppendItem(@NonNull MediaQueueItem item, @Nullable JSONObject customData) throws IllegalArgumentException {
        void var2_2;
        void var1_1;
        MediaQueueItem[] mediaQueueItemArray = new MediaQueueItem[]{var1_1};
        return this.queueInsertItems(mediaQueueItemArray, 0, (JSONObject)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public PendingResult<MediaChannelResult> queueInsertAndPlayItem(@NonNull MediaQueueItem item, int insertBeforeItemId, @Nullable JSONObject customData) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.queueInsertAndPlayItem((MediaQueueItem)var1_1, (int)var2_2, -1L, (JSONObject)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public PendingResult<MediaChannelResult> queueInsertAndPlayItem(@NonNull MediaQueueItem item, int insertBeforeItemId, long playPosition, @Nullable JSONObject customData) {
        void var5_4;
        void var3_3;
        void var2_2;
        void var1_1;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        if (!this.zzy()) {
            return RemoteMediaClient.zze(17, null);
        }
        zzaj zzaj2 = new zzaj(this, (MediaQueueItem)var1_1, (int)var2_2, (long)var3_3, (JSONObject)var5_4);
        RemoteMediaClient.zzz(zzaj2);
        return zzaj2;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public PendingResult<MediaChannelResult> queueInsertItems(@NonNull MediaQueueItem[] itemsToInsert, int insertBeforeItemId, @Nullable JSONObject customData) throws IllegalArgumentException {
        void var3_3;
        void var2_2;
        void var1_1;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        if (!this.zzy()) {
            return RemoteMediaClient.zze(17, null);
        }
        zzai zzai2 = new zzai(this, (MediaQueueItem[])var1_1, (int)var2_2, (JSONObject)var3_3);
        RemoteMediaClient.zzz(zzai2);
        return zzai2;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public PendingResult<MediaChannelResult> queueJumpToItem(int itemId, @Nullable JSONObject customData) {
        void var2_2;
        void var1_1;
        return this.queueJumpToItem((int)var1_1, -1L, (JSONObject)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public PendingResult<MediaChannelResult> queueJumpToItem(int itemId, long playPosition, @Nullable JSONObject customData) {
        void var4_3;
        void var2_2;
        void var1_1;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        if (!this.zzy()) {
            return RemoteMediaClient.zze(17, null);
        }
        zzas zzas2 = new zzas(this, (int)var1_1, (long)var2_2, (JSONObject)var4_3);
        RemoteMediaClient.zzz(zzas2);
        return zzas2;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public PendingResult<MediaChannelResult> queueLoad(@NonNull MediaQueueItem[] items, int startIndex, int repeatMode, @Nullable JSONObject customData) throws IllegalArgumentException {
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        return this.queueLoad((MediaQueueItem[])var1_1, (int)var2_2, (int)var3_3, -1L, (JSONObject)var4_4);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public PendingResult<MediaChannelResult> queueLoad(@NonNull MediaQueueItem[] items, int startIndex, int repeatMode, long playPosition, @Nullable JSONObject customData) throws IllegalArgumentException {
        void var6_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        if (!this.zzy()) {
            return RemoteMediaClient.zze(17, null);
        }
        zzah zzah2 = new zzah(this, (MediaQueueItem[])var1_1, (int)var2_2, (int)var3_3, (long)var4_4, (JSONObject)var6_5);
        RemoteMediaClient.zzz(zzah2);
        return zzah2;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public PendingResult<MediaChannelResult> queueMoveItemToNewIndex(int itemId, int newIndex, @Nullable JSONObject customData) {
        void var3_3;
        void var2_2;
        void var1_1;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        if (!this.zzy()) {
            return RemoteMediaClient.zze(17, null);
        }
        zzat zzat2 = new zzat(this, (int)var1_1, (int)var2_2, (JSONObject)var3_3);
        RemoteMediaClient.zzz(zzat2);
        return zzat2;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public PendingResult<MediaChannelResult> queueNext(@Nullable JSONObject customData) {
        void var1_1;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        if (!this.zzy()) {
            return RemoteMediaClient.zze(17, null);
        }
        zzap zzap2 = new zzap(this, (JSONObject)var1_1);
        RemoteMediaClient.zzz(zzap2);
        return zzap2;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public PendingResult<MediaChannelResult> queuePrev(@Nullable JSONObject customData) {
        void var1_1;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        if (!this.zzy()) {
            return RemoteMediaClient.zze(17, null);
        }
        zzao zzao2 = new zzao(this, (JSONObject)var1_1);
        RemoteMediaClient.zzz(zzao2);
        return zzao2;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public PendingResult<MediaChannelResult> queueRemoveItem(int itemId, @Nullable JSONObject customData) {
        void var2_2;
        void var1_1;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        if (!this.zzy()) {
            return RemoteMediaClient.zze(17, null);
        }
        zzar zzar2 = new zzar(this, (int)var1_1, (JSONObject)var2_2);
        RemoteMediaClient.zzz(zzar2);
        return zzar2;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public PendingResult<MediaChannelResult> queueRemoveItems(@NonNull int[] itemIdsToRemove, @Nullable JSONObject customData) throws IllegalArgumentException {
        void var2_2;
        void var1_1;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        if (!this.zzy()) {
            return RemoteMediaClient.zze(17, null);
        }
        zzal zzal2 = new zzal(this, (int[])var1_1, (JSONObject)var2_2);
        RemoteMediaClient.zzz(zzal2);
        return zzal2;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public PendingResult<MediaChannelResult> queueReorderItems(@NonNull int[] itemIdsToReorder, int insertBeforeItemId, @Nullable JSONObject customData) throws IllegalArgumentException {
        void var3_3;
        void var2_2;
        void var1_1;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        if (!this.zzy()) {
            return RemoteMediaClient.zze(17, null);
        }
        zzam zzam2 = new zzam(this, (int[])var1_1, (int)var2_2, (JSONObject)var3_3);
        RemoteMediaClient.zzz(zzam2);
        return zzam2;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public PendingResult<MediaChannelResult> queueSetRepeatMode(int repeatMode, @Nullable JSONObject customData) {
        void var2_2;
        void var1_1;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        if (!this.zzy()) {
            return RemoteMediaClient.zze(17, null);
        }
        zzaq zzaq2 = new zzaq(this, (int)var1_1, (JSONObject)var2_2);
        RemoteMediaClient.zzz(zzaq2);
        return zzaq2;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @KeepForSdk
    @ShowFirstParty
    @NonNull
    public PendingResult<MediaChannelResult> queueShuffle(@Nullable JSONObject customData) {
        void var1_4;
        void var0_2;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        if (!this.zzy()) {
            PendingResult pendingResult = RemoteMediaClient.zze(17, null);
            return var0_2;
        }
        zzan zzan2 = new zzan(this, true, (JSONObject)var1_4);
        RemoteMediaClient.zzz(zzan2);
        zzan zzan3 = zzan2;
        return var0_2;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public PendingResult<MediaChannelResult> queueUpdateItems(@NonNull MediaQueueItem[] itemsToUpdate, @Nullable JSONObject customData) {
        void var2_2;
        void var1_1;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        if (!this.zzy()) {
            return RemoteMediaClient.zze(17, null);
        }
        zzak zzak2 = new zzak(this, (MediaQueueItem[])var1_1, (JSONObject)var2_2);
        RemoteMediaClient.zzz(zzak2);
        return zzak2;
    }

    @NonNull
    public PendingResult<MediaChannelResult> requestStatus() {
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        if (!this.zzy()) {
            return RemoteMediaClient.zze(17, null);
        }
        zzae zzae2 = new zzae(this);
        RemoteMediaClient.zzz(zzae2);
        return zzae2;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @NonNull
    public PendingResult<MediaChannelResult> seek(long position) {
        void var1_1;
        return this.seek((long)var1_1, 0, null);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public PendingResult<MediaChannelResult> seek(@NonNull MediaSeekOptions seekOptions) {
        void var1_1;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        if (!this.zzy()) {
            return RemoteMediaClient.zze(17, null);
        }
        zzbc zzbc2 = new zzbc(this, (MediaSeekOptions)var1_1);
        RemoteMediaClient.zzz(zzbc2);
        return zzbc2;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @NonNull
    public PendingResult<MediaChannelResult> seek(long position, int resumeState) {
        void var3_2;
        void var1_1;
        return this.seek((long)var1_1, (int)var3_2, null);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @NonNull
    public PendingResult<MediaChannelResult> seek(long position, int resumeState, @Nullable JSONObject customData) {
        void var4_3;
        void var3_2;
        void var1_1;
        MediaSeekOptions.Builder builder = new MediaSeekOptions.Builder();
        builder.setPosition((long)var1_1);
        builder.setResumeState((int)var3_2);
        builder.setCustomData((JSONObject)var4_3);
        return this.seek(builder.build());
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public PendingResult<MediaChannelResult> setActiveMediaTracks(@NonNull long[] trackIds) {
        void var1_1;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        if (!this.zzy()) {
            return RemoteMediaClient.zze(17, null);
        }
        zzaf zzaf2 = new zzaf(this, (long[])var1_1);
        RemoteMediaClient.zzz(zzaf2);
        return zzaf2;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public PendingResult<MediaChannelResult> setPlaybackRate(double playbackRate) {
        void var1_1;
        return this.setPlaybackRate((double)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public PendingResult<MediaChannelResult> setPlaybackRate(double playbackRate, @Nullable JSONObject customData) {
        void var3_2;
        void var1_1;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        if (!this.zzy()) {
            return RemoteMediaClient.zze(17, null);
        }
        zzbf zzbf2 = new zzbf(this, (double)var1_1, (JSONObject)var3_2);
        RemoteMediaClient.zzz(zzbf2);
        return zzbf2;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public PendingResult<MediaChannelResult> setStreamMute(boolean muted) {
        void var1_1;
        return this.setStreamMute((boolean)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public PendingResult<MediaChannelResult> setStreamMute(boolean muted, @Nullable JSONObject customData) {
        void var2_2;
        void var1_1;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        if (!this.zzy()) {
            return RemoteMediaClient.zze(17, null);
        }
        zzbe zzbe2 = new zzbe(this, (boolean)var1_1, (JSONObject)var2_2);
        RemoteMediaClient.zzz(zzbe2);
        return zzbe2;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public PendingResult<MediaChannelResult> setStreamVolume(double volume) throws IllegalArgumentException {
        void var1_1;
        return this.setStreamVolume((double)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public PendingResult<MediaChannelResult> setStreamVolume(double volume, @Nullable JSONObject customData) throws IllegalArgumentException {
        void var3_2;
        void var1_1;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        if (!this.zzy()) {
            return RemoteMediaClient.zze(17, null);
        }
        zzbd zzbd2 = new zzbd(this, (double)var1_1, (JSONObject)var3_2);
        RemoteMediaClient.zzz(zzbd2);
        return zzbd2;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public PendingResult<MediaChannelResult> setTextTrackStyle(@NonNull TextTrackStyle trackStyle) {
        void var1_1;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        if (!this.zzy()) {
            return RemoteMediaClient.zze(17, null);
        }
        zzag zzag2 = new zzag(this, (TextTrackStyle)var1_1);
        RemoteMediaClient.zzz(zzag2);
        return zzag2;
    }

    @NonNull
    public PendingResult<MediaChannelResult> skipAd() {
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        if (!this.zzy()) {
            return RemoteMediaClient.zze(17, null);
        }
        zzad zzad2 = new zzad(this);
        RemoteMediaClient.zzz(zzad2);
        return zzad2;
    }

    @NonNull
    public PendingResult<MediaChannelResult> stop() {
        return this.stop(null);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public PendingResult<MediaChannelResult> stop(@Nullable JSONObject customData) {
        void var1_1;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        if (!this.zzy()) {
            return RemoteMediaClient.zze(17, null);
        }
        zzba zzba2 = new zzba(this, (JSONObject)var1_1);
        RemoteMediaClient.zzz(zzba2);
        return zzba2;
    }

    @NonNull
    public String getNamespace() {
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        return this.zze.zze();
    }

    static {
        Logger logger;
        zzb = logger = new Logger("RemoteMediaClient");
        NAMESPACE = com.google.android.gms.cast.internal.zzas.zzb;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public void addListener(@NonNull Listener listener) {
        void var1_1;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        if (var1_1 != null) {
            this.zzj.add(var1_1);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void onMessageReceived(@NonNull CastDevice castDevice, @NonNull String string2, @NonNull String message) {
        void var3_3;
        this.zze.zzQ((String)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public void registerCallback(@NonNull Callback callback) {
        void var1_1;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        if (var1_1 != null) {
            this.zza.add(var1_1);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public void removeListener(@NonNull Listener listener) {
        void var1_1;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        if (var1_1 != null) {
            this.zzj.remove(var1_1);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void removeProgressListener(@NonNull ProgressListener listener) {
        void var1_1;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        zzbr zzbr2 = (zzbr)this.zzk.remove(var1_1);
        if (zzbr2 != null) {
            zzbr2.zze((ProgressListener)var1_1);
            if (!zzbr2.zzh()) {
                this.zzl.remove(zzbr2.zzb());
                zzbr2.zzg();
                return;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setParseAdsInfoCallback(@NonNull ParseAdsInfoCallback callback) {
        void var1_1;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        this.zzm = var1_1;
    }

    public void togglePlayback() {
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        int n = this.getPlayerState();
        if (n == 4 || n == 2) {
            this.pause();
            return;
        }
        this.play();
    }

    /*
     * WARNING - void declaration
     */
    public void unregisterCallback(@NonNull Callback callback) {
        void var1_1;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        if (var1_1 != null) {
            this.zza.remove(var1_1);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean addProgressListener(@NonNull ProgressListener listener, long periodMs) {
        void var2_2;
        void var1_1;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        if (var1_1 == null || this.zzk.containsKey(var1_1)) {
            return false;
        }
        Object object = this.zzl;
        Long l = (long)var2_2;
        if ((object = (zzbr)object.get(l)) == null) {
            object = new zzbr(this, (long)var2_2);
            this.zzl.put(l, object);
        }
        ((zzbr)object).zzd((ProgressListener)var1_1);
        this.zzk.put(var1_1, object);
        if (this.hasMediaSession()) {
            ((zzbr)object).zzf();
        }
        return true;
    }

    public boolean hasMediaSession() {
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        return this.isBuffering() || this.zzu() || this.isPlaying() || this.isPaused() || this.isLoadingNextItem();
    }

    public boolean isBuffering() {
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        RemoteMediaClient remoteMediaClient = remoteMediaClient.getMediaStatus();
        return remoteMediaClient != null && remoteMediaClient.getPlayerState() == 4;
    }

    public boolean isLiveStream() {
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        RemoteMediaClient remoteMediaClient = remoteMediaClient.getMediaInfo();
        return remoteMediaClient != null && remoteMediaClient.getStreamType() == 2;
    }

    public boolean isLoadingNextItem() {
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        RemoteMediaClient remoteMediaClient = remoteMediaClient.getMediaStatus();
        return remoteMediaClient != null && remoteMediaClient.getLoadingItemId() != 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isPaused() {
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        MediaStatus mediaStatus = this.getMediaStatus();
        if (mediaStatus == null) return false;
        if (mediaStatus.getPlayerState() == 3) return true;
        if (!this.isLiveStream()) return false;
        if (this.getIdleReason() == 2) return true;
        return false;
    }

    public boolean isPlaying() {
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        RemoteMediaClient remoteMediaClient = remoteMediaClient.getMediaStatus();
        return remoteMediaClient != null && remoteMediaClient.getPlayerState() == 2;
    }

    public boolean isPlayingAd() {
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        RemoteMediaClient remoteMediaClient = remoteMediaClient.getMediaStatus();
        return remoteMediaClient != null && remoteMediaClient.isPlayingAd();
    }

    static /* bridge */ /* synthetic */ Handler zza(RemoteMediaClient remoteMediaClient) {
        return remoteMediaClient.zzd;
    }

    static /* bridge */ /* synthetic */ ParseAdsInfoCallback zzb(RemoteMediaClient remoteMediaClient) {
        return remoteMediaClient.zzm;
    }

    static /* bridge */ /* synthetic */ Logger zzc() {
        return zzb;
    }

    static /* bridge */ /* synthetic */ com.google.android.gms.cast.internal.zzas zzd(RemoteMediaClient remoteMediaClient) {
        return remoteMediaClient.zze;
    }

    @NonNull
    public static PendingResult zze(int n, @Nullable String string2) {
        zzbj zzbj2 = new zzbj();
        Status status = new Status(n, string2);
        zzbi zzbi2 = new zzbi(zzbj2, status);
        zzbj2.setResult(zzbi2);
        return zzbj2;
    }

    @NonNull
    public final PendingResult zzf(@Nullable String string2, @Nullable List object) {
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        if (!this.zzy()) {
            return RemoteMediaClient.zze(17, null);
        }
        object = new zzay(this, true, string2, null);
        RemoteMediaClient.zzz((zzbm)((Object)object));
        return object;
    }

    @NonNull
    public final PendingResult zzg(int n, int n2, int n3) {
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        if (!this.zzy()) {
            return RemoteMediaClient.zze(17, null);
        }
        zzaw zzaw2 = new zzaw(this, true, n, n2, n3);
        RemoteMediaClient.zzz(zzaw2);
        return zzaw2;
    }

    @NonNull
    public final PendingResult zzh() {
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        if (!this.zzy()) {
            return RemoteMediaClient.zze(17, null);
        }
        zzau zzau2 = new zzau(this, true);
        RemoteMediaClient.zzz(zzau2);
        return zzau2;
    }

    @NonNull
    public final PendingResult zzi(@NonNull int[] nArray) {
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        if (!this.zzy()) {
            return RemoteMediaClient.zze(17, null);
        }
        zzav zzav2 = new zzav(this, true, nArray);
        RemoteMediaClient.zzz(zzav2);
        return zzav2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NonNull
    public final Task zzj(@Nullable JSONObject jSONObject) {
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        if (!remoteMediaClient.zzy()) {
            RemoteMediaClient remoteMediaClient = new com.google.android.gms.cast.internal.zzaq();
            return Tasks.forException((Exception)((Object)remoteMediaClient));
        }
        jSONObject = new TaskCompletionSource();
        remoteMediaClient.zzi = jSONObject;
        jSONObject = remoteMediaClient.getMediaStatus();
        if (jSONObject != null && jSONObject.isMediaCommandSupported(262144L)) {
            jSONObject = remoteMediaClient.zze;
            jSONObject = jSONObject.zzN(null);
            Object object = new zzab(remoteMediaClient);
            jSONObject = jSONObject.addOnSuccessListener((OnSuccessListener)object);
            object = new zzac(remoteMediaClient);
            jSONObject.addOnFailureListener((OnFailureListener)object);
            return remoteMediaClient.zzi.getTask();
        }
        remoteMediaClient.zzw();
        return remoteMediaClient.zzi.getTask();
    }

    static /* bridge */ /* synthetic */ Object zzk(RemoteMediaClient remoteMediaClient) {
        return remoteMediaClient.zzc;
    }

    static /* bridge */ /* synthetic */ List zzl(RemoteMediaClient remoteMediaClient) {
        return remoteMediaClient.zzj;
    }

    /*
     * Enabled aggressive block sorting
     */
    static /* bridge */ /* synthetic */ void zzm(RemoteMediaClient remoteMediaClient) {
        Iterator iterator = remoteMediaClient.zzl.values().iterator();
        while (iterator.hasNext()) {
            zzbr zzbr2 = (zzbr)iterator.next();
            if (remoteMediaClient.hasMediaSession() && !zzbr2.zzi()) {
                zzbr2.zzf();
            } else if (!remoteMediaClient.hasMediaSession() && zzbr2.zzi()) {
                zzbr2.zzg();
            }
            if (!zzbr2.zzi() || !remoteMediaClient.isBuffering() && !remoteMediaClient.zzu() && !remoteMediaClient.isPaused() && !remoteMediaClient.isLoadingNextItem()) continue;
            remoteMediaClient.zzx(zzbr.zzc(zzbr2));
        }
        return;
    }

    static /* bridge */ /* synthetic */ void zzn(RemoteMediaClient remoteMediaClient, Set set) {
        remoteMediaClient.zzx(set);
    }

    public RemoteMediaClient(com.google.android.gms.cast.internal.zzas object) {
        Object object2 = new CopyOnWriteArrayList();
        this.zzj = object2;
        object2 = new CopyOnWriteArrayList();
        this.zza = object2;
        this.zzk = object2;
        super();
        this.zzl = object2;
        this.zzc = object2 = new Object();
        object2 = new zzdm(Looper.getMainLooper());
        this.zzd = object2;
        this.zzf = object2 = new zzbh(this);
        object = this.zze = (com.google.android.gms.cast.internal.zzas)Preconditions.checkNotNull((Object)object);
        object2 = new zzbp(this, null);
        object.zzS((com.google.android.gms.cast.internal.zzap)object2);
        this.zze.zzh((com.google.android.gms.cast.internal.zzat)this.zzf);
        super(this, 20, 20);
        this.zzg = object;
    }

    public final void zzo() {
        zzr zzr2 = this.zzh;
        if (zzr2 == null) {
            return;
        }
        zzr2.zzi(this.getNamespace(), (Cast.MessageReceivedCallback)this);
        this.requestStatus();
    }

    final /* synthetic */ void zzp(SessionState sessionState) {
        this.zzi.setResult((Object)sessionState);
    }

    final /* synthetic */ void zzq(Exception exception) {
        zzb.d("Fail to store SessionState from receiver, use cached one", new Object[0]);
        this.zzw();
    }

    public final void zzr(@Nullable zzr zzr2) {
        zzr zzr3 = this.zzh;
        if (zzr3 == zzr2) {
            return;
        }
        if (zzr3 != null) {
            this.zze.zzf();
            this.zzg.zzl();
            zzr3.zzg(this.getNamespace());
            this.zzf.zzc(null);
            this.zzd.removeCallbacksAndMessages(null);
        }
        if ((zzr2 = (this.zzh = zzr2)) != null) {
            this.zzf.zzc(zzr2);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void zzw() {
        if (remoteMediaClient.zzi == null) {
            return;
        }
        zzb.d("create SessionState with cached mediaInfo and mediaStatus", new Object[0]);
        MediaInfo mediaInfo = remoteMediaClient.getMediaInfo();
        MediaStatus mediaStatus = remoteMediaClient.getMediaStatus();
        if (mediaInfo != null) {
            if (mediaStatus == null) {
                mediaInfo = null;
            } else {
                MediaLoadRequestData.Builder builder = new MediaLoadRequestData.Builder();
                builder.setMediaInfo(mediaInfo);
                builder.setCurrentTime(remoteMediaClient.getApproximateStreamPosition());
                builder.setQueueData(mediaStatus.getQueueData());
                builder.setPlaybackRate(mediaStatus.getPlaybackRate());
                builder.setActiveTrackIds(mediaStatus.getActiveTrackIds());
                builder.setCustomData(mediaStatus.getCustomData());
                mediaInfo = builder.build();
                mediaStatus = new SessionState.Builder();
                mediaStatus.setLoadRequestData((MediaLoadRequestData)mediaInfo);
                mediaInfo = mediaStatus.build();
            }
        } else {
            mediaInfo = null;
        }
        if (mediaInfo != null) {
            remoteMediaClient.zzi.setResult((Object)mediaInfo);
            return;
        }
        RemoteMediaClient remoteMediaClient = remoteMediaClient.zzi;
        mediaInfo = new com.google.android.gms.cast.internal.zzaq();
        remoteMediaClient.setException((Exception)mediaInfo);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void zzx(Set iterator) {
        HashSet hashSet = new HashSet(iterator);
        if (((RemoteMediaClient)object).isPlaying() || ((RemoteMediaClient)object).isPaused() || ((RemoteMediaClient)object).isBuffering() || ((RemoteMediaClient)object).zzu()) {
            iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                ((ProgressListener)iterator.next()).onProgressUpdated(((RemoteMediaClient)object).getApproximateStreamPosition(), ((RemoteMediaClient)object).getStreamDuration());
            }
            return;
        }
        if (((RemoteMediaClient)object).isLoadingNextItem()) {
            if ((object = ((RemoteMediaClient)object).getLoadingItem()) == null || (object = object.getMedia()) == null) return;
            iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                ((ProgressListener)iterator.next()).onProgressUpdated(0L, object.getStreamDuration());
            }
            return;
        }
        Object object = hashSet.iterator();
        while (object.hasNext()) {
            ((ProgressListener)object.next()).onProgressUpdated(0L, 0L);
        }
    }

    private final boolean zzy() {
        return this.zzh != null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean zzs() {
        if (!this.hasMediaSession()) {
            return false;
        }
        if ((this = (MediaStatus)Preconditions.checkNotNull((Object)this.getMediaStatus())).isMediaCommandSupported(64L)) {
            return true;
        }
        if (this.getQueueRepeatMode() != 0) return true;
        Integer n = this.getIndexById(this.getCurrentItemId());
        if (n == null) return false;
        if (n >= this.getQueueItemCount() + -1) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean zzt() {
        if (!((RemoteMediaClient)this).hasMediaSession()) {
            return false;
        }
        if ((this = (MediaStatus)Preconditions.checkNotNull((Object)((RemoteMediaClient)this).getMediaStatus())).isMediaCommandSupported(128L)) {
            return true;
        }
        if (this.getQueueRepeatMode() != 0) return true;
        if ((this = this.getIndexById(this.getCurrentItemId())) == null) return false;
        if ((Integer)this <= 0) return false;
        return true;
    }

    final boolean zzu() {
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        RemoteMediaClient remoteMediaClient = remoteMediaClient.getMediaStatus();
        return remoteMediaClient != null && remoteMediaClient.getPlayerState() == 5;
    }

    public final boolean zzv() {
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        if (!this.isLiveStream()) {
            return true;
        }
        if ((this = this.getMediaStatus()) == null) {
            return false;
        }
        return this.isMediaCommandSupported(2L) && this.getLiveSeekableRange() != null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final zzbm zzz(zzbm zzbm2) {
        try {
            zzbm2.zzc();
            return zzbm2;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw illegalArgumentException;
        }
        catch (Throwable throwable) {
            Status status = new Status(2100);
            zzbl zzbl2 = new zzbl(zzbm2, status);
            zzbm2.setResult(zzbl2);
            return zzbm2;
        }
    }

    public static interface ProgressListener {
        public void onProgressUpdated(long var1, long var3);
    }

    public static interface ParseAdsInfoCallback {
        @NonNull
        public List<AdBreakInfo> parseAdBreaksFromMediaStatus(@NonNull MediaStatus var1);

        public boolean parseIsPlayingAdFromMediaStatus(@NonNull MediaStatus var1);
    }

    public static interface MediaChannelResult
    extends Result {
        @Nullable
        public MediaError getMediaError();

        @Nullable
        public JSONObject getCustomData();
    }

    public static abstract class Callback {
        public void onAdBreakStatusUpdated() {
        }

        public void onMediaError(@NonNull MediaError mediaError) {
        }

        public void onMetadataUpdated() {
        }

        public void onPreloadStatusUpdated() {
        }

        public void onQueueStatusUpdated() {
        }

        public void onSendingRemoteMediaRequest() {
        }

        public void onStatusUpdated() {
        }

        public void zza(@NonNull int[] nArray) {
        }

        public void zzb(@NonNull int[] nArray, int n) {
        }

        public void zzc(@NonNull MediaQueueItem[] mediaQueueItemArray) {
        }

        public void zzd(@NonNull int[] nArray) {
        }

        public void zze(@NonNull List list, @NonNull List list2, int n) {
        }

        public void zzf(@NonNull int[] nArray) {
        }

        public void zzg() {
        }
    }

    @Deprecated
    public static interface Listener {
        public void onAdBreakStatusUpdated();

        public void onMetadataUpdated();

        public void onPreloadStatusUpdated();

        public void onQueueStatusUpdated();

        public void onSendingRemoteMediaRequest();

        public void onStatusUpdated();
    }
}

