/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.RemoteException;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.framework.CastStateListener;
import com.google.android.gms.cast.framework.R;
import com.google.android.gms.cast.framework.Session;
import com.google.android.gms.cast.framework.SessionManagerListener;
import com.google.android.gms.cast.framework.zzam;
import com.google.android.gms.cast.framework.zzax;
import com.google.android.gms.cast.framework.zzp;
import com.google.android.gms.cast.internal.Logger;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;

public class SessionManager {
    private static final Logger zza;
    private final zzam zzb;
    private final Context zzc;

    @Nullable
    public CastSession getCurrentCastSession() {
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        Session session = ((SessionManager)((Object)session)).getCurrentSession();
        if (session != null && session instanceof CastSession) {
            return (CastSession)session;
        }
        return null;
    }

    @Nullable
    public Session getCurrentSession() {
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        try {
            Session session = (Session)ObjectWrapper.unwrap((IObjectWrapper)((SessionManager)((Object)session)).zzb.zzf());
            return session;
        }
        catch (RemoteException remoteException) {
            Logger logger = zza;
            Object[] objectArray = new Object[]{"getWrappedCurrentSession", zzam.class.getSimpleName()};
            logger.d((Throwable)remoteException, "Unable to call %s on %s.", objectArray);
            return null;
        }
    }

    static {
        Logger logger;
        zza = logger = new Logger("SessionManager");
    }

    /*
     * WARNING - void declaration
     */
    public void addSessionManagerListener(@NonNull SessionManagerListener<Session> listener) throws NullPointerException {
        void var1_1;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        this.addSessionManagerListener((SessionManagerListener)var1_1, (Class)Session.class);
    }

    public <T extends Session> void addSessionManagerListener(@NonNull SessionManagerListener<T> listener, @NonNull Class<T> sessionClass) throws NullPointerException {
        Logger logger;
        Object[] objectArray;
        Object object;
        if (listener == null) {
            object = new NullPointerException("SessionManagerListener can't be null");
            throw object;
        }
        Preconditions.checkNotNull((Object)objectArray);
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        try {
            object = ((SessionManager)object).zzb;
            zzax zzax2 = new zzax((SessionManagerListener)logger, (Class)objectArray);
            object.zzi(zzax2);
            return;
        }
        catch (RemoteException remoteException) {
            logger = zza;
            objectArray = new Object[]{"addSessionManagerListener", zzam.class.getSimpleName()};
            logger.d((Throwable)remoteException, "Unable to call %s on %s.", objectArray);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void endCurrentSession(boolean stopCasting) {
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        try {
            void var1_2;
            Logger logger = zza;
            Object[] objectArray = new Object[]{this.zzc.getPackageName()};
            logger.i("End session for %s", objectArray);
            this.zzb.zzj(true, (boolean)var1_2);
            return;
        }
        catch (RemoteException remoteException) {
            Logger logger = zza;
            Object[] objectArray = new Object[]{"endCurrentSession", zzam.class.getSimpleName()};
            logger.d((Throwable)remoteException, "Unable to call %s on %s.", objectArray);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void removeSessionManagerListener(@NonNull SessionManagerListener<Session> listener) {
        void var1_1;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        this.removeSessionManagerListener((SessionManagerListener)var1_1, (Class)Session.class);
    }

    public <T extends Session> void removeSessionManagerListener(@NonNull SessionManagerListener<T> listener, @NonNull Class<T> sessionClass) {
        Object[] objectArray;
        Logger logger;
        Preconditions.checkNotNull(sessionClass);
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        if (logger == null) {
            return;
        }
        try {
            zzam zzam2 = ((SessionManager)((Object)zzam2)).zzb;
            zzax zzax2 = new zzax((SessionManagerListener)logger, (Class)objectArray);
            zzam2.zzl(zzax2);
            return;
        }
        catch (RemoteException remoteException) {
            logger = zza;
            objectArray = new Object[]{"removeSessionManagerListener", zzam.class.getSimpleName()};
            logger.d((Throwable)remoteException, "Unable to call %s on %s.", objectArray);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void startSession(@NonNull Intent startSessionIntent) {
        Logger logger;
        try {
            String string2;
            Logger logger2 = zza;
            Object[] objectArray = new Object[]{((SessionManager)((Object)zzam2)).zzc.getPackageName()};
            logger2.i("Start session for %s", objectArray);
            logger2 = logger.getExtras();
            if (logger2 == null || (string2 = logger2.getString("CAST_INTENT_TO_CAST_ROUTE_ID_KEY")) == null) {
                return;
            }
            String string3 = logger2.getString("CAST_INTENT_TO_CAST_DEVICE_NAME_KEY");
            boolean bl = logger2.getBoolean("CAST_INTENT_TO_CAST_NO_TOAST_KEY");
            if (!bl) {
                Context context = ((SessionManager)((Object)zzam2)).zzc;
                int n = R.string.cast_connecting_to_device;
                Object[] objectArray2 = new Object[]{string3};
                String string4 = context.getString(n, objectArray2);
                Toast.makeText((Context)((SessionManager)((Object)zzam2)).zzc, (CharSequence)string4, (int)0).show();
            }
            String string5 = "CAST_CUSTOM_MEDIA_ROUTE_DIALOG_FACTORY_SET_UP_KEY";
            logger2.putBoolean(string5, false);
            zzam zzam2 = ((SessionManager)((Object)zzam2)).zzb;
            Bundle bundle = new Bundle((Bundle)logger2);
            zzam2.zzm(bundle);
            logger.removeExtra("CAST_INTENT_TO_CAST_ROUTE_ID_KEY");
            return;
        }
        catch (RemoteException remoteException) {
            logger = zza;
            Object[] objectArray = new Object[]{"startSession", zzam.class.getSimpleName()};
            logger.d((Throwable)remoteException, "Unable to call %s on %s.", objectArray);
            return;
        }
    }

    final int zza() {
        try {
            int n = this.zzb.zze();
            return n;
        }
        catch (RemoteException remoteException) {
            Logger logger = zza;
            Object[] objectArray = new Object[]{"addCastStateListener", zzam.class.getSimpleName()};
            logger.d((Throwable)remoteException, "Unable to call %s on %s.", objectArray);
            return 1;
        }
    }

    @Nullable
    public final IObjectWrapper zzb() {
        try {
            SessionManager sessionManager = sessionManager.zzb.zzg();
            return sessionManager;
        }
        catch (RemoteException remoteException) {
            Logger logger = zza;
            Object[] objectArray = new Object[]{"getWrappedThis", zzam.class.getSimpleName()};
            logger.d((Throwable)remoteException, "Unable to call %s on %s.", objectArray);
            return null;
        }
    }

    public SessionManager(zzam zzam2, Context context) {
        this.zzb = zzam2;
        this.zzc = context;
    }

    final void zzc(CastStateListener castStateListener) throws NullPointerException {
        Preconditions.checkNotNull((Object)castStateListener);
        try {
            zzam zzam2 = ((SessionManager)((Object)zzam2)).zzb;
            zzp zzp2 = new zzp(castStateListener);
            zzam2.zzh(zzp2);
            return;
        }
        catch (RemoteException remoteException) {
            castStateListener = zza;
            Object[] objectArray = new Object[]{"addCastStateListener", zzam.class.getSimpleName()};
            castStateListener.d(remoteException, "Unable to call %s on %s.", objectArray);
            return;
        }
    }

    final void zzd(CastStateListener castStateListener) {
        try {
            zzam zzam2 = ((SessionManager)((Object)zzam2)).zzb;
            zzp zzp2 = new zzp(castStateListener);
            zzam2.zzk(zzp2);
            return;
        }
        catch (RemoteException remoteException) {
            castStateListener = zza;
            Object[] objectArray = new Object[]{"removeCastStateListener", zzam.class.getSimpleName()};
            castStateListener.d(remoteException, "Unable to call %s on %s.", objectArray);
            return;
        }
    }
}

