/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.flexbox;

import android.view.View;
import com.google.android.flexbox.FlexItem;
import java.util.ArrayList;
import java.util.List;

public class FlexLine {
    int mLeft = Integer.MAX_VALUE;
    int mTop = Integer.MAX_VALUE;
    int mRight = Integer.MIN_VALUE;
    int mBottom = Integer.MIN_VALUE;
    int mMainSize;
    int mDividerLengthInMainSize;
    int mCrossSize;
    int mItemCount;
    int mGoneItemCount;
    float mTotalFlexGrow;
    float mTotalFlexShrink;
    int mMaxBaseline;
    List<Integer> mIndicesAlignSelfStretch = new ArrayList<Integer>();
    int mFirstIndex;
    int mLastIndex;

    FlexLine() {
    }

    public int getLeft() {
        return this.mLeft;
    }

    public int getTop() {
        return this.mTop;
    }

    public int getRight() {
        return this.mRight;
    }

    public int getBottom() {
        return this.mBottom;
    }

    public int getMainSize() {
        return this.mMainSize;
    }

    public int getCrossSize() {
        return this.mCrossSize;
    }

    public int getItemCount() {
        return this.mItemCount;
    }

    public int getItemCountNotGone() {
        return this.mItemCount - this.mGoneItemCount;
    }

    public float getTotalFlexGrow() {
        return this.mTotalFlexGrow;
    }

    public float getTotalFlexShrink() {
        return this.mTotalFlexShrink;
    }

    void updatePositionFromView(View view, int leftDecoration, int topDecoration, int rightDecoration, int bottomDecoration) {
        FlexItem flexItem = (FlexItem)view.getLayoutParams();
        this.mLeft = Math.min(this.mLeft, view.getLeft() - flexItem.getMarginLeft() - leftDecoration);
        this.mTop = Math.min(this.mTop, view.getTop() - flexItem.getMarginTop() - topDecoration);
        this.mRight = Math.max(this.mRight, view.getRight() + flexItem.getMarginRight() + rightDecoration);
        this.mBottom = Math.max(this.mBottom, view.getBottom() + flexItem.getMarginBottom() + bottomDecoration);
    }
}

