/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.filament.utils;

import androidx.annotation.Nullable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class RemoteServer {
    private long mNativeObject;

    public RemoteServer(int port) {
        this.mNativeObject = RemoteServer.nCreate(port);
        if (this.mNativeObject == 0L) {
            throw new IllegalStateException("Couldn't create RemoteServer");
        }
    }

    @Nullable
    public String peekIncomingLabel() {
        return RemoteServer.nPeekIncomingLabel(this.mNativeObject);
    }

    public static boolean isJson(@Nullable String label) {
        return label != null && label.endsWith(".json");
    }

    public static boolean isBinary(@Nullable String label) {
        return label != null && !label.endsWith(".json");
    }

    @Nullable
    public ReceivedMessage acquireReceivedMessage() {
        int length = RemoteServer.nPeekReceivedBufferLength(this.mNativeObject);
        if (length == 0) {
            return null;
        }
        ReceivedMessage message = new ReceivedMessage();
        message.label = RemoteServer.nPeekReceivedLabel(this.mNativeObject);
        message.buffer = ByteBuffer.allocateDirect(length);
        message.buffer.order(ByteOrder.LITTLE_ENDIAN);
        RemoteServer.nAcquireReceivedMessage(this.mNativeObject, message.buffer, length);
        return message;
    }

    public void close() {
        RemoteServer.nDestroy(this.mNativeObject);
        this.mNativeObject = 0L;
    }

    protected void finalize() throws Throwable {
        RemoteServer.nDestroy(this.mNativeObject);
        super.finalize();
    }

    private static native long nCreate(int var0);

    private static native String nPeekIncomingLabel(long var0);

    private static native String nPeekReceivedLabel(long var0);

    private static native int nPeekReceivedBufferLength(long var0);

    private static native void nAcquireReceivedMessage(long var0, ByteBuffer var2, int var3);

    private static native void nDestroy(long var0);

    public static class ReceivedMessage {
        public String label;
        public ByteBuffer buffer;
    }
}

