/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.upstream.cache;

import androidx.annotation.Nullable;
import com.google.android.exoplayer2.upstream.DataSink;
import com.google.android.exoplayer2.upstream.DataSpec;
import com.google.android.exoplayer2.upstream.cache.Cache;
import com.google.android.exoplayer2.upstream.cache.ReusableBufferedOutputStream;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.Util;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

public final class CacheDataSink
implements DataSink {
    public static final long DEFAULT_FRAGMENT_SIZE = 0x500000L;
    public static final int DEFAULT_BUFFER_SIZE = 20480;
    private static final long MIN_RECOMMENDED_FRAGMENT_SIZE = 0x200000L;
    private static final String TAG = "CacheDataSink";
    private final Cache cache;
    private final long fragmentSize;
    private final int bufferSize;
    @Nullable
    private DataSpec dataSpec;
    private long dataSpecFragmentSize;
    @Nullable
    private File file;
    @Nullable
    private OutputStream outputStream;
    private long outputStreamBytesWritten;
    private long dataSpecBytesWritten;
    private @MonotonicNonNull ReusableBufferedOutputStream bufferedOutputStream;

    public CacheDataSink(Cache cache, long fragmentSize) {
        this(cache, fragmentSize, 20480);
    }

    public CacheDataSink(Cache cache, long fragmentSize, int bufferSize) {
        Assertions.checkState((fragmentSize > 0L || fragmentSize == -1L ? 1 : 0) != 0, (Object)"fragmentSize must be positive or C.LENGTH_UNSET.");
        if (fragmentSize != -1L && fragmentSize < 0x200000L) {
            Log.w((String)TAG, (String)"fragmentSize is below the minimum recommended value of 2097152. This may cause poor cache performance.");
        }
        this.cache = (Cache)Assertions.checkNotNull((Object)cache);
        this.fragmentSize = fragmentSize == -1L ? Long.MAX_VALUE : fragmentSize;
        this.bufferSize = bufferSize;
    }

    @Override
    public void open(DataSpec dataSpec) throws CacheDataSinkException {
        Assertions.checkNotNull((Object)dataSpec.key);
        if (dataSpec.length == -1L && dataSpec.isFlagSet(2)) {
            this.dataSpec = null;
            return;
        }
        this.dataSpec = dataSpec;
        this.dataSpecFragmentSize = dataSpec.isFlagSet(4) ? this.fragmentSize : Long.MAX_VALUE;
        this.dataSpecBytesWritten = 0L;
        try {
            this.openNextOutputStream(dataSpec);
        }
        catch (IOException e) {
            throw new CacheDataSinkException(e);
        }
    }

    @Override
    public void write(byte[] buffer, int offset, int length) throws CacheDataSinkException {
        DataSpec dataSpec = this.dataSpec;
        if (dataSpec == null) {
            return;
        }
        try {
            int bytesWritten = 0;
            while (bytesWritten < length) {
                if (this.outputStreamBytesWritten == this.dataSpecFragmentSize) {
                    this.closeCurrentOutputStream();
                    this.openNextOutputStream(dataSpec);
                }
                int bytesToWrite = (int)Math.min((long)(length - bytesWritten), this.dataSpecFragmentSize - this.outputStreamBytesWritten);
                ((OutputStream)Util.castNonNull((Object)this.outputStream)).write(buffer, offset + bytesWritten, bytesToWrite);
                bytesWritten += bytesToWrite;
                this.outputStreamBytesWritten += (long)bytesToWrite;
                this.dataSpecBytesWritten += (long)bytesToWrite;
            }
        }
        catch (IOException e) {
            throw new CacheDataSinkException(e);
        }
    }

    @Override
    public void close() throws CacheDataSinkException {
        if (this.dataSpec == null) {
            return;
        }
        try {
            this.closeCurrentOutputStream();
        }
        catch (IOException e) {
            throw new CacheDataSinkException(e);
        }
    }

    private void openNextOutputStream(DataSpec dataSpec) throws IOException {
        long length = dataSpec.length == -1L ? -1L : Math.min(dataSpec.length - this.dataSpecBytesWritten, this.dataSpecFragmentSize);
        this.file = this.cache.startFile((String)Util.castNonNull((Object)dataSpec.key), dataSpec.position + this.dataSpecBytesWritten, length);
        FileOutputStream underlyingFileOutputStream = new FileOutputStream(this.file);
        if (this.bufferSize > 0) {
            if (this.bufferedOutputStream == null) {
                this.bufferedOutputStream = new ReusableBufferedOutputStream(underlyingFileOutputStream, this.bufferSize);
            } else {
                this.bufferedOutputStream.reset(underlyingFileOutputStream);
            }
            this.outputStream = this.bufferedOutputStream;
        } else {
            this.outputStream = underlyingFileOutputStream;
        }
        this.outputStreamBytesWritten = 0L;
    }

    private void closeCurrentOutputStream() throws IOException {
        if (this.outputStream == null) {
            return;
        }
        boolean success = false;
        try {
            this.outputStream.flush();
            success = true;
        }
        finally {
            Util.closeQuietly((Closeable)this.outputStream);
            this.outputStream = null;
            File fileToCommit = (File)Util.castNonNull((Object)this.file);
            this.file = null;
            if (success) {
                this.cache.commitFile(fileToCommit, this.outputStreamBytesWritten);
            } else {
                fileToCommit.delete();
            }
        }
    }

    public static final class CacheDataSinkException
    extends Cache.CacheException {
        public CacheDataSinkException(IOException cause) {
            super(cause);
        }
    }

    public static final class Factory
    implements DataSink.Factory {
        private @MonotonicNonNull Cache cache;
        private long fragmentSize = 0x500000L;
        private int bufferSize = 20480;

        public Factory setCache(Cache cache) {
            this.cache = cache;
            return this;
        }

        public Factory setFragmentSize(long fragmentSize) {
            this.fragmentSize = fragmentSize;
            return this;
        }

        public Factory setBufferSize(int bufferSize) {
            this.bufferSize = bufferSize;
            return this;
        }

        @Override
        public DataSink createDataSink() {
            return new CacheDataSink((Cache)Assertions.checkNotNull((Object)this.cache), this.fragmentSize, this.bufferSize);
        }
    }
}

