/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.upstream;

import android.net.Uri;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.exoplayer2.upstream.BaseDataSource;
import com.google.android.exoplayer2.upstream.DataSourceException;
import com.google.android.exoplayer2.upstream.DataSpec;
import com.google.android.exoplayer2.upstream.HttpDataSource;
import com.google.android.exoplayer2.upstream.HttpUtil;
import com.google.android.exoplayer2.upstream.TransferListener;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.Util;
import com.google.common.base.Predicate;
import com.google.common.collect.ForwardingMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.NoRouteToHostException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;

public class DefaultHttpDataSource
extends BaseDataSource
implements HttpDataSource {
    public static final int DEFAULT_CONNECT_TIMEOUT_MILLIS = 8000;
    public static final int DEFAULT_READ_TIMEOUT_MILLIS = 8000;
    private static final String TAG = "DefaultHttpDataSource";
    private static final int MAX_REDIRECTS = 20;
    private static final int HTTP_STATUS_TEMPORARY_REDIRECT = 307;
    private static final int HTTP_STATUS_PERMANENT_REDIRECT = 308;
    private static final long MAX_BYTES_TO_DRAIN = 2048L;
    private final boolean allowCrossProtocolRedirects;
    private final int connectTimeoutMillis;
    private final int readTimeoutMillis;
    @Nullable
    private final String userAgent;
    @Nullable
    private final HttpDataSource.RequestProperties defaultRequestProperties;
    private final HttpDataSource.RequestProperties requestProperties;
    private final boolean keepPostFor302Redirects;
    @Nullable
    private Predicate<String> contentTypePredicate;
    @Nullable
    private DataSpec dataSpec;
    @Nullable
    private HttpURLConnection connection;
    @Nullable
    private InputStream inputStream;
    private boolean opened;
    private int responseCode;
    private long bytesToRead;
    private long bytesRead;

    @Deprecated
    public DefaultHttpDataSource() {
        this(null, 8000, 8000);
    }

    @Deprecated
    public DefaultHttpDataSource(@Nullable String userAgent) {
        this(userAgent, 8000, 8000);
    }

    @Deprecated
    public DefaultHttpDataSource(@Nullable String userAgent, int connectTimeoutMillis, int readTimeoutMillis) {
        this(userAgent, connectTimeoutMillis, readTimeoutMillis, false, null);
    }

    @Deprecated
    public DefaultHttpDataSource(@Nullable String userAgent, int connectTimeoutMillis, int readTimeoutMillis, boolean allowCrossProtocolRedirects, @Nullable HttpDataSource.RequestProperties defaultRequestProperties) {
        this(userAgent, connectTimeoutMillis, readTimeoutMillis, allowCrossProtocolRedirects, defaultRequestProperties, null, false);
    }

    private DefaultHttpDataSource(@Nullable String userAgent, int connectTimeoutMillis, int readTimeoutMillis, boolean allowCrossProtocolRedirects, @Nullable HttpDataSource.RequestProperties defaultRequestProperties, @Nullable Predicate<String> contentTypePredicate, boolean keepPostFor302Redirects) {
        super(true);
        this.userAgent = userAgent;
        this.connectTimeoutMillis = connectTimeoutMillis;
        this.readTimeoutMillis = readTimeoutMillis;
        this.allowCrossProtocolRedirects = allowCrossProtocolRedirects;
        this.defaultRequestProperties = defaultRequestProperties;
        this.contentTypePredicate = contentTypePredicate;
        this.requestProperties = new HttpDataSource.RequestProperties();
        this.keepPostFor302Redirects = keepPostFor302Redirects;
    }

    @Deprecated
    public void setContentTypePredicate(@Nullable Predicate<String> contentTypePredicate) {
        this.contentTypePredicate = contentTypePredicate;
    }

    @Override
    @Nullable
    public Uri getUri() {
        return this.connection == null ? null : Uri.parse((String)this.connection.getURL().toString());
    }

    @Override
    public int getResponseCode() {
        return this.connection == null || this.responseCode <= 0 ? -1 : this.responseCode;
    }

    @Override
    public Map<String, List<String>> getResponseHeaders() {
        if (this.connection == null) {
            return ImmutableMap.of();
        }
        return new NullFilteringHeadersMap(this.connection.getHeaderFields());
    }

    @Override
    public void setRequestProperty(String name, String value) {
        Assertions.checkNotNull((Object)name);
        Assertions.checkNotNull((Object)value);
        this.requestProperties.set(name, value);
    }

    @Override
    public void clearRequestProperty(String name) {
        Assertions.checkNotNull((Object)name);
        this.requestProperties.remove(name);
    }

    @Override
    public void clearAllRequestProperties() {
        this.requestProperties.clear();
    }

    @Override
    public long open(DataSpec dataSpec) throws HttpDataSource.HttpDataSourceException {
        long contentLength;
        String responseMessage;
        HttpURLConnection connection;
        this.dataSpec = dataSpec;
        this.bytesRead = 0L;
        this.bytesToRead = 0L;
        this.transferInitializing(dataSpec);
        try {
            connection = this.connection = this.makeConnection(dataSpec);
            this.responseCode = connection.getResponseCode();
            responseMessage = connection.getResponseMessage();
        }
        catch (IOException e) {
            this.closeConnectionQuietly();
            throw HttpDataSource.HttpDataSourceException.createForIOException(e, dataSpec, 1);
        }
        if (this.responseCode < 200 || this.responseCode > 299) {
            byte[] errorResponseBody;
            long documentSize;
            Map<String, List<String>> headers = connection.getHeaderFields();
            if (this.responseCode == 416 && dataSpec.position == (documentSize = HttpUtil.getDocumentSize(connection.getHeaderField("Content-Range")))) {
                this.opened = true;
                this.transferStarted(dataSpec);
                return dataSpec.length != -1L ? dataSpec.length : 0L;
            }
            InputStream errorStream = connection.getErrorStream();
            try {
                errorResponseBody = errorStream != null ? Util.toByteArray((InputStream)errorStream) : Util.EMPTY_BYTE_ARRAY;
            }
            catch (IOException e) {
                errorResponseBody = Util.EMPTY_BYTE_ARRAY;
            }
            this.closeConnectionQuietly();
            DataSourceException cause = this.responseCode == 416 ? new DataSourceException(2008) : null;
            throw new HttpDataSource.InvalidResponseCodeException(this.responseCode, responseMessage, cause, headers, dataSpec, errorResponseBody);
        }
        String contentType = connection.getContentType();
        if (this.contentTypePredicate != null && !this.contentTypePredicate.apply((Object)contentType)) {
            this.closeConnectionQuietly();
            throw new HttpDataSource.InvalidContentTypeException(contentType, dataSpec);
        }
        long bytesToSkip = this.responseCode == 200 && dataSpec.position != 0L ? dataSpec.position : 0L;
        boolean isCompressed = DefaultHttpDataSource.isCompressed(connection);
        this.bytesToRead = !isCompressed ? (dataSpec.length != -1L ? dataSpec.length : ((contentLength = HttpUtil.getContentLength(connection.getHeaderField("Content-Length"), connection.getHeaderField("Content-Range"))) != -1L ? contentLength - bytesToSkip : -1L)) : dataSpec.length;
        try {
            this.inputStream = connection.getInputStream();
            if (isCompressed) {
                this.inputStream = new GZIPInputStream(this.inputStream);
            }
        }
        catch (IOException e) {
            this.closeConnectionQuietly();
            throw new HttpDataSource.HttpDataSourceException(e, dataSpec, 2000, 1);
        }
        this.opened = true;
        this.transferStarted(dataSpec);
        try {
            this.skipFully(bytesToSkip, dataSpec);
        }
        catch (IOException e) {
            this.closeConnectionQuietly();
            if (e instanceof HttpDataSource.HttpDataSourceException) {
                throw (HttpDataSource.HttpDataSourceException)e;
            }
            throw new HttpDataSource.HttpDataSourceException(e, dataSpec, 2000, 1);
        }
        return this.bytesToRead;
    }

    @Override
    public int read(byte[] buffer, int offset, int length) throws HttpDataSource.HttpDataSourceException {
        try {
            return this.readInternal(buffer, offset, length);
        }
        catch (IOException e) {
            throw HttpDataSource.HttpDataSourceException.createForIOException(e, (DataSpec)Util.castNonNull((Object)this.dataSpec), 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws HttpDataSource.HttpDataSourceException {
        block6: {
            try {
                InputStream inputStream = this.inputStream;
                if (inputStream == null) break block6;
                long bytesRemaining = this.bytesToRead == -1L ? -1L : this.bytesToRead - this.bytesRead;
                DefaultHttpDataSource.maybeTerminateInputStream(this.connection, bytesRemaining);
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    throw new HttpDataSource.HttpDataSourceException(e, (DataSpec)Util.castNonNull((Object)this.dataSpec), 2000, 3);
                }
            }
            finally {
                this.inputStream = null;
                this.closeConnectionQuietly();
                if (this.opened) {
                    this.opened = false;
                    this.transferEnded();
                }
            }
        }
    }

    private HttpURLConnection makeConnection(DataSpec dataSpec) throws IOException {
        URL url = new URL(dataSpec.uri.toString());
        int httpMethod = dataSpec.httpMethod;
        byte[] httpBody = dataSpec.httpBody;
        long position = dataSpec.position;
        long length = dataSpec.length;
        boolean allowGzip = dataSpec.isFlagSet(1);
        if (!this.allowCrossProtocolRedirects && !this.keepPostFor302Redirects) {
            return this.makeConnection(url, httpMethod, httpBody, position, length, allowGzip, true, dataSpec.httpRequestHeaders);
        }
        int redirectCount = 0;
        while (redirectCount++ <= 20) {
            HttpURLConnection connection = this.makeConnection(url, httpMethod, httpBody, position, length, allowGzip, false, dataSpec.httpRequestHeaders);
            int responseCode = connection.getResponseCode();
            String location = connection.getHeaderField("Location");
            if (!(httpMethod != 1 && httpMethod != 3 || responseCode != 300 && responseCode != 301 && responseCode != 302 && responseCode != 303 && responseCode != 307 && responseCode != 308)) {
                connection.disconnect();
                url = this.handleRedirect(url, location, dataSpec);
                continue;
            }
            if (httpMethod == 2 && (responseCode == 300 || responseCode == 301 || responseCode == 302 || responseCode == 303)) {
                boolean shouldKeepPost;
                connection.disconnect();
                boolean bl = shouldKeepPost = this.keepPostFor302Redirects && responseCode == 302;
                if (!shouldKeepPost) {
                    httpMethod = 1;
                    httpBody = null;
                }
                url = this.handleRedirect(url, location, dataSpec);
                continue;
            }
            return connection;
        }
        throw new HttpDataSource.HttpDataSourceException(new NoRouteToHostException("Too many redirects: " + redirectCount), dataSpec, 2001, 1);
    }

    private HttpURLConnection makeConnection(URL url, int httpMethod, @Nullable byte[] httpBody, long position, long length, boolean allowGzip, boolean followRedirects, Map<String, String> requestParameters) throws IOException {
        HttpURLConnection connection = this.openConnection(url);
        connection.setConnectTimeout(this.connectTimeoutMillis);
        connection.setReadTimeout(this.readTimeoutMillis);
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        if (this.defaultRequestProperties != null) {
            requestHeaders.putAll(this.defaultRequestProperties.getSnapshot());
        }
        requestHeaders.putAll(this.requestProperties.getSnapshot());
        requestHeaders.putAll(requestParameters);
        for (Map.Entry property : requestHeaders.entrySet()) {
            connection.setRequestProperty((String)property.getKey(), (String)property.getValue());
        }
        String rangeHeader = HttpUtil.buildRangeRequestHeader(position, length);
        if (rangeHeader != null) {
            connection.setRequestProperty("Range", rangeHeader);
        }
        if (this.userAgent != null) {
            connection.setRequestProperty("User-Agent", this.userAgent);
        }
        connection.setRequestProperty("Accept-Encoding", allowGzip ? "gzip" : "identity");
        connection.setInstanceFollowRedirects(followRedirects);
        connection.setDoOutput(httpBody != null);
        connection.setRequestMethod(DataSpec.getStringForHttpMethod(httpMethod));
        if (httpBody != null) {
            connection.setFixedLengthStreamingMode(httpBody.length);
            connection.connect();
            OutputStream os = connection.getOutputStream();
            os.write(httpBody);
            os.close();
        } else {
            connection.connect();
        }
        return connection;
    }

    @VisibleForTesting
    HttpURLConnection openConnection(URL url) throws IOException {
        return (HttpURLConnection)url.openConnection();
    }

    private URL handleRedirect(URL originalUrl, @Nullable String location, DataSpec dataSpec) throws HttpDataSource.HttpDataSourceException {
        URL url;
        if (location == null) {
            throw new HttpDataSource.HttpDataSourceException("Null location redirect", dataSpec, 2001, 1);
        }
        try {
            url = new URL(originalUrl, location);
        }
        catch (MalformedURLException e) {
            throw new HttpDataSource.HttpDataSourceException(e, dataSpec, 2001, 1);
        }
        String protocol = url.getProtocol();
        if (!"https".equals(protocol) && !"http".equals(protocol)) {
            throw new HttpDataSource.HttpDataSourceException("Unsupported protocol redirect: " + protocol, dataSpec, 2001, 1);
        }
        if (!this.allowCrossProtocolRedirects && !protocol.equals(originalUrl.getProtocol())) {
            throw new HttpDataSource.HttpDataSourceException("Disallowed cross-protocol redirect (" + originalUrl.getProtocol() + " to " + protocol + ")", dataSpec, 2001, 1);
        }
        return url;
    }

    private void skipFully(long bytesToSkip, DataSpec dataSpec) throws IOException {
        if (bytesToSkip == 0L) {
            return;
        }
        byte[] skipBuffer = new byte[4096];
        while (bytesToSkip > 0L) {
            int readLength = (int)Math.min(bytesToSkip, (long)skipBuffer.length);
            int read = ((InputStream)Util.castNonNull((Object)this.inputStream)).read(skipBuffer, 0, readLength);
            if (Thread.currentThread().isInterrupted()) {
                throw new HttpDataSource.HttpDataSourceException(new InterruptedIOException(), dataSpec, 2000, 1);
            }
            if (read == -1) {
                throw new HttpDataSource.HttpDataSourceException(dataSpec, 2008, 1);
            }
            bytesToSkip -= (long)read;
            this.bytesTransferred(read);
        }
    }

    private int readInternal(byte[] buffer, int offset, int readLength) throws IOException {
        int read;
        if (readLength == 0) {
            return 0;
        }
        if (this.bytesToRead != -1L) {
            long bytesRemaining = this.bytesToRead - this.bytesRead;
            if (bytesRemaining == 0L) {
                return -1;
            }
            readLength = (int)Math.min((long)readLength, bytesRemaining);
        }
        if ((read = ((InputStream)Util.castNonNull((Object)this.inputStream)).read(buffer, offset, readLength)) == -1) {
            return -1;
        }
        this.bytesRead += (long)read;
        this.bytesTransferred(read);
        return read;
    }

    private static void maybeTerminateInputStream(@Nullable HttpURLConnection connection, long bytesRemaining) {
        if (connection == null || Util.SDK_INT < 19 || Util.SDK_INT > 20) {
            return;
        }
        try {
            InputStream inputStream = connection.getInputStream();
            if (bytesRemaining == -1L ? inputStream.read() == -1 : bytesRemaining <= 2048L) {
                return;
            }
            String className = inputStream.getClass().getName();
            if ("com.android.okhttp.internal.http.HttpTransport$ChunkedInputStream".equals(className) || "com.android.okhttp.internal.http.HttpTransport$FixedLengthInputStream".equals(className)) {
                Class<?> superclass = inputStream.getClass().getSuperclass();
                Method unexpectedEndOfInput = ((Class)Assertions.checkNotNull(superclass)).getDeclaredMethod("unexpectedEndOfInput", new Class[0]);
                unexpectedEndOfInput.setAccessible(true);
                unexpectedEndOfInput.invoke((Object)inputStream, new Object[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void closeConnectionQuietly() {
        if (this.connection != null) {
            try {
                this.connection.disconnect();
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"Unexpected error while disconnecting", (Throwable)e);
            }
            this.connection = null;
        }
    }

    private static boolean isCompressed(HttpURLConnection connection) {
        String contentEncoding = connection.getHeaderField("Content-Encoding");
        return "gzip".equalsIgnoreCase(contentEncoding);
    }

    private static class NullFilteringHeadersMap
    extends ForwardingMap<String, List<String>> {
        private final Map<String, List<String>> headers;

        public NullFilteringHeadersMap(Map<String, List<String>> headers) {
            this.headers = headers;
        }

        protected Map<String, List<String>> delegate() {
            return this.headers;
        }

        public boolean containsKey(@Nullable Object key) {
            return key != null && super.containsKey(key);
        }

        @Nullable
        public List<String> get(@Nullable Object key) {
            return key == null ? null : (List)super.get(key);
        }

        public Set<String> keySet() {
            return Sets.filter((Set)super.keySet(), key -> key != null);
        }

        public Set<Map.Entry<String, List<String>>> entrySet() {
            return Sets.filter((Set)super.entrySet(), entry -> entry.getKey() != null);
        }

        public int size() {
            return super.size() - (super.containsKey(null) ? 1 : 0);
        }

        public boolean isEmpty() {
            return super.isEmpty() || super.size() == 1 && super.containsKey(null);
        }

        public boolean containsValue(@Nullable Object value) {
            return super.standardContainsValue(value);
        }

        public boolean equals(@Nullable Object object) {
            return object != null && super.standardEquals(object);
        }

        public int hashCode() {
            return super.standardHashCode();
        }
    }

    public static final class Factory
    implements HttpDataSource.Factory {
        private final HttpDataSource.RequestProperties defaultRequestProperties = new HttpDataSource.RequestProperties();
        @Nullable
        private TransferListener transferListener;
        @Nullable
        private Predicate<String> contentTypePredicate;
        @Nullable
        private String userAgent;
        private int connectTimeoutMs = 8000;
        private int readTimeoutMs = 8000;
        private boolean allowCrossProtocolRedirects;
        private boolean keepPostFor302Redirects;

        @Override
        public final Factory setDefaultRequestProperties(Map<String, String> defaultRequestProperties) {
            this.defaultRequestProperties.clearAndSet(defaultRequestProperties);
            return this;
        }

        public Factory setUserAgent(@Nullable String userAgent) {
            this.userAgent = userAgent;
            return this;
        }

        public Factory setConnectTimeoutMs(int connectTimeoutMs) {
            this.connectTimeoutMs = connectTimeoutMs;
            return this;
        }

        public Factory setReadTimeoutMs(int readTimeoutMs) {
            this.readTimeoutMs = readTimeoutMs;
            return this;
        }

        public Factory setAllowCrossProtocolRedirects(boolean allowCrossProtocolRedirects) {
            this.allowCrossProtocolRedirects = allowCrossProtocolRedirects;
            return this;
        }

        public Factory setContentTypePredicate(@Nullable Predicate<String> contentTypePredicate) {
            this.contentTypePredicate = contentTypePredicate;
            return this;
        }

        public Factory setTransferListener(@Nullable TransferListener transferListener) {
            this.transferListener = transferListener;
            return this;
        }

        public Factory setKeepPostFor302Redirects(boolean keepPostFor302Redirects) {
            this.keepPostFor302Redirects = keepPostFor302Redirects;
            return this;
        }

        @Override
        public DefaultHttpDataSource createDataSource() {
            DefaultHttpDataSource dataSource = new DefaultHttpDataSource(this.userAgent, this.connectTimeoutMs, this.readTimeoutMs, this.allowCrossProtocolRedirects, this.defaultRequestProperties, this.contentTypePredicate, this.keepPostFor302Redirects);
            if (this.transferListener != null) {
                dataSource.addTransferListener(this.transferListener);
            }
            return dataSource;
        }
    }
}

