/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.upstream;

import android.content.ContentResolver;
import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.media.ApplicationMediaCapabilities;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import androidx.annotation.DoNotInline;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.google.android.exoplayer2.upstream.BaseDataSource;
import com.google.android.exoplayer2.upstream.DataSourceException;
import com.google.android.exoplayer2.upstream.DataSpec;
import com.google.android.exoplayer2.util.Util;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.channels.FileChannel;

public final class ContentDataSource
extends BaseDataSource {
    private final ContentResolver resolver;
    @Nullable
    private Uri uri;
    @Nullable
    private AssetFileDescriptor assetFileDescriptor;
    @Nullable
    private FileInputStream inputStream;
    private long bytesRemaining;
    private boolean opened;

    public ContentDataSource(Context context) {
        super(false);
        this.resolver = context.getContentResolver();
    }

    @Override
    public long open(DataSpec dataSpec) throws ContentDataSourceException {
        try {
            FileInputStream inputStream;
            AssetFileDescriptor assetFileDescriptor;
            Object providerOptions;
            Uri uri;
            this.uri = uri = dataSpec.uri;
            this.transferInitializing(dataSpec);
            if ("content".equals(dataSpec.uri.getScheme())) {
                providerOptions = new Bundle();
                if (Util.SDK_INT >= 31) {
                    Api31.disableTranscoding(providerOptions);
                }
                assetFileDescriptor = this.resolver.openTypedAssetFileDescriptor(uri, "*/*", providerOptions);
            } else {
                assetFileDescriptor = this.resolver.openAssetFileDescriptor(uri, "r");
            }
            this.assetFileDescriptor = assetFileDescriptor;
            if (assetFileDescriptor == null) {
                providerOptions = String.valueOf(uri);
                throw new ContentDataSourceException(new IOException(new StringBuilder(36 + String.valueOf(providerOptions).length()).append("Could not open file descriptor for: ").append((String)providerOptions).toString()), 2000);
            }
            long assetFileDescriptorLength = assetFileDescriptor.getLength();
            this.inputStream = inputStream = new FileInputStream(assetFileDescriptor.getFileDescriptor());
            if (assetFileDescriptorLength != -1L && dataSpec.position > assetFileDescriptorLength) {
                throw new ContentDataSourceException(null, 2008);
            }
            long assetFileDescriptorOffset = assetFileDescriptor.getStartOffset();
            long skipped = inputStream.skip(assetFileDescriptorOffset + dataSpec.position) - assetFileDescriptorOffset;
            if (skipped != dataSpec.position) {
                throw new ContentDataSourceException(null, 2008);
            }
            if (assetFileDescriptorLength == -1L) {
                FileChannel channel = inputStream.getChannel();
                long channelSize = channel.size();
                if (channelSize == 0L) {
                    this.bytesRemaining = -1L;
                } else {
                    this.bytesRemaining = channelSize - channel.position();
                    if (this.bytesRemaining < 0L) {
                        throw new ContentDataSourceException(null, 2008);
                    }
                }
            } else {
                this.bytesRemaining = assetFileDescriptorLength - skipped;
                if (this.bytesRemaining < 0L) {
                    throw new ContentDataSourceException(null, 2008);
                }
            }
        }
        catch (ContentDataSourceException e) {
            throw e;
        }
        catch (IOException e) {
            throw new ContentDataSourceException(e, e instanceof FileNotFoundException ? 2005 : 2000);
        }
        if (dataSpec.length != -1L) {
            this.bytesRemaining = this.bytesRemaining == -1L ? dataSpec.length : Math.min(this.bytesRemaining, dataSpec.length);
        }
        this.opened = true;
        this.transferStarted(dataSpec);
        return dataSpec.length != -1L ? dataSpec.length : this.bytesRemaining;
    }

    public int read(byte[] buffer, int offset, int length) throws ContentDataSourceException {
        int bytesRead;
        if (length == 0) {
            return 0;
        }
        if (this.bytesRemaining == 0L) {
            return -1;
        }
        try {
            int bytesToRead = this.bytesRemaining == -1L ? length : (int)Math.min(this.bytesRemaining, (long)length);
            bytesRead = ((FileInputStream)Util.castNonNull((Object)this.inputStream)).read(buffer, offset, bytesToRead);
        }
        catch (IOException e) {
            throw new ContentDataSourceException(e, 2000);
        }
        if (bytesRead == -1) {
            return -1;
        }
        if (this.bytesRemaining != -1L) {
            this.bytesRemaining -= (long)bytesRead;
        }
        this.bytesTransferred(bytesRead);
        return bytesRead;
    }

    @Override
    @Nullable
    public Uri getUri() {
        return this.uri;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void close() throws ContentDataSourceException {
        this.uri = null;
        try {
            if (this.inputStream == null) return;
            this.inputStream.close();
            return;
        }
        catch (IOException e) {
            throw new ContentDataSourceException(e, 2000);
        }
        finally {
            this.inputStream = null;
            try {
                if (this.assetFileDescriptor != null) {
                    this.assetFileDescriptor.close();
                }
            }
            catch (IOException e) {
                throw new ContentDataSourceException(e, 2000);
            }
            finally {
                this.assetFileDescriptor = null;
                if (this.opened) {
                    this.opened = false;
                    this.transferEnded();
                }
            }
        }
    }

    @RequiresApi(value=31)
    private static final class Api31 {
        private Api31() {
        }

        @DoNotInline
        public static void disableTranscoding(Bundle providerOptions) {
            ApplicationMediaCapabilities mediaCapabilities = new ApplicationMediaCapabilities.Builder().addSupportedVideoMimeType("video/hevc").addSupportedHdrType("android.media.feature.hdr.dolby_vision").addSupportedHdrType("android.media.feature.hdr.hdr10").addSupportedHdrType("android.media.feature.hdr.hdr10_plus").addSupportedHdrType("android.media.feature.hdr.hlg").build();
            providerOptions.putParcelable("android.provider.extra.MEDIA_CAPABILITIES", (Parcelable)mediaCapabilities);
        }
    }

    public static class ContentDataSourceException
    extends DataSourceException {
        @Deprecated
        public ContentDataSourceException(IOException cause) {
            this(cause, 2000);
        }

        public ContentDataSourceException(@Nullable IOException cause, int errorCode) {
            super(cause, errorCode);
        }
    }
}

