/*
 * Decompiled with CFR 0.152.
 */
package com.google.analytics.data.v1beta.stub;

import com.google.analytics.data.v1beta.BatchRunPivotReportsRequest;
import com.google.analytics.data.v1beta.BatchRunPivotReportsResponse;
import com.google.analytics.data.v1beta.BatchRunReportsRequest;
import com.google.analytics.data.v1beta.BatchRunReportsResponse;
import com.google.analytics.data.v1beta.CheckCompatibilityRequest;
import com.google.analytics.data.v1beta.CheckCompatibilityResponse;
import com.google.analytics.data.v1beta.GetMetadataRequest;
import com.google.analytics.data.v1beta.Metadata;
import com.google.analytics.data.v1beta.RunPivotReportRequest;
import com.google.analytics.data.v1beta.RunPivotReportResponse;
import com.google.analytics.data.v1beta.RunRealtimeReportRequest;
import com.google.analytics.data.v1beta.RunRealtimeReportResponse;
import com.google.analytics.data.v1beta.RunReportRequest;
import com.google.analytics.data.v1beta.RunReportResponse;
import com.google.analytics.data.v1beta.stub.BetaAnalyticsDataStub;
import com.google.analytics.data.v1beta.stub.GrpcBetaAnalyticsDataStub;
import com.google.api.core.ApiFunction;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class BetaAnalyticsDataStubSettings
extends StubSettings<BetaAnalyticsDataStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/analytics").add((Object)"https://www.googleapis.com/auth/analytics.readonly").build();
    private final UnaryCallSettings<RunReportRequest, RunReportResponse> runReportSettings;
    private final UnaryCallSettings<RunPivotReportRequest, RunPivotReportResponse> runPivotReportSettings;
    private final UnaryCallSettings<BatchRunReportsRequest, BatchRunReportsResponse> batchRunReportsSettings;
    private final UnaryCallSettings<BatchRunPivotReportsRequest, BatchRunPivotReportsResponse> batchRunPivotReportsSettings;
    private final UnaryCallSettings<GetMetadataRequest, Metadata> getMetadataSettings;
    private final UnaryCallSettings<RunRealtimeReportRequest, RunRealtimeReportResponse> runRealtimeReportSettings;
    private final UnaryCallSettings<CheckCompatibilityRequest, CheckCompatibilityResponse> checkCompatibilitySettings;

    public UnaryCallSettings<RunReportRequest, RunReportResponse> runReportSettings() {
        return this.runReportSettings;
    }

    public UnaryCallSettings<RunPivotReportRequest, RunPivotReportResponse> runPivotReportSettings() {
        return this.runPivotReportSettings;
    }

    public UnaryCallSettings<BatchRunReportsRequest, BatchRunReportsResponse> batchRunReportsSettings() {
        return this.batchRunReportsSettings;
    }

    public UnaryCallSettings<BatchRunPivotReportsRequest, BatchRunPivotReportsResponse> batchRunPivotReportsSettings() {
        return this.batchRunPivotReportsSettings;
    }

    public UnaryCallSettings<GetMetadataRequest, Metadata> getMetadataSettings() {
        return this.getMetadataSettings;
    }

    public UnaryCallSettings<RunRealtimeReportRequest, RunRealtimeReportResponse> runRealtimeReportSettings() {
        return this.runRealtimeReportSettings;
    }

    public UnaryCallSettings<CheckCompatibilityRequest, CheckCompatibilityResponse> checkCompatibilitySettings() {
        return this.checkCompatibilitySettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public BetaAnalyticsDataStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcBetaAnalyticsDataStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "analyticsdata.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "analyticsdata.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return BetaAnalyticsDataStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(BetaAnalyticsDataStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected BetaAnalyticsDataStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.runReportSettings = settingsBuilder.runReportSettings().build();
        this.runPivotReportSettings = settingsBuilder.runPivotReportSettings().build();
        this.batchRunReportsSettings = settingsBuilder.batchRunReportsSettings().build();
        this.batchRunPivotReportsSettings = settingsBuilder.batchRunPivotReportsSettings().build();
        this.getMetadataSettings = settingsBuilder.getMetadataSettings().build();
        this.runRealtimeReportSettings = settingsBuilder.runRealtimeReportSettings().build();
        this.checkCompatibilitySettings = settingsBuilder.checkCompatibilitySettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<BetaAnalyticsDataStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<RunReportRequest, RunReportResponse> runReportSettings;
        private final UnaryCallSettings.Builder<RunPivotReportRequest, RunPivotReportResponse> runPivotReportSettings;
        private final UnaryCallSettings.Builder<BatchRunReportsRequest, BatchRunReportsResponse> batchRunReportsSettings;
        private final UnaryCallSettings.Builder<BatchRunPivotReportsRequest, BatchRunPivotReportsResponse> batchRunPivotReportsSettings;
        private final UnaryCallSettings.Builder<GetMetadataRequest, Metadata> getMetadataSettings;
        private final UnaryCallSettings.Builder<RunRealtimeReportRequest, RunRealtimeReportResponse> runRealtimeReportSettings;
        private final UnaryCallSettings.Builder<CheckCompatibilityRequest, CheckCompatibilityResponse> checkCompatibilitySettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.runReportSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.runPivotReportSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.batchRunReportsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.batchRunPivotReportsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getMetadataSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.runRealtimeReportSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.checkCompatibilitySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.runReportSettings, this.runPivotReportSettings, this.batchRunReportsSettings, this.batchRunPivotReportsSettings, this.getMetadataSettings, this.runRealtimeReportSettings, this.checkCompatibilitySettings);
            Builder.initDefaults(this);
        }

        protected Builder(BetaAnalyticsDataStubSettings settings) {
            super((StubSettings)settings);
            this.runReportSettings = settings.runReportSettings.toBuilder();
            this.runPivotReportSettings = settings.runPivotReportSettings.toBuilder();
            this.batchRunReportsSettings = settings.batchRunReportsSettings.toBuilder();
            this.batchRunPivotReportsSettings = settings.batchRunPivotReportsSettings.toBuilder();
            this.getMetadataSettings = settings.getMetadataSettings.toBuilder();
            this.runRealtimeReportSettings = settings.runRealtimeReportSettings.toBuilder();
            this.checkCompatibilitySettings = settings.checkCompatibilitySettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.runReportSettings, this.runPivotReportSettings, this.batchRunReportsSettings, this.batchRunPivotReportsSettings, this.getMetadataSettings, this.runRealtimeReportSettings, this.checkCompatibilitySettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(BetaAnalyticsDataStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)BetaAnalyticsDataStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)BetaAnalyticsDataStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(BetaAnalyticsDataStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(BetaAnalyticsDataStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.runReportSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.runPivotReportSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.batchRunReportsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.batchRunPivotReportsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getMetadataSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.runRealtimeReportSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.checkCompatibilitySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<RunReportRequest, RunReportResponse> runReportSettings() {
            return this.runReportSettings;
        }

        public UnaryCallSettings.Builder<RunPivotReportRequest, RunPivotReportResponse> runPivotReportSettings() {
            return this.runPivotReportSettings;
        }

        public UnaryCallSettings.Builder<BatchRunReportsRequest, BatchRunReportsResponse> batchRunReportsSettings() {
            return this.batchRunReportsSettings;
        }

        public UnaryCallSettings.Builder<BatchRunPivotReportsRequest, BatchRunPivotReportsResponse> batchRunPivotReportsSettings() {
            return this.batchRunPivotReportsSettings;
        }

        public UnaryCallSettings.Builder<GetMetadataRequest, Metadata> getMetadataSettings() {
            return this.getMetadataSettings;
        }

        public UnaryCallSettings.Builder<RunRealtimeReportRequest, RunRealtimeReportResponse> runRealtimeReportSettings() {
            return this.runRealtimeReportSettings;
        }

        public UnaryCallSettings.Builder<CheckCompatibilityRequest, CheckCompatibilityResponse> checkCompatibilitySettings() {
            return this.checkCompatibilitySettings;
        }

        public BetaAnalyticsDataStubSettings build() throws IOException {
            return new BetaAnalyticsDataStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNKNOWN})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

