/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.web.service;

import com.google.adk.agents.BaseAgent;
import com.google.adk.artifacts.BaseArtifactService;
import com.google.adk.memory.BaseMemoryService;
import com.google.adk.runner.Runner;
import com.google.adk.sessions.BaseSessionService;
import com.google.adk.web.AgentLoader;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.stereotype.Component;
import org.springframework.web.server.ResponseStatusException;

@Component
public class RunnerService {
    private static final Logger log = LoggerFactory.getLogger(RunnerService.class);
    private final AgentLoader agentProvider;
    private final BaseArtifactService artifactService;
    private final BaseSessionService sessionService;
    private final BaseMemoryService memoryService;
    private final Map<String, Runner> runnerCache = new ConcurrentHashMap<String, Runner>();

    @Autowired
    public RunnerService(AgentLoader agentProvider, BaseArtifactService artifactService, BaseSessionService sessionService, BaseMemoryService memoryService) {
        this.agentProvider = agentProvider;
        this.artifactService = artifactService;
        this.sessionService = sessionService;
        this.memoryService = memoryService;
    }

    public Runner getRunner(String appName) {
        return this.runnerCache.computeIfAbsent(appName, key -> {
            try {
                BaseAgent agent = this.agentProvider.loadAgent((String)key);
                log.info("RunnerService: Creating Runner for appName: {}, using agent definition: {}", (Object)appName, (Object)agent.name());
                return new Runner(agent, appName, this.artifactService, this.sessionService, this.memoryService);
            }
            catch (NoSuchElementException e) {
                log.error("Agent/App named '{}' not found in registry. Available apps: {}", key, this.agentProvider.listAgents());
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Agent/App not found: " + key);
            }
            catch (IllegalStateException e) {
                log.error("Agent '{}' exists but failed to load: {}", key, (Object)e.getMessage());
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, "Agent failed to load: " + key, (Throwable)e);
            }
        });
    }

    public void onAgentUpdated(String agentName) {
        Runner removed = this.runnerCache.remove(agentName);
        if (removed != null) {
            log.info("Cleared cached Runner for updated agent: {}", (Object)agentName);
        } else {
            log.debug("No cached Runner found for agent: {}", (Object)agentName);
        }
    }
}

