/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.web.controller;

import com.google.adk.sessions.BaseSessionService;
import com.google.adk.sessions.ListSessionsResponse;
import com.google.adk.sessions.Session;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.Single;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
public class SessionController {
    private static final Logger log = LoggerFactory.getLogger(SessionController.class);
    private static final String EVAL_SESSION_ID_PREFIX = "ADK_EVAL_";
    private final BaseSessionService sessionService;

    @Autowired
    public SessionController(BaseSessionService sessionService) {
        this.sessionService = sessionService;
    }

    private Session findSessionOrThrow(String appName, String userId, String sessionId) {
        Maybe maybeSession = this.sessionService.getSession(appName, userId, sessionId, Optional.empty());
        Session session = (Session)maybeSession.blockingGet();
        if (session == null) {
            log.warn("Session not found for appName={}, userId={}, sessionId={}", new Object[]{appName, userId, sessionId});
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, String.format("Session not found: appName=%s, userId=%s, sessionId=%s", appName, userId, sessionId));
        }
        if (!Objects.equals(session.appName(), appName) || !Objects.equals(session.userId(), userId)) {
            log.warn("Session ID {} found but appName/userId mismatch (Expected: {}/{}, Found: {}/{}) - Treating as not found.", new Object[]{sessionId, appName, userId, session.appName(), session.userId()});
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Session found but belongs to a different app/user.");
        }
        log.debug("Found session: {}", (Object)sessionId);
        return session;
    }

    @GetMapping(value={"/apps/{appName}/users/{userId}/sessions/{sessionId}"})
    public Session getSession(@PathVariable String appName, @PathVariable String userId, @PathVariable String sessionId) {
        log.info("Request received for GET /apps/{}/users/{}/sessions/{}", new Object[]{appName, userId, sessionId});
        return this.findSessionOrThrow(appName, userId, sessionId);
    }

    @GetMapping(value={"/apps/{appName}/users/{userId}/sessions"})
    public List<Session> listSessions(@PathVariable String appName, @PathVariable String userId) {
        log.info("Request received for GET /apps/{}/users/{}/sessions", (Object)appName, (Object)userId);
        Single sessionsResponseSingle = this.sessionService.listSessions(appName, userId);
        ListSessionsResponse response = (ListSessionsResponse)sessionsResponseSingle.blockingGet();
        if (response == null || response.sessions() == null) {
            log.warn("Received null response or null sessions list for listSessions({}, {})", (Object)appName, (Object)userId);
            return Collections.emptyList();
        }
        List<Session> filteredSessions = response.sessions().stream().filter(s -> !s.id().startsWith(EVAL_SESSION_ID_PREFIX)).collect(Collectors.toList());
        log.info("Found {} non-evaluation sessions for app={}, user={}", new Object[]{filteredSessions.size(), appName, userId});
        return filteredSessions;
    }

    @PostMapping(value={"/apps/{appName}/users/{userId}/sessions/{sessionId}"})
    public Session createSessionWithId(@PathVariable String appName, @PathVariable String userId, @PathVariable String sessionId, @RequestBody(required=false) Map<String, Object> state) {
        log.info("Request received for POST /apps/{}/users/{}/sessions/{} with state: {}", new Object[]{appName, userId, sessionId, state});
        try {
            this.findSessionOrThrow(appName, userId, sessionId);
            log.warn("Attempted to create session with existing ID: {}", (Object)sessionId);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Session already exists: " + sessionId);
        }
        catch (ResponseStatusException e) {
            if (e.getStatusCode() != HttpStatus.NOT_FOUND) {
                throw e;
            }
            log.info("Session {} not found, proceeding with creation.", (Object)sessionId);
            Map<String, Object> initialState = state != null ? state : Collections.emptyMap();
            try {
                Session createdSession = (Session)this.sessionService.createSession(appName, userId, new ConcurrentHashMap<String, Object>(initialState), sessionId).blockingGet();
                if (createdSession == null) {
                    log.error("Session creation call completed without error but returned null session for {}", (Object)sessionId);
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, "Failed to create session (null result)");
                }
                log.info("Session created successfully with id: {}", (Object)createdSession.id());
                return createdSession;
            }
            catch (Exception e2) {
                log.error("Error creating session with id {}", (Object)sessionId, (Object)e2);
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, "Error creating session", (Throwable)e2);
            }
        }
    }

    @PostMapping(value={"/apps/{appName}/users/{userId}/sessions"})
    public Session createSession(@PathVariable String appName, @PathVariable String userId, @RequestBody(required=false) Map<String, Object> state) {
        log.info("Request received for POST /apps/{}/users/{}/sessions (service generates ID) with state: {}", new Object[]{appName, userId, state});
        Map<String, Object> initialState = state != null ? state : Collections.emptyMap();
        try {
            Session createdSession = (Session)this.sessionService.createSession(appName, userId, new ConcurrentHashMap<String, Object>(initialState), null).blockingGet();
            if (createdSession == null) {
                log.error("Session creation call completed without error but returned null session for user {}", (Object)userId);
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, "Failed to create session (null result)");
            }
            log.info("Session created successfully with generated id: {}", (Object)createdSession.id());
            return createdSession;
        }
        catch (Exception e) {
            log.error("Error creating session for user {}", (Object)userId, (Object)e);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, "Error creating session", (Throwable)e);
        }
    }

    @DeleteMapping(value={"/apps/{appName}/users/{userId}/sessions/{sessionId}"})
    public ResponseEntity<Void> deleteSession(@PathVariable String appName, @PathVariable String userId, @PathVariable String sessionId) {
        log.info("Request received for DELETE /apps/{}/users/{}/sessions/{}", new Object[]{appName, userId, sessionId});
        try {
            this.sessionService.deleteSession(appName, userId, sessionId).blockingAwait();
            log.info("Session deleted successfully: {}", (Object)sessionId);
            return ResponseEntity.noContent().build();
        }
        catch (Exception e) {
            log.error("Error deleting session {}", (Object)sessionId, (Object)e);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, "Error deleting session", (Throwable)e);
        }
    }
}

