/*
 * Decompiled with CFR 0.152.
 */
package com.zynksoftware.documentscanner.ui.components.polygon;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PointF;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import androidx.core.content.ContextCompat;
import com.zynksoftware.documentscanner.R;
import com.zynksoftware.documentscanner.ui.components.polygon.PolygonPointImageView;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0000\u0018\u0000 ,2\u00020\u0001:\u0001,B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J\u0018\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u0007H\u0002J\"\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u001e0\u001d2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001e0 H\u0002J(\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\"\u001a\u00020#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001e0 J\u001c\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\"\u001a\u00020#H\u0002J\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u001e0\u001dJ\u001a\u0010'\u001a\u00020(2\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u001e0\u001dJ\u001a\u0010*\u001a\u00020\u00162\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u001e0\u001dJ\u001c\u0010+\u001a\u00020\u00162\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u001e0\u001dH\u0002R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/zynksoftware/documentscanner/ui/components/polygon/PolygonView;", "Landroid/widget/FrameLayout;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "paint", "Landroid/graphics/Paint;", "getPaint", "()Landroid/graphics/Paint;", "setPaint", "(Landroid/graphics/Paint;)V", "pointPadding", "pointer1", "Landroid/widget/ImageView;", "pointer2", "pointer3", "pointer4", "dispatchDraw", "", "canvas", "Landroid/graphics/Canvas;", "getImageView", "x", "y", "getOrderedPoints", "", "Landroid/graphics/PointF;", "points", "", "getOrderedValidEdgePoints", "tempBitmap", "Landroid/graphics/Bitmap;", "pointFs", "getOutlinePoints", "getPoints", "isValidShape", "", "pointFMap", "setPoints", "setPointsCoordinates", "Companion", "DocumentScanner_release"})
public final class PolygonView
extends FrameLayout {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Paint paint;
    @NotNull
    private ImageView pointer1;
    @NotNull
    private ImageView pointer2;
    @NotNull
    private ImageView pointer3;
    @NotNull
    private ImageView pointer4;
    private int pointPadding;
    @NotNull
    public Map<Integer, View> _$_findViewCache;
    @Nullable
    private static final String TAG = Reflection.getOrCreateKotlinClass(PolygonView.class).getSimpleName();
    private static final int HALF = 2;
    private static final int THREE_PARTS = 3;

    @JvmOverloads
    public PolygonView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.paint = new Paint();
        this.pointPadding = (int)this.getResources().getDimension(R.dimen.zdc_point_padding);
        this.pointer1 = this.getImageView(0, 0);
        this.pointer2 = this.getImageView(this.getWidth(), 0);
        this.pointer3 = this.getImageView(0, this.getHeight());
        this.pointer4 = this.getImageView(this.getWidth(), this.getHeight());
        this.addView((View)this.pointer1);
        this.addView((View)this.pointer2);
        this.addView((View)this.pointer3);
        this.addView((View)this.pointer4);
        this.paint.setColor(ContextCompat.getColor((Context)context, (int)17170443));
        this.paint.setStrokeWidth(context.getResources().getDimension(R.dimen.zdc_polygon_line_stroke_width));
        this.paint.setAntiAlias(true);
        this._$_findViewCache = new LinkedHashMap();
    }

    public /* synthetic */ PolygonView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @NotNull
    public final Paint getPaint() {
        return this.paint;
    }

    public final void setPaint(@NotNull Paint paint) {
        Intrinsics.checkNotNullParameter((Object)paint, (String)"<set-?>");
        this.paint = paint;
    }

    @NotNull
    public final Map<Integer, PointF> getOrderedValidEdgePoints(@NotNull Bitmap tempBitmap, @NotNull List<? extends PointF> pointFs) {
        Intrinsics.checkNotNullParameter((Object)tempBitmap, (String)"tempBitmap");
        Intrinsics.checkNotNullParameter(pointFs, (String)"pointFs");
        Map<Integer, PointF> orderedPoints = this.getOrderedPoints(pointFs);
        if (!this.isValidShape(orderedPoints)) {
            orderedPoints = this.getOutlinePoints(tempBitmap);
        }
        return orderedPoints;
    }

    public final void setPoints(@NotNull Map<Integer, ? extends PointF> pointFMap) {
        Intrinsics.checkNotNullParameter(pointFMap, (String)"pointFMap");
        if (pointFMap.size() == 4) {
            this.setPointsCoordinates(pointFMap);
        }
    }

    @NotNull
    public final Map<Integer, PointF> getPoints() {
        List points = new ArrayList();
        points.add(new PointF(this.pointer1.getX(), this.pointer1.getY()));
        points.add(new PointF(this.pointer2.getX(), this.pointer2.getY()));
        points.add(new PointF(this.pointer3.getX(), this.pointer3.getY()));
        points.add(new PointF(this.pointer4.getX(), this.pointer4.getY()));
        return this.getOrderedPoints(points);
    }

    public final boolean isValidShape(@NotNull Map<Integer, ? extends PointF> pointFMap) {
        Intrinsics.checkNotNullParameter(pointFMap, (String)"pointFMap");
        return pointFMap.size() == 4;
    }

    private final Map<Integer, PointF> getOutlinePoints(Bitmap tempBitmap) {
        float offsetWidth = tempBitmap.getWidth() / 3;
        float offsetHeight = tempBitmap.getHeight() / 3;
        int screenXCenter = tempBitmap.getWidth() / 2;
        int screenYCenter = tempBitmap.getHeight() / 2;
        Map outlinePoints = new HashMap();
        outlinePoints.put(0, new PointF((float)screenXCenter - offsetWidth, (float)screenYCenter - offsetHeight));
        outlinePoints.put(1, new PointF((float)screenXCenter + offsetWidth, (float)screenYCenter - offsetHeight));
        outlinePoints.put(2, new PointF((float)screenXCenter - offsetWidth, (float)screenYCenter + offsetHeight));
        outlinePoints.put(3, new PointF((float)screenXCenter + offsetWidth, (float)screenYCenter + offsetHeight));
        return outlinePoints;
    }

    private final Map<Integer, PointF> getOrderedPoints(List<? extends PointF> points) {
        PointF centerPoint = new PointF();
        int size = points.size();
        for (PointF pointF : points) {
            centerPoint.x += pointF.x / (float)size;
            centerPoint.y += pointF.y / (float)size;
        }
        Map orderedPoints = new HashMap();
        for (PointF pointF : points) {
            int index = -1;
            if (pointF.x < centerPoint.x && pointF.y < centerPoint.y) {
                index = 0;
            } else if (pointF.x > centerPoint.x && pointF.y < centerPoint.y) {
                index = 1;
            } else if (pointF.x < centerPoint.x && pointF.y > centerPoint.y) {
                index = 2;
            } else if (pointF.x > centerPoint.x && pointF.y > centerPoint.y) {
                index = 3;
            }
            Map map = orderedPoints;
            Integer n = index;
            map.put(n, pointF);
        }
        return orderedPoints;
    }

    private final void setPointsCoordinates(Map<Integer, ? extends PointF> pointFMap) {
        try {
            this.pointer1.setX(((PointF)MapsKt.getValue(pointFMap, (Object)Integer.valueOf((int)0))).x - (float)this.pointPadding);
            this.pointer1.setY(((PointF)MapsKt.getValue(pointFMap, (Object)Integer.valueOf((int)0))).y - (float)this.pointPadding);
            this.pointer2.setX(((PointF)MapsKt.getValue(pointFMap, (Object)Integer.valueOf((int)1))).x - (float)this.pointPadding);
            this.pointer2.setY(((PointF)MapsKt.getValue(pointFMap, (Object)Integer.valueOf((int)1))).y - (float)this.pointPadding);
            this.pointer3.setX(((PointF)MapsKt.getValue(pointFMap, (Object)Integer.valueOf((int)2))).x - (float)this.pointPadding);
            this.pointer3.setY(((PointF)MapsKt.getValue(pointFMap, (Object)Integer.valueOf((int)2))).y - (float)this.pointPadding);
            this.pointer4.setX(((PointF)MapsKt.getValue(pointFMap, (Object)Integer.valueOf((int)3))).x - (float)this.pointPadding);
            this.pointer4.setY(((PointF)MapsKt.getValue(pointFMap, (Object)Integer.valueOf((int)3))).y - (float)this.pointPadding);
        }
        catch (NoSuchElementException exception) {
            Log.e((String)TAG, (String)"", (Throwable)exception);
        }
    }

    protected void dispatchDraw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        super.dispatchDraw(canvas);
        canvas.drawLine(this.pointer1.getX() + (float)(this.pointer1.getWidth() / 2), this.pointer1.getY() + (float)(this.pointer1.getHeight() / 2), this.pointer3.getX() + (float)(this.pointer3.getWidth() / 2), this.pointer3.getY() + (float)(this.pointer3.getHeight() / 2), this.paint);
        canvas.drawLine(this.pointer1.getX() + (float)(this.pointer1.getWidth() / 2), this.pointer1.getY() + (float)(this.pointer1.getHeight() / 2), this.pointer2.getX() + (float)(this.pointer2.getWidth() / 2), this.pointer2.getY() + (float)(this.pointer2.getHeight() / 2), this.paint);
        canvas.drawLine(this.pointer2.getX() + (float)(this.pointer2.getWidth() / 2), this.pointer2.getY() + (float)(this.pointer2.getHeight() / 2), this.pointer4.getX() + (float)(this.pointer4.getWidth() / 2), this.pointer4.getY() + (float)(this.pointer4.getHeight() / 2), this.paint);
        canvas.drawLine(this.pointer3.getX() + (float)(this.pointer3.getWidth() / 2), this.pointer3.getY() + (float)(this.pointer3.getHeight() / 2), this.pointer4.getX() + (float)(this.pointer4.getWidth() / 2), this.pointer4.getY() + (float)(this.pointer4.getHeight() / 2), this.paint);
    }

    private final ImageView getImageView(int x, int y) {
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        PolygonPointImageView imageView = new PolygonPointImageView(context, this, null, 0, 12, null);
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-2, -2);
        imageView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        imageView.setImageResource(R.drawable.crop_corner_circle);
        imageView.setPadding(this.pointPadding, this.pointPadding, this.pointPadding, this.pointPadding);
        imageView.setX(x);
        imageView.setY(y);
        return (ImageView)imageView;
    }

    public void _$_clearFindViewByIdCache() {
        this._$_findViewCache.clear();
    }

    @Nullable
    public View _$_findCachedViewById(int id2) {
        Map<Integer, View> map = this._$_findViewCache;
        View view = map.get(id2);
        if (view == null) {
            View view2 = this.findViewById(id2);
            if (view2 == null) {
                view = null;
            } else {
                map.put(id2, view2);
                view = view2;
            }
        }
        return view;
    }

    @JvmOverloads
    public PolygonView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public PolygonView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/zynksoftware/documentscanner/ui/components/polygon/PolygonView$Companion;", "", "()V", "HALF", "", "TAG", "", "THREE_PARTS", "DocumentScanner_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

