/*
 * Decompiled with CFR 0.152.
 */
package com.zynksoftware.documentscanner.common.utils;

import android.graphics.Bitmap;
import android.graphics.PointF;
import com.zynksoftware.documentscanner.common.extensions.BitmapExtensionsKt;
import com.zynksoftware.documentscanner.common.extensions.OpenCvExtensionsKt;
import com.zynksoftware.documentscanner.common.utils.PerspectiveTransformation;
import com.zynksoftware.documentscanner.ui.components.Quadrilateral;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opencv.core.Core;
import org.opencv.core.CvType;
import org.opencv.core.Mat;
import org.opencv.core.MatOfInt;
import org.opencv.core.MatOfPoint;
import org.opencv.core.MatOfPoint2f;
import org.opencv.core.Point;
import org.opencv.core.Scalar;
import org.opencv.core.Size;
import org.opencv.imgproc.Imgproc;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\b\u0000\u0018\u0000 ,2\u00020\u0001:\u0001,B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nJ\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0002J\u0018\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u00102\u0006\u0010\u0012\u001a\u00020\nH\u0002J\u0018\u0010\u0013\u001a\u0004\u0018\u00010\b2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002J\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u00102\u0006\u0010\u0017\u001a\u00020\u0018J\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u001a\u001a\u00020\u0018JN\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020\u001d2\u0006\u0010$\u001a\u00020\u001dJ\u0018\u0010%\u001a\u00020\u00112\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u0011H\u0002J!\u0010)\u001a\b\u0012\u0004\u0012\u00020\r0*2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\r0*H\u0002\u00a2\u0006\u0002\u0010+\u00a8\u0006-"}, d2={"Lcom/zynksoftware/documentscanner/common/utils/OpenCvNativeBridge;", "", "()V", "contourArea", "", "approx", "Lorg/opencv/core/MatOfPoint2f;", "detectLargestQuadrilateral", "Lcom/zynksoftware/documentscanner/ui/components/Quadrilateral;", "src", "Lorg/opencv/core/Mat;", "distance", "p1", "Lorg/opencv/core/Point;", "p2", "findLargestContours", "", "Lorg/opencv/core/MatOfPoint;", "inputMat", "findQuadrilateral", "mContourList", "getContourEdgePoints", "Landroid/graphics/PointF;", "tempBitmap", "Landroid/graphics/Bitmap;", "getPoint", "bitmap", "getScannedBitmap", "x1", "", "y1", "x2", "y2", "x3", "y3", "x4", "y4", "hull2Points", "hull", "Lorg/opencv/core/MatOfInt;", "contour", "sortPoints", "", "([Lorg/opencv/core/Point;)[Lorg/opencv/core/Point;", "Companion", "DocumentScanner_release"})
public final class OpenCvNativeBridge {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int ANGLES_NUMBER = 4;
    private static final double EPSILON_CONSTANT = 0.02;
    private static final double CLOSE_KERNEL_SIZE = 10.0;
    private static final double CANNY_THRESHOLD_LOW = 75.0;
    private static final double CANNY_THRESHOLD_HIGH = 200.0;
    private static final double CUTOFF_THRESHOLD = 155.0;
    private static final double TRUNCATE_THRESHOLD = 150.0;
    private static final double NORMALIZATION_MIN_VALUE = 0.0;
    private static final double NORMALIZATION_MAX_VALUE = 255.0;
    private static final double BLURRING_KERNEL_SIZE = 5.0;
    private static final double DOWNSCALE_IMAGE_SIZE = 600.0;
    private static final int FIRST_MAX_CONTOURS = 10;

    @NotNull
    public final Bitmap getScannedBitmap(@NotNull Bitmap bitmap, float x1, float y1, float x2, float y2, float x3, float y3, float x4, float y4) {
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        MatOfPoint2f rectangle = new MatOfPoint2f();
        Point[] pointArray = new Point[]{new Point((double)x1, (double)y1), new Point((double)x2, (double)y2), new Point((double)x3, (double)y3), new Point((double)x4, (double)y4)};
        rectangle.fromArray(pointArray);
        Mat dstMat = PerspectiveTransformation.INSTANCE.transform(BitmapExtensionsKt.toMat(bitmap), rectangle);
        return OpenCvExtensionsKt.toBitmap(dstMat);
    }

    @NotNull
    public final List<PointF> getContourEdgePoints(@NotNull Bitmap tempBitmap) {
        Intrinsics.checkNotNullParameter((Object)tempBitmap, (String)"tempBitmap");
        MatOfPoint2f point2f = this.getPoint(tempBitmap);
        if (point2f == null) {
            point2f = new MatOfPoint2f();
        }
        Point[] pointArray = point2f.toArray();
        Intrinsics.checkNotNullExpressionValue((Object)pointArray, (String)"point2f.toArray()");
        List points = ArraysKt.toList((Object[])pointArray);
        List result = new ArrayList();
        int n = 0;
        int n2 = points.size();
        while (n < n2) {
            int i = n++;
            result.add(new PointF((float)((Point)points.get((int)i)).x, (float)((Point)points.get((int)i)).y));
        }
        return result;
    }

    @Nullable
    public final MatOfPoint2f getPoint(@NotNull Bitmap bitmap) {
        MatOfPoint2f matOfPoint2f;
        Quadrilateral largestRectangle;
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        Mat src = BitmapExtensionsKt.toMat(bitmap);
        double ratio = 600.0 / (double)Math.max(src.width(), src.height());
        Size downscaledSize = new Size((double)src.width() * ratio, (double)src.height() * ratio);
        Mat downscaled = new Mat(downscaledSize, src.type());
        Imgproc.resize((Mat)src, (Mat)downscaled, (Size)downscaledSize);
        Quadrilateral quadrilateral = largestRectangle = this.detectLargestQuadrilateral(downscaled);
        if (quadrilateral == null) {
            matOfPoint2f = null;
        } else {
            MatOfPoint2f matOfPoint2f2 = quadrilateral.getContour();
            matOfPoint2f = matOfPoint2f2 == null ? null : OpenCvExtensionsKt.scaleRectangle(matOfPoint2f2, (double)1.0f / ratio);
        }
        return matOfPoint2f;
    }

    @Nullable
    public final Quadrilateral detectLargestQuadrilateral(@NotNull Mat src) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Mat destination = new Mat();
        Imgproc.blur((Mat)src, (Mat)src, (Size)new Size(5.0, 5.0));
        Core.normalize((Mat)src, (Mat)src, (double)0.0, (double)255.0, (int)32);
        Imgproc.threshold((Mat)src, (Mat)src, (double)150.0, (double)255.0, (int)2);
        Core.normalize((Mat)src, (Mat)src, (double)0.0, (double)255.0, (int)32);
        Imgproc.Canny((Mat)src, (Mat)destination, (double)200.0, (double)75.0);
        Imgproc.threshold((Mat)destination, (Mat)destination, (double)155.0, (double)255.0, (int)3);
        Imgproc.morphologyEx((Mat)destination, (Mat)destination, (int)3, (Mat)new Mat(new Size(10.0, 10.0), CvType.CV_8UC1, new Scalar(255.0)), (Point)new Point(-1.0, -1.0), (int)1);
        List<MatOfPoint> largestContour = this.findLargestContours(destination);
        if (largestContour != null) {
            return this.findQuadrilateral(largestContour);
        }
        return null;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private final Quadrilateral findQuadrilateral(List<? extends MatOfPoint> mContourList) {
        for (MatOfPoint c : mContourList) {
            block8: {
                block10: {
                    block9: {
                        block7: {
                            var5_6 = c.toArray();
                            c2f = new MatOfPoint2f(Arrays.copyOf(var5_6, var5_6.length));
                            peri = Imgproc.arcLength((MatOfPoint2f)c2f, (boolean)true);
                            approx = new MatOfPoint2f();
                            Imgproc.approxPolyDP((MatOfPoint2f)c2f, (MatOfPoint2f)approx, (double)(0.02 * peri), (boolean)true);
                            points = approx.toArray();
                            if (approx.rows() == 4) {
                                Intrinsics.checkNotNullExpressionValue((Object)points, (String)"points");
                                foundPoints = this.sortPoints((Point[])points);
                                return new Quadrilateral(approx, foundPoints);
                            }
                            if (approx.rows() != 5) continue;
                            shortestDistance = 2.147483647E9;
                            shortestPoint1 = null;
                            shortestPoint2 = null;
                            diagonal = 0.0;
                            diagonalPoint1 = null;
                            diagonalPoint2 = null;
                            var17_16 = 0;
                            while (var17_16 < 4) {
                                i = var17_16++;
                                var19_20 = i + 1;
                                while (var19_20 < 5) {
                                    j = var19_20++;
                                    var23_25 = points[i];
                                    Intrinsics.checkNotNullExpressionValue((Object)var23_25, (String)"points[i]");
                                    v0 = var23_25;
                                    var23_25 = points[j];
                                    Intrinsics.checkNotNullExpressionValue((Object)var23_25, (String)"points[j]");
                                    d = this.distance((Point)v0, (Point)var23_25);
                                    if (d < shortestDistance) {
                                        shortestDistance = d;
                                        shortestPoint1 = points[i];
                                        shortestPoint2 = points[j];
                                    }
                                    if (!(d > diagonal)) continue;
                                    diagonal = d;
                                    diagonalPoint1 = points[i];
                                    diagonalPoint2 = points[j];
                                }
                            }
                            Intrinsics.checkNotNullExpressionValue((Object)points, (String)"points");
                            i = new Point[]{shortestPoint1, shortestPoint2, diagonalPoint1, diagonalPoint2};
                            v1 = trianglePointWithHypotenuse = (Point)CollectionsKt.minus((Iterable)ArraysKt.toList((Object[])points), (Iterable)CollectionsKt.arrayListOf((Object[])i)).get(0);
                            Intrinsics.checkNotNull((Object)v1);
                            v2 = v1.x;
                            v3 = shortestPoint1;
                            Intrinsics.checkNotNull(v3);
                            if (!(v2 > v3.x)) break block7;
                            v4 = trianglePointWithHypotenuse.x;
                            v5 = shortestPoint2;
                            Intrinsics.checkNotNull((Object)v5);
                            if (!(v4 > v5.x) || !(trianglePointWithHypotenuse.y > shortestPoint1.y) || !(trianglePointWithHypotenuse.y > shortestPoint2.y)) break block7;
                            v6 = new Point(Math.min(shortestPoint1.x, shortestPoint2.x), Math.min(shortestPoint1.y, shortestPoint2.y));
                            break block8;
                        }
                        if (!(trianglePointWithHypotenuse.x < shortestPoint1.x)) break block9;
                        v7 = trianglePointWithHypotenuse.x;
                        v8 = shortestPoint2;
                        Intrinsics.checkNotNull((Object)v8);
                        if (!(v7 < v8.x) || !(trianglePointWithHypotenuse.y > shortestPoint1.y) || !(trianglePointWithHypotenuse.y > shortestPoint2.y)) break block9;
                        v6 = new Point(Math.max(shortestPoint1.x, shortestPoint2.x), Math.min(shortestPoint1.y, shortestPoint2.y));
                        break block8;
                    }
                    if (!(trianglePointWithHypotenuse.x < shortestPoint1.x)) break block10;
                    v9 = trianglePointWithHypotenuse.x;
                    v10 = shortestPoint2;
                    Intrinsics.checkNotNull((Object)v10);
                    if (!(v9 < v10.x) || !(trianglePointWithHypotenuse.y < shortestPoint1.y) || !(trianglePointWithHypotenuse.y < shortestPoint2.y)) break block10;
                    v6 = new Point(Math.max(shortestPoint1.x, shortestPoint2.x), Math.max(shortestPoint1.y, shortestPoint2.y));
                    break block8;
                }
                if (!(trianglePointWithHypotenuse.x > shortestPoint1.x)) ** GOTO lbl-1000
                v11 = trianglePointWithHypotenuse.x;
                v12 = shortestPoint2;
                Intrinsics.checkNotNull((Object)v12);
                if (v11 > v12.x && trianglePointWithHypotenuse.y < shortestPoint1.y && trianglePointWithHypotenuse.y < shortestPoint2.y) {
                    v6 = new Point(Math.min(shortestPoint1.x, shortestPoint2.x), Math.max(shortestPoint1.y, shortestPoint2.y));
                } else lbl-1000:
                // 2 sources

                {
                    v6 = new Point(0.0, 0.0);
                }
            }
            newPoint = v6;
            j = new Point[4];
            j[0] = trianglePointWithHypotenuse;
            Intrinsics.checkNotNull((Object)diagonalPoint1);
            Intrinsics.checkNotNull((Object)diagonalPoint2);
            j[3] = newPoint;
            sortedPoints = this.sortPoints(j);
            newApprox = new MatOfPoint2f();
            newApprox.fromArray(Arrays.copyOf(sortedPoints, sortedPoints.length));
            return new Quadrilateral(newApprox, sortedPoints);
        }
        return null;
    }

    private final double distance(Point p1, Point p2) {
        return Math.sqrt(Math.pow(p1.x - p2.x, 2.0) + Math.pow(p1.y - p2.y, 2.0));
    }

    /*
     * WARNING - void declaration
     */
    private final Point[] sortPoints(Point[] src) {
        void $this$toTypedArray$iv;
        void $this$mapTo$iv$iv;
        ArrayList srcPoints = new ArrayList(ArraysKt.toList((Object[])src));
        Point[] pointArray = new Point[]{null, null, null, null};
        Point[] result = pointArray;
        Comparator sumComparator = OpenCvNativeBridge::sortPoints$lambda-0;
        Comparator diffComparator = OpenCvNativeBridge::sortPoints$lambda-1;
        result[0] = (Point)Collections.min(srcPoints, sumComparator);
        result[2] = (Point)Collections.max(srcPoints, sumComparator);
        result[1] = (Point)Collections.min(srcPoints, diffComparator);
        result[3] = (Point)Collections.max(srcPoints, diffComparator);
        Object $this$map$iv = result;
        boolean $i$f$map = false;
        Point[] pointArray2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((Point[])$this$map$iv).length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var14_14 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void v0 = it;
            Intrinsics.checkNotNull((Object)v0);
            collection.add(v0);
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        Point[] pointArray3 = thisCollection$iv.toArray(new Point[0]);
        Intrinsics.checkNotNull((Object)pointArray3, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        return pointArray3;
    }

    private final List<MatOfPoint> findLargestContours(Mat inputMat) {
        Mat mHierarchy = new Mat();
        List mContourList = new ArrayList();
        Imgproc.findContours((Mat)inputMat, (List)mContourList, (Mat)mHierarchy, (int)1, (int)2);
        List mHullList = new ArrayList();
        MatOfInt tempHullIndices = new MatOfInt();
        int n = 0;
        int n2 = mContourList.size();
        while (n < n2) {
            int i = n++;
            Imgproc.convexHull((MatOfPoint)((MatOfPoint)mContourList.get(i)), (MatOfInt)tempHullIndices);
            mHullList.add(this.hull2Points(tempHullIndices, (MatOfPoint)mContourList.get(i)));
        }
        for (MatOfPoint c : mContourList) {
            c.release();
        }
        tempHullIndices.release();
        mHierarchy.release();
        if (mHullList.size() != 0) {
            CollectionsKt.sortWith((List)mHullList, OpenCvNativeBridge::findLargestContours$lambda-3);
            return mHullList.subList(0, Math.min(mHullList.size(), 10));
        }
        return null;
    }

    private final MatOfPoint hull2Points(MatOfInt hull, MatOfPoint contour) {
        List indexes = hull.toList();
        List points = new ArrayList();
        List ctrList = contour.toList();
        for (Integer index : indexes) {
            Intrinsics.checkNotNullExpressionValue((Object)index, (String)"index");
            Object e = ctrList.get(index);
            Intrinsics.checkNotNullExpressionValue(e, (String)"ctrList[index]");
            points.add(e);
        }
        MatOfPoint point = new MatOfPoint();
        point.fromList(points);
        return point;
    }

    public final double contourArea(@NotNull MatOfPoint2f approx) {
        Intrinsics.checkNotNullParameter((Object)approx, (String)"approx");
        return Imgproc.contourArea((Mat)((Mat)approx));
    }

    private static final int sortPoints$lambda-0(Point lhs, Point rhs) {
        return Double.compare(lhs.y + lhs.x, rhs.y + rhs.x);
    }

    private static final int sortPoints$lambda-1(Point lhs, Point rhs) {
        return Double.compare(lhs.y - lhs.x, rhs.y - rhs.x);
    }

    private static final int findLargestContours$lambda-3(MatOfPoint lhs, MatOfPoint rhs) {
        return Double.compare(Imgproc.contourArea((Mat)((Mat)rhs)), Imgproc.contourArea((Mat)((Mat)lhs)));
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u000b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/zynksoftware/documentscanner/common/utils/OpenCvNativeBridge$Companion;", "", "()V", "ANGLES_NUMBER", "", "BLURRING_KERNEL_SIZE", "", "CANNY_THRESHOLD_HIGH", "CANNY_THRESHOLD_LOW", "CLOSE_KERNEL_SIZE", "CUTOFF_THRESHOLD", "DOWNSCALE_IMAGE_SIZE", "EPSILON_CONSTANT", "FIRST_MAX_CONTOURS", "NORMALIZATION_MAX_VALUE", "NORMALIZATION_MIN_VALUE", "TRUNCATE_THRESHOLD", "DocumentScanner_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

