/*
 * Decompiled with CFR 0.152.
 */
package com.zynksoftware.documentscanner.ui.imagecrop;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.PointF;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Handler;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import androidx.fragment.app.FragmentActivity;
import com.zynksoftware.documentscanner.R;
import com.zynksoftware.documentscanner.common.extensions.BitmapExtensionsKt;
import com.zynksoftware.documentscanner.common.utils.OpenCvNativeBridge;
import com.zynksoftware.documentscanner.model.DocumentScannerErrorModel;
import com.zynksoftware.documentscanner.ui.base.BaseFragment;
import com.zynksoftware.documentscanner.ui.components.polygon.PolygonView;
import com.zynksoftware.documentscanner.ui.scan.InternalScanActivity;
import id.zelory.compressor.UtilKt;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0002J\b\u0010\t\u001a\u00020\bH\u0002J\u001c\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b2\u0006\u0010\u000e\u001a\u00020\u0006H\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\bH\u0002J\b\u0010\u0012\u001a\u00020\bH\u0002J\b\u0010\u0013\u001a\u00020\bH\u0002J&\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u001a\u0010\u001f\u001a\u00020\b2\u0006\u0010 \u001a\u00020\u00152\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016J\b\u0010!\u001a\u00020\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/zynksoftware/documentscanner/ui/imagecrop/ImageCropFragment;", "Lcom/zynksoftware/documentscanner/ui/base/BaseFragment;", "()V", "nativeClass", "Lcom/zynksoftware/documentscanner/common/utils/OpenCvNativeBridge;", "selectedImage", "Landroid/graphics/Bitmap;", "closeFragment", "", "getCroppedImage", "getEdgePoints", "", "", "Landroid/graphics/PointF;", "tempBitmap", "getScanActivity", "Lcom/zynksoftware/documentscanner/ui/scan/InternalScanActivity;", "initListeners", "initializeCropping", "onConfirmButtonClicked", "onCreateView", "Landroid/view/View;", "inflater", "Landroid/view/LayoutInflater;", "container", "Landroid/view/ViewGroup;", "savedInstanceState", "Landroid/os/Bundle;", "onError", "error", "Lcom/zynksoftware/documentscanner/model/DocumentScannerErrorModel;", "onViewCreated", "view", "startImageProcessingFragment", "Companion", "DocumentScanner_release"})
public final class ImageCropFragment
extends BaseFragment {
    private final OpenCvNativeBridge nativeClass = new OpenCvNativeBridge();
    private Bitmap selectedImage;
    private static final String TAG;
    public static final Companion Companion;
    private HashMap _$_findViewCache;

    @Nullable
    public View onCreateView(@NotNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        Intrinsics.checkNotNullParameter((Object)inflater, (String)"inflater");
        return inflater.inflate(R.layout.fragment_image_crop, container, false);
    }

    public void onViewCreated(@NotNull View view, @Nullable Bundle savedInstanceState) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        super.onViewCreated(view, savedInstanceState);
        Bitmap sourceBitmap = BitmapFactory.decodeFile((String)this.getScanActivity().getOriginalImageFile$DocumentScanner_release().getAbsolutePath());
        if (sourceBitmap != null) {
            this.selectedImage = UtilKt.determineImageRotation((File)this.getScanActivity().getOriginalImageFile$DocumentScanner_release(), (Bitmap)sourceBitmap);
        } else {
            Log.e((String)TAG, (String)DocumentScannerErrorModel.ErrorMessage.INVALID_IMAGE.getError());
            this.onError(new DocumentScannerErrorModel(DocumentScannerErrorModel.ErrorMessage.INVALID_IMAGE, null, 2, null));
            new Handler().post(new Runnable(this){
                final /* synthetic */ ImageCropFragment this$0;

                public final void run() {
                    ImageCropFragment.access$closeFragment(this.this$0);
                }
                {
                    this.this$0 = imageCropFragment;
                }
            });
        }
        ((FrameLayout)this._$_findCachedViewById(R.id.holderImageView)).post(new Runnable(this){
            final /* synthetic */ ImageCropFragment this$0;

            public final void run() {
                ImageCropFragment.access$initializeCropping(this.this$0);
            }
            {
                this.this$0 = imageCropFragment;
            }
        });
        this.initListeners();
    }

    private final void initListeners() {
        ((ImageView)this._$_findCachedViewById(R.id.closeButton)).setOnClickListener(new View.OnClickListener(this){
            final /* synthetic */ ImageCropFragment this$0;

            public final void onClick(View it) {
                ImageCropFragment.access$closeFragment(this.this$0);
            }
            {
                this.this$0 = imageCropFragment;
            }
        });
        ((ImageView)this._$_findCachedViewById(R.id.confirmButton)).setOnClickListener(new View.OnClickListener(this){
            final /* synthetic */ ImageCropFragment this$0;

            public final void onClick(View it) {
                ImageCropFragment.access$onConfirmButtonClicked(this.this$0);
            }
            {
                this.this$0 = imageCropFragment;
            }
        });
    }

    private final InternalScanActivity getScanActivity() {
        FragmentActivity fragmentActivity = this.requireActivity();
        if (fragmentActivity == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.zynksoftware.documentscanner.ui.scan.InternalScanActivity");
        }
        return (InternalScanActivity)fragmentActivity;
    }

    private final void initializeCropping() {
        if (this.selectedImage != null) {
            Bitmap bitmap = this.selectedImage;
            Intrinsics.checkNotNull((Object)bitmap);
            if (bitmap.getWidth() > 0) {
                Bitmap bitmap2 = this.selectedImage;
                Intrinsics.checkNotNull((Object)bitmap2);
                if (bitmap2.getHeight() > 0) {
                    Bitmap tempBitmap;
                    Bitmap bitmap3 = this.selectedImage;
                    Intrinsics.checkNotNull((Object)bitmap3);
                    FrameLayout frameLayout = (FrameLayout)this._$_findCachedViewById(R.id.holderImageCrop);
                    Intrinsics.checkNotNullExpressionValue((Object)frameLayout, (String)"holderImageCrop");
                    int n = frameLayout.getWidth();
                    FrameLayout frameLayout2 = (FrameLayout)this._$_findCachedViewById(R.id.holderImageCrop);
                    Intrinsics.checkNotNullExpressionValue((Object)frameLayout2, (String)"holderImageCrop");
                    Bitmap scaledBitmap = BitmapExtensionsKt.scaledBitmap(bitmap3, n, frameLayout2.getHeight());
                    ((ImageView)this._$_findCachedViewById(R.id.imagePreview)).setImageBitmap(scaledBitmap);
                    ImageView imageView = (ImageView)this._$_findCachedViewById(R.id.imagePreview);
                    Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"imagePreview");
                    Drawable drawable = imageView.getDrawable();
                    if (drawable == null) {
                        throw new NullPointerException("null cannot be cast to non-null type android.graphics.drawable.BitmapDrawable");
                    }
                    Bitmap bitmap4 = tempBitmap = ((BitmapDrawable)drawable).getBitmap();
                    Intrinsics.checkNotNullExpressionValue((Object)bitmap4, (String)"tempBitmap");
                    Map<Integer, PointF> pointFs = this.getEdgePoints(bitmap4);
                    Log.d((String)TAG, (String)("ZDCgetEdgePoints ends " + System.currentTimeMillis()));
                    ((PolygonView)this._$_findCachedViewById(R.id.polygonView)).setPoints(pointFs);
                    PolygonView polygonView = (PolygonView)this._$_findCachedViewById(R.id.polygonView);
                    Intrinsics.checkNotNullExpressionValue((Object)((Object)polygonView), (String)"polygonView");
                    polygonView.setVisibility(0);
                    int padding = (int)this.getResources().getDimension(R.dimen.zdc_polygon_dimens);
                    FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(tempBitmap.getWidth() + padding, tempBitmap.getHeight() + padding);
                    layoutParams.gravity = 17;
                    PolygonView polygonView2 = (PolygonView)this._$_findCachedViewById(R.id.polygonView);
                    Intrinsics.checkNotNullExpressionValue((Object)((Object)polygonView2), (String)"polygonView");
                    polygonView2.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                }
            }
        }
    }

    private final void onError(DocumentScannerErrorModel error) {
        if (this.isAdded()) {
            this.getScanActivity().onError(error);
        }
    }

    private final void onConfirmButtonClicked() {
        this.getCroppedImage();
        this.startImageProcessingFragment();
    }

    private final Map<Integer, PointF> getEdgePoints(Bitmap tempBitmap) {
        Log.d((String)TAG, (String)("ZDCgetEdgePoints Starts " + System.currentTimeMillis()));
        List<PointF> pointFs = this.nativeClass.getContourEdgePoints(tempBitmap);
        return ((PolygonView)this._$_findCachedViewById(R.id.polygonView)).getOrderedValidEdgePoints(tempBitmap, pointFs);
    }

    private final void getCroppedImage() {
        if (this.selectedImage != null) {
            try {
                Log.d((String)TAG, (String)("ZDCgetCroppedImage starts " + System.currentTimeMillis()));
                Map<Integer, PointF> points = ((PolygonView)this._$_findCachedViewById(R.id.polygonView)).getPoints();
                Bitmap bitmap = this.selectedImage;
                Intrinsics.checkNotNull((Object)bitmap);
                float f = bitmap.getWidth();
                ImageView imageView = (ImageView)this._$_findCachedViewById(R.id.imagePreview);
                Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"imagePreview");
                float xRatio = f / (float)imageView.getWidth();
                Bitmap bitmap2 = this.selectedImage;
                Intrinsics.checkNotNull((Object)bitmap2);
                float f2 = bitmap2.getHeight();
                ImageView imageView2 = (ImageView)this._$_findCachedViewById(R.id.imagePreview);
                Intrinsics.checkNotNullExpressionValue((Object)imageView2, (String)"imagePreview");
                float yRatio = f2 / (float)imageView2.getHeight();
                Context context = this.requireContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"requireContext()");
                int pointPadding = (int)context.getResources().getDimension(R.dimen.zdc_point_padding);
                float x1 = (((PointF)MapsKt.getValue(points, (Object)Integer.valueOf((int)0))).x + (float)pointPadding) * xRatio;
                float x2 = (((PointF)MapsKt.getValue(points, (Object)Integer.valueOf((int)1))).x + (float)pointPadding) * xRatio;
                float x3 = (((PointF)MapsKt.getValue(points, (Object)Integer.valueOf((int)2))).x + (float)pointPadding) * xRatio;
                float x4 = (((PointF)MapsKt.getValue(points, (Object)Integer.valueOf((int)3))).x + (float)pointPadding) * xRatio;
                float y1 = (((PointF)MapsKt.getValue(points, (Object)Integer.valueOf((int)0))).y + (float)pointPadding) * yRatio;
                float y2 = (((PointF)MapsKt.getValue(points, (Object)Integer.valueOf((int)1))).y + (float)pointPadding) * yRatio;
                float y3 = (((PointF)MapsKt.getValue(points, (Object)Integer.valueOf((int)2))).y + (float)pointPadding) * yRatio;
                float y4 = (((PointF)MapsKt.getValue(points, (Object)Integer.valueOf((int)3))).y + (float)pointPadding) * yRatio;
                InternalScanActivity internalScanActivity = this.getScanActivity();
                Bitmap bitmap3 = this.selectedImage;
                Intrinsics.checkNotNull((Object)bitmap3);
                internalScanActivity.setCroppedImage$DocumentScanner_release(this.nativeClass.getScannedBitmap(bitmap3, x1, y1, x2, y2, x3, y3, x4, y4));
                Log.d((String)TAG, (String)("ZDCgetCroppedImage ends " + System.currentTimeMillis()));
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)DocumentScannerErrorModel.ErrorMessage.CROPPING_FAILED.getError(), (Throwable)e);
                this.onError(new DocumentScannerErrorModel(DocumentScannerErrorModel.ErrorMessage.CROPPING_FAILED, e));
            }
        } else {
            Log.e((String)TAG, (String)DocumentScannerErrorModel.ErrorMessage.INVALID_IMAGE.getError());
            this.onError(new DocumentScannerErrorModel(DocumentScannerErrorModel.ErrorMessage.INVALID_IMAGE, null, 2, null));
        }
    }

    private final void startImageProcessingFragment() {
        this.getScanActivity().showImageProcessingFragment$DocumentScanner_release();
    }

    private final void closeFragment() {
        this.getScanActivity().closeCurrentFragment$DocumentScanner_release();
    }

    static {
        Companion = new Companion(null);
        TAG = Reflection.getOrCreateKotlinClass(ImageCropFragment.class).getSimpleName();
    }

    public static final /* synthetic */ void access$closeFragment(ImageCropFragment $this) {
        $this.closeFragment();
    }

    public static final /* synthetic */ void access$initializeCropping(ImageCropFragment $this) {
        $this.initializeCropping();
    }

    public static final /* synthetic */ void access$onConfirmButtonClicked(ImageCropFragment $this) {
        $this.onConfirmButtonClicked();
    }

    @Override
    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            View view2 = this.getView();
            if (view2 == null) {
                return null;
            }
            view = view2.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    @Override
    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Override
    public /* synthetic */ void onDestroyView() {
        super.onDestroyView();
        this._$_clearFindViewByIdCache();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0005\u001a\u00020\u0006R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/zynksoftware/documentscanner/ui/imagecrop/ImageCropFragment$Companion;", "", "()V", "TAG", "", "newInstance", "Lcom/zynksoftware/documentscanner/ui/imagecrop/ImageCropFragment;", "DocumentScanner_release"})
    public static final class Companion {
        @NotNull
        public final ImageCropFragment newInstance() {
            return new ImageCropFragment();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

