/*
 * Decompiled with CFR 0.152.
 */
package com.zynksoftware.documentscanner.ui.components.scansurface;

import android.content.Context;
import android.os.CountDownTimer;
import android.util.AttributeSet;
import android.util.Log;
import android.util.Size;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.camera.core.Camera;
import androidx.camera.core.CameraSelector;
import androidx.camera.core.ImageAnalysis;
import androidx.camera.core.ImageCapture;
import androidx.camera.core.ImageCaptureException;
import androidx.camera.core.ImageProxy;
import androidx.camera.core.Preview;
import androidx.camera.core.UseCase;
import androidx.camera.lifecycle.ProcessCameraProvider;
import androidx.camera.view.PreviewView;
import androidx.core.content.ContextCompat;
import androidx.lifecycle.LifecycleOwner;
import com.google.common.util.concurrent.ListenableFuture;
import com.zynksoftware.documentscanner.R;
import com.zynksoftware.documentscanner.common.extensions.ImageProxyExtensionsKt;
import com.zynksoftware.documentscanner.common.utils.ImageDetectionProperties;
import com.zynksoftware.documentscanner.common.utils.OpenCvNativeBridge;
import com.zynksoftware.documentscanner.model.DocumentScannerErrorModel;
import com.zynksoftware.documentscanner.ui.components.Quadrilateral;
import com.zynksoftware.documentscanner.ui.components.ScanCanvasView;
import com.zynksoftware.documentscanner.ui.components.scansurface.ScanSurfaceListener;
import com.zynksoftware.documentscanner.ui.components.scansurface.ScanSurfaceView;
import java.io.File;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opencv.core.Mat;
import org.opencv.core.MatOfPoint2f;
import org.opencv.core.Point;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0000\u0018\u0000 O2\u00020\u0001:\u0001OB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u00108\u001a\u000209H\u0002J\b\u0010:\u001a\u000209H\u0002J\b\u0010;\u001a\u000209H\u0002J\b\u0010<\u001a\u000209H\u0002J\b\u0010=\u001a\u000209H\u0002J+\u0010>\u001a\u0002092\u0006\u0010?\u001a\u00020@2\f\u0010A\u001a\b\u0012\u0004\u0012\u00020C0B2\u0006\u0010D\u001a\u00020EH\u0002\u00a2\u0006\u0002\u0010FJ\b\u0010G\u001a\u000209H\u0002J\b\u0010H\u001a\u000209H\u0002J\b\u0010I\u001a\u000209H\u0002J\b\u0010J\u001a\u000209H\u0002J\u0006\u0010K\u001a\u000209J\u0006\u0010L\u001a\u000209J\u0006\u0010M\u001a\u000209J\u0006\u0010N\u001a\u000209R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001e\u001a\u00020\u001fX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u001a\u0010$\u001a\u00020%X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u000e\u0010*\u001a\u00020+X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010.\u001a\u00020/X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u00101\"\u0004\b2\u00103R\u0010\u00104\u001a\u0004\u0018\u000105X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00106\u001a\u000207X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006P"}, d2={"Lcom/zynksoftware/documentscanner/ui/components/scansurface/ScanSurfaceView;", "Landroid/widget/FrameLayout;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyle", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "autoCaptureTimer", "Landroid/os/CountDownTimer;", "camera", "Landroidx/camera/core/Camera;", "cameraProvider", "Landroidx/camera/lifecycle/ProcessCameraProvider;", "flashMode", "imageAnalysis", "Landroidx/camera/core/ImageAnalysis;", "imageCapture", "Landroidx/camera/core/ImageCapture;", "isAutoCaptureOn", "", "()Z", "setAutoCaptureOn", "(Z)V", "isAutoCaptureScheduled", "isCapturing", "isFlashEnabled", "lifecycleOwner", "Landroidx/lifecycle/LifecycleOwner;", "getLifecycleOwner", "()Landroidx/lifecycle/LifecycleOwner;", "setLifecycleOwner", "(Landroidx/lifecycle/LifecycleOwner;)V", "listener", "Lcom/zynksoftware/documentscanner/ui/components/scansurface/ScanSurfaceListener;", "getListener", "()Lcom/zynksoftware/documentscanner/ui/components/scansurface/ScanSurfaceListener;", "setListener", "(Lcom/zynksoftware/documentscanner/ui/components/scansurface/ScanSurfaceListener;)V", "millisLeft", "", "nativeClass", "Lcom/zynksoftware/documentscanner/common/utils/OpenCvNativeBridge;", "originalImageFile", "Ljava/io/File;", "getOriginalImageFile", "()Ljava/io/File;", "setOriginalImageFile", "(Ljava/io/File;)V", "preview", "Landroidx/camera/core/Preview;", "previewSize", "Landroid/util/Size;", "autoCapture", "", "bindCamera", "cancelAutoCapture", "checkIfFlashIsPresent", "clearAndInvalidateCanvas", "drawLargestRect", "approx", "Lorg/opencv/core/MatOfPoint2f;", "points", "", "Lorg/opencv/core/Point;", "stdSize", "Lorg/opencv/core/Size;", "(Lorg/opencv/core/MatOfPoint2f;[Lorg/opencv/core/Point;Lorg/opencv/core/Size;)V", "openCamera", "scheduleAutoCapture", "setImageCapture", "setUseCases", "start", "switchFlashState", "takePicture", "unbindCamera", "Companion", "DocumentScanner_release"})
public final class ScanSurfaceView
extends FrameLayout {
    @NotNull
    public LifecycleOwner lifecycleOwner;
    @NotNull
    public ScanSurfaceListener listener;
    @NotNull
    public File originalImageFile;
    private final OpenCvNativeBridge nativeClass;
    private CountDownTimer autoCaptureTimer;
    private long millisLeft;
    private boolean isAutoCaptureScheduled;
    private boolean isCapturing;
    private ImageAnalysis imageAnalysis;
    private Camera camera;
    private ImageCapture imageCapture;
    private Preview preview;
    private ProcessCameraProvider cameraProvider;
    private Size previewSize;
    private boolean isAutoCaptureOn;
    private boolean isFlashEnabled;
    private int flashMode;
    private static final String TAG;
    private static final long TIME_POST_PICTURE = 1500L;
    private static final long DEFAULT_TIME_POST_PICTURE = 1500L;
    private static final int IMAGE_ANALYSIS_SCALE_WIDTH = 400;
    public static final Companion Companion;
    private HashMap _$_findViewCache;

    @NotNull
    public final LifecycleOwner getLifecycleOwner() {
        LifecycleOwner lifecycleOwner = this.lifecycleOwner;
        if (lifecycleOwner == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"lifecycleOwner");
        }
        return lifecycleOwner;
    }

    public final void setLifecycleOwner(@NotNull LifecycleOwner lifecycleOwner) {
        Intrinsics.checkNotNullParameter((Object)lifecycleOwner, (String)"<set-?>");
        this.lifecycleOwner = lifecycleOwner;
    }

    @NotNull
    public final ScanSurfaceListener getListener() {
        ScanSurfaceListener scanSurfaceListener = this.listener;
        if (scanSurfaceListener == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"listener");
        }
        return scanSurfaceListener;
    }

    public final void setListener(@NotNull ScanSurfaceListener scanSurfaceListener) {
        Intrinsics.checkNotNullParameter((Object)scanSurfaceListener, (String)"<set-?>");
        this.listener = scanSurfaceListener;
    }

    @NotNull
    public final File getOriginalImageFile() {
        File file = this.originalImageFile;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"originalImageFile");
        }
        return file;
    }

    public final void setOriginalImageFile(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"<set-?>");
        this.originalImageFile = file;
    }

    public final boolean isAutoCaptureOn() {
        return this.isAutoCaptureOn;
    }

    public final void setAutoCaptureOn(boolean bl) {
        this.isAutoCaptureOn = bl;
    }

    public final void start() {
        ((PreviewView)this._$_findCachedViewById(R.id.viewFinder)).post(new Runnable(this){
            final /* synthetic */ ScanSurfaceView this$0;

            public final void run() {
                ((PreviewView)this.this$0._$_findCachedViewById(R.id.viewFinder)).measure(0, 0);
                PreviewView previewView = (PreviewView)this.this$0._$_findCachedViewById(R.id.viewFinder);
                Intrinsics.checkNotNullExpressionValue((Object)previewView, (String)"viewFinder");
                int n = previewView.getWidth();
                PreviewView previewView2 = (PreviewView)this.this$0._$_findCachedViewById(R.id.viewFinder);
                Intrinsics.checkNotNullExpressionValue((Object)previewView2, (String)"viewFinder");
                ScanSurfaceView.access$setPreviewSize$p(this.this$0, new Size(n, previewView2.getHeight()));
                ScanSurfaceView.access$openCamera(this.this$0);
            }
            {
                this.this$0 = scanSurfaceView;
            }
        });
    }

    private final void clearAndInvalidateCanvas() {
        ((ScanCanvasView)this._$_findCachedViewById(R.id.scanCanvasView)).clearShape();
    }

    private final void openCamera() {
        ListenableFuture listenableFuture = ProcessCameraProvider.getInstance((Context)this.getContext());
        Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"ProcessCameraProvider.getInstance(context)");
        ListenableFuture cameraProviderFuture = listenableFuture;
        cameraProviderFuture.addListener(new Runnable(this, cameraProviderFuture){
            final /* synthetic */ ScanSurfaceView this$0;
            final /* synthetic */ ListenableFuture $cameraProviderFuture;

            public final void run() {
                ScanSurfaceView.access$setCameraProvider$p(this.this$0, (ProcessCameraProvider)this.$cameraProviderFuture.get());
                try {
                    ScanSurfaceView.access$bindCamera(this.this$0);
                    ScanSurfaceView.access$checkIfFlashIsPresent(this.this$0);
                }
                catch (Exception exc) {
                    Log.e((String)ScanSurfaceView.access$getTAG$cp(), (String)DocumentScannerErrorModel.ErrorMessage.CAMERA_USE_CASE_BINDING_FAILED.getError(), (Throwable)exc);
                    this.this$0.getListener().onError(new DocumentScannerErrorModel(DocumentScannerErrorModel.ErrorMessage.CAMERA_USE_CASE_BINDING_FAILED, exc));
                }
            }
            {
                this.this$0 = scanSurfaceView;
                this.$cameraProviderFuture = listenableFuture;
            }
        }, ContextCompat.getMainExecutor((Context)this.getContext()));
    }

    private final void bindCamera() {
        ProcessCameraProvider processCameraProvider = this.cameraProvider;
        if (processCameraProvider != null) {
            processCameraProvider.unbindAll();
        }
        this.camera = null;
        this.setUseCases();
    }

    private final void setImageCapture() {
        if (this.imageCapture != null) {
            ProcessCameraProvider processCameraProvider = this.cameraProvider;
            if (processCameraProvider != null) {
                ImageCapture imageCapture = this.imageCapture;
                Intrinsics.checkNotNull((Object)imageCapture);
                if (processCameraProvider.isBound((UseCase)imageCapture)) {
                    ProcessCameraProvider processCameraProvider2 = this.cameraProvider;
                    if (processCameraProvider2 != null) {
                        processCameraProvider2.unbind(new UseCase[]{(UseCase)this.imageCapture});
                    }
                }
            }
        }
        this.imageCapture = null;
        this.imageCapture = new ImageCapture.Builder().setTargetRotation(0).setFlashMode(this.flashMode).build();
    }

    public final void unbindCamera() {
        block0: {
            ProcessCameraProvider processCameraProvider = this.cameraProvider;
            if (processCameraProvider == null) break block0;
            processCameraProvider.unbind(new UseCase[]{(UseCase)this.imageAnalysis});
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void setUseCases() {
        void it;
        Preview.Builder builder = new Preview.Builder();
        Size size = this.previewSize;
        if (size == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"previewSize");
        }
        Preview preview = builder.setTargetResolution(size).setTargetRotation(0).build();
        boolean bl = false;
        boolean bl2 = false;
        Preview preview2 = preview;
        ScanSurfaceView scanSurfaceView = this;
        boolean bl3 = false;
        PreviewView previewView = (PreviewView)this._$_findCachedViewById(R.id.viewFinder);
        Intrinsics.checkNotNullExpressionValue((Object)previewView, (String)"viewFinder");
        it.setSurfaceProvider(previewView.getSurfaceProvider());
        Unit unit = Unit.INSTANCE;
        scanSurfaceView.preview = preview;
        this.setImageCapture();
        Size size2 = this.previewSize;
        if (size2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"previewSize");
        }
        float f = size2.getWidth();
        Size size3 = this.previewSize;
        if (size3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"previewSize");
        }
        float aspectRatio = f / (float)size3.getHeight();
        int width = 400;
        int height = MathKt.roundToInt((float)((float)width / aspectRatio));
        ImageAnalysis imageAnalysis = this.imageAnalysis = new ImageAnalysis.Builder().setBackpressureStrategy(0).setTargetResolution(new Size(width, height)).setTargetRotation(0).build();
        if (imageAnalysis != null) {
            imageAnalysis.setAnalyzer(ContextCompat.getMainExecutor((Context)this.getContext()), new ImageAnalysis.Analyzer(this){
                final /* synthetic */ ScanSurfaceView this$0;

                public final void analyze(@NotNull ImageProxy image) {
                    block5: {
                        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
                        if (this.this$0.isAutoCaptureOn()) {
                            try {
                                Mat mat = ImageProxyExtensionsKt.yuvToRgba(image);
                                org.opencv.core.Size originalPreviewSize = mat.size();
                                Quadrilateral largestQuad = ScanSurfaceView.access$getNativeClass$p(this.this$0).detectLargestQuadrilateral(mat);
                                mat.release();
                                if (largestQuad != null) {
                                    MatOfPoint2f matOfPoint2f = largestQuad.getContour();
                                    Point[] pointArray = largestQuad.getPoints();
                                    org.opencv.core.Size size = originalPreviewSize;
                                    Intrinsics.checkNotNullExpressionValue((Object)size, (String)"originalPreviewSize");
                                    ScanSurfaceView.access$drawLargestRect(this.this$0, matOfPoint2f, pointArray, size);
                                    break block5;
                                }
                                ScanSurfaceView.access$clearAndInvalidateCanvas(this.this$0);
                            }
                            catch (Exception e) {
                                Log.e((String)ScanSurfaceView.access$getTAG$cp(), (String)DocumentScannerErrorModel.ErrorMessage.DETECT_LARGEST_QUADRILATERAL_FAILED.getError(), (Throwable)e);
                                this.this$0.getListener().onError(new DocumentScannerErrorModel(DocumentScannerErrorModel.ErrorMessage.DETECT_LARGEST_QUADRILATERAL_FAILED, e));
                                ScanSurfaceView.access$clearAndInvalidateCanvas(this.this$0);
                            }
                        } else {
                            ScanSurfaceView.access$clearAndInvalidateCanvas(this.this$0);
                        }
                    }
                    image.close();
                }
                {
                    this.this$0 = scanSurfaceView;
                }
            });
        }
        ProcessCameraProvider processCameraProvider = this.cameraProvider;
        Intrinsics.checkNotNull((Object)processCameraProvider);
        LifecycleOwner lifecycleOwner = this.lifecycleOwner;
        if (lifecycleOwner == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"lifecycleOwner");
        }
        this.camera = processCameraProvider.bindToLifecycle(lifecycleOwner, CameraSelector.DEFAULT_BACK_CAMERA, new UseCase[]{(UseCase)this.preview, (UseCase)this.imageAnalysis, (UseCase)this.imageCapture});
    }

    private final void drawLargestRect(MatOfPoint2f approx, Point[] points, org.opencv.core.Size stdSize) {
        float previewWidth = (float)stdSize.height;
        float previewHeight = (float)stdSize.width;
        float f = previewWidth - (float)points[0].y;
        float f2 = previewWidth - (float)points[1].y;
        boolean bl = false;
        float f3 = Math.max(f, f2);
        f = previewWidth - (float)points[2].y;
        f2 = previewWidth - (float)points[3].y;
        bl = false;
        float resultWidth = f3 - Math.min(f, f2);
        f2 = (float)points[1].x;
        float f4 = (float)points[2].x;
        boolean bl2 = false;
        float f5 = Math.max(f2, f4);
        f2 = (float)points[0].x;
        f4 = (float)points[3].x;
        bl2 = false;
        float resultHeight = f5 - Math.min(f2, f4);
        ImageDetectionProperties imgDetectionPropsObj = new ImageDetectionProperties(previewWidth, previewHeight, points[0], points[1], points[2], points[3], (int)resultWidth, (int)resultHeight);
        if (imgDetectionPropsObj.isNotValidImage(approx)) {
            ((ScanCanvasView)this._$_findCachedViewById(R.id.scanCanvasView)).clearShape();
            this.cancelAutoCapture();
        } else {
            if (!this.isAutoCaptureScheduled) {
                this.scheduleAutoCapture();
            }
            ((ScanCanvasView)this._$_findCachedViewById(R.id.scanCanvasView)).showShape(previewWidth, previewHeight, points);
        }
    }

    private final void scheduleAutoCapture() {
        block0: {
            this.isAutoCaptureScheduled = true;
            this.millisLeft = 0L;
            CountDownTimer countDownTimer = this.autoCaptureTimer = (CountDownTimer)new CountDownTimer(this, 1500L, 100L){
                final /* synthetic */ ScanSurfaceView this$0;

                public void onTick(long millisUntilFinished) {
                    if (millisUntilFinished != ScanSurfaceView.access$getMillisLeft$p(this.this$0)) {
                        ScanSurfaceView.access$setMillisLeft$p(this.this$0, millisUntilFinished);
                    }
                }

                public void onFinish() {
                    ScanSurfaceView.access$setAutoCaptureScheduled$p(this.this$0, false);
                    ScanSurfaceView.access$autoCapture(this.this$0);
                }
                {
                    this.this$0 = this$0;
                    super($super_call_param$1, $super_call_param$2);
                }
            };
            if (countDownTimer == null) break block0;
            (countDownTimer).start();
        }
    }

    private final void autoCapture() {
        if (this.isCapturing) {
            return;
        }
        this.cancelAutoCapture();
        this.takePicture();
    }

    public final void takePicture() {
        Log.d((String)TAG, (String)("ZDCtakePicture Starts " + System.currentTimeMillis()));
        ScanSurfaceListener scanSurfaceListener = this.listener;
        if (scanSurfaceListener == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"listener");
        }
        scanSurfaceListener.scanSurfaceShowProgress();
        this.isCapturing = true;
        ImageCapture imageCapture = this.imageCapture;
        if (imageCapture == null) {
            return;
        }
        ImageCapture imageCapture2 = imageCapture;
        File file = this.originalImageFile;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"originalImageFile");
        }
        ImageCapture.OutputFileOptions outputFileOptions = new ImageCapture.OutputFileOptions.Builder(file).build();
        Intrinsics.checkNotNullExpressionValue((Object)outputFileOptions, (String)"ImageCapture.OutputFileO\u2026riginalImageFile).build()");
        ImageCapture.OutputFileOptions outputOptions = outputFileOptions;
        imageCapture2.takePicture(outputOptions, ContextCompat.getMainExecutor((Context)this.getContext()), new ImageCapture.OnImageSavedCallback(this){
            final /* synthetic */ ScanSurfaceView this$0;

            public void onError(@NotNull ImageCaptureException exc) {
                Intrinsics.checkNotNullParameter((Object)exc, (String)"exc");
                this.this$0.getListener().scanSurfaceHideProgress();
                Log.e((String)ScanSurfaceView.access$getTAG$cp(), (String)(DocumentScannerErrorModel.ErrorMessage.PHOTO_CAPTURE_FAILED.getError() + ": " + exc.getMessage()), (Throwable)((Throwable)exc));
                this.this$0.getListener().onError(new DocumentScannerErrorModel(DocumentScannerErrorModel.ErrorMessage.PHOTO_CAPTURE_FAILED, (Throwable)exc));
            }

            public void onImageSaved(@NotNull ImageCapture.OutputFileResults output) {
                Intrinsics.checkNotNullParameter((Object)output, (String)"output");
                this.this$0.getListener().scanSurfaceHideProgress();
                this.this$0.unbindCamera();
                ScanSurfaceView.access$clearAndInvalidateCanvas(this.this$0);
                this.this$0.getListener().scanSurfacePictureTaken();
                this.this$0.postDelayed(new Runnable(this){
                    final /* synthetic */ takePicture.1 this$0;

                    public final void run() {
                        ScanSurfaceView.access$setCapturing$p(this.this$0.this$0, false);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                }, 1500L);
                Log.d((String)ScanSurfaceView.access$getTAG$cp(), (String)("ZDCtakePicture ends " + System.currentTimeMillis()));
            }
            {
                this.this$0 = this$0;
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void checkIfFlashIsPresent() {
        Camera camera = this.camera;
        if (camera != null && (camera = camera.getCameraInfo()) != null) {
            if (camera.hasFlashUnit()) {
                ScanSurfaceListener scanSurfaceListener = this.listener;
                if (scanSurfaceListener == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"listener");
                }
                scanSurfaceListener.showFlash();
                return;
            }
        }
        ScanSurfaceListener scanSurfaceListener = this.listener;
        if (scanSurfaceListener == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"listener");
        }
        scanSurfaceListener.hideFlash();
    }

    private final void cancelAutoCapture() {
        block1: {
            if (!this.isAutoCaptureScheduled) break block1;
            this.isAutoCaptureScheduled = false;
            CountDownTimer countDownTimer = this.autoCaptureTimer;
            if (countDownTimer != null) {
                countDownTimer.cancel();
            }
        }
    }

    public final void switchFlashState() {
        int n;
        boolean bl = this.isFlashEnabled = !this.isFlashEnabled;
        if (this.isFlashEnabled) {
            ScanSurfaceListener scanSurfaceListener = this.listener;
            if (scanSurfaceListener == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"listener");
            }
            scanSurfaceListener.showFlashModeOn();
            n = 1;
        } else {
            ScanSurfaceListener scanSurfaceListener = this.listener;
            if (scanSurfaceListener == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"listener");
            }
            scanSurfaceListener.showFlashModeOff();
            n = 2;
        }
        this.flashMode = n;
        this.setImageCapture();
        ProcessCameraProvider processCameraProvider = this.cameraProvider;
        Intrinsics.checkNotNull((Object)processCameraProvider);
        LifecycleOwner lifecycleOwner = this.lifecycleOwner;
        if (lifecycleOwner == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"lifecycleOwner");
        }
        this.camera = processCameraProvider.bindToLifecycle(lifecycleOwner, CameraSelector.DEFAULT_BACK_CAMERA, new UseCase[]{(UseCase)this.imageCapture});
    }

    public ScanSurfaceView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.nativeClass = new OpenCvNativeBridge();
        this.isAutoCaptureOn = true;
        this.flashMode = 2;
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.scan_surface_view, (ViewGroup)this, true);
    }

    public ScanSurfaceView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs);
        this.nativeClass = new OpenCvNativeBridge();
        this.isAutoCaptureOn = true;
        this.flashMode = 2;
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.scan_surface_view, (ViewGroup)this, true);
    }

    public ScanSurfaceView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyle) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyle);
        this.nativeClass = new OpenCvNativeBridge();
        this.isAutoCaptureOn = true;
        this.flashMode = 2;
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.scan_surface_view, (ViewGroup)this, true);
    }

    static {
        Companion = new Companion(null);
        TAG = Reflection.getOrCreateKotlinClass(ScanSurfaceView.class).getSimpleName();
    }

    public static final /* synthetic */ Size access$getPreviewSize$p(ScanSurfaceView $this) {
        Size size = $this.previewSize;
        if (size == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"previewSize");
        }
        return size;
    }

    public static final /* synthetic */ void access$setPreviewSize$p(ScanSurfaceView $this, Size size) {
        $this.previewSize = size;
    }

    public static final /* synthetic */ void access$openCamera(ScanSurfaceView $this) {
        $this.openCamera();
    }

    public static final /* synthetic */ ProcessCameraProvider access$getCameraProvider$p(ScanSurfaceView $this) {
        return $this.cameraProvider;
    }

    public static final /* synthetic */ void access$setCameraProvider$p(ScanSurfaceView $this, ProcessCameraProvider processCameraProvider) {
        $this.cameraProvider = processCameraProvider;
    }

    public static final /* synthetic */ void access$bindCamera(ScanSurfaceView $this) {
        $this.bindCamera();
    }

    public static final /* synthetic */ void access$checkIfFlashIsPresent(ScanSurfaceView $this) {
        $this.checkIfFlashIsPresent();
    }

    public static final /* synthetic */ String access$getTAG$cp() {
        return TAG;
    }

    public static final /* synthetic */ OpenCvNativeBridge access$getNativeClass$p(ScanSurfaceView $this) {
        return $this.nativeClass;
    }

    public static final /* synthetic */ void access$drawLargestRect(ScanSurfaceView $this, MatOfPoint2f approx, Point[] points, org.opencv.core.Size stdSize) {
        $this.drawLargestRect(approx, points, stdSize);
    }

    public static final /* synthetic */ void access$clearAndInvalidateCanvas(ScanSurfaceView $this) {
        $this.clearAndInvalidateCanvas();
    }

    public static final /* synthetic */ long access$getMillisLeft$p(ScanSurfaceView $this) {
        return $this.millisLeft;
    }

    public static final /* synthetic */ void access$setMillisLeft$p(ScanSurfaceView $this, long l) {
        $this.millisLeft = l;
    }

    public static final /* synthetic */ boolean access$isAutoCaptureScheduled$p(ScanSurfaceView $this) {
        return $this.isAutoCaptureScheduled;
    }

    public static final /* synthetic */ void access$setAutoCaptureScheduled$p(ScanSurfaceView $this, boolean bl) {
        $this.isAutoCaptureScheduled = bl;
    }

    public static final /* synthetic */ void access$autoCapture(ScanSurfaceView $this) {
        $this.autoCapture();
    }

    public static final /* synthetic */ boolean access$isCapturing$p(ScanSurfaceView $this) {
        return $this.isCapturing;
    }

    public static final /* synthetic */ void access$setCapturing$p(ScanSurfaceView $this, boolean bl) {
        $this.isCapturing = bl;
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/zynksoftware/documentscanner/ui/components/scansurface/ScanSurfaceView$Companion;", "", "()V", "DEFAULT_TIME_POST_PICTURE", "", "IMAGE_ANALYSIS_SCALE_WIDTH", "", "TAG", "", "TIME_POST_PICTURE", "DocumentScanner_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

