/*
 * Decompiled with CFR 0.152.
 */
package com.zynksoftware.documentscanner.ui;

import android.content.Context;
import android.graphics.Bitmap;
import com.zynksoftware.documentscanner.manager.SessionManager;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\tB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a8\u0006\n"}, d2={"Lcom/zynksoftware/documentscanner/ui/DocumentScanner;", "", "()V", "init", "", "context", "Landroid/content/Context;", "configuration", "Lcom/zynksoftware/documentscanner/ui/DocumentScanner$Configuration;", "Configuration", "DocumentScanner_release"})
public final class DocumentScanner {
    public static final DocumentScanner INSTANCE;

    public final void init(@NotNull Context context, @NotNull Configuration configuration) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        System.loadLibrary("opencv_java4");
        SessionManager sessionManager = new SessionManager(context);
        int n = configuration.getImageQuality();
        if (1 <= n && 100 >= n) {
            sessionManager.setImageQuality(configuration.getImageQuality());
        }
        sessionManager.setImageSize(configuration.getImageSize());
        sessionManager.setImageType(configuration.getImageType());
    }

    public static /* synthetic */ void init$default(DocumentScanner documentScanner, Context context, Configuration configuration, int n, Object object) {
        if ((n & 2) != 0) {
            configuration = new Configuration(0, 0L, null, 7, null);
        }
        documentScanner.init(context, configuration);
    }

    private DocumentScanner() {
    }

    static {
        DocumentScanner documentScanner;
        INSTANCE = documentScanner = new DocumentScanner();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B#\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001f"}, d2={"Lcom/zynksoftware/documentscanner/ui/DocumentScanner$Configuration;", "", "imageQuality", "", "imageSize", "", "imageType", "Landroid/graphics/Bitmap$CompressFormat;", "(IJLandroid/graphics/Bitmap$CompressFormat;)V", "getImageQuality", "()I", "setImageQuality", "(I)V", "getImageSize", "()J", "setImageSize", "(J)V", "getImageType", "()Landroid/graphics/Bitmap$CompressFormat;", "setImageType", "(Landroid/graphics/Bitmap$CompressFormat;)V", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "DocumentScanner_release"})
    public static final class Configuration {
        private int imageQuality;
        private long imageSize;
        @NotNull
        private Bitmap.CompressFormat imageType;

        public final int getImageQuality() {
            return this.imageQuality;
        }

        public final void setImageQuality(int n) {
            this.imageQuality = n;
        }

        public final long getImageSize() {
            return this.imageSize;
        }

        public final void setImageSize(long l) {
            this.imageSize = l;
        }

        @NotNull
        public final Bitmap.CompressFormat getImageType() {
            return this.imageType;
        }

        public final void setImageType(@NotNull Bitmap.CompressFormat compressFormat) {
            Intrinsics.checkNotNullParameter((Object)compressFormat, (String)"<set-?>");
            this.imageType = compressFormat;
        }

        public Configuration(int imageQuality, long imageSize, @NotNull Bitmap.CompressFormat imageType) {
            Intrinsics.checkNotNullParameter((Object)imageType, (String)"imageType");
            this.imageQuality = imageQuality;
            this.imageSize = imageSize;
            this.imageType = imageType;
        }

        public /* synthetic */ Configuration(int n, long l, Bitmap.CompressFormat compressFormat, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                n = 100;
            }
            if ((n2 & 2) != 0) {
                l = -1L;
            }
            if ((n2 & 4) != 0) {
                compressFormat = Bitmap.CompressFormat.JPEG;
            }
            this(n, l, compressFormat);
        }

        public Configuration() {
            this(0, 0L, null, 7, null);
        }

        public final int component1() {
            return this.imageQuality;
        }

        public final long component2() {
            return this.imageSize;
        }

        @NotNull
        public final Bitmap.CompressFormat component3() {
            return this.imageType;
        }

        @NotNull
        public final Configuration copy(int imageQuality, long imageSize, @NotNull Bitmap.CompressFormat imageType) {
            Intrinsics.checkNotNullParameter((Object)imageType, (String)"imageType");
            return new Configuration(imageQuality, imageSize, imageType);
        }

        public static /* synthetic */ Configuration copy$default(Configuration configuration, int n, long l, Bitmap.CompressFormat compressFormat, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = configuration.imageQuality;
            }
            if ((n2 & 2) != 0) {
                l = configuration.imageSize;
            }
            if ((n2 & 4) != 0) {
                compressFormat = configuration.imageType;
            }
            return configuration.copy(n, l, compressFormat);
        }

        @NotNull
        public String toString() {
            return "Configuration(imageQuality=" + this.imageQuality + ", imageSize=" + this.imageSize + ", imageType=" + this.imageType + ")";
        }

        public int hashCode() {
            Bitmap.CompressFormat compressFormat = this.imageType;
            return (Integer.hashCode(this.imageQuality) * 31 + Long.hashCode(this.imageSize)) * 31 + (compressFormat != null ? compressFormat.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Configuration)) break block3;
                    Configuration configuration = (Configuration)object;
                    if (this.imageQuality != configuration.imageQuality || this.imageSize != configuration.imageSize || !Intrinsics.areEqual((Object)this.imageType, (Object)configuration.imageType)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

