/*
 * Decompiled with CFR 0.152.
 */
package com.zynksoftware.documentscanner.common.utils;

import com.zynksoftware.documentscanner.common.utils.MathUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.opencv.core.Mat;
import org.opencv.core.MatOfPoint2f;
import org.opencv.core.Point;
import org.opencv.core.Size;
import org.opencv.imgproc.Imgproc;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0006H\u0002J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0006H\u0002J\u0016\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u0006\u00a8\u0006\u0011"}, d2={"Lcom/zynksoftware/documentscanner/common/utils/PerspectiveTransformation;", "", "()V", "getMassCenter", "Lorg/opencv/core/Point;", "points", "Lorg/opencv/core/MatOfPoint2f;", "getOutline", "image", "Lorg/opencv/core/Mat;", "getRectangleSize", "Lorg/opencv/core/Size;", "rectangle", "sortCorners", "corners", "transform", "src", "DocumentScanner_release"})
public final class PerspectiveTransformation {
    public static final PerspectiveTransformation INSTANCE;

    @NotNull
    public final Mat transform(@NotNull Mat src, @NotNull MatOfPoint2f corners) {
        Mat result;
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter((Object)corners, (String)"corners");
        MatOfPoint2f sortedCorners = this.sortCorners(corners);
        Size size = this.getRectangleSize(sortedCorners);
        Mat mat = result = Mat.zeros((Size)size, (int)src.type());
        Intrinsics.checkNotNullExpressionValue((Object)mat, (String)"result");
        MatOfPoint2f imageOutline = this.getOutline(mat);
        Mat transformation = Imgproc.getPerspectiveTransform((Mat)((Mat)sortedCorners), (Mat)((Mat)imageOutline));
        Imgproc.warpPerspective((Mat)src, (Mat)result, (Mat)transformation, (Size)size);
        return result;
    }

    private final Size getRectangleSize(MatOfPoint2f rectangle) {
        Point[] corners = rectangle.toArray();
        Point point = corners[0];
        Intrinsics.checkNotNullExpressionValue((Object)point, (String)"corners[0]");
        Point point2 = corners[1];
        Intrinsics.checkNotNullExpressionValue((Object)point2, (String)"corners[1]");
        double top = MathUtils.INSTANCE.getDistance(point, point2);
        Point point3 = corners[1];
        Intrinsics.checkNotNullExpressionValue((Object)point3, (String)"corners[1]");
        Point point4 = corners[2];
        Intrinsics.checkNotNullExpressionValue((Object)point4, (String)"corners[2]");
        double right = MathUtils.INSTANCE.getDistance(point3, point4);
        Point point5 = corners[2];
        Intrinsics.checkNotNullExpressionValue((Object)point5, (String)"corners[2]");
        Point point6 = corners[3];
        Intrinsics.checkNotNullExpressionValue((Object)point6, (String)"corners[3]");
        double bottom = MathUtils.INSTANCE.getDistance(point5, point6);
        Point point7 = corners[3];
        Intrinsics.checkNotNullExpressionValue((Object)point7, (String)"corners[3]");
        Point point8 = corners[0];
        Intrinsics.checkNotNullExpressionValue((Object)point8, (String)"corners[0]");
        double left = MathUtils.INSTANCE.getDistance(point7, point8);
        double averageWidth = (top + bottom) / (double)2.0f;
        double averageHeight = (right + left) / (double)2.0f;
        return new Size(new Point(averageWidth, averageHeight));
    }

    private final MatOfPoint2f getOutline(Mat image) {
        Point topLeft = new Point(0.0, 0.0);
        Point topRight = new Point((double)image.cols(), 0.0);
        Point bottomRight = new Point((double)image.cols(), (double)image.rows());
        Point bottomLeft = new Point(0.0, (double)image.rows());
        Point[] points = new Point[]{topLeft, topRight, bottomRight, bottomLeft};
        MatOfPoint2f result = new MatOfPoint2f();
        result.fromArray(Arrays.copyOf(points, points.length));
        return result;
    }

    private final MatOfPoint2f sortCorners(MatOfPoint2f corners) {
        Point center = this.getMassCenter(corners);
        List points = corners.toList();
        List topPoints = new ArrayList();
        List bottomPoints = new ArrayList();
        for (Point point : points) {
            if (point.y < center.y) {
                Point point2 = point;
                Intrinsics.checkNotNullExpressionValue((Object)point2, (String)"point");
                topPoints.add(point2);
                continue;
            }
            Point point3 = point;
            Intrinsics.checkNotNullExpressionValue((Object)point3, (String)"point");
            bottomPoints.add(point3);
        }
        Point topLeft = ((Point)topPoints.get((int)0)).x > ((Point)topPoints.get((int)1)).x ? (Point)topPoints.get(1) : (Point)topPoints.get(0);
        Point topRight = ((Point)topPoints.get((int)0)).x > ((Point)topPoints.get((int)1)).x ? (Point)topPoints.get(0) : (Point)topPoints.get(1);
        Point bottomLeft = ((Point)bottomPoints.get((int)0)).x > ((Point)bottomPoints.get((int)1)).x ? (Point)bottomPoints.get(1) : (Point)bottomPoints.get(0);
        Point bottomRight = ((Point)bottomPoints.get((int)0)).x > ((Point)bottomPoints.get((int)1)).x ? (Point)bottomPoints.get(0) : (Point)bottomPoints.get(1);
        MatOfPoint2f result = new MatOfPoint2f();
        Point[] sortedPoints = new Point[]{topLeft, topRight, bottomRight, bottomLeft};
        result.fromArray(Arrays.copyOf(sortedPoints, sortedPoints.length));
        return result;
    }

    private final Point getMassCenter(MatOfPoint2f points) {
        double xSum = 0.0;
        double ySum = 0.0;
        List pointList = points.toList();
        int len = pointList.size();
        for (Point point : pointList) {
            xSum += point.x;
            ySum += point.y;
        }
        return new Point(xSum / (double)len, ySum / (double)len);
    }

    private PerspectiveTransformation() {
    }

    static {
        PerspectiveTransformation perspectiveTransformation;
        INSTANCE = perspectiveTransformation = new PerspectiveTransformation();
    }
}

