/*
 * Decompiled with CFR 0.152.
 */
package org.muyie.framework.security.uaa;

import org.muyie.framework.config.MuyieProperties;
import org.muyie.framework.security.uaa.LoadBalancedResourceDetails;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.client.loadbalancer.LoadBalancerClient;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.oauth2.client.token.grant.client.ClientCredentialsResourceDetails;

@Configuration
@ConditionalOnClass(value={ClientCredentialsResourceDetails.class, LoadBalancerClient.class})
@ConditionalOnProperty(value={"muyie.security.client-authorization.client-id"})
public class UaaAutoConfiguration {
    private MuyieProperties muyieProperties;

    public UaaAutoConfiguration(MuyieProperties muyieProperties) {
        this.muyieProperties = muyieProperties;
    }

    @Bean
    public LoadBalancedResourceDetails loadBalancedResourceDetails(LoadBalancerClient loadBalancerClient) {
        LoadBalancedResourceDetails loadBalancedResourceDetails = new LoadBalancedResourceDetails(loadBalancerClient);
        MuyieProperties.Security.ClientAuthorization clientAuthorization = this.muyieProperties.getSecurity().getClientAuthorization();
        loadBalancedResourceDetails.setAccessTokenUri(clientAuthorization.getAccessTokenUri());
        loadBalancedResourceDetails.setTokenServiceId(clientAuthorization.getTokenServiceId());
        loadBalancedResourceDetails.setClientId(clientAuthorization.getClientId());
        loadBalancedResourceDetails.setClientSecret(clientAuthorization.getClientSecret());
        return loadBalancedResourceDetails;
    }
}

