/*
 * Decompiled with CFR 0.152.
 */
package org.muyie.framework.config.metric;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Slf4jReporter;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.dropwizard.DropwizardConfig;
import io.micrometer.core.instrument.dropwizard.DropwizardMeterRegistry;
import io.micrometer.core.instrument.util.HierarchicalNameMapper;
import java.util.concurrent.TimeUnit;
import org.muyie.framework.config.MuyieProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(value={"muyie.metrics.logs.enabled"})
public class MuyieLoggingMetricsExportConfiguration {
    private final Logger log = LoggerFactory.getLogger(MuyieLoggingMetricsExportConfiguration.class);
    private final MuyieProperties muyieProperties;

    public MuyieLoggingMetricsExportConfiguration(MuyieProperties muyieProperties) {
        this.muyieProperties = muyieProperties;
    }

    @Bean
    public MetricRegistry dropwizardRegistry() {
        return new MetricRegistry();
    }

    @Bean
    public Slf4jReporter consoleReporter(MetricRegistry dropwizardRegistry) {
        this.log.info("Initializing Metrics Log reporting");
        Marker metricsMarker = MarkerFactory.getMarker((String)"metrics");
        Slf4jReporter reporter = Slf4jReporter.forRegistry((MetricRegistry)dropwizardRegistry).outputTo(LoggerFactory.getLogger((String)"metrics")).markWith(metricsMarker).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).build();
        reporter.start(this.muyieProperties.getMetrics().getLogs().getReportFrequency(), TimeUnit.SECONDS);
        return reporter;
    }

    @Bean
    public MeterRegistry consoleLoggingRegistry(MetricRegistry dropwizardRegistry) {
        DropwizardConfig dropwizardConfig = new DropwizardConfig(){

            public String prefix() {
                return "console";
            }

            public String get(String key) {
                return null;
            }
        };
        return new DropwizardMeterRegistry(dropwizardConfig, dropwizardRegistry, HierarchicalNameMapper.DEFAULT, Clock.SYSTEM){

            protected Double nullGaugeValue() {
                return null;
            }
        };
    }
}

