/*
 * Decompiled with CFR 0.152.
 */
package org.muyie.framework.config.apidoc.customizer;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.muyie.framework.config.MuyieProperties;
import org.muyie.framework.config.apidoc.customizer.SwaggerCustomizer;
import org.springframework.core.annotation.Order;
import org.springframework.http.ResponseEntity;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Contact;
import springfox.documentation.spring.web.plugins.Docket;

@Order(value=0)
public class GenericSwaggerCustomizer
implements SwaggerCustomizer {
    private final MuyieProperties.Swagger properties;

    public GenericSwaggerCustomizer(MuyieProperties.Swagger properties) {
        this.properties = properties;
    }

    @Override
    public void customize(Docket docket) {
        Contact contact = new Contact(this.properties.getContactName(), this.properties.getContactUrl(), this.properties.getContactEmail());
        ApiInfo apiInfo = new ApiInfo(this.properties.getTitle(), this.properties.getDescription(), this.properties.getVersion(), this.properties.getTermsOfServiceUrl(), contact, this.properties.getLicense(), this.properties.getLicenseUrl(), new ArrayList());
        docket.host(this.properties.getHost()).protocols(new HashSet<String>(Arrays.asList(this.properties.getProtocols()))).apiInfo(apiInfo).useDefaultResponseMessages(this.properties.isUseDefaultResponseMessages()).forCodeGeneration(true).directModelSubstitute(ByteBuffer.class, String.class).genericModelSubstitutes(new Class[]{ResponseEntity.class}).select().paths(PathSelectors.regex((String)this.properties.getDefaultIncludePattern())).build();
    }
}

