/*
 * Decompiled with CFR 0.152.
 */
package com.zhpan.indicator.option;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.util.AttributeSet;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.zhpan.indicator.R;
import com.zhpan.indicator.option.IndicatorOptions;
import com.zhpan.indicator.utils.IndicatorUtils;

public class AttrsController {
    public static void initAttrs(@NonNull Context context, @Nullable AttributeSet attrs, IndicatorOptions indicatorOptions) {
        if (attrs != null) {
            TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.IndicatorView);
            int indicatorSlideMode = typedArray.getInt(R.styleable.IndicatorView_vpi_slide_mode, 0);
            int indicatorStyle = typedArray.getInt(R.styleable.IndicatorView_vpi_style, 0);
            int checkedColor = typedArray.getColor(R.styleable.IndicatorView_vpi_slider_checked_color, Color.parseColor((String)"#6C6D72"));
            int normalColor = typedArray.getColor(R.styleable.IndicatorView_vpi_slider_normal_color, Color.parseColor((String)"#8C18171C"));
            int orientation = typedArray.getInt(R.styleable.IndicatorView_vpi_orientation, 0);
            float radius = typedArray.getDimension(R.styleable.IndicatorView_vpi_slider_radius, (float)IndicatorUtils.dp2px(8.0f));
            indicatorOptions.setCheckedColor(checkedColor);
            indicatorOptions.setNormalSliderColor(normalColor);
            indicatorOptions.setOrientation(orientation);
            indicatorOptions.setIndicatorStyle(indicatorStyle);
            indicatorOptions.setSlideMode(indicatorSlideMode);
            indicatorOptions.setSliderWidth(radius * 2.0f, radius * 2.0f);
            typedArray.recycle();
        }
    }
}

