/*
 * Decompiled with CFR 0.152.
 */
package com.zhpan.indicator.utils;

import android.content.res.Resources;
import com.zhpan.indicator.option.IndicatorOptions;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u001e\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0004J\u000e\u0010\f\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0006\u00a8\u0006\r"}, d2={"Lcom/zhpan/indicator/utils/IndicatorUtils;", "", "()V", "dp2px", "", "dpValue", "", "getCoordinateX", "indicatorOptions", "Lcom/zhpan/indicator/option/IndicatorOptions;", "maxDiameter", "index", "getCoordinateY", "indicator_release"})
public final class IndicatorUtils {
    public static final IndicatorUtils INSTANCE;

    @JvmStatic
    public static final int dp2px(float dpValue) {
        Resources resources = Resources.getSystem();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"Resources.getSystem()");
        return (int)(0.5f + dpValue * resources.getDisplayMetrics().density);
    }

    public final float getCoordinateX(@NotNull IndicatorOptions indicatorOptions, float maxDiameter, int index) {
        Intrinsics.checkParameterIsNotNull((Object)indicatorOptions, (String)"indicatorOptions");
        float normalIndicatorWidth = indicatorOptions.getNormalSliderWidth();
        return maxDiameter / (float)2 + (normalIndicatorWidth + indicatorOptions.getSliderGap()) * (float)index;
    }

    public final float getCoordinateY(float maxDiameter) {
        return maxDiameter / (float)2;
    }

    private IndicatorUtils() {
    }

    static {
        IndicatorUtils indicatorUtils;
        INSTANCE = indicatorUtils = new IndicatorUtils();
    }
}

