/*
 * Decompiled with CFR 0.152.
 */
package com.zhpan.indicator.drawer;

import android.animation.ArgbEvaluator;
import android.graphics.Canvas;
import android.graphics.RectF;
import com.zhpan.indicator.drawer.BaseDrawer;
import com.zhpan.indicator.option.IndicatorOptions;
import com.zhpan.indicator.utils.IndicatorUtils;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\b\b\u0016\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u0018\u0010\u0011\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J \u0010\u0014\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0014J\u0018\u0010\u0018\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u0013H\u0002J\u0010\u0010\u001a\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u001b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u001c\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u001d\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u001a\u0010\u0005\u001a\u00020\u0006X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u001e"}, d2={"Lcom/zhpan/indicator/drawer/RectDrawer;", "Lcom/zhpan/indicator/drawer/BaseDrawer;", "indicatorOptions", "Lcom/zhpan/indicator/option/IndicatorOptions;", "(Lcom/zhpan/indicator/option/IndicatorOptions;)V", "mRectF", "Landroid/graphics/RectF;", "getMRectF$indicator_release", "()Landroid/graphics/RectF;", "setMRectF$indicator_release", "(Landroid/graphics/RectF;)V", "drawCheckedSlider", "", "canvas", "Landroid/graphics/Canvas;", "drawColorSlider", "drawDash", "drawInequalitySlider", "pageSize", "", "drawRoundRect", "rx", "", "ry", "drawScaleSlider", "i", "drawSmoothSlider", "drawUncheckedSlider", "drawWormSlider", "onDraw", "indicator_release"})
public class RectDrawer
extends BaseDrawer {
    @NotNull
    private RectF mRectF;

    @NotNull
    public final RectF getMRectF$indicator_release() {
        return this.mRectF;
    }

    public final void setMRectF$indicator_release(@NotNull RectF rectF) {
        Intrinsics.checkParameterIsNotNull((Object)rectF, (String)"<set-?>");
        this.mRectF = rectF;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        int pageSize = this.getMIndicatorOptions$indicator_release().getPageSize();
        if (pageSize > 1) {
            if (this.isWidthEquals() && this.getMIndicatorOptions$indicator_release().getSlideMode() != 0) {
                this.drawUncheckedSlider(canvas, pageSize);
                this.drawCheckedSlider(canvas);
            } else if (this.getMIndicatorOptions$indicator_release().getSlideMode() == 4) {
                int n = 0;
                int n2 = pageSize;
                while (n < n2) {
                    void i;
                    this.drawScaleSlider(canvas, (int)i);
                    ++i;
                }
            } else {
                this.drawInequalitySlider(canvas, pageSize);
            }
        }
    }

    private final void drawScaleSlider(Canvas canvas, int i) {
        int checkedColor = this.getMIndicatorOptions$indicator_release().getCheckedSliderColor();
        float indicatorGap = this.getMIndicatorOptions$indicator_release().getSliderGap();
        float sliderHeight = this.getMIndicatorOptions$indicator_release().getSliderHeight();
        int currentPosition = this.getMIndicatorOptions$indicator_release().getCurrentPosition();
        float normalWidth = this.getMIndicatorOptions$indicator_release().getNormalSliderWidth();
        float checkedWidth = this.getMIndicatorOptions$indicator_release().getCheckedSliderWidth();
        if (i < currentPosition) {
            this.getMPaint$indicator_release().setColor(this.getMIndicatorOptions$indicator_release().getNormalSliderColor());
            float left = currentPosition == this.getMIndicatorOptions$indicator_release().getPageSize() - 1 ? (float)i * normalWidth + (float)i * indicatorGap + (checkedWidth - normalWidth) * this.getMIndicatorOptions$indicator_release().getSlideProgress() : (float)i * normalWidth + (float)i * indicatorGap;
            this.mRectF.set(left, 0.0f, left + normalWidth, sliderHeight);
            this.drawRoundRect(canvas, sliderHeight, sliderHeight);
        } else if (i == currentPosition) {
            float right;
            float left;
            float left2;
            float right2;
            Object evaluate;
            this.getMPaint$indicator_release().setColor(checkedColor);
            float slideProgress = this.getMIndicatorOptions$indicator_release().getSlideProgress();
            if (currentPosition == this.getMIndicatorOptions$indicator_release().getPageSize() - 1) {
                ArgbEvaluator argbEvaluator = this.getArgbEvaluator$indicator_release();
                Object object = evaluate = argbEvaluator != null ? argbEvaluator.evaluate(slideProgress, (Object)checkedColor, (Object)this.getMIndicatorOptions$indicator_release().getNormalSliderColor()) : null;
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Int");
                }
                this.getMPaint$indicator_release().setColor(((Integer)object).intValue());
                right2 = (float)(this.getMIndicatorOptions$indicator_release().getPageSize() - 1) * (normalWidth + this.getMIndicatorOptions$indicator_release().getSliderGap()) + checkedWidth;
                left2 = right2 - checkedWidth + (checkedWidth - normalWidth) * slideProgress;
                this.mRectF.set(left2, 0.0f, right2, sliderHeight);
                this.drawRoundRect(canvas, sliderHeight, sliderHeight);
            } else if (slideProgress < 1.0f) {
                ArgbEvaluator argbEvaluator = this.getArgbEvaluator$indicator_release();
                Object object = evaluate = argbEvaluator != null ? argbEvaluator.evaluate(slideProgress, (Object)checkedColor, (Object)this.getMIndicatorOptions$indicator_release().getNormalSliderColor()) : null;
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Int");
                }
                this.getMPaint$indicator_release().setColor(((Integer)object).intValue());
                left = (float)i * normalWidth + (float)i * indicatorGap;
                right = left + normalWidth + (checkedWidth - normalWidth) * (1.0f - slideProgress);
                this.mRectF.set(left, 0.0f, right, sliderHeight);
                this.drawRoundRect(canvas, sliderHeight, sliderHeight);
            }
            if (currentPosition == this.getMIndicatorOptions$indicator_release().getPageSize() - 1) {
                if (slideProgress > 0.0f) {
                    ArgbEvaluator argbEvaluator = this.getArgbEvaluator$indicator_release();
                    Object object = evaluate = argbEvaluator != null ? argbEvaluator.evaluate(1.0f - slideProgress, (Object)checkedColor, (Object)this.getMIndicatorOptions$indicator_release().getNormalSliderColor()) : null;
                    if (object == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.Int");
                    }
                    this.getMPaint$indicator_release().setColor(((Integer)object).intValue());
                    left = 0.0f;
                    right = left + normalWidth + (checkedWidth - normalWidth) * slideProgress;
                    this.mRectF.set(left, 0.0f, right, sliderHeight);
                    this.drawRoundRect(canvas, sliderHeight, sliderHeight);
                }
            } else if (slideProgress > 0.0f) {
                ArgbEvaluator argbEvaluator = this.getArgbEvaluator$indicator_release();
                Object object = evaluate = argbEvaluator != null ? argbEvaluator.evaluate(1.0f - slideProgress, (Object)checkedColor, (Object)this.getMIndicatorOptions$indicator_release().getNormalSliderColor()) : null;
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Int");
                }
                this.getMPaint$indicator_release().setColor(((Integer)object).intValue());
                right2 = (float)i * normalWidth + (float)i * indicatorGap + normalWidth + (indicatorGap + checkedWidth);
                left2 = right2 - normalWidth - (checkedWidth - normalWidth) * slideProgress;
                this.mRectF.set(left2, 0.0f, right2, sliderHeight);
                this.drawRoundRect(canvas, sliderHeight, sliderHeight);
            }
        } else if (currentPosition + 1 != i || this.getMIndicatorOptions$indicator_release().getSlideProgress() == 0.0f) {
            this.getMPaint$indicator_release().setColor(this.getMIndicatorOptions$indicator_release().getNormalSliderColor());
            float left = (float)i * this.getMinWidth$indicator_release() + (float)i * indicatorGap + (checkedWidth - this.getMinWidth$indicator_release());
            this.mRectF.set(left, 0.0f, left + this.getMinWidth$indicator_release(), sliderHeight);
            this.drawRoundRect(canvas, sliderHeight, sliderHeight);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void drawUncheckedSlider(Canvas canvas, int pageSize) {
        int n = 0;
        int n2 = pageSize;
        while (n < n2) {
            void i;
            this.getMPaint$indicator_release().setColor(this.getMIndicatorOptions$indicator_release().getNormalSliderColor());
            float left = (float)i * this.getMaxWidth$indicator_release() + (float)i * this.getMIndicatorOptions$indicator_release().getSliderGap() + (this.getMaxWidth$indicator_release() - this.getMinWidth$indicator_release());
            this.mRectF.set(left, 0.0f, left + this.getMinWidth$indicator_release(), this.getMIndicatorOptions$indicator_release().getSliderHeight());
            this.drawRoundRect(canvas, this.getMIndicatorOptions$indicator_release().getSliderHeight(), this.getMIndicatorOptions$indicator_release().getSliderHeight());
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void drawInequalitySlider(Canvas canvas, int pageSize) {
        float left = 0.0f;
        int n = 0;
        int n2 = pageSize;
        while (n < n2) {
            void i;
            float sliderWidth = i == this.getMIndicatorOptions$indicator_release().getCurrentPosition() ? this.getMaxWidth$indicator_release() : this.getMinWidth$indicator_release();
            this.getMPaint$indicator_release().setColor(i == this.getMIndicatorOptions$indicator_release().getCurrentPosition() ? this.getMIndicatorOptions$indicator_release().getCheckedSliderColor() : this.getMIndicatorOptions$indicator_release().getNormalSliderColor());
            this.mRectF.set(left, 0.0f, left + sliderWidth, this.getMIndicatorOptions$indicator_release().getSliderHeight());
            this.drawRoundRect(canvas, this.getMIndicatorOptions$indicator_release().getSliderHeight(), this.getMIndicatorOptions$indicator_release().getSliderHeight());
            left += sliderWidth + this.getMIndicatorOptions$indicator_release().getSliderGap();
            ++i;
        }
    }

    private final void drawCheckedSlider(Canvas canvas) {
        this.getMPaint$indicator_release().setColor(this.getMIndicatorOptions$indicator_release().getCheckedSliderColor());
        switch (this.getMIndicatorOptions$indicator_release().getSlideMode()) {
            case 2: {
                this.drawSmoothSlider(canvas);
                break;
            }
            case 3: {
                this.drawWormSlider(canvas);
                break;
            }
            case 5: {
                this.drawColorSlider(canvas);
            }
        }
    }

    private final void drawColorSlider(Canvas canvas) {
        Object evaluate;
        int currentPosition = this.getMIndicatorOptions$indicator_release().getCurrentPosition();
        float slideProgress = this.getMIndicatorOptions$indicator_release().getSlideProgress();
        float left = (float)currentPosition * this.getMinWidth$indicator_release() + (float)currentPosition * this.getMIndicatorOptions$indicator_release().getSliderGap();
        if ((double)slideProgress < 0.99) {
            Object evaluate2;
            ArgbEvaluator argbEvaluator = this.getArgbEvaluator$indicator_release();
            Object object = evaluate2 = argbEvaluator != null ? argbEvaluator.evaluate(slideProgress, (Object)this.getMIndicatorOptions$indicator_release().getCheckedSliderColor(), (Object)this.getMIndicatorOptions$indicator_release().getNormalSliderColor()) : null;
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Int");
            }
            this.getMPaint$indicator_release().setColor(((Integer)object).intValue());
            this.mRectF.set(left, 0.0f, left + this.getMinWidth$indicator_release(), this.getMIndicatorOptions$indicator_release().getSliderHeight());
            this.drawRoundRect(canvas, this.getMIndicatorOptions$indicator_release().getSliderHeight(), this.getMIndicatorOptions$indicator_release().getSliderHeight());
        }
        float nextSliderLeft = left + this.getMIndicatorOptions$indicator_release().getSliderGap() + this.getMIndicatorOptions$indicator_release().getNormalSliderWidth();
        if (currentPosition == this.getMIndicatorOptions$indicator_release().getPageSize() - 1) {
            nextSliderLeft = 0.0f;
        }
        ArgbEvaluator argbEvaluator = this.getArgbEvaluator$indicator_release();
        Object object = evaluate = argbEvaluator != null ? argbEvaluator.evaluate(1.0f - slideProgress, (Object)this.getMIndicatorOptions$indicator_release().getCheckedSliderColor(), (Object)this.getMIndicatorOptions$indicator_release().getNormalSliderColor()) : null;
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Int");
        }
        this.getMPaint$indicator_release().setColor(((Integer)object).intValue());
        this.mRectF.set(nextSliderLeft, 0.0f, nextSliderLeft + this.getMinWidth$indicator_release(), this.getMIndicatorOptions$indicator_release().getSliderHeight());
        this.drawRoundRect(canvas, this.getMIndicatorOptions$indicator_release().getSliderHeight(), this.getMIndicatorOptions$indicator_release().getSliderHeight());
    }

    private final void drawWormSlider(Canvas canvas) {
        float sliderHeight = this.getMIndicatorOptions$indicator_release().getSliderHeight();
        float slideProgress = this.getMIndicatorOptions$indicator_release().getSlideProgress();
        int currentPosition = this.getMIndicatorOptions$indicator_release().getCurrentPosition();
        float distance = this.getMIndicatorOptions$indicator_release().getSliderGap() + this.getMIndicatorOptions$indicator_release().getNormalSliderWidth();
        float startCoordinateX = IndicatorUtils.INSTANCE.getCoordinateX(this.getMIndicatorOptions$indicator_release(), this.getMaxWidth$indicator_release(), currentPosition);
        float left = startCoordinateX + Math.max(distance * (slideProgress - 0.5f) * 2.0f, 0.0f) - this.getMIndicatorOptions$indicator_release().getNormalSliderWidth() / (float)2;
        float right = startCoordinateX + Math.min(distance * slideProgress * 2.0f, distance) + this.getMIndicatorOptions$indicator_release().getNormalSliderWidth() / (float)2;
        this.mRectF.set(left, 0.0f, right, sliderHeight);
        this.drawRoundRect(canvas, sliderHeight, sliderHeight);
    }

    private final void drawSmoothSlider(Canvas canvas) {
        int currentPosition = this.getMIndicatorOptions$indicator_release().getCurrentPosition();
        float indicatorGap = this.getMIndicatorOptions$indicator_release().getSliderGap();
        float sliderHeight = this.getMIndicatorOptions$indicator_release().getSliderHeight();
        float left = (float)currentPosition * this.getMaxWidth$indicator_release() + (float)currentPosition * indicatorGap + (this.getMaxWidth$indicator_release() + indicatorGap) * this.getMIndicatorOptions$indicator_release().getSlideProgress();
        this.mRectF.set(left, 0.0f, left + this.getMaxWidth$indicator_release(), sliderHeight);
        this.drawRoundRect(canvas, sliderHeight, sliderHeight);
    }

    protected void drawRoundRect(@NotNull Canvas canvas, float rx, float ry) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        this.drawDash(canvas);
    }

    protected void drawDash(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
    }

    public RectDrawer(@NotNull IndicatorOptions indicatorOptions) {
        Intrinsics.checkParameterIsNotNull((Object)indicatorOptions, (String)"indicatorOptions");
        super(indicatorOptions);
        this.mRectF = new RectF();
    }
}

