/*
 * Decompiled with CFR 0.152.
 */
package com.zhpan.indicator;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.DrawableRes;
import androidx.core.graphics.drawable.DrawableCompat;
import com.zhpan.indicator.base.BaseIndicatorView;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0016\u0018\u00002\u00020\u0001:\u0001.B'\b\u0007\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ*\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u00072\b\u0010\u001c\u001a\u0004\u0018\u00010\fH\u0002J\u0018\u0010\u001d\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u0007H\u0002J\b\u0010\u001f\u001a\u00020\u0017H\u0002J\u0010\u0010 \u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0014J\u0018\u0010!\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020\u00072\u0006\u0010#\u001a\u00020\u0007H\u0014J\u001a\u0010$\u001a\u00020\u00002\b\b\u0001\u0010%\u001a\u00020\u00072\b\b\u0001\u0010&\u001a\u00020\u0007J\u000e\u0010'\u001a\u00020\u00002\u0006\u0010(\u001a\u00020\u0007J&\u0010)\u001a\u00020\u00002\u0006\u0010*\u001a\u00020\u00072\u0006\u0010+\u001a\u00020\u00072\u0006\u0010,\u001a\u00020\u00072\u0006\u0010-\u001a\u00020\u0007R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/zhpan/indicator/DrawableIndicator;", "Lcom/zhpan/indicator/base/BaseIndicatorView;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "checkCanResize", "", "mCheckedBitmap", "Landroid/graphics/Bitmap;", "mCheckedBitmapHeight", "mCheckedBitmapWidth", "mIndicatorPadding", "mIndicatorSize", "Lcom/zhpan/indicator/DrawableIndicator$IndicatorSize;", "mNormalBitmap", "mNormalBitmapHeight", "mNormalBitmapWidth", "normalCanResize", "drawIcon", "", "canvas", "Landroid/graphics/Canvas;", "left", "top", "icon", "getBitmapFromVectorDrawable", "drawableId", "initIconSize", "onDraw", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "setIndicatorDrawable", "normalDrawable", "checkedDrawable", "setIndicatorGap", "padding", "setIndicatorSize", "normalWidth", "normalHeight", "checkedWidth", "checkedHeight", "IndicatorSize", "indicator_release"})
public final class DrawableIndicator
extends BaseIndicatorView {
    private Bitmap mCheckedBitmap;
    private Bitmap mNormalBitmap;
    private int mIndicatorPadding;
    private int mCheckedBitmapWidth;
    private int mCheckedBitmapHeight;
    private int mNormalBitmapWidth;
    private int mNormalBitmapHeight;
    private IndicatorSize mIndicatorSize;
    private boolean normalCanResize;
    private boolean checkCanResize;
    private HashMap _$_findViewCache;

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int maxHeight = RangesKt.coerceAtLeast((int)this.mCheckedBitmapHeight, (int)this.mNormalBitmapHeight);
        int realWidth = this.mCheckedBitmapWidth + (this.mNormalBitmapWidth + this.mIndicatorPadding) * (this.getPageSize() - 1);
        this.setMeasuredDimension(realWidth, maxHeight);
    }

    /*
     * WARNING - void declaration
     */
    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        super.onDraw(canvas);
        if (this.getPageSize() > 1 && this.mCheckedBitmap != null && this.mNormalBitmap != null) {
            int n = 1;
            int n2 = this.getPageSize() + 1;
            while (n < n2) {
                void i;
                int left = 0;
                int top = 0;
                Bitmap bitmap = this.mNormalBitmap;
                void index = i - true;
                if (index < this.getCurrentPosition()) {
                    left = (i - true) * (this.mNormalBitmapWidth + this.mIndicatorPadding);
                    top = this.getMeasuredHeight() / 2 - this.mNormalBitmapHeight / 2;
                } else if (index == this.getCurrentPosition()) {
                    left = (i - true) * (this.mNormalBitmapWidth + this.mIndicatorPadding);
                    top = this.getMeasuredHeight() / 2 - this.mCheckedBitmapHeight / 2;
                    bitmap = this.mCheckedBitmap;
                } else {
                    left = (i - true) * this.mIndicatorPadding + (i - 2) * this.mNormalBitmapWidth + this.mCheckedBitmapWidth;
                    top = this.getMeasuredHeight() / 2 - this.mNormalBitmapHeight / 2;
                }
                this.drawIcon(canvas, left, top, bitmap);
                ++i;
            }
        }
    }

    private final void drawIcon(Canvas canvas, int left, int top, Bitmap icon) {
        if (icon == null) {
            return;
        }
        canvas.drawBitmap(icon, (float)left, (float)top, null);
    }

    private final void initIconSize() {
        Matrix matrix;
        float scaleHeight;
        float scaleWidth;
        int height;
        int width;
        if (this.mCheckedBitmap != null) {
            if (this.mIndicatorSize != null) {
                Bitmap bitmap = this.mCheckedBitmap;
                if (bitmap == null) {
                    Intrinsics.throwNpe();
                }
                if (bitmap.isMutable() && this.checkCanResize) {
                    Bitmap bitmap2 = this.mCheckedBitmap;
                    if (bitmap2 == null) {
                        Intrinsics.throwNpe();
                    }
                    IndicatorSize indicatorSize = this.mIndicatorSize;
                    if (indicatorSize == null) {
                        Intrinsics.throwNpe();
                    }
                    bitmap2.setWidth(indicatorSize.getCheckedWidth());
                    Bitmap bitmap3 = this.mCheckedBitmap;
                    if (bitmap3 == null) {
                        Intrinsics.throwNpe();
                    }
                    IndicatorSize indicatorSize2 = this.mIndicatorSize;
                    if (indicatorSize2 == null) {
                        Intrinsics.throwNpe();
                    }
                    bitmap3.setHeight(indicatorSize2.getCheckedHeight());
                } else {
                    Bitmap bitmap4 = this.mCheckedBitmap;
                    if (bitmap4 == null) {
                        Intrinsics.throwNpe();
                    }
                    width = bitmap4.getWidth();
                    Bitmap bitmap5 = this.mCheckedBitmap;
                    if (bitmap5 == null) {
                        Intrinsics.throwNpe();
                    }
                    height = bitmap5.getHeight();
                    IndicatorSize indicatorSize = this.mIndicatorSize;
                    if (indicatorSize == null) {
                        Intrinsics.throwNpe();
                    }
                    scaleWidth = (float)indicatorSize.getCheckedWidth() / (float)width;
                    IndicatorSize indicatorSize3 = this.mIndicatorSize;
                    if (indicatorSize3 == null) {
                        Intrinsics.throwNpe();
                    }
                    scaleHeight = (float)indicatorSize3.getCheckedHeight() / (float)height;
                    matrix = new Matrix();
                    matrix.postScale(scaleWidth, scaleHeight);
                    Bitmap bitmap6 = this.mCheckedBitmap;
                    if (bitmap6 == null) {
                        Intrinsics.throwNpe();
                    }
                    this.mCheckedBitmap = Bitmap.createBitmap((Bitmap)bitmap6, (int)0, (int)0, (int)width, (int)height, (Matrix)matrix, (boolean)true);
                }
            }
            Bitmap bitmap = this.mCheckedBitmap;
            if (bitmap == null) {
                Intrinsics.throwNpe();
            }
            this.mCheckedBitmapWidth = bitmap.getWidth();
            Bitmap bitmap7 = this.mCheckedBitmap;
            if (bitmap7 == null) {
                Intrinsics.throwNpe();
            }
            this.mCheckedBitmapHeight = bitmap7.getHeight();
        }
        if (this.mNormalBitmap != null) {
            if (this.mIndicatorSize != null) {
                Bitmap bitmap = this.mNormalBitmap;
                if (bitmap == null) {
                    Intrinsics.throwNpe();
                }
                if (bitmap.isMutable() && this.normalCanResize) {
                    Bitmap bitmap8 = this.mNormalBitmap;
                    if (bitmap8 == null) {
                        Intrinsics.throwNpe();
                    }
                    IndicatorSize indicatorSize = this.mIndicatorSize;
                    if (indicatorSize == null) {
                        Intrinsics.throwNpe();
                    }
                    bitmap8.setWidth(indicatorSize.getNormalWidth());
                    Bitmap bitmap9 = this.mNormalBitmap;
                    if (bitmap9 == null) {
                        Intrinsics.throwNpe();
                    }
                    IndicatorSize indicatorSize4 = this.mIndicatorSize;
                    if (indicatorSize4 == null) {
                        Intrinsics.throwNpe();
                    }
                    bitmap9.setHeight(indicatorSize4.getNormalHeight());
                } else {
                    Bitmap bitmap10 = this.mNormalBitmap;
                    if (bitmap10 == null) {
                        Intrinsics.throwNpe();
                    }
                    width = bitmap10.getWidth();
                    Bitmap bitmap11 = this.mNormalBitmap;
                    if (bitmap11 == null) {
                        Intrinsics.throwNpe();
                    }
                    height = bitmap11.getHeight();
                    IndicatorSize indicatorSize = this.mIndicatorSize;
                    if (indicatorSize == null) {
                        Intrinsics.throwNpe();
                    }
                    float f = indicatorSize.getNormalWidth();
                    Bitmap bitmap12 = this.mNormalBitmap;
                    if (bitmap12 == null) {
                        Intrinsics.throwNpe();
                    }
                    scaleWidth = f / (float)bitmap12.getWidth();
                    IndicatorSize indicatorSize5 = this.mIndicatorSize;
                    if (indicatorSize5 == null) {
                        Intrinsics.throwNpe();
                    }
                    float f2 = indicatorSize5.getNormalHeight();
                    Bitmap bitmap13 = this.mNormalBitmap;
                    if (bitmap13 == null) {
                        Intrinsics.throwNpe();
                    }
                    scaleHeight = f2 / (float)bitmap13.getHeight();
                    matrix = new Matrix();
                    matrix.postScale(scaleWidth, scaleHeight);
                    Bitmap bitmap14 = this.mNormalBitmap;
                    if (bitmap14 == null) {
                        Intrinsics.throwNpe();
                    }
                    this.mNormalBitmap = Bitmap.createBitmap((Bitmap)bitmap14, (int)0, (int)0, (int)width, (int)height, (Matrix)matrix, (boolean)true);
                }
            }
            Bitmap bitmap = this.mNormalBitmap;
            if (bitmap == null) {
                Intrinsics.throwNpe();
            }
            this.mNormalBitmapWidth = bitmap.getWidth();
            Bitmap bitmap15 = this.mNormalBitmap;
            if (bitmap15 == null) {
                Intrinsics.throwNpe();
            }
            this.mNormalBitmapHeight = bitmap15.getHeight();
        }
    }

    @NotNull
    public final DrawableIndicator setIndicatorDrawable(@DrawableRes int normalDrawable, @DrawableRes int checkedDrawable) {
        this.mNormalBitmap = BitmapFactory.decodeResource((Resources)this.getResources(), (int)normalDrawable);
        this.mCheckedBitmap = BitmapFactory.decodeResource((Resources)this.getResources(), (int)checkedDrawable);
        if (this.mNormalBitmap == null) {
            Context context = this.getContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
            this.mNormalBitmap = this.getBitmapFromVectorDrawable(context, normalDrawable);
            this.normalCanResize = false;
        }
        if (this.mCheckedBitmap == null) {
            Context context = this.getContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
            this.mCheckedBitmap = this.getBitmapFromVectorDrawable(context, checkedDrawable);
            this.checkCanResize = false;
        }
        this.initIconSize();
        this.postInvalidate();
        return this;
    }

    @NotNull
    public final DrawableIndicator setIndicatorSize(int normalWidth, int normalHeight, int checkedWidth, int checkedHeight) {
        this.mIndicatorSize = new IndicatorSize(normalWidth, normalHeight, checkedWidth, checkedHeight);
        this.initIconSize();
        this.postInvalidate();
        return this;
    }

    @NotNull
    public final DrawableIndicator setIndicatorGap(int padding) {
        if (padding >= 0) {
            this.mIndicatorPadding = padding;
            this.postInvalidate();
        }
        return this;
    }

    private final Bitmap getBitmapFromVectorDrawable(Context context, int drawableId) {
        Drawable drawable = context.getResources().getDrawable(drawableId);
        if (Build.VERSION.SDK_INT < 21) {
            drawable = DrawableCompat.wrap((Drawable)drawable).mutate();
        }
        Drawable drawable2 = drawable;
        Intrinsics.checkExpressionValueIsNotNull((Object)drawable2, (String)"drawable");
        Bitmap bitmap = Bitmap.createBitmap((int)drawable2.getIntrinsicWidth(), (int)drawable.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        drawable.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        drawable.draw(canvas);
        Bitmap bitmap2 = bitmap;
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap2, (String)"bitmap");
        return bitmap2;
    }

    @JvmOverloads
    public DrawableIndicator(@Nullable Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Context context2 = context;
        if (context2 == null) {
            Intrinsics.throwNpe();
        }
        super(context2, attrs, defStyleAttr);
        this.normalCanResize = true;
        this.checkCanResize = true;
    }

    public /* synthetic */ DrawableIndicator(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @JvmOverloads
    public DrawableIndicator(@Nullable Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public DrawableIndicator(@Nullable Context context) {
        this(context, null, 0, 6, null);
    }

    @Override
    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    @Override
    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u000f\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007R\u001a\u0010\u0006\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\t\"\u0004\b\r\u0010\u000bR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\t\"\u0004\b\u000f\u0010\u000bR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\t\"\u0004\b\u0011\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lcom/zhpan/indicator/DrawableIndicator$IndicatorSize;", "", "normalWidth", "", "normalHeight", "checkedWidth", "checkedHeight", "(IIII)V", "getCheckedHeight", "()I", "setCheckedHeight", "(I)V", "getCheckedWidth", "setCheckedWidth", "getNormalHeight", "setNormalHeight", "getNormalWidth", "setNormalWidth", "indicator_release"})
    public static final class IndicatorSize {
        private int normalWidth;
        private int normalHeight;
        private int checkedWidth;
        private int checkedHeight;

        public final int getNormalWidth() {
            return this.normalWidth;
        }

        public final void setNormalWidth(int n) {
            this.normalWidth = n;
        }

        public final int getNormalHeight() {
            return this.normalHeight;
        }

        public final void setNormalHeight(int n) {
            this.normalHeight = n;
        }

        public final int getCheckedWidth() {
            return this.checkedWidth;
        }

        public final void setCheckedWidth(int n) {
            this.checkedWidth = n;
        }

        public final int getCheckedHeight() {
            return this.checkedHeight;
        }

        public final void setCheckedHeight(int n) {
            this.checkedHeight = n;
        }

        public IndicatorSize(int normalWidth, int normalHeight, int checkedWidth, int checkedHeight) {
            this.normalWidth = normalWidth;
            this.normalHeight = normalHeight;
            this.checkedWidth = checkedWidth;
            this.checkedHeight = checkedHeight;
        }
    }
}

