/*
 * Decompiled with CFR 0.152.
 */
package com.zhpan.indicator.drawer;

import com.zhpan.indicator.drawer.CircleDrawer;
import com.zhpan.indicator.drawer.DashDrawer;
import com.zhpan.indicator.drawer.IDrawer;
import com.zhpan.indicator.drawer.RoundRectDrawer;
import com.zhpan.indicator.option.IndicatorOptions;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/zhpan/indicator/drawer/DrawerFactory;", "", "()V", "createDrawer", "Lcom/zhpan/indicator/drawer/IDrawer;", "indicatorOptions", "Lcom/zhpan/indicator/option/IndicatorOptions;", "indicator_release"})
public final class DrawerFactory {
    public static final DrawerFactory INSTANCE;

    @NotNull
    public final IDrawer createDrawer(@NotNull IndicatorOptions indicatorOptions) {
        IDrawer iDrawer;
        Intrinsics.checkParameterIsNotNull((Object)indicatorOptions, (String)"indicatorOptions");
        switch (indicatorOptions.getIndicatorStyle()) {
            case 2: {
                iDrawer = new DashDrawer(indicatorOptions);
                break;
            }
            case 4: {
                iDrawer = new RoundRectDrawer(indicatorOptions);
                break;
            }
            default: {
                iDrawer = new CircleDrawer(indicatorOptions);
            }
        }
        return iDrawer;
    }

    private DrawerFactory() {
    }

    static {
        DrawerFactory drawerFactory;
        INSTANCE = drawerFactory = new DrawerFactory();
    }
}

