/*
 * Decompiled with CFR 0.152.
 */
package com.zhpan.indicatorview.base;

import android.content.Context;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.Nullable;
import com.zhpan.indicatorview.base.IIndicator;
import com.zhpan.indicatorview.model.IndicatorOptions;

public class BaseIndicatorView
extends View
implements IIndicator {
    private IndicatorOptions mIndicatorOptions;
    protected Paint mPaint;

    public BaseIndicatorView(Context context) {
        super(context);
    }

    public BaseIndicatorView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public BaseIndicatorView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mIndicatorOptions = new IndicatorOptions();
        this.mPaint = new Paint();
        this.mPaint.setAntiAlias(true);
    }

    public void onPageSelected(int position) {
        if (this.getSlideMode() == 0) {
            this.setCurrentPosition(position);
            this.setSlideProgress(0.0f);
            this.invalidate();
        }
    }

    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        if (this.getSlideMode() != 0 && this.getPageSize() > 1) {
            this.scrollSlider(position, positionOffset);
            this.invalidate();
        }
    }

    private void scrollSlider(int position, float positionOffset) {
        if (position % this.getPageSize() == this.getPageSize() - 1) {
            if ((double)positionOffset < 0.5) {
                this.setCurrentPosition(position);
                this.setSlideProgress(0.0f);
            } else {
                this.setCurrentPosition(0);
                this.setSlideProgress(0.0f);
            }
        } else {
            this.setCurrentPosition(position);
            this.setSlideProgress(positionOffset);
        }
    }

    @Override
    public void setPageSize(int pageSize) {
        this.mIndicatorOptions.setPageSize(pageSize);
        this.requestLayout();
    }

    public int getPageSize() {
        return this.mIndicatorOptions.getPageSize();
    }

    public int getNormalColor() {
        return this.mIndicatorOptions.getNormalColor();
    }

    public int getCheckedColor() {
        return this.mIndicatorOptions.getCheckedColor();
    }

    public float getIndicatorGap() {
        return this.mIndicatorOptions.getIndicatorGap();
    }

    public float getSlideProgress() {
        return this.mIndicatorOptions.getSlideProgress();
    }

    public int getCurrentPosition() {
        return this.mIndicatorOptions.getCurrentPosition();
    }

    public void setCurrentPosition(int currentPosition) {
        this.mIndicatorOptions.setCurrentPosition(currentPosition);
    }

    @Override
    public void setIndicatorOptions(IndicatorOptions indicatorOptions) {
        this.mIndicatorOptions = indicatorOptions;
    }

    public int getSlideMode() {
        return this.mIndicatorOptions.getSlideMode();
    }

    public float getNormalIndicatorWidth() {
        return this.mIndicatorOptions.getNormalIndicatorWidth();
    }

    public float getCheckedIndicatorWidth() {
        return this.mIndicatorOptions.getCheckedIndicatorWidth();
    }

    private void setSlideProgress(float slideProgress) {
        this.mIndicatorOptions.setSlideProgress(slideProgress);
    }

    public IndicatorOptions getIndicatorOptions() {
        return this.mIndicatorOptions;
    }

    public void onPageScrollStateChanged(int state) {
    }
}

