/*
 * Decompiled with CFR 0.152.
 */
package com.zhpan.bannerview.indicator;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.AttributeSet;
import androidx.annotation.DrawableRes;
import androidx.core.content.ContextCompat;
import androidx.core.graphics.drawable.DrawableCompat;
import com.zhpan.indicator.base.BaseIndicatorView;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0013\u0018\u00002\u00020\u0001:\u0001/B)\b\u0007\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u0007H\u0014J\u0010\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J*\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u00072\b\u0010!\u001a\u0004\u0018\u00010\u000bH\u0002J\b\u0010\"\u001a\u00020\u0018H\u0002J\u001a\u0010#\u001a\u00020\u00002\b\b\u0001\u0010$\u001a\u00020\u00072\b\b\u0001\u0010%\u001a\u00020\u0007J&\u0010&\u001a\u00020\u00002\u0006\u0010'\u001a\u00020\u00072\u0006\u0010(\u001a\u00020\u00072\u0006\u0010)\u001a\u00020\u00072\u0006\u0010*\u001a\u00020\u0007J\u000e\u0010+\u001a\u00020\u00002\u0006\u0010,\u001a\u00020\u0007J\u001a\u0010-\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010.\u001a\u00020\u0007H\u0002R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/zhpan/bannerview/indicator/DrawableIndicator;", "Lcom/zhpan/indicator/base/BaseIndicatorView;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "<init>", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "mCheckedBitmap", "Landroid/graphics/Bitmap;", "mNormalBitmap", "mIndicatorPadding", "mCheckedBitmapWidth", "mCheckedBitmapHeight", "mNormalBitmapWidth", "mNormalBitmapHeight", "mIndicatorSize", "Lcom/zhpan/bannerview/indicator/DrawableIndicator$IndicatorSize;", "normalCanResize", "", "checkCanResize", "onMeasure", "", "widthMeasureSpec", "heightMeasureSpec", "onDraw", "canvas", "Landroid/graphics/Canvas;", "drawIcon", "left", "top", "icon", "initIconSize", "setIndicatorDrawable", "normalDrawable", "checkedDrawable", "setIndicatorSize", "normalWidth", "normalHeight", "checkedWidth", "checkedHeight", "setIndicatorGap", "padding", "getBitmapFromVectorDrawable", "drawableId", "IndicatorSize", "bannerview_release"})
public final class DrawableIndicator
extends BaseIndicatorView {
    @Nullable
    private Bitmap mCheckedBitmap;
    @Nullable
    private Bitmap mNormalBitmap;
    private int mIndicatorPadding;
    private int mCheckedBitmapWidth;
    private int mCheckedBitmapHeight;
    private int mNormalBitmapWidth;
    private int mNormalBitmapHeight;
    @Nullable
    private IndicatorSize mIndicatorSize;
    private boolean normalCanResize;
    private boolean checkCanResize;

    @JvmOverloads
    public DrawableIndicator(@Nullable Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Context context2 = context;
        Intrinsics.checkNotNull((Object)context2);
        super(context2, attrs, defStyleAttr);
        this.normalCanResize = true;
        this.checkCanResize = true;
    }

    public /* synthetic */ DrawableIndicator(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int maxHeight = RangesKt.coerceAtLeast((int)this.mCheckedBitmapHeight, (int)this.mNormalBitmapHeight);
        int realWidth = this.mCheckedBitmapWidth + (this.mNormalBitmapWidth + this.mIndicatorPadding) * (this.getPageSize() - 1);
        this.setMeasuredDimension(realWidth, maxHeight);
    }

    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        super.onDraw(canvas);
        if (this.getPageSize() > 1 && this.mCheckedBitmap != null && this.mNormalBitmap != null) {
            int n = this.getPageSize() + 1;
            for (int i = 1; i < n; ++i) {
                int left = 0;
                int top = 0;
                Bitmap bitmap = this.mNormalBitmap;
                int index = i - 1;
                if (index < this.getCurrentPosition()) {
                    left = (i - 1) * (this.mNormalBitmapWidth + this.mIndicatorPadding);
                    top = this.getMeasuredHeight() / 2 - this.mNormalBitmapHeight / 2;
                } else if (index == this.getCurrentPosition()) {
                    left = (i - 1) * (this.mNormalBitmapWidth + this.mIndicatorPadding);
                    top = this.getMeasuredHeight() / 2 - this.mCheckedBitmapHeight / 2;
                    bitmap = this.mCheckedBitmap;
                } else {
                    left = (i - 1) * this.mIndicatorPadding + (i - 2) * this.mNormalBitmapWidth + this.mCheckedBitmapWidth;
                    top = this.getMeasuredHeight() / 2 - this.mNormalBitmapHeight / 2;
                }
                this.drawIcon(canvas, left, top, bitmap);
            }
        }
    }

    private final void drawIcon(Canvas canvas, int left, int top, Bitmap icon) {
        if (icon == null) {
            return;
        }
        canvas.drawBitmap(icon, (float)left, (float)top, null);
    }

    private final void initIconSize() {
        block7: {
            Matrix matrix;
            float scaleHeight;
            float scaleWidth;
            int height;
            int width;
            IndicatorSize it;
            Bitmap it2;
            Bitmap bitmap = this.mCheckedBitmap;
            if (bitmap != null) {
                it2 = bitmap;
                boolean bl = false;
                IndicatorSize indicatorSize = this.mIndicatorSize;
                if (indicatorSize != null) {
                    it = indicatorSize;
                    boolean bl2 = false;
                    Bitmap bitmap2 = this.mCheckedBitmap;
                    Intrinsics.checkNotNull((Object)bitmap2);
                    if (bitmap2.isMutable() && this.checkCanResize) {
                        Bitmap bitmap3 = this.mCheckedBitmap;
                        Intrinsics.checkNotNull((Object)bitmap3);
                        IndicatorSize indicatorSize2 = this.mIndicatorSize;
                        Intrinsics.checkNotNull((Object)indicatorSize2);
                        bitmap3.setWidth(indicatorSize2.getCheckedWidth());
                        Bitmap bitmap4 = this.mCheckedBitmap;
                        Intrinsics.checkNotNull((Object)bitmap4);
                        IndicatorSize indicatorSize3 = this.mIndicatorSize;
                        Intrinsics.checkNotNull((Object)indicatorSize3);
                        bitmap4.setHeight(indicatorSize3.getCheckedHeight());
                    } else {
                        Bitmap bitmap5 = this.mCheckedBitmap;
                        Intrinsics.checkNotNull((Object)bitmap5);
                        width = bitmap5.getWidth();
                        Bitmap bitmap6 = this.mCheckedBitmap;
                        Intrinsics.checkNotNull((Object)bitmap6);
                        height = bitmap6.getHeight();
                        IndicatorSize indicatorSize4 = this.mIndicatorSize;
                        Intrinsics.checkNotNull((Object)indicatorSize4);
                        scaleWidth = (float)indicatorSize4.getCheckedWidth() / (float)width;
                        IndicatorSize indicatorSize5 = this.mIndicatorSize;
                        Intrinsics.checkNotNull((Object)indicatorSize5);
                        scaleHeight = (float)indicatorSize5.getCheckedHeight() / (float)height;
                        matrix = new Matrix();
                        matrix.postScale(scaleWidth, scaleHeight);
                        Bitmap bitmap7 = this.mCheckedBitmap;
                        Intrinsics.checkNotNull((Object)bitmap7);
                        this.mCheckedBitmap = Bitmap.createBitmap((Bitmap)bitmap7, (int)0, (int)0, (int)width, (int)height, (Matrix)matrix, (boolean)true);
                    }
                }
                Bitmap bitmap8 = this.mCheckedBitmap;
                Intrinsics.checkNotNull((Object)bitmap8);
                this.mCheckedBitmapWidth = bitmap8.getWidth();
                Bitmap bitmap9 = this.mCheckedBitmap;
                Intrinsics.checkNotNull((Object)bitmap9);
                this.mCheckedBitmapHeight = bitmap9.getHeight();
            }
            Bitmap bitmap10 = this.mNormalBitmap;
            if (bitmap10 == null) break block7;
            it2 = bitmap10;
            boolean bl = false;
            IndicatorSize indicatorSize = this.mIndicatorSize;
            if (indicatorSize != null) {
                it = indicatorSize;
                boolean bl3 = false;
                Bitmap bitmap11 = this.mNormalBitmap;
                Intrinsics.checkNotNull((Object)bitmap11);
                if (bitmap11.isMutable() && this.normalCanResize) {
                    Bitmap bitmap12 = this.mNormalBitmap;
                    Intrinsics.checkNotNull((Object)bitmap12);
                    IndicatorSize indicatorSize6 = this.mIndicatorSize;
                    Intrinsics.checkNotNull((Object)indicatorSize6);
                    bitmap12.setWidth(indicatorSize6.getNormalWidth());
                    Bitmap bitmap13 = this.mNormalBitmap;
                    Intrinsics.checkNotNull((Object)bitmap13);
                    IndicatorSize indicatorSize7 = this.mIndicatorSize;
                    Intrinsics.checkNotNull((Object)indicatorSize7);
                    bitmap13.setHeight(indicatorSize7.getNormalHeight());
                } else {
                    Bitmap bitmap14 = this.mNormalBitmap;
                    Intrinsics.checkNotNull((Object)bitmap14);
                    width = bitmap14.getWidth();
                    Bitmap bitmap15 = this.mNormalBitmap;
                    Intrinsics.checkNotNull((Object)bitmap15);
                    height = bitmap15.getHeight();
                    IndicatorSize indicatorSize8 = this.mIndicatorSize;
                    Intrinsics.checkNotNull((Object)indicatorSize8);
                    float f = indicatorSize8.getNormalWidth();
                    Bitmap bitmap16 = this.mNormalBitmap;
                    Intrinsics.checkNotNull((Object)bitmap16);
                    scaleWidth = f / (float)bitmap16.getWidth();
                    IndicatorSize indicatorSize9 = this.mIndicatorSize;
                    Intrinsics.checkNotNull((Object)indicatorSize9);
                    float f2 = indicatorSize9.getNormalHeight();
                    Bitmap bitmap17 = this.mNormalBitmap;
                    Intrinsics.checkNotNull((Object)bitmap17);
                    scaleHeight = f2 / (float)bitmap17.getHeight();
                    matrix = new Matrix();
                    matrix.postScale(scaleWidth, scaleHeight);
                    Bitmap bitmap18 = this.mNormalBitmap;
                    Intrinsics.checkNotNull((Object)bitmap18);
                    this.mNormalBitmap = Bitmap.createBitmap((Bitmap)bitmap18, (int)0, (int)0, (int)width, (int)height, (Matrix)matrix, (boolean)true);
                }
            }
            Bitmap bitmap19 = this.mNormalBitmap;
            Intrinsics.checkNotNull((Object)bitmap19);
            this.mNormalBitmapWidth = bitmap19.getWidth();
            Bitmap bitmap20 = this.mNormalBitmap;
            Intrinsics.checkNotNull((Object)bitmap20);
            this.mNormalBitmapHeight = bitmap20.getHeight();
        }
    }

    @NotNull
    public final DrawableIndicator setIndicatorDrawable(@DrawableRes int normalDrawable, @DrawableRes int checkedDrawable) {
        this.mNormalBitmap = BitmapFactory.decodeResource((Resources)this.getResources(), (int)normalDrawable);
        this.mCheckedBitmap = BitmapFactory.decodeResource((Resources)this.getResources(), (int)checkedDrawable);
        if (this.mNormalBitmap == null) {
            Context context = this.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
            this.mNormalBitmap = this.getBitmapFromVectorDrawable(context, normalDrawable);
            this.normalCanResize = false;
        }
        if (this.mCheckedBitmap == null) {
            Context context = this.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
            this.mCheckedBitmap = this.getBitmapFromVectorDrawable(context, checkedDrawable);
            this.checkCanResize = false;
        }
        this.initIconSize();
        this.postInvalidate();
        return this;
    }

    @NotNull
    public final DrawableIndicator setIndicatorSize(int normalWidth, int normalHeight, int checkedWidth, int checkedHeight) {
        this.mIndicatorSize = new IndicatorSize(normalWidth, normalHeight, checkedWidth, checkedHeight);
        this.initIconSize();
        this.postInvalidate();
        return this;
    }

    @NotNull
    public final DrawableIndicator setIndicatorGap(int padding) {
        if (padding >= 0) {
            this.mIndicatorPadding = padding;
            this.postInvalidate();
        }
        return this;
    }

    private final Bitmap getBitmapFromVectorDrawable(Context context, int drawableId) {
        Drawable drawable = null;
        drawable = ContextCompat.getDrawable((Context)context, (int)drawableId);
        Drawable drawable2 = drawable;
        if (drawable2 != null) {
            Drawable it = drawable2;
            boolean bl = false;
            if (Build.VERSION.SDK_INT < 21) {
                Drawable drawable3 = drawable;
                Intrinsics.checkNotNull((Object)drawable3);
                drawable = DrawableCompat.wrap((Drawable)drawable3).mutate();
            }
            Drawable drawable4 = drawable;
            Intrinsics.checkNotNull((Object)drawable4);
            Bitmap bitmap = Bitmap.createBitmap((int)drawable4.getIntrinsicWidth(), (int)drawable.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"createBitmap(...)");
            Bitmap bitmap2 = bitmap;
            Canvas canvas = new Canvas(bitmap2);
            drawable.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
            drawable.draw(canvas);
            return bitmap2;
        }
        return null;
    }

    @JvmOverloads
    public DrawableIndicator(@Nullable Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public DrawableIndicator(@Nullable Context context) {
        this(context, null, 0, 6, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0010\b\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\n\"\u0004\b\u000e\u0010\fR\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\n\"\u0004\b\u0010\u0010\fR\u001a\u0010\u0006\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\n\"\u0004\b\u0012\u0010\f\u00a8\u0006\u0013"}, d2={"Lcom/zhpan/bannerview/indicator/DrawableIndicator$IndicatorSize;", "", "normalWidth", "", "normalHeight", "checkedWidth", "checkedHeight", "<init>", "(IIII)V", "getNormalWidth", "()I", "setNormalWidth", "(I)V", "getNormalHeight", "setNormalHeight", "getCheckedWidth", "setCheckedWidth", "getCheckedHeight", "setCheckedHeight", "bannerview_release"})
    public static final class IndicatorSize {
        private int normalWidth;
        private int normalHeight;
        private int checkedWidth;
        private int checkedHeight;

        public IndicatorSize(int normalWidth, int normalHeight, int checkedWidth, int checkedHeight) {
            this.normalWidth = normalWidth;
            this.normalHeight = normalHeight;
            this.checkedWidth = checkedWidth;
            this.checkedHeight = checkedHeight;
        }

        public final int getNormalWidth() {
            return this.normalWidth;
        }

        public final void setNormalWidth(int n) {
            this.normalWidth = n;
        }

        public final int getNormalHeight() {
            return this.normalHeight;
        }

        public final void setNormalHeight(int n) {
            this.normalHeight = n;
        }

        public final int getCheckedWidth() {
            return this.checkedWidth;
        }

        public final void setCheckedWidth(int n) {
            this.checkedWidth = n;
        }

        public final int getCheckedHeight() {
            return this.checkedHeight;
        }

        public final void setCheckedHeight(int n) {
            this.checkedHeight = n;
        }
    }
}

