/*
 * Decompiled with CFR 0.152.
 */
package com.zakgof.tools.io;

import com.zakgof.tools.io.ISimpleSerializer;
import com.zakgof.tools.io.SimpleInputStream;
import com.zakgof.tools.io.SimpleOutputStream;
import java.io.IOException;

public class SimpleArraySerializer<T, S extends ISimpleSerializer<T>>
implements ISimpleSerializer<T[]> {
    private final S elementSerializer;

    public SimpleArraySerializer(S elementSerializer) {
        this.elementSerializer = elementSerializer;
    }

    @Override
    public void write(SimpleOutputStream out, T[] val) throws IOException {
        out.write(val.length);
        for (T t : val) {
            this.elementSerializer.write(out, t);
        }
    }

    @Override
    public T[] read(SimpleInputStream in) throws IOException {
        int length = in.readInt();
        Object[] arr = new Object[length];
        for (int i = 0; i < length; ++i) {
            arr[i] = this.elementSerializer.read(in);
        }
        return arr;
    }
}

