/*
 * Decompiled with CFR 0.152.
 */
package com.zakgof.tools;

import com.zakgof.tools.ICollectionFactory;
import com.zakgof.tools.MultiMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class MultiMapImpl<K, V>
implements MultiMap<K, V> {
    private final Map<K, Set<V>> map;
    private final ICollectionFactory factory;

    protected MultiMapImpl(ICollectionFactory factory) {
        this.factory = factory;
        this.map = factory.createMap();
    }

    @Override
    public void put(K key, V value) {
        Set<V> list = this.map.get(key);
        if (list == null) {
            list = this.factory.createList();
            this.map.put(key, list);
        }
        list.add(value);
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public Set<V> get(K key) {
        HashSet set = this.map.get(key);
        return set == null ? new HashSet() : set;
    }

    @Override
    public Set<V> getE(K key) {
        Set<V> list = this.map.get(key);
        return list == null ? this.factory.createList() : list;
    }

    @Override
    public Set<V> allValues() {
        Set res = this.factory.createList();
        for (Set<V> list : this.map.values()) {
            for (V value : list) {
                res.add(value);
            }
        }
        return res;
    }

    @Override
    public void remove(K key) {
        this.map.remove(key);
    }

    @Override
    public void remove(K key, V value) {
        this.map.get(key).remove(value);
    }
}

