/*
 * Decompiled with CFR 0.152.
 */
package com.zakgof.serialize;

import com.zakgof.serialize.ISerializer;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ClassStructure {
    private Map<String, Class<?>> fieldMap;
    private List<String> enumLabels;

    public static ClassStructure of(Class<?> clazz, ISerializer serializer) {
        return new ClassStructure(clazz, serializer);
    }

    private ClassStructure(Class<?> clazz, ISerializer serializer) {
        if (clazz.isEnum()) {
            this.enumLabels = Arrays.stream(clazz.getEnumConstants()).map(Enum.class::cast).map(Enum::name).collect(Collectors.toList());
        } else {
            List<Field> fields = serializer.getFields(clazz);
            this.fieldMap = fields.stream().collect(Collectors.toMap(Field::getName, Field::getType, (u, v) -> u, LinkedHashMap::new));
        }
    }

    public Map<String, Class<?>> getFields() {
        return this.fieldMap;
    }

    public int hashCode() {
        int prime1 = 31;
        int prime2 = 31;
        int result = 1;
        result = 31 * result + (this.fieldMap == null ? 0 : this.fieldMap.hashCode());
        result = 31 * result + (this.enumLabels == null ? 0 : this.enumLabels.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClassStructure other = (ClassStructure)obj;
        if (this.fieldMap == null) {
            return this.enumLabels.equals(other.enumLabels);
        }
        return this.fieldMap.equals(other.fieldMap);
    }

    public String getEnumLabel(int index) {
        return this.enumLabels.get(index);
    }
}

