/*
 * Decompiled with CFR 0.152.
 */
package com.github.zagum.speechrecognitionview.animators;

import android.view.animation.AccelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import com.github.zagum.speechrecognitionview.RecognitionBar;
import com.github.zagum.speechrecognitionview.animators.BarParamsAnimator;
import java.util.Random;

public class BarRmsAnimator
implements BarParamsAnimator {
    private static final float QUIT_RMSDB_MAX = 2.0f;
    private static final float MEDIUM_RMSDB_MAX = 5.5f;
    private static final long BAR_ANIMATION_UP_DURATION = 130L;
    private static final long BAR_ANIMATION_DOWN_DURATION = 500L;
    private final RecognitionBar bar;
    private float fromHeightPart;
    private float toHeightPart;
    private long startTimestamp;
    private boolean isPlaying;
    private boolean isUpAnimation;

    public BarRmsAnimator(RecognitionBar bar) {
        this.bar = bar;
    }

    @Override
    public void start() {
        this.isPlaying = true;
    }

    @Override
    public void stop() {
        this.isPlaying = false;
    }

    @Override
    public void animate() {
        if (this.isPlaying) {
            this.update();
        }
    }

    public void onRmsChanged(float rmsdB) {
        float newHeightPart;
        if (rmsdB < 2.0f) {
            newHeightPart = 0.2f;
        } else if (rmsdB >= 2.0f && rmsdB <= 5.5f) {
            newHeightPart = 0.3f + new Random().nextFloat();
            if (newHeightPart > 0.6f) {
                newHeightPart = 0.6f;
            }
        } else {
            newHeightPart = 0.7f + new Random().nextFloat();
            if (newHeightPart > 1.0f) {
                newHeightPart = 1.0f;
            }
        }
        if (this.newHeightIsSmallerCurrent(newHeightPart)) {
            return;
        }
        this.fromHeightPart = (float)this.bar.getHeight() / (float)this.bar.getMaxHeight();
        this.toHeightPart = newHeightPart;
        this.startTimestamp = System.currentTimeMillis();
        this.isUpAnimation = true;
        this.isPlaying = true;
    }

    private boolean newHeightIsSmallerCurrent(float newHeightPart) {
        return (float)this.bar.getHeight() / (float)this.bar.getMaxHeight() > newHeightPart;
    }

    private void update() {
        long currTimestamp = System.currentTimeMillis();
        long delta = currTimestamp - this.startTimestamp;
        if (this.isUpAnimation) {
            this.animateUp(delta);
        } else {
            this.animateDown(delta);
        }
    }

    private void animateUp(long delta) {
        boolean finished = false;
        int minHeight = (int)(this.fromHeightPart * (float)this.bar.getMaxHeight());
        int toHeight = (int)((float)this.bar.getMaxHeight() * this.toHeightPart);
        AccelerateInterpolator interpolator = new AccelerateInterpolator();
        float timePart = (float)delta / 130.0f;
        int height = minHeight + (int)(interpolator.getInterpolation(timePart) * (float)(toHeight - minHeight));
        if (height < this.bar.getHeight()) {
            return;
        }
        if (height >= toHeight) {
            height = toHeight;
            finished = true;
        }
        this.bar.setHeight(height);
        this.bar.update();
        if (finished) {
            this.isUpAnimation = false;
            this.startTimestamp = System.currentTimeMillis();
        }
    }

    private void animateDown(long delta) {
        int minHeight = this.bar.getRadius() * 2;
        int fromHeight = (int)((float)this.bar.getMaxHeight() * this.toHeightPart);
        DecelerateInterpolator interpolator = new DecelerateInterpolator();
        float timePart = (float)delta / 500.0f;
        int height = minHeight + (int)((1.0f - interpolator.getInterpolation(timePart)) * (float)(fromHeight - minHeight));
        if (height > this.bar.getHeight()) {
            return;
        }
        if (height <= minHeight) {
            this.finish();
            return;
        }
        this.bar.setHeight(height);
        this.bar.update();
    }

    private void finish() {
        this.bar.setHeight(this.bar.getRadius() * 2);
        this.bar.update();
        this.isPlaying = false;
    }
}

