/*
 * Decompiled with CFR 0.152.
 */
package com.suke.zhjg.common.autofull.util;

import cn.hutool.core.date.DateUtil;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Date;

public final class ClassTypeUtil {
    public static Class<?>[] getParameterizedListType(Field f) {
        ParameterizedType pt;
        Type[] types;
        Type fc = f.getGenericType();
        if (fc != null && fc instanceof ParameterizedType && (types = (pt = (ParameterizedType)fc).getActualTypeArguments()) != null && types.length > 0) {
            Class[] classes = new Class[types.length];
            for (int i = 0; i < classes.length; ++i) {
                classes[i] = (Class)types[i];
            }
            return classes;
        }
        Class[] classes = new Class[]{f.getType()};
        return classes;
    }

    public static void setValue(Object obj, Field field, Object value) throws IllegalAccessException {
        if (field.getType() == Integer.class) {
            if (value != null) {
                int val = Integer.valueOf(String.valueOf(value));
                field.set(obj, val);
            } else {
                field.set(obj, 0);
            }
        } else if (field.getType() == String.class) {
            String val = String.valueOf(value);
            field.set(obj, val);
        } else if (field.getType() == Double.class) {
            if (value != null) {
                double val = Double.valueOf(String.valueOf(value));
                field.set(obj, val);
            } else {
                field.set(obj, 0.0);
            }
        } else if (field.getType() == Float.class) {
            if (value != null) {
                float val = Float.valueOf(String.valueOf(value)).floatValue();
                field.set(obj, Float.valueOf(val));
            } else {
                field.set(obj, Float.valueOf(0.0f));
            }
        } else if (field.getType() == Long.class) {
            if (value != null) {
                long val = Integer.valueOf(String.valueOf(value)).longValue();
                field.set(obj, val);
            } else {
                field.set(obj, 0L);
            }
        } else if (field.getType() == Boolean.class) {
            if (value != null) {
                boolean val = (Boolean)value;
                field.set(obj, val);
            } else {
                field.set(obj, false);
            }
        } else if (field.getType() == Date.class) {
            if (value != null) {
                if (value instanceof Date) {
                    Date val = (Date)value;
                    field.set(obj, val);
                } else {
                    String dataStr = String.valueOf(value);
                    field.set(obj, DateUtil.parseDate((CharSequence)dataStr));
                }
            } else {
                field.set(obj, null);
            }
        } else if (field.getType() == Integer.TYPE) {
            if (value != null) {
                int val = Integer.parseInt(String.valueOf(value));
                field.set(obj, val);
            } else {
                field.set(obj, 0);
            }
        }
    }

    private ClassTypeUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

