/*
 * Decompiled with CFR 0.152.
 */
package com.suke.zhjg.common.autofull.handler;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import com.suke.zhjg.common.autofull.annotation.AutoFullConfiguration;
import com.suke.zhjg.common.autofull.annotation.AutoFullList;
import com.suke.zhjg.common.autofull.cache.AutoFullRedisCache;
import com.suke.zhjg.common.autofull.constant.ConstantSQL;
import com.suke.zhjg.common.autofull.handler.AutoFullHandler;
import com.suke.zhjg.common.autofull.handler.DefaultHandler;
import com.suke.zhjg.common.autofull.sequence.AutoSequence;
import com.suke.zhjg.common.autofull.sql.AutoFullSqlJdbcTemplate;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.stereotype.Component;

@Component
@AutoFullConfiguration(type=AutoFullList.class)
public class AutoFullListService
extends DefaultHandler {
    private static final Logger log = LoggerFactory.getLogger(AutoFullListService.class);

    @Override
    public String sql(String table, String alias, String conditionField) {
        conditionField = this.getConditionField(conditionField);
        String sql = (Object)((Object)ConstantSQL.SQL.SELECT) + " * " + (Object)((Object)ConstantSQL.SQL.FROM) + " " + table + " " + (Object)((Object)ConstantSQL.SQL.WHERE) + " " + conditionField + "  =  ? ";
        return sql;
    }

    @Override
    public void result(Annotation annotation, Field[] fields, Field field, Object obj, String sequence, int level) {
        try {
            if (annotation instanceof AutoFullList) {
                Object object = AutoSequence.init().get(sequence);
                AutoFullList fieldAnnotation = field.getAnnotation(AutoFullList.class);
                field.setAccessible(true);
                String alias = field.getName();
                String table = fieldAnnotation.table();
                boolean useCache = fieldAnnotation.useCache();
                String tableField = fieldAnnotation.conditionField();
                Object param = this.findFieldValue(fields, tableField, obj);
                if (ObjectUtil.isNotNull((Object)param)) {
                    String parseSql = this.sql(table, alias, tableField) + " " + fieldAnnotation.orderBy();
                    HashMap<Integer, Object> paramMap = new HashMap<Integer, Object>();
                    paramMap.put(1, param);
                    if (this.configProperties.isShowLog()) {
                        log.info("ID:{}, LEVEL:{}, SQL:{}", new Object[]{sequence, level, parseSql});
                        log.info("ID:{}, LEVEL:{}, param\uff1a{}", new Object[]{sequence, level, param});
                    }
                    List<Class<Object>> result = null;
                    if (useCache) {
                        List<Class<?>> data = AutoFullRedisCache.getList(sequence, parseSql, param, this.getBeanClassType(field));
                        if (CollUtil.isNotEmpty(data)) {
                            result = data;
                        } else {
                            Class<?> classType = this.getListClassType(field);
                            BeanPropertyRowMapper rm = BeanPropertyRowMapper.newInstance(classType);
                            result = AutoFullSqlJdbcTemplate.queryList(parseSql, rm, new Object[]{param});
                            AutoFullRedisCache.setData(sequence, parseSql, param, result);
                        }
                    } else {
                        Class<?> classType = this.getListClassType(field);
                        BeanPropertyRowMapper rm = BeanPropertyRowMapper.newInstance(classType);
                        result = AutoFullSqlJdbcTemplate.queryList(parseSql, rm, new Object[]{param});
                    }
                    if (CollUtil.isNotEmpty(result)) {
                        int maxLevel;
                        if (ObjectUtil.isNotNull((Object)object) && level < (maxLevel = ((Integer)object).intValue()) && fieldAnnotation.childLevel()) {
                            AutoFullHandler.full(result, sequence, ++level);
                        }
                        field.set(obj, result);
                    }
                }
            }
        }
        catch (IllegalAccessException e) {
            log.error("\u586b\u5145List\u5931\u8d25:{}", (Throwable)e);
            e.printStackTrace();
        }
    }
}

