/*
 * Decompiled with CFR 0.152.
 */
package com.suke.zhjg.common.autofull.handler;

import cn.hutool.core.util.StrUtil;
import com.suke.zhjg.common.autofull.annotation.AutoFullConfiguration;
import com.suke.zhjg.common.autofull.annotation.AutoFullFieldSQL;
import com.suke.zhjg.common.autofull.cache.AutoFullRedisCache;
import com.suke.zhjg.common.autofull.handler.DefaultHandler;
import com.suke.zhjg.common.autofull.sequence.AutoSequence;
import com.suke.zhjg.common.autofull.sql.AutoFullSqlJdbcTemplate;
import com.suke.zhjg.common.autofull.util.ClassTypeUtil;
import com.suke.zhjg.common.autofull.util.StringSQLUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.List;
import java.util.regex.Matcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@AutoFullConfiguration(type=AutoFullFieldSQL.class)
public class AutoFullFieldSQLService
extends DefaultHandler {
    private static final Logger log = LoggerFactory.getLogger(AutoFullFieldSQLService.class);

    @Override
    public String sql(String sql) {
        Matcher matcher = StringSQLUtil.parse(sql);
        while (matcher.find()) {
            String fieldKey = matcher.group(1);
            sql = sql.replace("{" + fieldKey + "}", " ? ");
        }
        return sql;
    }

    @Override
    public void result(Annotation annotation, Field[] fields, Field field, Object obj, String sequence, int level) {
        try {
            if (annotation instanceof AutoFullFieldSQL) {
                Object object = AutoSequence.init().get(sequence);
                AutoFullFieldSQL sqlAnnotation = field.getAnnotation(AutoFullFieldSQL.class);
                field.setAccessible(true);
                String alias = field.getName();
                String sql = sqlAnnotation.sql();
                boolean useCache = sqlAnnotation.useCache();
                List<Object> param = this.getParamList(fields, obj, sql);
                String parseSql = this.sql(sql);
                if (this.configProperties.isShowLog()) {
                    log.info("ID:{}, LEVEL:{}, SQL:{}", new Object[]{sequence, level, parseSql});
                    log.info("ID:{}, LEVEL:{}, param\uff1a{}", new Object[]{sequence, level, param});
                }
                Object[] paramArray = param.toArray();
                String result = null;
                if (useCache) {
                    String stringData = AutoFullRedisCache.getStringData(sequence, parseSql, param);
                    if (StrUtil.isNotEmpty((CharSequence)stringData)) {
                        result = stringData;
                    } else {
                        result = AutoFullSqlJdbcTemplate.queryObj(parseSql, String.class, paramArray);
                        AutoFullRedisCache.setData(sequence, parseSql, param, result);
                    }
                } else {
                    result = AutoFullSqlJdbcTemplate.queryObj(parseSql, String.class, paramArray);
                }
                if (StrUtil.isNotEmpty((CharSequence)result)) {
                    ClassTypeUtil.setValue(obj, field, result);
                }
            }
        }
        catch (IllegalAccessException e) {
            log.error("\u586b\u5145\u5b57\u6bb5\u5931\u8d25:{}", (Throwable)e);
            e.printStackTrace();
        }
    }
}

