/*
 * Decompiled with CFR 0.152.
 */
package com.suke.zhjg.common.autofull.config;

import cn.hutool.core.collection.CollUtil;
import com.suke.zhjg.common.autofull.annotation.AutoFullConfiguration;
import com.suke.zhjg.common.autofull.config.ApplicationContextRegister;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Component;

@Component
public class AutoConfig
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(AutoConfig.class);
    private Map<String, Object> beansWithAnnotation = new HashMap<String, Object>();

    public void afterPropertiesSet() {
        this.beansWithAnnotation = ApplicationContextRegister.getApplicationContext().getBeansWithAnnotation(AutoFullConfiguration.class);
    }

    public Object findBean(Annotation annotation) {
        if (CollUtil.isNotEmpty(this.beansWithAnnotation)) {
            for (String key : this.beansWithAnnotation.keySet()) {
                Class<?> bean = this.beansWithAnnotation.get(key).getClass();
                AutoFullConfiguration customAnnotation = (AutoFullConfiguration)AnnotationUtils.findAnnotation(this.beansWithAnnotation.get(key).getClass(), AutoFullConfiguration.class);
                if (null == customAnnotation || customAnnotation.type() == null || customAnnotation.type() != annotation.annotationType()) continue;
                return ApplicationContextRegister.getApplicationContext().getBean(bean);
            }
        }
        return null;
    }

    public Map<String, Object> getBeansWithAnnotation() {
        return this.beansWithAnnotation;
    }
}

