/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.codescanner;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.hardware.Camera;
import android.os.Build;
import android.view.WindowManager;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.budiyev.android.codescanner.AutoFocusMode;
import com.budiyev.android.codescanner.CodeScannerException;
import com.budiyev.android.codescanner.DecoderWrapper;
import com.budiyev.android.codescanner.ErrorCallback;
import com.budiyev.android.codescanner.Point;
import com.budiyev.android.codescanner.Rect;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.NotFoundException;
import com.google.zxing.ReaderException;
import com.google.zxing.Result;
import com.google.zxing.common.HybridBinarizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

final class Utils {
    private static final float MIN_DISTORTION = 0.3f;
    private static final float MAX_DISTORTION = 3.0f;
    private static final float DISTORTION_STEP = 0.1f;
    private static final int MIN_PREVIEW_PIXELS = 589824;
    private static final int MIN_FPS = 10000;
    private static final int MAX_FPS = 30000;

    private Utils() {
    }

    @NonNull
    public static Point findSuitableImageSize(@NonNull Camera.Parameters parameters, int frameWidth, int frameHeight) {
        Camera.Size defaultSize;
        List sizes = parameters.getSupportedPreviewSizes();
        if (sizes != null && !sizes.isEmpty()) {
            Collections.sort(sizes, new CameraSizeComparator());
            float frameRatio = (float)frameWidth / (float)frameHeight;
            for (float distortion = 0.3f; distortion <= 3.0f; distortion += 0.1f) {
                for (Camera.Size size : sizes) {
                    int width = size.width;
                    int height = size.height;
                    if (width * height < 589824 || !(Math.abs(frameRatio - (float)width / (float)height) <= distortion)) continue;
                    return new Point(width, height);
                }
            }
        }
        if ((defaultSize = parameters.getPreviewSize()) == null) {
            throw new CodeScannerException("Unable to configure camera preview size");
        }
        return new Point(defaultSize.width, defaultSize.height);
    }

    public static void configureFpsRange(@NonNull Camera.Parameters parameters) {
        List supportedFpsRanges = parameters.getSupportedPreviewFpsRange();
        if (supportedFpsRanges == null || supportedFpsRanges.isEmpty()) {
            return;
        }
        Collections.sort(supportedFpsRanges, new FpsRangeComparator());
        for (int[] fpsRange : supportedFpsRanges) {
            if (fpsRange[0] < 10000 || fpsRange[1] > 30000) continue;
            parameters.setPreviewFpsRange(fpsRange[0], fpsRange[1]);
            return;
        }
    }

    public static void configureSceneMode(@NonNull Camera.Parameters parameters) {
        List supportedSceneModes;
        if (!"barcode".equals(parameters.getSceneMode()) && (supportedSceneModes = parameters.getSupportedSceneModes()) != null && supportedSceneModes.contains("barcode")) {
            parameters.setSceneMode("barcode");
        }
    }

    public static void configureVideoStabilization(@NonNull Camera.Parameters parameters) {
        if (parameters.isVideoStabilizationSupported() && !parameters.getVideoStabilization()) {
            parameters.setVideoStabilization(true);
        }
    }

    public static void configureFocusArea(@NonNull Camera.Parameters parameters, @NonNull Rect area, int width, int height, int orientation) {
        ArrayList<Camera.Area> areas = new ArrayList<Camera.Area>(1);
        Rect rotatedArea = area.rotate(-orientation, (float)width / 2.0f, (float)height / 2.0f).bound(0, 0, width, height);
        areas.add(new Camera.Area(new android.graphics.Rect(Utils.mapCoordinate(rotatedArea.getLeft(), width), Utils.mapCoordinate(rotatedArea.getTop(), height), Utils.mapCoordinate(rotatedArea.getRight(), width), Utils.mapCoordinate(rotatedArea.getBottom(), height)), 1000));
        if (parameters.getMaxNumFocusAreas() > 0) {
            parameters.setFocusAreas(areas);
        }
        if (parameters.getMaxNumMeteringAreas() > 0) {
            parameters.setMeteringAreas(areas);
        }
    }

    public static void configureDefaultFocusArea(@NonNull Camera.Parameters parameters, @NonNull Rect frameRect, @NonNull Point previewSize, @NonNull Point viewSize, int width, int height, int orientation) {
        boolean portrait = Utils.isPortrait(orientation);
        int rotatedWidth = portrait ? height : width;
        int rotatedHeight = portrait ? width : height;
        Utils.configureFocusArea(parameters, Utils.getImageFrameRect(rotatedWidth, rotatedHeight, frameRect, previewSize, viewSize), rotatedWidth, rotatedHeight, orientation);
    }

    public static void configureDefaultFocusArea(@NonNull Camera.Parameters parameters, @NonNull DecoderWrapper decoderWrapper, @NonNull Rect frameRect) {
        Point imageSize = decoderWrapper.getImageSize();
        Utils.configureDefaultFocusArea(parameters, frameRect, decoderWrapper.getPreviewSize(), decoderWrapper.getViewSize(), imageSize.getX(), imageSize.getY(), decoderWrapper.getDisplayOrientation());
    }

    public static void configureFocusModeForTouch(@NonNull Camera.Parameters parameters) {
        if ("auto".equals(parameters.getFocusMode())) {
            return;
        }
        List focusModes = parameters.getSupportedFocusModes();
        if (focusModes != null && focusModes.contains("auto")) {
            parameters.setFocusMode("auto");
        }
    }

    public static void disableAutoFocus(@NonNull Camera.Parameters parameters) {
        List focusModes = parameters.getSupportedFocusModes();
        if (focusModes == null || focusModes.isEmpty()) {
            return;
        }
        String focusMode = parameters.getFocusMode();
        if (focusModes.contains("fixed")) {
            if ("fixed".equals(focusMode)) {
                return;
            }
            parameters.setFocusMode("fixed");
            return;
        }
        if (focusModes.contains("auto") && !"auto".equals(focusMode)) {
            parameters.setFocusMode("auto");
        }
    }

    public static void setAutoFocusMode(@NonNull Camera.Parameters parameters, AutoFocusMode autoFocusMode) {
        List focusModes = parameters.getSupportedFocusModes();
        if (focusModes == null || focusModes.isEmpty()) {
            return;
        }
        if (autoFocusMode == AutoFocusMode.CONTINUOUS) {
            if ("continuous-picture".equals(parameters.getFocusMode())) {
                return;
            }
            if (focusModes.contains("continuous-picture")) {
                parameters.setFocusMode("continuous-picture");
                return;
            }
        }
        if ("auto".equals(parameters.getFocusMode())) {
            return;
        }
        if (focusModes.contains("auto")) {
            parameters.setFocusMode("auto");
        }
    }

    public static void setFlashMode(@NonNull Camera.Parameters parameters, @NonNull String flashMode) {
        if (flashMode.equals(parameters.getFlashMode())) {
            return;
        }
        List flashModes = parameters.getSupportedFlashModes();
        if (flashModes != null && flashModes.contains(flashMode)) {
            parameters.setFlashMode(flashMode);
        }
    }

    public static void setZoom(@NonNull Camera.Parameters parameters, int zoom) {
        if (parameters.isZoomSupported() && parameters.getZoom() != zoom) {
            int maxZoom = parameters.getMaxZoom();
            parameters.setZoom(Math.min(zoom, maxZoom));
        }
    }

    public static int getDisplayOrientation(@NonNull Context context, @NonNull Camera.CameraInfo cameraInfo) {
        int degrees;
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        if (windowManager == null) {
            throw new CodeScannerException("Unable to access window manager");
        }
        int rotation = windowManager.getDefaultDisplay().getRotation();
        switch (rotation) {
            case 0: {
                degrees = 0;
                break;
            }
            case 1: {
                degrees = 90;
                break;
            }
            case 2: {
                degrees = 180;
                break;
            }
            case 3: {
                degrees = 270;
                break;
            }
            default: {
                if (rotation % 90 == 0) {
                    degrees = (360 + rotation) % 360;
                    break;
                }
                throw new CodeScannerException("Invalid display rotation");
            }
        }
        return ((cameraInfo.facing == 1 ? 180 : 360) + cameraInfo.orientation - degrees) % 360;
    }

    public static boolean isPortrait(int orientation) {
        return orientation == 90 || orientation == 270;
    }

    @NonNull
    public static Point getPreviewSize(int imageWidth, int imageHeight, int frameWidth, int frameHeight) {
        if (imageWidth == frameWidth && imageHeight == frameHeight) {
            return new Point(frameWidth, frameHeight);
        }
        int resultWidth = imageWidth * frameHeight / imageHeight;
        if (resultWidth < frameWidth) {
            return new Point(frameWidth, imageHeight * frameWidth / imageWidth);
        }
        return new Point(resultWidth, frameHeight);
    }

    @NonNull
    public static Rect getImageFrameRect(int imageWidth, int imageHeight, @NonNull Rect viewFrameRect, @NonNull Point previewSize, @NonNull Point viewSize) {
        int previewWidth = previewSize.getX();
        int previewHeight = previewSize.getY();
        int viewWidth = viewSize.getX();
        int viewHeight = viewSize.getY();
        int wD = (previewWidth - viewWidth) / 2;
        int hD = (previewHeight - viewHeight) / 2;
        float wR = (float)imageWidth / (float)previewWidth;
        float hR = (float)imageHeight / (float)previewHeight;
        return new Rect(Math.max(Math.round((float)(viewFrameRect.getLeft() + wD) * wR), 0), Math.max(Math.round((float)(viewFrameRect.getTop() + hD) * hR), 0), Math.min(Math.round((float)(viewFrameRect.getRight() + wD) * wR), imageWidth), Math.min(Math.round((float)(viewFrameRect.getBottom() + hD) * hR), imageHeight));
    }

    @NonNull
    public static byte[] rotateYuv(@NonNull byte[] source, int width, int height, int rotation) {
        if (rotation == 0 || rotation == 360) {
            return source;
        }
        if (rotation % 90 != 0 || rotation < 0 || rotation > 270) {
            throw new IllegalArgumentException("Invalid rotation (valid: 0, 90, 180, 270)");
        }
        byte[] output = new byte[source.length];
        int frameSize = width * height;
        boolean swap = rotation % 180 != 0;
        boolean flipX = rotation % 270 != 0;
        boolean flipY = rotation >= 180;
        for (int j = 0; j < height; ++j) {
            for (int i = 0; i < width; ++i) {
                int yIn = j * width + i;
                int uIn = frameSize + (j >> 1) * width + (i & 0xFFFFFFFE);
                int vIn = uIn + 1;
                int wOut = swap ? height : width;
                int hOut = swap ? width : height;
                int iSwapped = swap ? j : i;
                int jSwapped = swap ? i : j;
                int iOut = flipX ? wOut - iSwapped - 1 : iSwapped;
                int jOut = flipY ? hOut - jSwapped - 1 : jSwapped;
                int yOut = jOut * wOut + iOut;
                int uOut = frameSize + (jOut >> 1) * wOut + (iOut & 0xFFFFFFFE);
                int vOut = uOut + 1;
                output[yOut] = (byte)(0xFF & source[yIn]);
                output[uOut] = (byte)(0xFF & source[uIn]);
                output[vOut] = (byte)(0xFF & source[vIn]);
            }
        }
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static Result decodeLuminanceSource(@NonNull MultiFormatReader reader, @NonNull LuminanceSource luminanceSource) throws ReaderException {
        try {
            Result result = reader.decodeWithState(new BinaryBitmap((Binarizer)new HybridBinarizer(luminanceSource)));
            return result;
        }
        catch (NotFoundException e) {
            Result result = reader.decodeWithState(new BinaryBitmap((Binarizer)new HybridBinarizer(luminanceSource.invert())));
            return result;
        }
        finally {
            reader.reset();
        }
    }

    @NonNull
    public static Drawable getDrawable(@NonNull Context context, @DrawableRes int resId) {
        if (Build.VERSION.SDK_INT >= 21) {
            return context.getDrawable(resId);
        }
        return context.getResources().getDrawable(resId);
    }

    private static int mapCoordinate(int value, int size) {
        return 2000 * value / size - 1000;
    }

    private static final class FpsRangeComparator
    implements Comparator<int[]> {
        private FpsRangeComparator() {
        }

        @Override
        public int compare(int[] a, int[] b) {
            int comparison = Integer.compare(b[1], a[1]);
            if (comparison == 0) {
                comparison = Integer.compare(b[0], a[0]);
            }
            return comparison;
        }
    }

    private static final class CameraSizeComparator
    implements Comparator<Camera.Size> {
        private CameraSizeComparator() {
        }

        @Override
        public int compare(@NonNull Camera.Size a, @NonNull Camera.Size b) {
            return Integer.compare(b.height * b.width, a.height * a.width);
        }
    }

    public static final class SuppressErrorCallback
    implements ErrorCallback {
        @Override
        public void onError(@NonNull Throwable thrown) {
        }
    }
}

