/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.codescanner;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.budiyev.android.codescanner.DecodeCallback;
import com.budiyev.android.codescanner.DecodeTask;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.DecodeHintType;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.ReaderException;
import com.google.zxing.Result;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.SynchronousQueue;

final class Decoder {
    private final BlockingQueue<DecodeTask> mDecodeQueue = new SynchronousQueue<DecodeTask>();
    private final MultiFormatReader mReader = new MultiFormatReader();
    private final DecoderThread mDecoderThread = new DecoderThread();
    private final StateListener mStateListener;
    private final Map<DecodeHintType, Object> mHints = new EnumMap<DecodeHintType, Object>(DecodeHintType.class);
    private volatile DecodeCallback mCallback;
    private volatile State mState;

    public Decoder(@NonNull StateListener stateListener, @NonNull List<BarcodeFormat> formats, @Nullable DecodeCallback callback) {
        this.mHints.put(DecodeHintType.POSSIBLE_FORMATS, formats);
        this.mReader.setHints(this.mHints);
        this.mCallback = callback;
        this.mStateListener = stateListener;
        this.mState = State.INITIALIZED;
    }

    public void setFormats(@NonNull List<BarcodeFormat> formats) {
        this.mHints.put(DecodeHintType.POSSIBLE_FORMATS, formats);
        this.mReader.setHints(this.mHints);
    }

    public void setCallback(@Nullable DecodeCallback callback) {
        this.mCallback = callback;
    }

    public void decode(@NonNull DecodeTask task) {
        this.mDecodeQueue.offer(task);
    }

    public void start() {
        if (this.mState != State.INITIALIZED) {
            throw new IllegalStateException("Illegal decoder state");
        }
        this.mDecoderThread.start();
    }

    public void shutdown() {
        this.mDecoderThread.interrupt();
        this.mDecodeQueue.clear();
    }

    @NonNull
    public State getState() {
        return this.mState;
    }

    private boolean setState(@NonNull State state) {
        this.mState = state;
        return this.mStateListener.onStateChanged(state);
    }

    public static enum State {
        INITIALIZED,
        IDLE,
        DECODING,
        DECODED,
        STOPPED;

    }

    public static interface StateListener {
        public boolean onStateChanged(@NonNull State var1);
    }

    private final class DecoderThread
    extends Thread {
        public DecoderThread() {
            super("Code scanner decode thread");
            if (this.getPriority() != 1) {
                this.setPriority(1);
            }
            if (this.isDaemon()) {
                this.setDaemon(false);
            }
        }

        @Override
        public void run() {
            try {
                while (true) {
                    Decoder.this.setState(State.IDLE);
                    Result result = null;
                    try {
                        DecodeTask task = (DecodeTask)Decoder.this.mDecodeQueue.take();
                        Decoder.this.setState(State.DECODING);
                        result = task.decode(Decoder.this.mReader);
                    }
                    catch (ReaderException callback) {}
                    continue;
                    finally {
                        if (result == null) continue;
                        Decoder.this.mDecodeQueue.clear();
                        if (!Decoder.this.setState(State.DECODED) || (callback = Decoder.this.mCallback) == null) continue;
                        callback.onDecoded(result);
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException e) {
                Decoder.this.setState(State.STOPPED);
                return;
            }
        }
    }
}

